/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.jblas.DoubleMatrix;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u00015\u0011\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\r\u000e\u0003\u0019I!A\u0007\u0004\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013\u0005Q$\u0001\u0003sC:\\W#\u0001\u0010\u0011\u0005=y\u0012B\u0001\u0011\u0011\u0005\rIe\u000e\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005=\u0005)!/\u00198lA!AA\u0005\u0001BC\u0002\u0013\u0005Q%\u0001\u0007vg\u0016\u0014h)Z1ukJ,7/F\u0001'!\r9#\u0006L\u0007\u0002Q)\u0011\u0011FB\u0001\u0004e\u0012$\u0017BA\u0016)\u0005\r\u0011F\t\u0012\t\u0005\u001f5rr&\u0003\u0002/!\t1A+\u001e9mKJ\u00022a\u0004\u00193\u0013\t\t\u0004CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010g%\u0011A\u0007\u0005\u0002\u0007\t>,(\r\\3\t\u0011Y\u0002!\u0011!Q\u0001\n\u0019\nQ\"^:fe\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002\u001fA\u0014x\u000eZ;di\u001a+\u0017\r^;sKND\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0011aJ|G-^2u\r\u0016\fG/\u001e:fg\u0002BQ\u0001\u0010\u0001\u0005\u0002u\na\u0001P5oSRtD\u0003\u0002 A\u0003\n\u0003\"a\u0010\u0001\u000e\u0003\tAQ\u0001H\u001eA\u0002yAQ\u0001J\u001eA\u0002\u0019BQ\u0001O\u001eA\u0002\u0019BQ\u0001\u0012\u0001\u0005\n\u0015\u000b\u0001C^1mS\u0012\fG/\u001a$fCR,(/Z:\u0015\u0007\u0019K%\u000b\u0005\u0002\u0010\u000f&\u0011\u0001\n\u0005\u0002\u0005+:LG\u000fC\u0003K\u0007\u0002\u00071*\u0001\u0003oC6,\u0007C\u0001'P\u001d\tyQ*\u0003\u0002O!\u00051\u0001K]3eK\u001aL!\u0001U)\u0003\rM#(/\u001b8h\u0015\tq\u0005\u0003C\u0003T\u0007\u0002\u0007a%\u0001\u0005gK\u0006$XO]3t\u0011\u0015)\u0006\u0001\"\u0001W\u0003\u001d\u0001(/\u001a3jGR$2AM,Z\u0011\u0015AF\u000b1\u0001\u001f\u0003\u0011)8/\u001a:\t\u000bi#\u0006\u0019\u0001\u0010\u0002\u000fA\u0014x\u000eZ;di\")Q\u000b\u0001C\u00019R\u0011Q,\u0019\t\u0004O)r\u0006CA `\u0013\t\u0001'A\u0001\u0004SCRLgn\u001a\u0005\u0006En\u0003\raY\u0001\u000ekN,'o\u001d)s_\u0012,8\r^:\u0011\u0007\u001dRC\r\u0005\u0003\u0010[yq\u0002\"B+\u0001\t\u00031GCA4p!\rAWNX\u0007\u0002S*\u0011!n[\u0001\u0005U\u00064\u0018M\u0003\u0002m\r\u0005\u0019\u0011\r]5\n\u00059L'a\u0002&bm\u0006\u0014F\t\u0012\u0005\u0006E\u0016\u0004\r\u0001\u001d\t\u0005QF\u001c8/\u0003\u0002sS\nY!*\u0019<b!\u0006L'O\u0015#E!\t!\b0D\u0001v\u0015\t1x/\u0001\u0003mC:<'\"\u00016\n\u0005e,(aB%oi\u0016<WM\u001d\u0005\u0006w\u0002!\t\u0001`\u0001\u0012e\u0016\u001cw.\\7f]\u0012\u0004&o\u001c3vGR\u001cHcA?\u007f\u007fB\u0019q\u0002\r0\t\u000baS\b\u0019\u0001\u0010\t\r\u0005\u0005!\u00101\u0001\u001f\u0003\rqW/\u001c\u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u00039\u0011XmY8n[\u0016tG-V:feN$R!`A\u0005\u0003\u0017AaAWA\u0002\u0001\u0004q\u0002bBA\u0001\u0003\u0007\u0001\rA\b\u0005\b\u0003\u001f\u0001A\u0011BA\t\u0003%\u0011XmY8n[\u0016tG\r\u0006\u0005\u0002\u0014\u0005]\u00111DA\u0010!\u0011y\u0001'!\u0006\u0011\t=icD\r\u0005\b\u00033\ti\u00011\u00010\u0003M\u0011XmY8n[\u0016tG\rV8GK\u0006$XO]3t\u0011\u001d\ti\"!\u0004A\u0002\u0019\nQC]3d_6lWM\u001c3bE2,g)Z1ukJ,7\u000fC\u0004\u0002\u0002\u00055\u0001\u0019\u0001\u0010")
public class MatrixFactorizationModel
implements Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps((double[])((Tuple2)features.first())._2()).size() == this.rank(), (Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModel $outer;
            private final String name$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " feature dimension does not match the rank ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)this.$outer.rank())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (features.partitioner().isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor does not have a partitioner. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)"Prediction on individual records could be slow.").toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor is not cached. Prediction could be slow."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
    }

    public double predict(int user, int product) {
        DoubleMatrix userVector = new DoubleMatrix((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head());
        DoubleMatrix productVector = new DoubleMatrix((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head());
        return userVector.dot(productVector);
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        RDD users = SparkContext$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$1) {
                Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        double[] uFeatures = (double[])tuple22._1();
                        int product = tuple22._2$mcI$sp();
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return SparkContext$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$2) {
                Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        Tuple2 tuple23 = (Tuple2)tuple22._1();
                        double[] pFeatures = (double[])tuple22._2();
                        if (tuple23 != null) {
                            int user = tuple23._1$mcI$sp();
                            double[] uFeatures = (double[])tuple23._2();
                            DoubleMatrix userVector = new DoubleMatrix(uFeatures);
                            DoubleMatrix productVector = new DoubleMatrix(pFeatures);
                            Rating rating = new Rating(user, product, userVector.dot(productVector));
                            return rating;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Rating.class));
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])this.recommend((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head(), this.productFeatures(), num)).map((Function1)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final int user$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(this.user$1, t._1$mcI$sp(), t._2$mcD$sp());
            }
            {
                this.user$1 = user$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])this.recommend((double[])SparkContext$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head(), this.userFeatures(), num)).map((Function1)new Serializable(this, product){
            public static final long serialVersionUID = 0L;
            private final int product$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(t._1$mcI$sp(), this.product$1, t._2$mcD$sp());
            }
            {
                this.product$1 = product$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    private Tuple2<Object, Object>[] recommend(double[] recommendToFeatures, RDD<Tuple2<Object, double[]>> recommendableFeatures, int num) {
        DoubleMatrix recommendToVector = new DoubleMatrix(recommendToFeatures);
        RDD scored = recommendableFeatures.map((Function1)new Serializable(this, recommendToVector){
            public static final long serialVersionUID = 0L;
            private final DoubleMatrix recommendToVector$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, double[]> x0$3) {
                Tuple2<Object, double[]> tuple2 = x0$3;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    double[] features = (double[])tuple2._2();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(id, this.recommendToVector$1.dot(new DoubleMatrix(features)));
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.recommendToVector$1 = recommendToVector$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return (Tuple2[])scored.top(num, package$.MODULE$.Ordering().by((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x$1) {
                return x$1._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
    }
}

