/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.Logging;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Null$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0003\u0003i!\u0001G*ue\u0016\fW.\u001b8h\u0019&tW-\u0019:BY\u001e|'/\u001b;i[*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0004\u001d\u0001R3c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003\u0019I!\u0001\u0007\u0004\u0003\u000f1{wmZ5oO\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0005;\u0001q\u0012&D\u0001\u0003!\ty\u0002\u0005\u0004\u0001\u0005\u000b\u0005\u0002!\u0019\u0001\u0012\u0003\u00035\u000b\"a\t\u0014\u0011\u0005A!\u0013BA\u0013\u0012\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!H\u0014\n\u0005!\u0012!AF$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be6{G-\u001a7\u0011\u0005}QC!B\u0016\u0001\u0005\u0004a#!A!\u0012\u0005\rj\u0003cA\u000f/=%\u0011qF\u0001\u0002\u001b\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014\u0018\t\\4pe&$\b.\u001c\u0005\bc\u0001\u0001\rQ\"\u00053\u0003\u0015iw\u000eZ3m+\u0005q\u0002b\u0002\u001b\u0001\u0001\u00045\t\"N\u0001\n[>$W\r\\0%KF$\"AN\u001d\u0011\u0005A9\u0014B\u0001\u001d\u0012\u0005\u0011)f.\u001b;\t\u000fi\u001a\u0014\u0011!a\u0001=\u0005\u0019\u0001\u0010J\u0019\t\u000fq\u0002!\u0019!D\t{\u0005I\u0011\r\\4pe&$\b.\\\u000b\u0002S!)q\b\u0001C\u0001\u0001\u0006YA.\u0019;fgRlu\u000eZ3m)\u0005q\u0002\"\u0002\"\u0001\t\u0003\u0019\u0015a\u0002;sC&twJ\u001c\u000b\u0003m\u0011CQ!R!A\u0002\u0019\u000bA\u0001Z1uCB\u0019q\t\u0014(\u000e\u0003!S!!\u0013&\u0002\u000f\u0011\u001cHO]3b[*\u00111JB\u0001\ngR\u0014X-Y7j]\u001eL!!\u0014%\u0003\u000f\u0011\u001bFO]3b[B\u0011QdT\u0005\u0003!\n\u0011A\u0002T1cK2,G\rU8j]RDQA\u0015\u0001\u0005\u0002M\u000b\u0011\u0002\u001d:fI&\u001cGo\u00148\u0015\u0005QC\u0006cA$M+B\u0011\u0001CV\u0005\u0003/F\u0011a\u0001R8vE2,\u0007\"B#R\u0001\u0004I\u0006cA$M5B\u00111LX\u0007\u00029*\u0011Q\fB\u0001\u0007Y&t\u0017\r\\4\n\u0005}c&A\u0002,fGR|'\u000fC\u0003b\u0001\u0011\u0005!-A\bqe\u0016$\u0017n\u0019;P]Z\u000bG.^3t+\t\u0019'\u000e\u0006\u0002eqR\u0011Q\r\u001d\t\u0004\u000f23\u0007\u0003\u0002\thSVK!\u0001[\t\u0003\rQ+\b\u000f\\33!\ty\"\u000eB\u0003lA\n\u0007ANA\u0001L#\t\u0019S\u000e\u0005\u0002\u0011]&\u0011q.\u0005\u0002\u0004\u0003:L\bbB9a\u0003\u0003\u0005\u001dA]\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA:wS6\tAO\u0003\u0002v#\u00059!/\u001a4mK\u000e$\u0018BA<u\u0005!\u0019E.Y:t)\u0006<\u0007\"B#a\u0001\u0004I\bcA$MuB!\u0001cZ5[Q\t\u0001A\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007f\u001a\t!\"\u00198o_R\fG/[8o\u0013\r\t\u0019A \u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b")
public abstract class StreamingLinearAlgorithm<M extends GeneralizedLinearModel, A extends GeneralizedLinearAlgorithm<M>>
implements Logging {
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public abstract M model();

    public abstract void model_$eq(M var1);

    public abstract A algorithm();

    public M latestModel() {
        return this.model();
    }

    public void trainOn(DStream<LabeledPoint> data) {
        Option option = Option$.MODULE$.apply((Object)((GeneralizedLinearModel)this.model()).weights());
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Initial weights must be set before starting training";
                }
            });
            throw new IllegalArgumentException();
        }
        data.foreachRDD((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingLinearAlgorithm $outer;

            public final void apply(RDD<LabeledPoint> rdd, Time time) {
                this.$outer.model_$eq(((GeneralizedLinearAlgorithm)this.$outer.algorithm()).run(rdd, ((GeneralizedLinearModel)this.$outer.model()).weights()));
                this.$outer.logInfo((Function0<String>)new Serializable(this, time){
                    public static final long serialVersionUID = 0L;
                    private final Time time$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Model updated at time %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.time$1.toString()}));
                    }
                    {
                        this.time$1 = time$1;
                    }
                });
                int n = ((GeneralizedLinearModel)this.$outer.model()).weights().size();
                switch (n) {
                    default: 
                }
                String display = n > 100 ? Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(((GeneralizedLinearModel)this.$outer.model()).weights().toArray()).take(100)).mkString("[", ",", "...") : Predef$.MODULE$.doubleArrayOps(((GeneralizedLinearModel)this.$outer.model()).weights().toArray()).mkString("[", ",", "]");
                this.$outer.logInfo((Function0<String>)new Serializable(this, display){
                    public static final long serialVersionUID = 0L;
                    private final String display$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Current model: weights, %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.display$1}));
                    }
                    {
                        this.display$1 = display$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public DStream<Object> predictOn(DStream<Vector> data) {
        Option option = Option$.MODULE$.apply((Object)((GeneralizedLinearModel)this.model()).weights());
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            String msg = "Initial weights must be set before starting prediction";
            this.logError((Function0<String>)new Serializable(this, msg){
                public static final long serialVersionUID = 0L;
                private final String msg$1;

                public final String apply() {
                    return this.msg$1;
                }
                {
                    this.msg$1 = msg$1;
                }
            });
            throw new IllegalArgumentException(msg);
        }
        M m = this.model();
        return data.map((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final GeneralizedLinearModel eta$0$1$1;

            public final double apply(Vector testData) {
                return this.eta$0$1$1.predict(testData);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public <K> DStream<Tuple2<K, Object>> predictOnValues(DStream<Tuple2<K, Vector>> data, ClassTag<K> evidence$1) {
        Option option = Option$.MODULE$.apply((Object)((GeneralizedLinearModel)this.model()).weights());
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals(none$) : none$ != null)) {
            String msg = "Initial weights must be set before starting prediction";
            this.logError((Function0<String>)new Serializable(this, msg){
                public static final long serialVersionUID = 0L;
                private final String msg$2;

                public final String apply() {
                    return this.msg$2;
                }
                {
                    this.msg$2 = msg$2;
                }
            });
            throw new IllegalArgumentException(msg);
        }
        DStream<Tuple2<K, Vector>> x$1 = data;
        ClassTag<K> x$2 = evidence$1;
        ClassTag x$3 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$4 = StreamingContext$.MODULE$.toPairDStreamFunctions$default$4(x$1);
        M m = this.model();
        return StreamingContext$.MODULE$.toPairDStreamFunctions(x$1, x$2, x$3, null).mapValues((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final GeneralizedLinearModel eta$0$2$1;

            public final double apply(Vector testData) {
                return this.eta$0$2$1.predict(testData);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public StreamingLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
    }
}

