/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.StreamingLinearAlgorithm;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u00015\u0011\u0001e\u0015;sK\u0006l\u0017N\\4MS:,\u0017M\u001d*fOJ,7o]5p]^KG\u000f[*H\t*\u00111\u0001B\u0001\u000be\u0016<'/Z:tS>t'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019A\u0002\u0003B\b\u0011%Ui\u0011AA\u0005\u0003#\t\u0011\u0001d\u0015;sK\u0006l\u0017N\\4MS:,\u0017M]!mO>\u0014\u0018\u000e\u001e5n!\ty1#\u0003\u0002\u0015\u0005\t)B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007CA\b\u0017\u0013\t9\"AA\fMS:,\u0017M\u001d*fOJ,7o]5p]^KG\u000f[*H\tB\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\ta1+\u001a:jC2L'0\u00192mK\"Aq\u0004\u0001BA\u0002\u0013%\u0001%\u0001\u0005ti\u0016\u00048+\u001b>f+\u0005\t\u0003CA\r#\u0013\t\u0019#D\u0001\u0004E_V\u0014G.\u001a\u0005\tK\u0001\u0011\t\u0019!C\u0005M\u0005a1\u000f^3q'&TXm\u0018\u0013fcR\u0011qE\u000b\t\u00033!J!!\u000b\u000e\u0003\tUs\u0017\u000e\u001e\u0005\bW\u0011\n\t\u00111\u0001\"\u0003\rAH%\r\u0005\t[\u0001\u0011\t\u0011)Q\u0005C\u0005I1\u000f^3q'&TX\r\t\u0005\t_\u0001\u0011\t\u0019!C\u0005a\u0005ia.^7Ji\u0016\u0014\u0018\r^5p]N,\u0012!\r\t\u00033IJ!a\r\u000e\u0003\u0007%sG\u000f\u0003\u00056\u0001\t\u0005\r\u0011\"\u00037\u0003EqW/\\%uKJ\fG/[8og~#S-\u001d\u000b\u0003O]Bqa\u000b\u001b\u0002\u0002\u0003\u0007\u0011\u0007\u0003\u0005:\u0001\t\u0005\t\u0015)\u00032\u00039qW/\\%uKJ\fG/[8og\u0002B\u0001b\u000f\u0001\u0003\u0002\u0004%I\u0001I\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0002C\u001f\u0001\u0005\u0003\u0007I\u0011\u0002 \u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011qe\u0010\u0005\bWq\n\t\u00111\u0001\"\u0011!\t\u0005A!A!B\u0013\t\u0013AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002B\u0001b\u0011\u0001\u0003\u0002\u0004%I\u0001R\u0001\u000fS:LG/[1m/\u0016Lw\r\u001b;t+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0005\u0003\u0019a\u0017N\\1mO&\u0011!j\u0012\u0002\u0007-\u0016\u001cGo\u001c:\t\u00111\u0003!\u00111A\u0005\n5\u000b!#\u001b8ji&\fGnV3jO\"$8o\u0018\u0013fcR\u0011qE\u0014\u0005\bW-\u000b\t\u00111\u0001F\u0011!\u0001\u0006A!A!B\u0013)\u0015aD5oSRL\u0017\r\\,fS\u001eDGo\u001d\u0011\t\u000bI\u0003A\u0011A*\u0002\rqJg.\u001b;?)\u0015!VKV,Y!\ty\u0001\u0001C\u0003 #\u0002\u0007\u0011\u0005C\u00030#\u0002\u0007\u0011\u0007C\u0003<#\u0002\u0007\u0011\u0005C\u0003D#\u0002\u0007Q\tC\u0003S\u0001\u0011\u0005!\fF\u0001U\u0011\u001da\u0006A1A\u0005\u0002u\u000b\u0011\"\u00197h_JLG\u000f[7\u0016\u0003UAaa\u0018\u0001!\u0002\u0013)\u0012AC1mO>\u0014\u0018\u000e\u001e5nA!9\u0011\r\u0001a\u0001\n\u0003\u0011\u0017!B7pI\u0016dW#\u0001\n\t\u000f\u0011\u0004\u0001\u0019!C\u0001K\u0006IQn\u001c3fY~#S-\u001d\u000b\u0003O\u0019DqaK2\u0002\u0002\u0003\u0007!\u0003\u0003\u0004i\u0001\u0001\u0006KAE\u0001\u0007[>$W\r\u001c\u0011\t\u000b)\u0004A\u0011A6\u0002\u0017M,Go\u0015;faNK'0\u001a\u000b\u0003Y6l\u0011\u0001\u0001\u0005\u0006?%\u0004\r!\t\u0005\u0006_\u0002!\t\u0001]\u0001\u0011g\u0016$h*^7Ji\u0016\u0014\u0018\r^5p]N$\"\u0001\\9\t\u000b=r\u0007\u0019A\u0019\t\u000bM\u0004A\u0011\u0001;\u0002)M,G/T5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8o)\taW\u000fC\u0003<e\u0002\u0007\u0011\u0005C\u0003x\u0001\u0011\u0005\u00010A\ttKRLe.\u001b;jC2<V-[4iiN$\"\u0001\\=\t\u000b\r3\b\u0019A#)\u0005\u0001Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003i(\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007")
public class StreamingLinearRegressionWithSGD
extends StreamingLinearAlgorithm<LinearRegressionModel, LinearRegressionWithSGD>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double miniBatchFraction;
    private Vector initialWeights;
    private final LinearRegressionWithSGD algorithm;
    private LinearRegressionModel model;

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private Vector initialWeights() {
        return this.initialWeights;
    }

    private void initialWeights_$eq(Vector x$1) {
        this.initialWeights = x$1;
    }

    @Override
    public LinearRegressionWithSGD algorithm() {
        return this.algorithm;
    }

    @Override
    public LinearRegressionModel model() {
        return this.model;
    }

    @Override
    public void model_$eq(LinearRegressionModel x$1) {
        this.model = x$1;
    }

    public StreamingLinearRegressionWithSGD setStepSize(double stepSize) {
        this.algorithm().optimizer().setStepSize(stepSize);
        return this;
    }

    public StreamingLinearRegressionWithSGD setNumIterations(int numIterations) {
        this.algorithm().optimizer().setNumIterations(numIterations);
        return this;
    }

    public StreamingLinearRegressionWithSGD setMiniBatchFraction(double miniBatchFraction) {
        this.algorithm().optimizer().setMiniBatchFraction(miniBatchFraction);
        return this;
    }

    public StreamingLinearRegressionWithSGD setInitialWeights(Vector initialWeights) {
        this.model_$eq(this.algorithm().createModel(initialWeights, 0.0));
        return this;
    }

    public StreamingLinearRegressionWithSGD(double stepSize, int numIterations, double miniBatchFraction, Vector initialWeights) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.miniBatchFraction = miniBatchFraction;
        this.initialWeights = initialWeights;
        this.algorithm = new LinearRegressionWithSGD(this.stepSize(), this.numIterations(), this.miniBatchFraction());
        this.model = this.algorithm().createModel(this.initialWeights(), 0.0);
    }

    public StreamingLinearRegressionWithSGD() {
        this(0.1, 50, 1.0, null);
    }
}

