/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.util.Map;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.BaggedPoint$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.mllib.tree.impl.NodeIdCache;
import org.apache.spark.mllib.tree.impl.NodeIdCache$;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.impl.TreePoint$;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\t5\u0011ABU1oI>lgi\u001c:fgRT!a\u0001\u0003\u0002\tQ\u0014X-\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0013i\u0012\u0001C:ue\u0006$XmZ=\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0002\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\u0019\u0003E\u0001\u0005TiJ\fG/Z4z\u0011!)\u0003A!A!\u0002\u0013q\u0012!C:ue\u0006$XmZ=!\u0011!9\u0003A!b\u0001\n\u0013A\u0013\u0001\u00038v[R\u0013X-Z:\u0016\u0003%\u0002\"a\u0004\u0016\n\u0005-\u0002\"aA%oi\"AQ\u0006\u0001B\u0001B\u0003%\u0011&A\u0005ok6$&/Z3tA!Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u000bgK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ=\u0011\u0005E\"dBA\b3\u0013\t\u0019\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u0011\u0011!A\u0004A!b\u0001\n\u0013A\u0013\u0001B:fK\u0012D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0006g\u0016,G\r\t\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\u0002\u0015IQ\"\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000bqY\u0004\u0019\u0001\u0010\t\u000b\u001dZ\u0004\u0019A\u0015\t\u000b=Z\u0004\u0019\u0001\u0019\t\u000baZ\u0004\u0019A\u0015\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0007I,h\u000e\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JA\u0001\u0006[>$W\r\\\u0005\u0003\u0019&\u0013\u0011CU1oI>lgi\u001c:fgRlu\u000eZ3m\u0011\u0015qE\t1\u0001P\u0003\u0015Ig\u000e];u!\r\u00016+V\u0007\u0002#*\u0011!KB\u0001\u0004e\u0012$\u0017B\u0001+R\u0005\r\u0011F\t\u0012\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\t!B]3he\u0016\u001c8/[8o\u0013\tQvK\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u000b\u0002\u00019B\u0011Q\fY\u0007\u0002=*\u0011qLB\u0001\u000bC:tw\u000e^1uS>t\u0017BA1_\u00051)\u0005\u0010]3sS6,g\u000e^1m\u000f\u0015\u0019'\u0001#\u0001e\u00031\u0011\u0016M\u001c3p[\u001a{'/Z:u!\tyTMB\u0003\u0002\u0005!\u0005am\u0005\u0003f\u001dQ9\u0002\"\u0002\u001ff\t\u0003AG#\u00013\t\u000b),G\u0011A6\u0002\u001fQ\u0014\u0018-\u001b8DY\u0006\u001c8/\u001b4jKJ$ba\u00127n]>\u0004\b\"\u0002(j\u0001\u0004y\u0005\"\u0002\u000fj\u0001\u0004q\u0002\"B\u0014j\u0001\u0004I\u0003\"B\u0018j\u0001\u0004\u0001\u0004\"\u0002\u001dj\u0001\u0004I\u0003\"\u00026f\t\u0003\u0011H\u0003D$tiZ\\H0`@\u0002\u0004\u0005\u001d\u0001\"\u0002(r\u0001\u0004y\u0005\"B;r\u0001\u0004I\u0013A\u00038v[\u000ec\u0017m]:fg\")q/\u001da\u0001q\u000692-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fg&sgm\u001c\t\u0005ceL\u0013&\u0003\u0002{m\t\u0019Q*\u00199\t\u000b\u001d\n\b\u0019A\u0015\t\u000b=\n\b\u0019\u0001\u0019\t\u000by\f\b\u0019\u0001\u0019\u0002\u0011%l\u0007/\u001e:jifDa!!\u0001r\u0001\u0004I\u0013\u0001C7bq\u0012+\u0007\u000f\u001e5\t\r\u0005\u0015\u0011\u000f1\u0001*\u0003\u001di\u0017\r\u001f\"j]NDq\u0001O9\u0011\u0002\u0003\u0007\u0011\u0006\u0003\u0004kK\u0012\u0005\u00111\u0002\u000b\u0014\u000f\u00065\u0011qDA\u0011\u0003w\ti$a\u0010\u0002B\u0005\r\u0013Q\t\u0005\b\u001d\u0006%\u0001\u0019AA\b!\u0015\t\t\"a\u0007V\u001b\t\t\u0019B\u0003\u0003\u0002\u0016\u0005]\u0011\u0001\u00026bm\u0006T1!!\u0007\u0007\u0003\r\t\u0007/[\u0005\u0005\u0003;\t\u0019BA\u0004KCZ\f'\u000b\u0012#\t\rU\fI\u00011\u0001*\u0011\u001d9\u0018\u0011\u0002a\u0001\u0003G\u0001\u0002\"!\n\u0002.\u0005=\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005!Q\u000f^5m\u0015\t\t)\"C\u0002{\u0003O\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0005\u0003k\tY#\u0001\u0003mC:<\u0017\u0002BA\u001d\u0003g\u0011q!\u00138uK\u001e,'\u000f\u0003\u0004(\u0003\u0013\u0001\r!\u000b\u0005\u0007_\u0005%\u0001\u0019\u0001\u0019\t\ry\fI\u00011\u00011\u0011\u001d\t\t!!\u0003A\u0002%Bq!!\u0002\u0002\n\u0001\u0007\u0011\u0006\u0003\u00049\u0003\u0013\u0001\r!\u000b\u0005\b\u0003\u0013*G\u0011AA&\u00039!(/Y5o%\u0016<'/Z:t_J$2bRA'\u0003\u001f\n\t&a\u0015\u0002V!1a*a\u0012A\u0002=Ca\u0001HA$\u0001\u0004q\u0002BB\u0014\u0002H\u0001\u0007\u0011\u0006\u0003\u00040\u0003\u000f\u0002\r\u0001\r\u0005\u0007q\u0005\u001d\u0003\u0019A\u0015\t\u000f\u0005%S\r\"\u0001\u0002ZQ\tr)a\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\n9'!\u001b\t\r9\u000b9\u00061\u0001P\u0011\u00199\u0018q\u000ba\u0001q\"1q%a\u0016A\u0002%BaaLA,\u0001\u0004\u0001\u0004B\u0002@\u0002X\u0001\u0007\u0001\u0007C\u0004\u0002\u0002\u0005]\u0003\u0019A\u0015\t\u000f\u0005\u0015\u0011q\u000ba\u0001S!A\u0001(a\u0016\u0011\u0002\u0003\u0007\u0011\u0006C\u0004\u0002J\u0015$\t!!\u001c\u0015#\u001d\u000by'!\u001d\u0002t\u0005U\u0014qOA=\u0003w\ni\bC\u0004O\u0003W\u0002\r!a\u0004\t\u000f]\fY\u00071\u0001\u0002$!1q%a\u001bA\u0002%BaaLA6\u0001\u0004\u0001\u0004B\u0002@\u0002l\u0001\u0007\u0001\u0007C\u0004\u0002\u0002\u0005-\u0004\u0019A\u0015\t\u000f\u0005\u0015\u00111\u000ea\u0001S!1\u0001(a\u001bA\u0002%B\u0011\"!!f\u0005\u0004%\t!a!\u0002AM,\b\u000f]8si\u0016$g)Z1ukJ,7+\u001e2tKR\u001cFO]1uK\u001eLWm]\u000b\u0003\u0003\u000b\u0003BaDADa%\u0019\u0011\u0011\u0012\t\u0003\u000b\u0005\u0013(/Y=\t\u0011\u00055U\r)A\u0005\u0003\u000b\u000b\u0011e];qa>\u0014H/\u001a3GK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ5fg\u00022q!!%f\u0001\t\t\u0019JA\u0007O_\u0012,\u0017J\u001c3fq&sgm\\\n\u0005\u0003\u001fsA\u0003\u0003\u0006\u0002\u0018\u0006=%Q1A\u0005\u0002!\n\u0001C\\8eK&sG-\u001a=J]\u001e\u0013x.\u001e9\t\u0015\u0005m\u0015q\u0012B\u0001B\u0003%\u0011&A\to_\u0012,\u0017J\u001c3fq&swI]8va\u0002B1\"a(\u0002\u0010\n\u0015\r\u0011\"\u0001\u0002\"\u0006ia-Z1ukJ,7+\u001e2tKR,\"!a)\u0011\u000b=\t)+!+\n\u0007\u0005\u001d\u0006C\u0001\u0004PaRLwN\u001c\t\u0005\u001f\u0005\u001d\u0015\u0006C\u0006\u0002.\u0006=%\u0011!Q\u0001\n\u0005\r\u0016A\u00044fCR,(/Z*vEN,G\u000f\t\u0005\by\u0005=E\u0011AAY)\u0019\t\u0019,a.\u0002:B!\u0011QWAH\u001b\u0005)\u0007bBAL\u0003_\u0003\r!\u000b\u0005\t\u0003?\u000by\u000b1\u0001\u0002$\"A\u0011QX3\u0005\u0002\t\ty,\u0001\ntK2,7\r\u001e(pI\u0016\u001cHk\\*qY&$HCCAa\u0003+\fY/!>\u0003\u0006A9q\"a1\u0002H\u0006E\u0017bAAc!\t1A+\u001e9mKJ\u0002R!M=*\u0003\u0013\u0004RaDAD\u0003\u0017\u00042\u0001SAg\u0013\r\ty-\u0013\u0002\u0005\u001d>$W\rE\u00032s&\n\u0019\u000eE\u00032s&\n\u0019\f\u0003\u0005\u0002X\u0006m\u0006\u0019AAm\u0003%qw\u000eZ3Rk\u0016,X\r\u0005\u0004\u0002\\\u0006\u0015\u0018\u0011^\u0007\u0003\u0003;TA!a8\u0002b\u00069Q.\u001e;bE2,'bAAr!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u001d\u0018Q\u001c\u0002\u0006#V,W/\u001a\t\u0007\u001f\u0005\r\u0017&a3\t\u0011\u00055\u00181\u0018a\u0001\u0003_\fa\"\\1y\u001b\u0016lwN]=Vg\u0006<W\rE\u0002\u0010\u0003cL1!a=\u0011\u0005\u0011auN\\4\t\u0011\u0005]\u00181\u0018a\u0001\u0003s\f\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u0003w\u0014\t!\u0004\u0002\u0002~*\u0019\u0011q \u0002\u0002\t%l\u0007\u000f\\\u0005\u0005\u0005\u0007\tiP\u0001\u000bEK\u000eL7/[8o)J,W-T3uC\u0012\fG/\u0019\u0005\t\u0005\u000f\tY\f1\u0001\u0003\n\u0005\u0019!O\\4\u0011\t\t-!qB\u0007\u0003\u0005\u001bQ1!!\u000b\u0011\u0013\u0011\u0011\tB!\u0004\u0003\rI\u000bg\u000eZ8n\u0011!\u0011)\"\u001aC\u0001\u0005\t]\u0011\u0001F1hOJ,w-\u0019;f'&TXMR8s\u001d>$W\r\u0006\u0004\u0002p\ne!1\u0004\u0005\t\u0003o\u0014\u0019\u00021\u0001\u0002z\"A\u0011q\u0014B\n\u0001\u0004\t\u0019\u000bC\u0005\u0003 \u0015\f\n\u0011\"\u0001\u0003\"\u0005IBO]1j]\u000ec\u0017m]:jM&,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011\u0019CK\u0002*\u0005KY#Aa\n\u0011\t\t%\"\u0011G\u0007\u0003\u0005WQAA!\f\u00030\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003?BIAAa\r\u0003,\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t]R-%A\u0005\u0002\t\u0005\u0012\u0001\u0007;sC&t'+Z4sKN\u001cxN\u001d\u0013eK\u001a\fW\u000f\u001c;%q!I!1H3\u0002\u0002\u0013%!QH\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003@A!\u0011\u0011\u0007B!\u0013\u0011\u0011\u0019%a\r\u0003\r=\u0013'.Z2u\u0001")
public class RandomForest
implements Serializable,
Logging {
    private final Strategy org$apache$spark$mllib$tree$RandomForest$$strategy;
    private final int org$apache$spark$mllib$tree$RandomForest$$numTrees;
    public final String org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy;
    private final int org$apache$spark$mllib$tree$RandomForest$$seed;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int trainRegressor$default$8() {
        return RandomForest$.MODULE$.trainRegressor$default$8();
    }

    public static int trainClassifier$default$9() {
        return RandomForest$.MODULE$.trainClassifier$default$9();
    }

    public static String[] supportedFeatureSubsetStrategies() {
        return RandomForest$.MODULE$.supportedFeatureSubsetStrategies();
    }

    public static RandomForestModel trainRegressor(JavaRDD<LabeledPoint> javaRDD, Map<Integer, Integer> map, int n, String string, String string2, int n2, int n3, int n4) {
        return RandomForest$.MODULE$.trainRegressor(javaRDD, map, n, string, string2, n2, n3, n4);
    }

    public static RandomForestModel trainRegressor(RDD<LabeledPoint> rDD, scala.collection.immutable.Map<Object, Object> map, int n, String string, String string2, int n2, int n3, int n4) {
        return RandomForest$.MODULE$.trainRegressor(rDD, map, n, string, string2, n2, n3, n4);
    }

    public static RandomForestModel trainRegressor(RDD<LabeledPoint> rDD, Strategy strategy, int n, String string, int n2) {
        return RandomForest$.MODULE$.trainRegressor(rDD, strategy, n, string, n2);
    }

    public static RandomForestModel trainClassifier(JavaRDD<LabeledPoint> javaRDD, int n, Map<Integer, Integer> map, int n2, String string, String string2, int n3, int n4, int n5) {
        return RandomForest$.MODULE$.trainClassifier(javaRDD, n, map, n2, string, string2, n3, n4, n5);
    }

    public static RandomForestModel trainClassifier(RDD<LabeledPoint> rDD, int n, scala.collection.immutable.Map<Object, Object> map, int n2, String string, String string2, int n3, int n4, int n5) {
        return RandomForest$.MODULE$.trainClassifier(rDD, n, map, n2, string, string2, n3, n4, n5);
    }

    public static RandomForestModel trainClassifier(RDD<LabeledPoint> rDD, Strategy strategy, int n, String string, int n2) {
        return RandomForest$.MODULE$.trainClassifier(rDD, strategy, n, string, n2);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Strategy org$apache$spark$mllib$tree$RandomForest$$strategy() {
        return this.org$apache$spark$mllib$tree$RandomForest$$strategy;
    }

    public int org$apache$spark$mllib$tree$RandomForest$$numTrees() {
        return this.org$apache$spark$mllib$tree$RandomForest$$numTrees;
    }

    public int org$apache$spark$mllib$tree$RandomForest$$seed() {
        return this.org$apache$spark$mllib$tree$RandomForest$$seed;
    }

    public RandomForestModel run(RDD<LabeledPoint> input) {
        TimeTracker timer = new TimeTracker();
        timer.start("total");
        timer.start("init");
        RDD retaggedInput = input.retag(LabeledPoint.class);
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<LabeledPoint>)retaggedInput, this.org$apache$spark$mllib$tree$RandomForest$$strategy(), this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), this.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy);
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"algo = ").append((Object)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().algo()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"numTrees = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$numTrees())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"seed = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$seed())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;

            public final String apply() {
                return new StringBuilder().append((Object)"maxBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.maxBins())).toString();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"featureSubsetStrategy = ").append((Object)this.$outer.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this, metadata){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeMetadata metadata$1;

            public final String apply() {
                return new StringBuilder().append((Object)"numFeaturesPerNode = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numFeaturesPerNode())).toString();
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
        timer.start("findSplitsBins");
        Tuple2<Split[][], Bin[][]> tuple2 = DecisionTree$.MODULE$.findSplitsBins((RDD<LabeledPoint>)retaggedInput, metadata);
        if (tuple2 != null) {
            Tuple2.mcDZ.sp sp2;
            Tuple2 tuple22;
            Split[][] splits = (Split[][])tuple2._1();
            Bin[][] bins = (Bin[][])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
            Split[][] splits2 = (Split[][])tuple23._1();
            Bin[][] bins2 = (Bin[][])tuple23._2();
            timer.stop("findSplitsBins");
            this.logDebug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "numBins: feature: number of bins";
                }
            });
            this.logDebug((Function0<String>)new Serializable(this, metadata){
                public static final long serialVersionUID = 0L;
                public final DecisionTreeMetadata metadata$1;

                public final String apply() {
                    return ((TraversableOnce)package$.MODULE$.Range().apply(0, this.metadata$1.numFeatures()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$run$9 $outer;

                        public final String apply(int featureIndex) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex), BoxesRunTime.boxToInteger((int)this.$outer.metadata$1.numBins()[featureIndex])}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n");
                }
                {
                    this.metadata$1 = metadata$1;
                }
            });
            RDD<TreePoint> treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<LabeledPoint>)retaggedInput, bins2, metadata);
            boolean isRandomForest = this.org$apache$spark$mllib$tree$RandomForest$$numTrees() > 1;
            Tuple2.mcDZ.sp sp3 = sp2 = isRandomForest ? new Tuple2.mcDZ.sp(1.0, true) : new Tuple2.mcDZ.sp(this.org$apache$spark$mllib$tree$RandomForest$$strategy().subsamplingRate(), false);
            if (sp2 != null) {
                Tuple2.mcDZ.sp sp4;
                double subsample = sp2._1$mcD$sp();
                boolean withReplacement = sp2._2$mcZ$sp();
                Tuple2.mcDZ.sp sp5 = sp4 = new Tuple2.mcDZ.sp(subsample, withReplacement);
                double subsample2 = sp5._1$mcD$sp();
                boolean withReplacement2 = sp5._2$mcZ$sp();
                RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, subsample2, this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), withReplacement2, this.org$apache$spark$mllib$tree$RandomForest$$seed()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                int maxDepth = this.org$apache$spark$mllib$tree$RandomForest$$strategy().maxDepth();
                Predef$.MODULE$.require(maxDepth <= 30, (Function0)new Serializable(this, maxDepth){
                    public static final long serialVersionUID = 0L;
                    private final int maxDepth$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree currently only supports maxDepth <= 30, but was given maxDepth = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxDepth$1)}));
                    }
                    {
                        this.maxDepth$1 = maxDepth$1;
                    }
                });
                long maxMemoryUsage = (long)this.org$apache$spark$mllib$tree$RandomForest$$strategy().maxMemoryInMB() * 1024L * 1024L;
                this.logDebug((Function0<String>)new Serializable(this, maxMemoryUsage){
                    public static final long serialVersionUID = 0L;
                    private final long maxMemoryUsage$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"max memory usage for aggregates = ").append((Object)BoxesRunTime.boxToLong((long)this.maxMemoryUsage$1)).append((Object)" bytes.").toString();
                    }
                    {
                        this.maxMemoryUsage$1 = maxMemoryUsage$1;
                    }
                });
                None$ featureSubset = metadata.subsamplingFeatures() ? new Some(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(metadata.numBins()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$3) {
                        return -x$3._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).take(metadata.numFeaturesPerNode())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$4) {
                        return x$4._2$mcI$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))) : None$.MODULE$;
                long maxMemoryPerNode = RandomForest$.MODULE$.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
                Predef$.MODULE$.require(maxMemoryPerNode <= maxMemoryUsage, (Function0)new Serializable(this, maxMemoryPerNode){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;
                    private final long maxMemoryPerNode$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest/DecisionTree given maxMemoryInMB = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().maxMemoryInMB())}))).append((Object)" which is too small for the given features.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Minimum value = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.maxMemoryPerNode$1 / 0x100000L))}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.maxMemoryPerNode$1 = maxMemoryPerNode$1;
                    }
                });
                timer.stop("init");
                None$ nodeIdCache = this.org$apache$spark$mllib$tree$RandomForest$$strategy().useNodeIdCache() ? new Some((Object)NodeIdCache$.MODULE$.init((RDD<BaggedPoint<TreePoint>>)baggedInput, this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), this.org$apache$spark$mllib$tree$RandomForest$$strategy().checkpointDir(), this.org$apache$spark$mllib$tree$RandomForest$$strategy().checkpointInterval(), 1)) : None$.MODULE$;
                Queue nodeQueue = new Queue();
                Random rng = new Random();
                rng.setSeed((long)this.org$apache$spark$mllib$tree$RandomForest$$seed());
                Node[] topNodes = (Node[])Array$.MODULE$.fill(this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Node apply() {
                        return Node$.MODULE$.emptyNode(1);
                    }
                }, ClassTag$.MODULE$.apply(Node.class));
                package$.MODULE$.Range().apply(0, this.org$apache$spark$mllib$tree$RandomForest$$numTrees()).foreach$mVc$sp((Function1)new Serializable(this, nodeQueue, topNodes){
                    public static final long serialVersionUID = 0L;
                    private final Queue nodeQueue$1;
                    private final Node[] topNodes$1;

                    public final void apply(int treeIndex) {
                        this.apply$mcVI$sp(treeIndex);
                    }

                    public void apply$mcVI$sp(int treeIndex) {
                        this.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)this.topNodes$1[treeIndex])}));
                    }
                    {
                        this.nodeQueue$1 = nodeQueue$1;
                        this.topNodes$1 = topNodes$1;
                    }
                });
                while (nodeQueue.nonEmpty()) {
                    Tuple2<scala.collection.immutable.Map<Object, Node[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, NodeIndexInfo>>> tuple24 = RandomForest$.MODULE$.selectNodesToSplit((Queue<Tuple2<Object, Node>>)nodeQueue, maxMemoryUsage, metadata, rng);
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)tuple24._1();
                        scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
                        scala.collection.immutable.Map nodesForGroup2 = (scala.collection.immutable.Map)tuple26._1();
                        scala.collection.immutable.Map treeToNodeToIndexInfo2 = (scala.collection.immutable.Map)tuple26._2();
                        Predef$.MODULE$.assert(nodesForGroup2.size() > 0, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest selected empty nodesForGroup.  Error for unknown reason."})).s((Seq)Nil$.MODULE$);
                            }
                        });
                        timer.start("findBestSplits");
                        DecisionTree$.MODULE$.findBestSplits((RDD<BaggedPoint<TreePoint>>)baggedInput, metadata, topNodes, (scala.collection.immutable.Map<Object, Node[]>)nodesForGroup2, (scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, NodeIndexInfo>>)treeToNodeToIndexInfo2, splits2, bins2, (Queue<Tuple2<Object, Node>>)nodeQueue, timer, (Option<NodeIdCache>)nodeIdCache);
                        timer.stop("findBestSplits");
                        continue;
                    }
                    throw new MatchError(tuple24);
                }
                baggedInput.unpersist(baggedInput.unpersist$default$1());
                timer.stop("total");
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Internal timing for DecisionTree:";
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this, timer){
                    public static final long serialVersionUID = 0L;
                    private final TimeTracker timer$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
                    }
                    {
                        this.timer$1 = timer$1;
                    }
                });
                if (nodeIdCache.nonEmpty()) {
                    ((NodeIdCache)nodeIdCache.get()).deleteAllCheckpoints();
                }
                DecisionTreeModel[] trees = (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final DecisionTreeModel apply(Node topNode) {
                        return new DecisionTreeModel(topNode, this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().algo());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
                return new RandomForestModel(this.org$apache$spark$mllib$tree$RandomForest$$strategy().algo(), trees);
            }
            throw new MatchError((Object)sp2);
        }
        throw new MatchError(tuple2);
    }

    public RandomForest(Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        this.org$apache$spark$mllib$tree$RandomForest$$strategy = strategy;
        this.org$apache$spark$mllib$tree$RandomForest$$numTrees = numTrees;
        this.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy = featureSubsetStrategy;
        this.org$apache$spark$mllib$tree$RandomForest$$seed = seed;
        Logging.class.$init$((Logging)this);
        strategy.assertValid();
        Predef$.MODULE$.require(numTrees > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest requires numTrees > 0, but was given numTrees = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$numTrees())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).contains((Object)featureSubsetStrategy), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest given invalid featureSubsetStrategy: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Supported values: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ")}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class NodeIndexInfo
    implements Serializable {
        private final int nodeIndexInGroup;
        private final Option<int[]> featureSubset;

        public int nodeIndexInGroup() {
            return this.nodeIndexInGroup;
        }

        public Option<int[]> featureSubset() {
            return this.featureSubset;
        }

        public NodeIndexInfo(int nodeIndexInGroup, Option<int[]> featureSubset) {
            this.nodeIndexInGroup = nodeIndexInGroup;
            this.featureSubset = featureSubset;
        }
    }
}

