/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.NodeIdCache$;
import org.apache.spark.mllib.tree.impl.NodeIndexUpdater;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u0001\u0003\u0001\u0011q!a\u0003(pI\u0016LEmQ1dQ\u0016T!a\u0001\u0003\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001e:fK*\u0011q\u0001C\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011Y\u0001!\u00111A\u0005\u0002a\t1C\\8eK&#7OR8s\u0013:\u001cH/\u00198dKN\u001c\u0001!F\u0001\u001a!\rQRdH\u0007\u00027)\u0011A\u0004C\u0001\u0004e\u0012$\u0017B\u0001\u0010\u001c\u0005\r\u0011F\t\u0012\t\u0004!\u0001\u0012\u0013BA\u0011\u0012\u0005\u0015\t%O]1z!\t\u00012%\u0003\u0002%#\t\u0019\u0011J\u001c;\t\u0011\u0019\u0002!\u00111A\u0005\u0002\u001d\nqC\\8eK&#7OR8s\u0013:\u001cH/\u00198dKN|F%Z9\u0015\u0005!Z\u0003C\u0001\t*\u0013\tQ\u0013C\u0001\u0003V]&$\bb\u0002\u0017&\u0003\u0003\u0005\r!G\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0015B\r\u0002)9|G-Z%eg\u001a{'/\u00138ti\u0006t7-Z:!\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0014!D2iK\u000e\\\u0007o\\5oi\u0012K'/F\u00013!\r\u00012'N\u0005\u0003iE\u0011aa\u00149uS>t\u0007C\u0001\u001c:\u001d\t\u0001r'\u0003\u00029#\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tA\u0014\u0003\u0003\u0005>\u0001\t\u0005\t\u0015!\u00033\u00039\u0019\u0007.Z2la>Lg\u000e\u001e#je\u0002B\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001Q\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG.F\u0001#\u0011!\u0011\u0005A!A!\u0002\u0013\u0011\u0013aE2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2\u0004\u0003\"\u0002#\u0001\t\u0003)\u0015A\u0002\u001fj]&$h\b\u0006\u0003G\u0011&S\u0005CA$\u0001\u001b\u0005\u0011\u0001\"\u0002\fD\u0001\u0004I\u0002\"\u0002\u0019D\u0001\u0004\u0011\u0004\"B D\u0001\u0004\u0011\u0003b\u0002'\u0001\u0001\u0004%I\u0001G\u0001\u0018aJ,gOT8eK&#7OR8s\u0013:\u001cH/\u00198dKNDqA\u0014\u0001A\u0002\u0013%q*A\u000eqe\u00164hj\u001c3f\u0013\u0012\u001chi\u001c:J]N$\u0018M\\2fg~#S-\u001d\u000b\u0003QACq\u0001L'\u0002\u0002\u0003\u0007\u0011\u0004\u0003\u0004S\u0001\u0001\u0006K!G\u0001\u0019aJ,gOT8eK&#7OR8s\u0013:\u001cH/\u00198dKN\u0004\u0003b\u0002+\u0001\u0005\u0004%I!V\u0001\u0010G\",7m\u001b9pS:$\u0018+^3vKV\ta\u000bE\u0002X9fi\u0011\u0001\u0017\u0006\u00033j\u000bq!\\;uC\ndWM\u0003\u0002\\#\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005uC&!B)vKV,\u0007BB0\u0001A\u0003%a+\u0001\tdQ\u0016\u001c7\u000e]8j]R\fV/Z;fA!9\u0011\r\u0001a\u0001\n\u0013\u0001\u0015A\u0004:eIV\u0003H-\u0019;f\u0007>,h\u000e\u001e\u0005\bG\u0002\u0001\r\u0011\"\u0003e\u0003I\u0011H\rZ+qI\u0006$XmQ8v]R|F%Z9\u0015\u0005!*\u0007b\u0002\u0017c\u0003\u0003\u0005\rA\t\u0005\u0007O\u0002\u0001\u000b\u0015\u0002\u0012\u0002\u001fI$G-\u00169eCR,7i\\;oi\u0002BQ!\u001b\u0001\u0005\u0002)\f\u0011#\u001e9eCR,gj\u001c3f\u0013:$\u0017nY3t)\u0011A3\u000e^?\t\u000b1D\u0007\u0019A7\u0002\t\u0011\fG/\u0019\t\u00045uq\u0007cA$pc&\u0011\u0001O\u0001\u0002\f\u0005\u0006<w-\u001a3Q_&tG\u000f\u0005\u0002He&\u00111O\u0001\u0002\n)J,W\rU8j]RDQ!\u001e5A\u0002Y\faB\\8eK&#W\u000b\u001d3bi\u0016\u00148\u000fE\u0002\u0011A]\u0004Ba\u0016=#u&\u0011\u0011\u0010\u0017\u0002\u0004\u001b\u0006\u0004\bCA$|\u0013\ta(A\u0001\tO_\u0012,\u0017J\u001c3fqV\u0003H-\u0019;fe\")a\u0010\u001ba\u0001\u007f\u0006!!-\u001b8t!\u0011\u0001\u0002%!\u0001\u0011\tA\u0001\u00131\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0003\u0002\u000b5|G-\u001a7\n\t\u00055\u0011q\u0001\u0002\u0004\u0005&t\u0007bBA\t\u0001\u0011\u0005\u00111C\u0001\u0015I\u0016dW\r^3BY2\u001c\u0005.Z2la>Lg\u000e^:\u0015\u0003!B3\u0001AA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u00121\u0004\u0002\r\t\u00164X\r\\8qKJ\f\u0005/[\u0004\t\u0003K\u0011\u0001\u0012\u0001\u0003\u0002(\u0005Yaj\u001c3f\u0013\u0012\u001c\u0015m\u00195f!\r9\u0015\u0011\u0006\u0004\b\u0003\tA\t\u0001BA\u0016'\r\tIc\u0004\u0005\b\t\u0006%B\u0011AA\u0018)\t\t9\u0003\u0003\u0005\u00024\u0005%B\u0011AA\u001b\u0003\u0011Ig.\u001b;\u0015\u0017\u0019\u000b9$!\u000f\u0002>\u0005}\u0012\u0011\t\u0005\u0007Y\u0006E\u0002\u0019A7\t\u000f\u0005m\u0012\u0011\u0007a\u0001E\u0005Aa.^7Ue\u0016,7\u000f\u0003\u00041\u0003c\u0001\rA\r\u0005\u0007\u007f\u0005E\u0002\u0019\u0001\u0012\t\u0013\u0005\r\u0013\u0011\u0007I\u0001\u0002\u0004\u0011\u0013aB5oSR4\u0016\r\u001c\u0005\u000b\u0003\u000f\nI#%A\u0005\u0002\u0005%\u0013AD5oSR$C-\u001a4bk2$H%N\u000b\u0003\u0003\u0017R3AIA'W\t\ty\u0005\u0005\u0003\u0002R\u0005eSBAA*\u0015\u0011\t)&a\u0016\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000f#%!\u00111LA*\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0015\u0005\u0003S\t9\u0002\u000b\u0003\u0002$\u0005]\u0001")
public class NodeIdCache {
    private RDD<int[]> nodeIdsForInstances;
    private final Option<String> checkpointDir;
    private final int checkpointInterval;
    private RDD<int[]> prevNodeIdsForInstances;
    private final Queue<RDD<int[]>> checkpointQueue;
    private int rddUpdateCount;

    public static int init$default$5() {
        return NodeIdCache$.MODULE$.init$default$5();
    }

    public static NodeIdCache init(RDD<BaggedPoint<TreePoint>> rDD, int n, Option<String> option, int n2, int n3) {
        return NodeIdCache$.MODULE$.init(rDD, n, option, n2, n3);
    }

    public RDD<int[]> nodeIdsForInstances() {
        return this.nodeIdsForInstances;
    }

    public void nodeIdsForInstances_$eq(RDD<int[]> x$1) {
        this.nodeIdsForInstances = x$1;
    }

    public Option<String> checkpointDir() {
        return this.checkpointDir;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    private RDD<int[]> prevNodeIdsForInstances() {
        return this.prevNodeIdsForInstances;
    }

    private void prevNodeIdsForInstances_$eq(RDD<int[]> x$1) {
        this.prevNodeIdsForInstances = x$1;
    }

    private Queue<RDD<int[]>> checkpointQueue() {
        return this.checkpointQueue;
    }

    private int rddUpdateCount() {
        return this.rddUpdateCount;
    }

    private void rddUpdateCount_$eq(int x$1) {
        this.rddUpdateCount = x$1;
    }

    public void updateNodeIndices(RDD<BaggedPoint<TreePoint>> data, Map<Object, NodeIndexUpdater>[] nodeIdUpdaters, Bin[][] bins) {
        BoxedUnit boxedUnit;
        if (this.prevNodeIdsForInstances() == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            RDD<int[]> qual$1 = this.prevNodeIdsForInstances();
            boolean x$2 = qual$1.unpersist$default$1();
            boxedUnit = qual$1.unpersist(x$2);
        }
        this.prevNodeIdsForInstances_$eq(this.nodeIdsForInstances());
        this.nodeIdsForInstances_$eq((RDD<int[]>)data.zip(this.nodeIdsForInstances(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).map((Function1)new Serializable(this, nodeIdUpdaters, bins){
            public static final long serialVersionUID = 0L;
            private final Map[] nodeIdUpdaters$1;
            private final Bin[][] bins$1;

            public final int[] apply(Tuple2<BaggedPoint<TreePoint>, int[]> dataPoint) {
                for (int treeId = 0; treeId < this.nodeIdUpdaters$1.length; ++treeId) {
                    int newNodeIndex;
                    NodeIndexUpdater nodeIdUpdater = (NodeIndexUpdater)this.nodeIdUpdaters$1[treeId].getOrElse((Object)BoxesRunTime.boxToInteger((int)((int[])dataPoint._2())[treeId]), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Null$ apply() {
                            return null;
                        }
                    });
                    if (nodeIdUpdater == null) continue;
                    ((int[])dataPoint._2())[treeId] = newNodeIndex = nodeIdUpdater.updateNodeIndex(((TreePoint)((BaggedPoint)dataPoint._1()).datum()).binnedFeatures(), this.bins$1);
                }
                return (int[])dataPoint._2();
            }
            {
                this.nodeIdUpdaters$1 = nodeIdUpdaters$1;
                this.bins$1 = bins$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))));
        this.nodeIdsForInstances().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        this.rddUpdateCount_$eq(this.rddUpdateCount() + 1);
        if (this.nodeIdsForInstances().sparkContext().getCheckpointDir().nonEmpty() && this.rddUpdateCount() % this.checkpointInterval() == 0) {
            boolean canDelete = true;
            while (this.checkpointQueue().size() > 1 && canDelete) {
                Object object;
                Option option = ((RDD)this.checkpointQueue().get(1).get()).getCheckpointFile();
                None$ none$ = None$.MODULE$;
                if (!(option != null ? !option.equals(none$) : none$ != null)) {
                    canDelete = false;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                RDD old = (RDD)this.checkpointQueue().dequeue();
                FileSystem fs = FileSystem.get((Configuration)old.sparkContext().hadoopConfiguration());
                object = BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path((String)old.getCheckpointFile().get()), true));
            }
            this.nodeIdsForInstances().checkpoint();
            this.checkpointQueue().enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RDD[]{this.nodeIdsForInstances()}));
        }
    }

    public void deleteAllCheckpoints() {
        while (this.checkpointQueue().size() > 0) {
            Object object;
            RDD old = (RDD)this.checkpointQueue().dequeue();
            Option option = old.getCheckpointFile();
            None$ none$ = None$.MODULE$;
            if (!(option != null ? !option.equals(none$) : none$ != null)) {
                object = BoxedUnit.UNIT;
                continue;
            }
            FileSystem fs = FileSystem.get((Configuration)old.sparkContext().hadoopConfiguration());
            object = BoxesRunTime.boxToBoolean((boolean)fs.delete(new Path((String)old.getCheckpointFile().get()), true));
        }
    }

    public NodeIdCache(RDD<int[]> nodeIdsForInstances, Option<String> checkpointDir, int checkpointInterval) {
        this.nodeIdsForInstances = nodeIdsForInstances;
        this.checkpointDir = checkpointDir;
        this.checkpointInterval = checkpointInterval;
        this.prevNodeIdsForInstances = null;
        this.checkpointQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.rddUpdateCount = 0;
        if (checkpointDir.nonEmpty() && this.nodeIdsForInstances().sparkContext().getCheckpointDir().isEmpty()) {
            this.nodeIdsForInstances().sparkContext().setCheckpointDir((String)checkpointDir.get());
        }
    }
}

