/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.classification;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.argmax$;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.classification.ClassificationModel;
import org.apache.spark.mllib.classification.ClassificationModel$class;
import org.apache.spark.mllib.classification.NaiveBayesModel;
import org.apache.spark.mllib.classification.NaiveBayesModel$;
import org.apache.spark.mllib.classification.NaiveBayesModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tEc\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001qA\u0003G\u000e\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\nDY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u00103%\u0011!\u0004\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00039}i\u0011!\b\u0006\u0003=\u0011\tA!\u001e;jY&\u0011\u0001%\b\u0002\t'\u00064X-\u00192mK\"A!\u0005\u0001BC\u0002\u0013\u00051%\u0001\u0004mC\n,Gn]\u000b\u0002IA\u0019q\"J\u0014\n\u0005\u0019\u0002\"!B!se\u0006L\bCA\b)\u0013\tI\u0003C\u0001\u0004E_V\u0014G.\u001a\u0005\tW\u0001\u0011\t\u0011)A\u0005I\u00059A.\u00192fYN\u0004\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011A\u0012\u0002\u0005AL\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0007AL\u0007\u0005\u0003\u00052\u0001\t\u0015\r\u0011\"\u00013\u0003\u0015!\b.\u001a;b+\u0005\u0019\u0004cA\b&I!AQ\u0007\u0001B\u0001B\u0003%1'\u0001\u0004uQ\u0016$\u0018\r\t\u0005\u0007o\u0001!\t\u0001\u0002\u001d\u0002\rqJg.\u001b;?)\u0011I$h\u000f\u001f\u0011\u0005U\u0001\u0001\"\u0002\u00127\u0001\u0004!\u0003\"B\u00177\u0001\u0004!\u0003\"B\u00197\u0001\u0004\u0019\u0004b\u0002 \u0001\u0005\u0004%IaP\u0001\u0006EJT\b+[\u000b\u0002\u0001B\u0019\u0011IR\u0014\u000e\u0003\tS!a\u0011#\u0002\r1Lg.\u00197h\u0015\u0005)\u0015A\u00022sK\u0016TX-\u0003\u0002H\u0005\nYA)\u001a8tKZ+7\r^8s\u0011\u0019I\u0005\u0001)A\u0005\u0001\u00061!M\u001d>QS\u0002Bqa\u0013\u0001C\u0002\u0013%A*\u0001\u0005cej$\u0006.\u001a;b+\u0005i\u0005cA!OO%\u0011qJ\u0011\u0002\f\t\u0016t7/Z'biJL\u0007\u0010\u0003\u0004R\u0001\u0001\u0006I!T\u0001\nEJTH\u000b[3uC\u0002BQa\u0015\u0001\u0005BQ\u000bq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002V7B\u0019a+W\u0014\u000e\u0003]S!\u0001\u0017\u0004\u0002\u0007I$G-\u0003\u0002[/\n\u0019!\u000b\u0012#\t\u000bq\u0013\u0006\u0019A/\u0002\u0011Q,7\u000f\u001e#bi\u0006\u00042AV-_!\ty\u0016-D\u0001a\u0015\t\u0019E!\u0003\u0002cA\n1a+Z2u_JDQa\u0015\u0001\u0005B\u0011$\"aJ3\t\u000bq\u001b\u0007\u0019\u00010\t\u000b\u001d\u0004A\u0011\t5\u0002\tM\fg/\u001a\u000b\u0004S2\u0014\bCA\bk\u0013\tY\u0007C\u0001\u0003V]&$\b\"B7g\u0001\u0004q\u0017AA:d!\ty\u0007/D\u0001\u0007\u0013\t\thA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003tM\u0002\u0007A/\u0001\u0003qCRD\u0007CA;y\u001d\tya/\u0003\u0002x!\u00051\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t9\b\u0003C\u0003}\u0001\u0011ES0A\u0007g_Jl\u0017\r\u001e,feNLwN\\\u000b\u0002i\u001e1qP\u0001E\u0001\u0003\u0003\tqBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\t\u0004+\u0005\raAB\u0001\u0003\u0011\u0003\t)a\u0005\u0004\u0002\u00049\t9\u0001\u0007\t\u00059\u0005%\u0011(C\u0002\u0002\fu\u0011a\u0001T8bI\u0016\u0014\bbB\u001c\u0002\u0004\u0011\u0005\u0011q\u0002\u000b\u0003\u0003\u00039\u0001\"a\u0005\u0002\u0004!%\u0011QC\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u0003/\tI\"\u0004\u0002\u0002\u0004\u0019A\u00111DA\u0002\u0011\u0013\tiB\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0002\u001a9AqaNA\r\t\u0003\t\t\u0003\u0006\u0002\u0002\u0016!A\u0011QEA\r\t\u0003\t9#A\tuQ&\u001chi\u001c:nCR4VM]:j_:,\"!!\u000b\u0011\t\u0005-\u0012QG\u0007\u0003\u0003[QA!a\f\u00022\u0005!A.\u00198h\u0015\t\t\u0019$\u0001\u0003kCZ\f\u0017bA=\u0002.!A\u0011\u0011HA\r\t\u0003\t9#A\u0007uQ&\u001c8\t\\1tg:\u000bW.\u001a\u0004\b\u0003{\tI\u0002QA \u0005\u0011!\u0015\r^1\u0014\r\u0005mb\"!\u0011\u0019!\ry\u00111I\u0005\u0004\u0003\u000b\u0002\"a\u0002)s_\u0012,8\r\u001e\u0005\nE\u0005m\"Q3A\u0005\u0002\rB\u0011bKA\u001e\u0005#\u0005\u000b\u0011\u0002\u0013\t\u00135\nYD!f\u0001\n\u0003\u0019\u0003\"C\u0018\u0002<\tE\t\u0015!\u0003%\u0011%\t\u00141\bBK\u0002\u0013\u0005!\u0007C\u00056\u0003w\u0011\t\u0012)A\u0005g!9q'a\u000f\u0005\u0002\u0005UC\u0003CA,\u00037\ni&a\u0018\u0011\t\u0005e\u00131H\u0007\u0003\u00033AaAIA*\u0001\u0004!\u0003BB\u0017\u0002T\u0001\u0007A\u0005\u0003\u00042\u0003'\u0002\ra\r\u0005\u000b\u0003G\nY$!A\u0005\u0002\u0005\u0015\u0014\u0001B2paf$\u0002\"a\u0016\u0002h\u0005%\u00141\u000e\u0005\tE\u0005\u0005\u0004\u0013!a\u0001I!AQ&!\u0019\u0011\u0002\u0003\u0007A\u0005\u0003\u00052\u0003C\u0002\n\u00111\u00014\u0011)\ty'a\u000f\u0012\u0002\u0013\u0005\u0011\u0011O\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019HK\u0002%\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003\u0003\u0012AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003\u0013\u000bY$%A\u0005\u0002\u0005E\u0014AD2paf$C-\u001a4bk2$HE\r\u0005\u000b\u0003\u001b\u000bY$%A\u0005\u0002\u0005=\u0015AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003#S3aMA;\u0011)\t)*a\u000f\u0002\u0002\u0013\u0005\u0013qE\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0015\u0005e\u00151HA\u0001\n\u0003\tY*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u001eB\u0019q\"a(\n\u0007\u0005\u0005\u0006CA\u0002J]RD!\"!*\u0002<\u0005\u0005I\u0011AAT\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!+\u00020B\u0019q\"a+\n\u0007\u00055\u0006CA\u0002B]fD!\"!-\u0002$\u0006\u0005\t\u0019AAO\u0003\rAH%\r\u0005\u000b\u0003k\u000bY$!A\u0005B\u0005]\u0016a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005e\u0006CBA^\u0003\u0003\fI+\u0004\u0002\u0002>*\u0019\u0011q\u0018\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002D\u0006u&\u0001C%uKJ\fGo\u001c:\t\u0015\u0005\u001d\u00171HA\u0001\n\u0003\tI-\u0001\u0005dC:,\u0015/^1m)\u0011\tY-!5\u0011\u0007=\ti-C\u0002\u0002PB\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u00022\u0006\u0015\u0017\u0011!a\u0001\u0003SC!\"!6\u0002<\u0005\u0005I\u0011IAl\u0003!A\u0017m\u001d5D_\u0012,GCAAO\u0011)\tY.a\u000f\u0002\u0002\u0013\u0005\u0013Q\\\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u0006\u0005\u000b\u0003C\fY$!A\u0005B\u0005\r\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002L\u0006\u0015\bBCAY\u0003?\f\t\u00111\u0001\u0002*\u001eQ\u0011\u0011^A\r\u0003\u0003E\t!a;\u0002\t\u0011\u000bG/\u0019\t\u0005\u00033\niO\u0002\u0006\u0002>\u0005e\u0011\u0011!E\u0001\u0003_\u001cR!!<\u0002rb\u0001\u0012\"a=\u0002z\u0012\"3'a\u0016\u000e\u0005\u0005U(bAA|!\u00059!/\u001e8uS6,\u0017\u0002BA~\u0003k\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84\u0011\u001d9\u0014Q\u001eC\u0001\u0003\u007f$\"!a;\t\u0015\u0005m\u0017Q^A\u0001\n\u000b\ni\u000e\u0003\u0006\u0003\u0006\u00055\u0018\u0011!CA\u0005\u000f\tQ!\u00199qYf$\u0002\"a\u0016\u0003\n\t-!Q\u0002\u0005\u0007E\t\r\u0001\u0019\u0001\u0013\t\r5\u0012\u0019\u00011\u0001%\u0011\u0019\t$1\u0001a\u0001g!Q!\u0011CAw\u0003\u0003%\tIa\u0005\u0002\u000fUt\u0017\r\u001d9msR!!Q\u0003B\u0011!\u0015y!q\u0003B\u000e\u0013\r\u0011I\u0002\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r=\u0011i\u0002\n\u00134\u0013\r\u0011y\u0002\u0005\u0002\u0007)V\u0004H.Z\u001a\t\u0015\t\r\"qBA\u0001\u0002\u0004\t9&A\u0002yIAB!Ba\n\u0002n\u0006\u0005I\u0011\u0002B\u0015\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t-\u0002\u0003BA\u0016\u0005[IAAa\f\u0002.\t1qJ\u00196fGRDqaZA\r\t\u0003\u0011\u0019\u0004F\u0004j\u0005k\u00119D!\u000f\t\r5\u0014\t\u00041\u0001o\u0011\u0019\u0019(\u0011\u0007a\u0001i\"A!1\bB\u0019\u0001\u0004\t9&\u0001\u0003eCR\f\u0007\u0002\u0003B \u00033!\tA!\u0011\u0002\t1|\u0017\r\u001a\u000b\u0006s\t\r#Q\t\u0005\u0007[\nu\u0002\u0019\u00018\t\rM\u0014i\u00041\u0001u\u0011!\u0011y$a\u0001\u0005B\t%C#B\u001d\u0003L\t5\u0003BB7\u0003H\u0001\u0007a\u000e\u0003\u0004t\u0005\u000f\u0002\r\u0001\u001e\u0005\u000b\u0005O\t\u0019!!A\u0005\n\t%\u0002")
public class NaiveBayesModel
implements ClassificationModel,
Saveable {
    private final double[] labels;
    private final double[] pi;
    private final double[][] theta;
    private final DenseVector<Object> brzPi;
    private final DenseMatrix<Object> brzTheta;

    public static NaiveBayesModel load(SparkContext sparkContext, String string) {
        return NaiveBayesModel$.MODULE$.load(sparkContext, string);
    }

    @Override
    public JavaRDD<Double> predict(JavaRDD<Vector> testData) {
        return ClassificationModel$class.predict(this, testData);
    }

    public double[] labels() {
        return this.labels;
    }

    public double[] pi() {
        return this.pi;
    }

    public double[][] theta() {
        return this.theta;
    }

    private DenseVector<Object> brzPi() {
        return this.brzPi;
    }

    private DenseMatrix<Object> brzTheta() {
        return this.brzTheta;
    }

    @Override
    public RDD<Object> predict(RDD<Vector> testData) {
        Broadcast bcModel = testData.context().broadcast((Object)this, ClassTag$.MODULE$.apply(NaiveBayesModel.class));
        return testData.mapPartitions((Function1)new Serializable(this, bcModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcModel$1;

            public final Iterator<Object> apply(Iterator<Vector> iter) {
                NaiveBayesModel model = (NaiveBayesModel)this.bcModel$1.value();
                return iter.map((Function1)new Serializable(this, model){
                    public static final long serialVersionUID = 0L;
                    private final NaiveBayesModel model$1;

                    public final double apply(Vector testData) {
                        return this.model$1.predict(testData);
                    }
                    {
                        this.model$1 = model$1;
                    }
                });
            }
            {
                this.bcModel$1 = bcModel$1;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    @Override
    public double predict(Vector testData) {
        return this.labels()[BoxesRunTime.unboxToInt((Object)argmax$.MODULE$.apply(this.brzPi().$plus(this.brzTheta().$times(testData.toBreeze(), (UFunc.UImpl2)DenseMatrix$.MODULE$.op_DM_V_Double()), DenseVector$.MODULE$.canAddD()), argmax$.MODULE$.reduce_Double(DenseVector$.MODULE$.canTraverseKeyValuePairs())))];
    }

    @Override
    public void save(SparkContext sc, String path) {
        SaveLoadV1_0.Data data = new SaveLoadV1_0.Data(this.labels(), this.pi(), this.theta());
        NaiveBayesModel$SaveLoadV1_0$.MODULE$.save(sc, path, data);
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public NaiveBayesModel(double[] labels, double[] pi, double[][] theta) {
        this.labels = labels;
        this.pi = pi;
        this.theta = theta;
        ClassificationModel$class.$init$(this);
        this.brzPi = new DenseVector.mcD.sp(pi);
        this.brzTheta = new DenseMatrix.mcD.sp(theta.length, theta[0].length, ClassTag$.MODULE$.Double());
        for (int i = 0; i < theta.length; ++i) {
            for (int j = 0; j < theta[i].length; ++j) {
                this.brzTheta().update$mcD$sp(i, j, theta[i][j]);
            }
        }
    }
}

