/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u001b\tY1*T3b]Nlu\u000eZ3m\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001a\u00039\u0019G.^:uKJ\u001cUM\u001c;feN,\u0012A\u0007\t\u0004\u001fmi\u0012B\u0001\u000f\u0011\u0005\u0015\t%O]1z!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0004mS:\fGnZ\u0005\u0003E}\u0011aAV3di>\u0014\b\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u001f\rdWo\u001d;fe\u000e+g\u000e^3sg\u0002BQA\n\u0001\u0005\u0002\u001d\na\u0001P5oSRtDC\u0001\u0015+!\tI\u0003!D\u0001\u0003\u0011\u0015AR\u00051\u0001\u001b\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0005YW#\u0001\u0018\u0011\u0005=y\u0013B\u0001\u0019\u0011\u0005\rIe\u000e\u001e\u0005\u0006e\u0001!\taM\u0001\baJ,G-[2u)\tqC\u0007C\u00036c\u0001\u0007Q$A\u0003q_&tG\u000fC\u00033\u0001\u0011\u0005q\u0007\u0006\u00029}A\u0019\u0011\b\u0010\u0018\u000e\u0003iR!a\u000f\u0004\u0002\u0007I$G-\u0003\u0002>u\t\u0019!\u000b\u0012#\t\u000b}2\u0004\u0019\u0001!\u0002\rA|\u0017N\u001c;t!\rID(\b\u0005\u0006e\u0001!\tA\u0011\u000b\u0003\u0007J\u00032\u0001R%L\u001b\u0005)%B\u0001$H\u0003\u0011Q\u0017M^1\u000b\u0005!3\u0011aA1qS&\u0011!*\u0012\u0002\b\u0015\u00064\u0018M\u0015#E!\ta\u0005+D\u0001N\u0015\tqu*\u0001\u0003mC:<'\"\u0001$\n\u0005Ek%aB%oi\u0016<WM\u001d\u0005\u0006\u007f\u0005\u0003\ra\u0015\t\u0004\t&k\u0002\"B+\u0001\t\u00031\u0016aC2p[B,H/Z\"pgR$\"a\u0016.\u0011\u0005=A\u0016BA-\u0011\u0005\u0019!u.\u001e2mK\")1\f\u0016a\u0001\u0001\u0006!A-\u0019;b\u0011\u0015i\u0006\u0001\"\u0003_\u0003Y\u0019G.^:uKJ\u001cUM\u001c;feN<\u0016\u000e\u001e5O_JlW#A0\u0011\u0007\u0001D7N\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011A\rD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u001a\t\u0002\u000fA\f7m[1hK&\u0011\u0011N\u001b\u0002\t\u0013R,'/\u00192mK*\u0011q\r\u0005\t\u0003S1L!!\u001c\u0002\u0003\u001dY+7\r^8s/&$\bNT8s[\u0002")
public class KMeansModel
implements Serializable {
    private final Vector[] clusterCenters;

    public Vector[] clusterCenters() {
        return this.clusterCenters;
    }

    public int k() {
        return this.clusterCenters().length;
    }

    public int predict(Vector point) {
        return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)this.clusterCentersWithNorm(), new VectorWithNorm(point))._1$mcI$sp();
    }

    public RDD<Object> predict(RDD<Vector> points) {
        Iterable<VectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        Broadcast bcCentersWithNorm = points.context().broadcast(centersWithNorm, ClassTag$.MODULE$.apply(Iterable.class));
        return points.map((Function1)new Serializable(this, bcCentersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcCentersWithNorm$1;

            public final int apply(Vector p) {
                return KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCentersWithNorm$1.value()), new VectorWithNorm(p))._1$mcI$sp();
            }
            {
                this.bcCentersWithNorm$1 = bcCentersWithNorm$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public double computeCost(RDD<Vector> data) {
        Iterable<VectorWithNorm> centersWithNorm = this.clusterCentersWithNorm();
        Broadcast bcCentersWithNorm = data.context().broadcast(centersWithNorm, ClassTag$.MODULE$.apply(Iterable.class));
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1)new Serializable(this, bcCentersWithNorm){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcCentersWithNorm$2;

            public final double apply(Vector p) {
                return KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((TraversableOnce)this.bcCentersWithNorm$2.value()), new VectorWithNorm(p));
            }
            {
                this.bcCentersWithNorm$2 = bcCentersWithNorm$2;
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    private Iterable<VectorWithNorm> clusterCentersWithNorm() {
        return (Iterable)Predef$.MODULE$.refArrayOps((Object[])this.clusterCenters()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Vector x$1) {
                return new VectorWithNorm(x$1);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public KMeansModel(Vector[] clusterCenters) {
        this.clusterCenters = clusterCenters;
    }
}

