/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.storage.Zero;
import org.apache.spark.Partitioner;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix$;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0001\u0003\u0001=\u0011\u0001cQ8pe\u0012Lg.\u0019;f\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0012\t&\u001cHO]5ckR,G-T1ue&D\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f\u0015tGO]5fgV\tQ\u0004E\u0002\u001fC\rj\u0011a\b\u0006\u0003A!\t1A\u001d3e\u0013\t\u0011sDA\u0002S\t\u0012\u0003\"a\u0006\u0013\n\u0005\u0015\u0012!aC'biJL\u00070\u00128uefD\u0001b\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\tK:$(/[3tA!A\u0011\u0006\u0001BA\u0002\u0013%!&A\u0003o%><8/F\u0001,!\t\tB&\u0003\u0002.%\t!Aj\u001c8h\u0011!y\u0003A!a\u0001\n\u0013\u0001\u0014!\u00038S_^\u001cx\fJ3r)\t\tD\u0007\u0005\u0002\u0012e%\u00111G\u0005\u0002\u0005+:LG\u000fC\u00046]\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013\u0007\u0003\u00058\u0001\t\u0005\t\u0015)\u0003,\u0003\u0019q'k\\<tA!A\u0011\b\u0001BA\u0002\u0013%!&A\u0003o\u0007>d7\u000f\u0003\u0005<\u0001\t\u0005\r\u0011\"\u0003=\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u00022{!9QGOA\u0001\u0002\u0004Y\u0003\u0002C \u0001\u0005\u0003\u0005\u000b\u0015B\u0016\u0002\r9\u001cu\u000e\\:!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q!1\tR#G!\t9\u0002\u0001C\u0003\u001c\u0001\u0002\u0007Q\u0004C\u0003*\u0001\u0002\u00071\u0006C\u0003:\u0001\u0002\u00071\u0006C\u0003B\u0001\u0011\u0005\u0001\n\u0006\u0002D\u0013\")1d\u0012a\u0001;!)1\n\u0001C!\u0019\u00069a.^7D_2\u001cH#A\u0016\t\u000b9\u0003A\u0011\t'\u0002\u000f9,XNU8xg\")\u0001\u000b\u0001C\u0001#\u0006IAO]1ogB|7/\u001a\u000b\u0002\u0007\")1\u000b\u0001C\u0001)\u0006\u0011Bo\\%oI\u0016DX\r\u001a*po6\u000bGO]5y)\u0005)\u0006CA\fW\u0013\t9&A\u0001\tJ]\u0012,\u00070\u001a3S_^l\u0015\r\u001e:jq\")\u0011\f\u0001C\u00015\u0006YAo\u001c*po6\u000bGO]5y)\u0005Y\u0006CA\f]\u0013\ti&AA\u0005S_^l\u0015\r\u001e:jq\")q\f\u0001C\u0001A\u0006iAo\u001c\"m_\u000e\\W*\u0019;sSb$\u0012!\u0019\t\u0003/\tL!a\u0019\u0002\u0003\u0017\tcwnY6NCR\u0014\u0018\u000e\u001f\u0005\u0006?\u0002!\t!\u001a\u000b\u0004C\u001a\\\u0007\"B4e\u0001\u0004A\u0017\u0001\u0004:poN\u0004VM\u001d\"m_\u000e\\\u0007CA\tj\u0013\tQ'CA\u0002J]RDQ\u0001\u001c3A\u0002!\fAbY8mgB+'O\u00117pG.DQA\u001c\u0001\u0005\n=\f1bY8naV$XmU5{KR\t\u0011\u0007\u0003\u0004r\u0001\u0011\u0005cA]\u0001\ti>\u0014%/Z3{KR\t1\u000fE\u0002uqjl\u0011!\u001e\u0006\u0003\u000bYT\u0011a^\u0001\u0007EJ,WM_3\n\u0005e,(a\u0003#f]N,W*\u0019;sSb\u0004\"!E>\n\u0005q\u0014\"A\u0002#pk\ndW\r\u000b\u0002\u0001}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002\u0011\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0011\u0011\u0001\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class CoordinateMatrix
implements DistributedMatrix {
    private final RDD<MatrixEntry> entries;
    private long nRows;
    private long nCols;

    public RDD<MatrixEntry> entries() {
        return this.entries;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private long nCols() {
        return this.nCols;
    }

    private void nCols_$eq(long x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0L) {
            this.computeSize();
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.computeSize();
        }
        return this.nRows();
    }

    public CoordinateMatrix transpose() {
        return new CoordinateMatrix((RDD<MatrixEntry>)this.entries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MatrixEntry apply(MatrixEntry x) {
                return new MatrixEntry(x.j(), x.i(), x.value());
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class)), this.numCols(), this.numRows());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        long nl = this.numCols();
        if (nl > Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot convert to a row-oriented format because the number of columns ", " is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)nl)}))).append((Object)"too large.").toString());
        }
        int n = (int)nl;
        RDD indexedRows = RDD$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<Object, Object>> apply(MatrixEntry entry) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)entry.i()), (Object)new Tuple2.mcID.sp((int)entry.j(), entry.value()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Long$.MODULE$).groupByKey().map((Function1)new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final IndexedRow apply(Tuple2<Object, Iterable<Tuple2<Object, Object>>> x0$1) {
                Tuple2<Object, Iterable<Tuple2<Object, Object>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    long i = tuple2._1$mcJ$sp();
                    Iterable vectorEntries = (Iterable)tuple2._2();
                    IndexedRow indexedRow = new IndexedRow(i, Vectors$.MODULE$.sparse(this.n$1, (Seq<Tuple2<Object, Object>>)vectorEntries.toSeq()));
                    return indexedRow;
                }
                throw new MatchError(tuple2);
            }
            {
                this.n$1 = n$1;
            }
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)indexedRows, this.numRows(), n);
    }

    public RowMatrix toRowMatrix() {
        return this.toIndexedRowMatrix().toRowMatrix();
    }

    public BlockMatrix toBlockMatrix() {
        return this.toBlockMatrix(1024, 1024);
    }

    public BlockMatrix toBlockMatrix(int rowsPerBlock, int colsPerBlock) {
        Predef$.MODULE$.require(rowsPerBlock > 0, (Function0)new Serializable(this, rowsPerBlock){
            public static final long serialVersionUID = 0L;
            private final int rowsPerBlock$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowsPerBlock needs to be greater than 0. rowsPerBlock: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rowsPerBlock$1)}));
            }
            {
                this.rowsPerBlock$1 = rowsPerBlock$1;
            }
        });
        Predef$.MODULE$.require(colsPerBlock > 0, (Function0)new Serializable(this, colsPerBlock){
            public static final long serialVersionUID = 0L;
            private final int colsPerBlock$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"colsPerBlock needs to be greater than 0. colsPerBlock: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsPerBlock$1)}));
            }
            {
                this.colsPerBlock$1 = colsPerBlock$1;
            }
        });
        long m = this.numRows();
        long n = this.numCols();
        int numRowBlocks = (int)package$.MODULE$.ceil((double)m / (double)rowsPerBlock);
        int numColBlocks = (int)package$.MODULE$.ceil((double)n / (double)colsPerBlock);
        GridPartitioner partitioner = GridPartitioner$.MODULE$.apply(numRowBlocks, numColBlocks, this.entries().partitions().length);
        RDD blocks = RDD$.MODULE$.rddToPairRDDFunctions(this.entries().map((Function1)new Serializable(this, rowsPerBlock, colsPerBlock){
            public static final long serialVersionUID = 0L;
            private final int rowsPerBlock$1;
            private final int colsPerBlock$1;

            public final Tuple2<Tuple2<Object, Object>, Tuple3<Object, Object, Object>> apply(MatrixEntry entry) {
                int blockRowIndex = (int)(entry.i() / (long)this.rowsPerBlock$1);
                int blockColIndex = (int)(entry.j() / (long)this.colsPerBlock$1);
                long rowId = entry.i() % (long)this.rowsPerBlock$1;
                long colId = entry.j() % (long)this.colsPerBlock$1;
                return new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)((int)rowId)), (Object)BoxesRunTime.boxToInteger((int)((int)colId)), (Object)BoxesRunTime.boxToDouble((double)entry.value())));
            }
            {
                this.rowsPerBlock$1 = rowsPerBlock$1;
                this.colsPerBlock$1 = colsPerBlock$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple3.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).groupByKey((Partitioner)partitioner).map((Function1)new Serializable(this, rowsPerBlock, colsPerBlock, m, n){
            public static final long serialVersionUID = 0L;
            private final int rowsPerBlock$1;
            private final int colsPerBlock$1;
            private final long m$1;
            private final long n$2;

            public final Tuple2<Tuple2<Object, Object>, Matrix> apply(Tuple2<Tuple2<Object, Object>, Iterable<Tuple3<Object, Object, Object>>> x0$2) {
                Tuple2<Tuple2<Object, Object>, Iterable<Tuple3<Object, Object, Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Iterable entry = (Iterable)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        int effRows = (int)package$.MODULE$.min(this.m$1 - (long)blockRowIndex * (long)this.rowsPerBlock$1, (long)this.rowsPerBlock$1);
                        int effCols = (int)package$.MODULE$.min(this.n$2 - (long)blockColIndex * (long)this.colsPerBlock$1, (long)this.colsPerBlock$1);
                        Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)SparseMatrix$.MODULE$.fromCOO(effRows, effCols, (Iterable<Tuple3<Object, Object, Object>>)entry));
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.rowsPerBlock$1 = rowsPerBlock$1;
                this.colsPerBlock$1 = colsPerBlock$1;
                this.m$1 = m$1;
                this.n$2 = n$2;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)blocks, rowsPerBlock, colsPerBlock, m, n);
    }

    private void computeSize() {
        Tuple2 tuple2 = (Tuple2)this.entries().map((Function1)new $anonfun$5(this), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new $anonfun$6(this));
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long m1 = tuple2._1$mcJ$sp();
            long n1 = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(m1, n1);
            long m12 = sp3._1$mcJ$sp();
            long n12 = sp3._2$mcJ$sp();
            this.nRows_$eq(package$.MODULE$.max(this.nRows(), m12 + 1L));
            this.nCols_$eq(package$.MODULE$.max(this.nCols(), n12 + 1L));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])this.entries().collect()).foreach((Function1)new Serializable(this, mat){
            public static final long serialVersionUID = 0L;
            private final DenseMatrix mat$1;

            public final void apply(MatrixEntry x0$4) {
                MatrixEntry matrixEntry = x0$4;
                if (matrixEntry != null) {
                    long i = matrixEntry.i();
                    long j = matrixEntry.j();
                    double value = matrixEntry.value();
                    this.mat$1.update$mcD$sp((int)i, (int)j, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)matrixEntry);
            }
            {
                this.mat$1 = mat$1;
            }
        });
        return var3_3;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries, long nRows, long nCols) {
        this.entries = entries;
        this.nRows = nRows;
        this.nCols = nCols;
    }

    public CoordinateMatrix(RDD<MatrixEntry> entries) {
        this(entries, 0L, 0L);
    }
}

