/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LinearRegressionModel;
import org.apache.spark.mllib.regression.LinearRegressionWithSGD;
import org.apache.spark.mllib.regression.StreamingLinearAlgorithm;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\t\u00013\u000b\u001e:fC6Lgn\u001a'j]\u0016\f'OU3he\u0016\u001c8/[8o/&$\bnU$E\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001da\u0001Ba\u0004\t\u0013+5\t!!\u0003\u0002\u0012\u0005\tA2\u000b\u001e:fC6Lgn\u001a'j]\u0016\f'/\u00117h_JLG\u000f[7\u0011\u0005=\u0019\u0012B\u0001\u000b\u0003\u0005Ua\u0015N\\3beJ+wM]3tg&|g.T8eK2\u0004\"a\u0004\f\n\u0005]\u0011!a\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o/&$\bnU$E!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!y\u0002A!a\u0001\n\u0013\u0001\u0013\u0001C:uKB\u001c\u0016N_3\u0016\u0003\u0005\u0002\"!\u0007\u0012\n\u0005\rR\"A\u0002#pk\ndW\r\u0003\u0005&\u0001\t\u0005\r\u0011\"\u0003'\u00031\u0019H/\u001a9TSj,w\fJ3r)\t9#\u0006\u0005\u0002\u001aQ%\u0011\u0011F\u0007\u0002\u0005+:LG\u000fC\u0004,I\u0005\u0005\t\u0019A\u0011\u0002\u0007a$\u0013\u0007\u0003\u0005.\u0001\t\u0005\t\u0015)\u0003\"\u0003%\u0019H/\u001a9TSj,\u0007\u0005\u0003\u00050\u0001\t\u0005\r\u0011\"\u00031\u00035qW/\\%uKJ\fG/[8ogV\t\u0011\u0007\u0005\u0002\u001ae%\u00111G\u0007\u0002\u0004\u0013:$\b\u0002C\u001b\u0001\u0005\u0003\u0007I\u0011\u0002\u001c\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002(o!91\u0006NA\u0001\u0002\u0004\t\u0004\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0015B\u0019\u0002\u001d9,X.\u0013;fe\u0006$\u0018n\u001c8tA!A1\b\u0001BA\u0002\u0013%\u0001%A\tnS:L')\u0019;dQ\u001a\u0013\u0018m\u0019;j_:D\u0001\"\u0010\u0001\u0003\u0002\u0004%IAP\u0001\u0016[&t\u0017NQ1uG\"4%/Y2uS>tw\fJ3r)\t9s\bC\u0004,y\u0005\u0005\t\u0019A\u0011\t\u0011\u0005\u0003!\u0011!Q!\n\u0005\n!#\\5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8oA!11\t\u0001C\u0001\t\u0011\u000ba\u0001P5oSRtD\u0003B#G\u000f\"\u0003\"a\u0004\u0001\t\u000b}\u0011\u0005\u0019A\u0011\t\u000b=\u0012\u0005\u0019A\u0019\t\u000bm\u0012\u0005\u0019A\u0011\t\u000b\r\u0003A\u0011\u0001&\u0015\u0003\u0015Cq\u0001\u0014\u0001C\u0002\u0013\u0005Q*A\u0005bY\u001e|'/\u001b;i[V\tQ\u0003\u0003\u0004P\u0001\u0001\u0006I!F\u0001\u000bC2<wN]5uQ6\u0004\u0003bB)\u0001\u0001\u0004%\tBU\u0001\u0006[>$W\r\\\u000b\u0002'B\u0019\u0011\u0004\u0016\n\n\u0005US\"AB(qi&|g\u000eC\u0004X\u0001\u0001\u0007I\u0011\u0003-\u0002\u00135|G-\u001a7`I\u0015\fHCA\u0014Z\u0011\u001dYc+!AA\u0002MCaa\u0017\u0001!B\u0013\u0019\u0016AB7pI\u0016d\u0007\u0005C\u0003^\u0001\u0011\u0005a,A\u0006tKR\u001cF/\u001a9TSj,GCA0a\u001b\u0005\u0001\u0001\"B\u0010]\u0001\u0004\t\u0003\"\u00022\u0001\t\u0003\u0019\u0017\u0001E:fi:+X.\u0013;fe\u0006$\u0018n\u001c8t)\tyF\rC\u00030C\u0002\u0007\u0011\u0007C\u0003g\u0001\u0011\u0005q-\u0001\u000btKRl\u0015N\\5CCR\u001c\u0007N\u0012:bGRLwN\u001c\u000b\u0003?\"DQaO3A\u0002\u0005BQA\u001b\u0001\u0005\u0002-\f\u0011c]3u\u0013:LG/[1m/\u0016Lw\r\u001b;t)\tyF\u000eC\u0003nS\u0002\u0007a.\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:\u0011\u0005=\u0014X\"\u00019\u000b\u0005E$\u0011A\u00027j]\u0006dw-\u0003\u0002ta\n1a+Z2u_JD#\u0001A;\u0011\u0005YLX\"A<\u000b\u0005a4\u0011AC1o]>$\u0018\r^5p]&\u0011!p\u001e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class StreamingLinearRegressionWithSGD
extends StreamingLinearAlgorithm<LinearRegressionModel, LinearRegressionWithSGD>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double miniBatchFraction;
    private final LinearRegressionWithSGD algorithm;
    private Option<LinearRegressionModel> model;

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public LinearRegressionWithSGD algorithm() {
        return this.algorithm;
    }

    @Override
    public Option<LinearRegressionModel> model() {
        return this.model;
    }

    @Override
    public void model_$eq(Option<LinearRegressionModel> x$1) {
        this.model = x$1;
    }

    public StreamingLinearRegressionWithSGD setStepSize(double stepSize) {
        this.algorithm().optimizer().setStepSize(stepSize);
        return this;
    }

    public StreamingLinearRegressionWithSGD setNumIterations(int numIterations) {
        this.algorithm().optimizer().setNumIterations(numIterations);
        return this;
    }

    public StreamingLinearRegressionWithSGD setMiniBatchFraction(double miniBatchFraction) {
        this.algorithm().optimizer().setMiniBatchFraction(miniBatchFraction);
        return this;
    }

    public StreamingLinearRegressionWithSGD setInitialWeights(Vector initialWeights) {
        this.model_$eq((Option<LinearRegressionModel>)new Some((Object)this.algorithm().createModel(initialWeights, 0.0)));
        return this;
    }

    public StreamingLinearRegressionWithSGD(double stepSize, int numIterations, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.miniBatchFraction = miniBatchFraction;
        this.algorithm = new LinearRegressionWithSGD(this.stepSize(), this.numIterations(), this.miniBatchFraction());
        this.model = None$.MODULE$;
    }

    public StreamingLinearRegressionWithSGD() {
        this(0.1, 50, 1.0);
    }
}

