/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams$class;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasProbabilityCol$class;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001!4a!\u0001\u0002\u0002\u0002\u0019a!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2T!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u000b\u0004\u001bQ\u00113c\u0001\u0001\u000fMA!q\u0002\u0005\n\"\u001b\u0005\u0011\u0011BA\t\u0003\u0005M\u0019E.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t\u0019B\u0003\u0004\u0001\u0005\u000bU\u0001!\u0019A\f\u0003\u0019\u0019+\u0017\r^;sKN$\u0016\u0010]3\u0004\u0001E\u0011\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\b\u001d>$\b.\u001b8h!\tIr$\u0003\u0002!5\t\u0019\u0011I\\=\u0011\u0005M\u0011C!B\u0012\u0001\u0005\u0004!#!A'\u0012\u0005a)\u0003\u0003B\b\u0001%\u0005\u0002\"aD\u0014\n\u0005!\u0012!!\b)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\u0005)\u0003\"B\u0017\u0001\t\u0003q\u0013!E:fiB\u0013xNY1cS2LG/_\"pYR\u0011\u0011e\f\u0005\u0006a1\u0002\r!M\u0001\u0006m\u0006dW/\u001a\t\u0003eUr!!G\u001a\n\u0005QR\u0012A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001\u000e\u000e\t\u000be\u0002A\u0011\t\u001e\u0002\u0013Q\u0014\u0018M\\:g_JlGCA\u001eB!\tat(D\u0001>\u0015\tqd!A\u0002tc2L!\u0001Q\u001f\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"\u0002\"9\u0001\u0004Y\u0014a\u00023bi\u0006\u001cX\r\u001e\u0005\u0006\t\u00021\t\"R\u0001\u0017e\u0006<(\u0007\u001d:pE\u0006\u0014\u0017\u000e\\5us&s\u0007\u000b\\1dKR\u0011aI\u0014\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000ba\u0001\\5oC2<'BA&\u0007\u0003\u0015iG\u000e\\5c\u0013\ti\u0005J\u0001\u0004WK\u000e$xN\u001d\u0005\u0006\u001f\u000e\u0003\rAR\u0001\u000ee\u0006<\bK]3eS\u000e$\u0018n\u001c8\t\u000bE\u0003A\u0011\u0003*\u0002\u001fI\fwO\r9s_\n\f'-\u001b7jif$\"AR*\t\u000b=\u0003\u0006\u0019\u0001$\t\u000bU\u0003A\u0011\u0003,\u0002%A\u0014X\rZ5diB\u0013xNY1cS2LG/\u001f\u000b\u0003\r^CQ\u0001\u0017+A\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\u00065\u0002!\tbW\u0001\u0017aJ|'-\u00192jY&$\u0018P\r9sK\u0012L7\r^5p]R\u0011Al\u0018\t\u00033uK!A\u0018\u000e\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\u0017\f1\u0001G\u0003-\u0001(o\u001c2bE&d\u0017\u000e^=)\u0005\u0001\u0011\u0007CA2g\u001b\u0005!'BA3\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003O\u0012\u0014A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final Param<String> probabilityCol;

    @Override
    public StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol$class.getProbabilityCol(this);
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame transform(DataFrame dataset) {
        void var2_2;
        this.transformSchema(dataset.schema(), true);
        DataFrame outputData = dataset;
        int numColsOutput = 0;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
            outputData = outputData.withColumn(this.getRawPredictionCol(), functions$.MODULE$.callUDF((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final Vector apply(FeaturesType features) {
                    return this.$outer.predictRaw(features);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (DataType)new VectorUDT(), functions$.MODULE$.col(this.getFeaturesCol())));
            ++numColsOutput;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
            Column probUDF = new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty() ? functions$.MODULE$.callUDF((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final Vector apply(Vector rawPrediction) {
                    return this.$outer.raw2probability(rawPrediction);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (DataType)new VectorUDT(), functions$.MODULE$.col(this.$(this.rawPredictionCol()))) : functions$.MODULE$.callUDF((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final Vector apply(FeaturesType features) {
                    return this.$outer.predictProbability(features);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (DataType)new VectorUDT(), functions$.MODULE$.col(this.$(this.featuresCol())));
            outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF);
            ++numColsOutput;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            Column predUDF = new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty() ? functions$.MODULE$.callUDF((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final double apply(Vector rawPrediction) {
                    return this.$outer.raw2prediction(rawPrediction);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (DataType)DoubleType$.MODULE$, functions$.MODULE$.col(this.$(this.rawPredictionCol()))) : (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty() ? functions$.MODULE$.callUDF((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final double apply(Vector probability) {
                    return this.$outer.probability2prediction(probability);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (DataType)DoubleType$.MODULE$, functions$.MODULE$.col(this.$(this.probabilityCol()))) : functions$.MODULE$.callUDF((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final double apply(FeaturesType features) {
                    return this.$outer.predict(features);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (DataType)DoubleType$.MODULE$, functions$.MODULE$.col(this.$(this.featuresCol()))));
            outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF);
            ++numColsOutput;
        }
        if (numColsOutput == 0) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ProbabilisticClassificationModel.transform() was called as NOOP"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uid()}))).append((Object)" since no output columns were set.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        return var2_2;
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        return probability.toDense().argmax();
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol$class.$init$(this);
        ProbabilisticClassifierParams$class.$init$(this);
    }
}

