/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.param.shared.HasRawPredictionCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0001\u001b\ti\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'O\u0003\u0002\u0004\t\u0005QQM^1mk\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019\u0011\"\u0004\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\tIQI^1mk\u0006$xN\u001d\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\taa\u001d5be\u0016$'BA\f\u0005\u0003\u0015\u0001\u0018M]1n\u0013\tIBCA\nICN\u0014\u0016m\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0005\u0002\u00147%\u0011A\u0004\u0006\u0002\f\u0011\u0006\u001cH*\u00192fY\u000e{G\u000e\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0011 \u0003\r)\u0018\u000eZ\u000b\u0002AA\u0011\u0011e\n\b\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011aeI\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002'G!A1\u0006\u0001B\u0001B\u0003%\u0001%\u0001\u0003vS\u0012\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020aA\u0011q\u0002\u0001\u0005\u0006=1\u0002\r\u0001\t\u0005\u0006[\u0001!\tA\r\u000b\u0002_!9A\u0007\u0001b\u0001\n\u0003)\u0014AC7fiJL7MT1nKV\ta\u0007E\u00028q\u0001j\u0011AF\u0005\u0003sY\u0011Q\u0001U1sC6Daa\u000f\u0001!\u0002\u00131\u0014aC7fiJL7MT1nK\u0002BQ!\u0010\u0001\u0005\u0002}\tQbZ3u\u001b\u0016$(/[2OC6,\u0007\"B \u0001\t\u0003\u0001\u0015!D:fi6+GO]5d\u001d\u0006lW\r\u0006\u0002B\u00056\t\u0001\u0001C\u0003D}\u0001\u0007\u0001%A\u0003wC2,X\rC\u0003F\u0001\u0011\u0005a)A\u0006tKR\u001c6m\u001c:f\u0007>dGCA!H\u0011\u0015\u0019E\t1\u0001!\u0011\u0015I\u0005\u0001\"\u0001K\u0003-\u0019X\r\u001e'bE\u0016d7i\u001c7\u0015\u0005\u0005[\u0005\"B\"I\u0001\u0004\u0001\u0003\"B'\u0001\t\u0003r\u0015\u0001C3wC2,\u0018\r^3\u0015\u0005=\u0013\u0006C\u0001\u0012Q\u0013\t\t6E\u0001\u0004E_V\u0014G.\u001a\u0005\u0006'2\u0003\r\u0001V\u0001\bI\u0006$\u0018m]3u!\t)\u0006,D\u0001W\u0015\t9f!A\u0002tc2L!!\u0017,\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B.\u0001\t\u0003b\u0016\u0001B2paf$\"aL/\t\u000byS\u0006\u0019A0\u0002\u000b\u0015DHO]1\u0011\u0005]\u0002\u0017BA1\u0017\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bF\u0001\u0001d!\t!w-D\u0001f\u0015\t1g!\u0001\u0006b]:|G/\u0019;j_:L!\u0001[3\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol$class.getRawPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public BinaryClassificationEvaluator setScoreCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset) {
        String string;
        block4: {
            double d;
            BinaryClassificationMetrics metrics;
            block3: {
                block2: {
                    StructType schema = dataset.schema();
                    SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.rawPredictionCol()), (DataType)new VectorUDT());
                    SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$);
                    RDD scoreAndLabels = dataset.select(this.$(this.rawPredictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol())})).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                Object rawPrediction = ((SeqLike)some.get()).apply(0);
                                Object label = ((SeqLike)some.get()).apply(1);
                                if (rawPrediction instanceof Vector) {
                                    Vector vector = (Vector)rawPrediction;
                                    if (label instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)label);
                                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(vector.apply(1), d);
                                        return sp2;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    metrics = new BinaryClassificationMetrics((RDD<Tuple2<Object, Object>>)scoreAndLabels);
                    String string2 = string = this.$(this.metricName());
                    if ("areaUnderROC" != null ? !"areaUnderROC".equals(string2) : string2 != null) break block2;
                    d = metrics.areaUnderROC();
                    break block3;
                }
                String string3 = string;
                if ("areaUnderPR" != null ? !"areaUnderPR".equals(string3) : string3 != null) break block4;
                d = metrics.areaUnderPR();
            }
            double metric = d;
            metrics.unpersist();
            return metric;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Does not support metric ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.defaultCopy(extra);
    }

    public BinaryClassificationEvaluator(String uid) {
        this.uid = uid;
        HasRawPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("areaUnderROC")}));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binEval"));
    }
}

