/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0003\u001b\t\u0019\"+Z4sKN\u001c\u0018n\u001c8Fm\u0006dW/\u0019;pe*\u00111\u0001B\u0001\u000bKZ\fG.^1uS>t'BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00135A\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\n\u000bZ\fG.^1u_J\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\rMD\u0017M]3e\u0015\t9B!A\u0003qCJ\fW.\u0003\u0002\u001a)\t\u0001\u0002*Y:Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\t\u0003'mI!\u0001\b\u000b\u0003\u0017!\u000b7\u000fT1cK2\u001cu\u000e\u001c\u0005\t=\u0001\u0011)\u0019!C!?\u0005\u0019Q/\u001b3\u0016\u0003\u0001\u0002\"!I\u0014\u000f\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003M\rB\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0005k&$\u0007\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0003_A\u0002\"a\u0004\u0001\t\u000bya\u0003\u0019\u0001\u0011\t\u000b5\u0002A\u0011\u0001\u001a\u0015\u0003=Bq\u0001\u000e\u0001C\u0002\u0013\u0005Q'\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016,\u0012A\u000e\t\u0004oa\u0002S\"\u0001\f\n\u0005e2\"!\u0002)be\u0006l\u0007BB\u001e\u0001A\u0003%a'A\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003\"B\u001f\u0001\t\u0003y\u0012!D4fi6+GO]5d\u001d\u0006lW\rC\u0003@\u0001\u0011\u0005\u0001)A\u0007tKRlU\r\u001e:jG:\u000bW.\u001a\u000b\u0003\u0003\nk\u0011\u0001\u0001\u0005\u0006\u0007z\u0002\r\u0001I\u0001\u0006m\u0006dW/\u001a\u0005\u0006\u000b\u0002!\tAR\u0001\u0011g\u0016$\bK]3eS\u000e$\u0018n\u001c8D_2$\"!Q$\t\u000b\r#\u0005\u0019\u0001\u0011\t\u000b%\u0003A\u0011\u0001&\u0002\u0017M,G\u000fT1cK2\u001cu\u000e\u001c\u000b\u0003\u0003.CQa\u0011%A\u0002\u0001BQ!\u0014\u0001\u0005B9\u000b\u0001\"\u001a<bYV\fG/\u001a\u000b\u0003\u001fJ\u0003\"A\t)\n\u0005E\u001b#A\u0002#pk\ndW\rC\u0003T\u0019\u0002\u0007A+A\u0004eCR\f7/\u001a;\u0011\u0005UCV\"\u0001,\u000b\u0005]3\u0011aA:rY&\u0011\u0011L\u0016\u0002\n\t\u0006$\u0018M\u0012:b[\u0016DQa\u0017\u0001\u0005Bq\u000bAaY8qsR\u0011q&\u0018\u0005\u0006=j\u0003\raX\u0001\u0006Kb$(/\u0019\t\u0003o\u0001L!!\u0019\f\u0003\u0011A\u000b'/Y7NCBD#\u0001A2\u0011\u0005\u0011<W\"A3\u000b\u0005\u00194\u0011AC1o]>$\u0018\r^5p]&\u0011\u0001.\u001a\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public final class RegressionEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public RegressionEvaluator setMetricName(String value) {
        return (RegressionEvaluator)this.set(this.metricName(), value);
    }

    public RegressionEvaluator setPredictionCol(String value) {
        return (RegressionEvaluator)this.set(this.predictionCol(), value);
    }

    public RegressionEvaluator setLabelCol(String value) {
        return (RegressionEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset) {
        String string;
        block6: {
            double d;
            block3: {
                RegressionMetrics metrics;
                block5: {
                    block4: {
                        block2: {
                            StructType schema = dataset.schema();
                            SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$);
                            SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$);
                            RDD predictionAndLabels = dataset.select(this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol())})).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<Object, Object> apply(Row x0$1) {
                                    Row row = x0$1;
                                    Some some = Row$.MODULE$.unapplySeq(row);
                                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                        Object prediction = ((SeqLike)some.get()).apply(0);
                                        Object label = ((SeqLike)some.get()).apply(1);
                                        if (prediction instanceof Double) {
                                            double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                            if (label instanceof Double) {
                                                double d2 = BoxesRunTime.unboxToDouble((Object)label);
                                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                                return sp2;
                                            }
                                        }
                                    }
                                    throw new MatchError((Object)row);
                                }
                            }, ClassTag$.MODULE$.apply(Tuple2.class));
                            metrics = new RegressionMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels);
                            String string2 = string = this.$(this.metricName());
                            if ("rmse" != null ? !"rmse".equals(string2) : string2 != null) break block2;
                            d = -metrics.rootMeanSquaredError();
                            break block3;
                        }
                        String string3 = string;
                        if ("mse" != null ? !"mse".equals(string3) : string3 != null) break block4;
                        d = -metrics.meanSquaredError();
                        break block3;
                    }
                    String string4 = string;
                    if ("r2" != null ? !"r2".equals(string4) : string4 != null) break block5;
                    d = metrics.r2();
                    break block3;
                }
                String string5 = string;
                if ("mae" != null ? !"mae".equals(string5) : string5 != null) break block6;
                d = -metrics.meanAbsoluteError();
            }
            double metric = d;
            return metric;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public RegressionEvaluator copy(ParamMap extra) {
        return (RegressionEvaluator)this.defaultCopy(extra);
    }

    public RegressionEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"mse", "rmse", "r2", "mae"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (mse|rmse|r2|mae)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("rmse")}));
    }

    public RegressionEvaluator() {
        this(Identifiable$.MODULE$.randomUID("regEval"));
    }
}

