/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0003\u001b\tI!)\u001b8be&TXM\u001d\u0006\u0003\u0007\u0011\tqAZ3biV\u0014XM\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f%i\u0001\"a\u0004\t\u000e\u0003\u0011I!!\u0005\u0003\u0003\u0017Q\u0013\u0018M\\:g_JlWM\u001d\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\taa\u001d5be\u0016$'BA\f\u0005\u0003\u0015\u0001\u0018M]1n\u0013\tIBCA\u0006ICNLe\u000e];u\u0007>d\u0007CA\n\u001c\u0013\taBC\u0001\u0007ICN|U\u000f\u001e9vi\u000e{G\u000e\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0011 \u0003\r)\u0018\u000eZ\u000b\u0002AA\u0011\u0011e\n\b\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011aeI\u0001\u0007!J,G-\u001a4\n\u0005!J#AB*ue&twM\u0003\u0002'G!A1\u0006\u0001B\u0001B\u0003%\u0001%\u0001\u0003vS\u0012\u0004\u0003\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\b\u0006\u00020cA\u0011\u0001\u0007A\u0007\u0002\u0005!)a\u0004\fa\u0001A!)Q\u0006\u0001C\u0001gQ\tq\u0006C\u00046\u0001\t\u0007I\u0011\u0001\u001c\u0002\u0013QD'/Z:i_2$W#A\u001c\u0011\u0005aJT\"\u0001\f\n\u0005i2\"a\u0003#pk\ndW\rU1sC6Da\u0001\u0010\u0001!\u0002\u00139\u0014A\u0003;ie\u0016\u001c\bn\u001c7eA!)a\b\u0001C\u0001\u007f\u0005aq-\u001a;UQJ,7\u000f[8mIV\t\u0001\t\u0005\u0002#\u0003&\u0011!i\t\u0002\u0007\t>,(\r\\3\t\u000b\u0011\u0003A\u0011A#\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\u0005\u0019;U\"\u0001\u0001\t\u000b!\u001b\u0005\u0019\u0001!\u0002\u000bY\fG.^3\t\u000b)\u0003A\u0011A&\u0002\u0017M,G/\u00138qkR\u001cu\u000e\u001c\u000b\u0003\r2CQ\u0001S%A\u0002\u0001BQA\u0014\u0001\u0005\u0002=\u000bAb]3u\u001fV$\b/\u001e;D_2$\"A\u0012)\t\u000b!k\u0005\u0019\u0001\u0011\t\u000bI\u0003A\u0011I*\u0002\u0013Q\u0014\u0018M\\:g_JlGC\u0001+[!\t)\u0006,D\u0001W\u0015\t9f!A\u0002tc2L!!\u0017,\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B.R\u0001\u0004!\u0016a\u00023bi\u0006\u001cX\r\u001e\u0005\u0006;\u0002!\tEX\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR\u0011q,\u001a\t\u0003A\u000el\u0011!\u0019\u0006\u0003EZ\u000bQ\u0001^=qKNL!\u0001Z1\u0003\u0015M#(/^2u)f\u0004X\rC\u0003g9\u0002\u0007q,\u0001\u0004tG\",W.\u0019\u0005\u0006Q\u0002!\t%[\u0001\u0005G>\u0004\u0018\u0010\u0006\u00020U\")1n\u001aa\u0001Y\u0006)Q\r\u001f;sCB\u0011\u0001(\\\u0005\u0003]Z\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0003\u0001A\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002ve\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public final class Binarizer
extends Transformer
implements HasInputCol,
HasOutputCol {
    private final String uid;
    private final DoubleParam threshold;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam threshold() {
        return this.threshold;
    }

    public double getThreshold() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()));
    }

    public Binarizer setThreshold(double value) {
        return (Binarizer)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public Binarizer setInputCol(String value) {
        return (Binarizer)this.set(this.inputCol(), value);
    }

    public Binarizer setOutputCol(String value) {
        return (Binarizer)this.set(this.outputCol(), value);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        this.transformSchema(dataset.schema(), true);
        double td = BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()));
        UserDefinedFunction binarizer = functions$.MODULE$.udf((Function1)new Serializable(this, td){
            public static final long serialVersionUID = 0L;
            private final double td$1;

            public final double apply(double in) {
                return this.apply$mcDD$sp(in);
            }

            public double apply$mcDD$sp(double in) {
                return in > this.td$1 ? 1.0 : 0.0;
            }
            {
                this.td$1 = td$1;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        String outputColName = this.$(this.outputCol());
        Metadata metadata = BinaryAttribute$.MODULE$.defaultAttr().withName(outputColName).toMetadata();
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), binarizer.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.inputCol()))})).as(outputColName, metadata)}));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.inputCol()), (DataType)DoubleType$.MODULE$);
        StructField[] inputFields = schema.fields();
        String outputColName = this.$(this.outputCol());
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])inputFields).forall((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.outputColName$1;
                return string != null ? !string.equals(string2) : string2 != null;
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$1}));
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        });
        BinaryAttribute attr = BinaryAttribute$.MODULE$.defaultAttr().withName(outputColName);
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)attr.toStructField(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    @Override
    public Binarizer copy(ParamMap extra) {
        return (Binarizer)this.defaultCopy(extra);
    }

    public Binarizer(String uid) {
        this.uid = uid;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        this.threshold = new DoubleParam(this, "threshold", "threshold used to binarize continuous features");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.threshold().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
    }

    public Binarizer() {
        this(Identifiable$.MODULE$.randomUID("binarizer"));
    }
}

