/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Transformer;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.Attribute$;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.feature.OneHotEncoder$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasInputCol;
import org.apache.spark.ml.param.shared.HasInputCol$class;
import org.apache.spark.ml.param.shared.HasOutputCol;
import org.apache.spark.ml.param.shared.HasOutputCol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001M4A!\u0001\u0002\u0001\u001b\tiqJ\\3I_R,enY8eKJT!a\u0001\u0003\u0002\u000f\u0019,\u0017\r^;sK*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0005\u000e\u0011\u0005=\u0001R\"\u0001\u0003\n\u0005E!!a\u0003+sC:\u001chm\u001c:nKJ\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\rMD\u0017M]3e\u0015\t9B!A\u0003qCJ\fW.\u0003\u0002\u001a)\tY\u0001*Y:J]B,HoQ8m!\t\u00192$\u0003\u0002\u001d)\ta\u0001*Y:PkR\u0004X\u000f^\"pY\"Aa\u0004\u0001BC\u0002\u0013\u0005s$A\u0002vS\u0012,\u0012\u0001\t\t\u0003C\u001dr!AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\na\u0001\u0015:fI\u00164\u0017B\u0001\u0015*\u0005\u0019\u0019FO]5oO*\u0011ae\t\u0005\tW\u0001\u0011\t\u0011)A\u0005A\u0005!Q/\u001b3!\u0011\u0015i\u0003\u0001\"\u0001/\u0003\u0019a\u0014N\\5u}Q\u0011q&\r\t\u0003a\u0001i\u0011A\u0001\u0005\u0006=1\u0002\r\u0001\t\u0005\u0006[\u0001!\ta\r\u000b\u0002_!9Q\u0007\u0001b\u0001\n\u000b1\u0014\u0001\u00033s_Bd\u0015m\u001d;\u0016\u0003]\u0002\"\u0001O\u001d\u000e\u0003YI!A\u000f\f\u0003\u0019\t{w\u000e\\3b]B\u000b'/Y7\t\rq\u0002\u0001\u0015!\u00048\u0003%!'o\u001c9MCN$\b\u0005C\u0003?\u0001\u0011\u0005q(A\u0006tKR$%o\u001c9MCN$HC\u0001!B\u001b\u0005\u0001\u0001\"\u0002\">\u0001\u0004\u0019\u0015!\u0002<bYV,\u0007C\u0001\u0012E\u0013\t)5EA\u0004C_>dW-\u00198\t\u000b\u001d\u0003A\u0011\u0001%\u0002\u0017M,G/\u00138qkR\u001cu\u000e\u001c\u000b\u0003\u0001&CQA\u0011$A\u0002\u0001BQa\u0013\u0001\u0005\u00021\u000bAb]3u\u001fV$\b/\u001e;D_2$\"\u0001Q'\t\u000b\tS\u0005\u0019\u0001\u0011\t\u000b=\u0003A\u0011\t)\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$\"!U-\u0011\u0005I;V\"A*\u000b\u0005Q+\u0016!\u0002;za\u0016\u001c(B\u0001,\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u00031N\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u0015Qf\n1\u0001R\u0003\u0019\u00198\r[3nC\")A\f\u0001C!;\u0006IAO]1og\u001a|'/\u001c\u000b\u0003=\n\u0004\"a\u00181\u000e\u0003UK!!Y+\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"B2\\\u0001\u0004q\u0016a\u00023bi\u0006\u001cX\r\u001e\u0005\u0006K\u0002!\tEZ\u0001\u0005G>\u0004\u0018\u0010\u0006\u00020O\")\u0001\u000e\u001aa\u0001S\u0006)Q\r\u001f;sCB\u0011\u0001H[\u0005\u0003WZ\u0011\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0003\u00015\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s_\naQ\t\u001f9fe&lWM\u001c;bY\u0002")
public class OneHotEncoder
extends Transformer
implements HasInputCol,
HasOutputCol {
    private final String uid;
    private final BooleanParam dropLast;
    private final Param<String> outputCol;
    private final Param<String> inputCol;

    @Override
    public final Param<String> outputCol() {
        return this.outputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasOutputCol$_setter_$outputCol_$eq(Param x$1) {
        this.outputCol = x$1;
    }

    @Override
    public final String getOutputCol() {
        return HasOutputCol$class.getOutputCol(this);
    }

    @Override
    public final Param<String> inputCol() {
        return this.inputCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasInputCol$_setter_$inputCol_$eq(Param x$1) {
        this.inputCol = x$1;
    }

    @Override
    public final String getInputCol() {
        return HasInputCol$class.getInputCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public final BooleanParam dropLast() {
        return this.dropLast;
    }

    public OneHotEncoder setDropLast(boolean value) {
        return (OneHotEncoder)this.set(this.dropLast(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public OneHotEncoder setInputCol(String value) {
        return (OneHotEncoder)this.set(this.inputCol(), value);
    }

    public OneHotEncoder setOutputCol(String value) {
        return (OneHotEncoder)this.set(this.outputCol(), value);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        AttributeGroup attributeGroup;
        None$ none$;
        Attribute inputAttr;
        String is = "_is_";
        String inputColName = this.$(this.inputCol());
        String outputColName = this.$(this.outputCol());
        SchemaUtils$.MODULE$.checkColumnType(schema, inputColName, (DataType)DoubleType$.MODULE$);
        StructField[] inputFields = schema.fields();
        Predef$.MODULE$.require(!Predef$.MODULE$.refArrayOps((Object[])inputFields).exists((Function1)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final boolean apply(StructField x$1) {
                String string = x$1.name();
                String string2 = this.outputColName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        }), (Function0)new Serializable(this, outputColName){
            public static final long serialVersionUID = 0L;
            private final String outputColName$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Output column ", " already exists."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputColName$1}));
            }
            {
                this.outputColName$1 = outputColName$1;
            }
        });
        Attribute attribute = inputAttr = Attribute$.MODULE$.fromStructField(schema.apply(inputColName));
        if (attribute instanceof NominalAttribute) {
            NominalAttribute nominalAttribute = (NominalAttribute)attribute;
            none$ = nominalAttribute.values().isDefined() ? nominalAttribute.values().map((Function1)new Serializable(this, is, inputColName){
                public static final long serialVersionUID = 0L;
                public final String is$1;
                public final String inputColName$1;

                public final String[] apply(String[] x$2) {
                    return (String[])Predef$.MODULE$.refArrayOps((Object[])x$2).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;

                        public final String apply(String v) {
                            return new StringBuilder().append((Object)this.$outer.inputColName$1).append((Object)this.$outer.is$1).append((Object)v).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                }
                {
                    this.is$1 = is$1;
                    this.inputColName$1 = inputColName$1;
                }
            }) : (nominalAttribute.numValues().isDefined() ? nominalAttribute.numValues().map((Function1)new Serializable(this, is, inputColName){
                public static final long serialVersionUID = 0L;
                public final String is$1;
                public final String inputColName$1;

                public final String[] apply(int n) {
                    return (String[])Array$.MODULE$.tabulate(n, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$4 $outer;

                        public final String apply(int i) {
                            return new StringBuilder().append((Object)this.$outer.inputColName$1).append((Object)this.$outer.is$1).append((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, ClassTag$.MODULE$.apply(String.class));
                }
                {
                    this.is$1 = is$1;
                    this.inputColName$1 = inputColName$1;
                }
            }) : None$.MODULE$);
        } else if (attribute instanceof BinaryAttribute) {
            BinaryAttribute binaryAttribute = (BinaryAttribute)attribute;
            none$ = binaryAttribute.values().isDefined() ? binaryAttribute.values().map((Function1)new Serializable(this, is, inputColName){
                public static final long serialVersionUID = 0L;
                public final String is$1;
                public final String inputColName$1;

                public final String[] apply(String[] x$3) {
                    return (String[])Predef$.MODULE$.refArrayOps((Object[])x$3).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$5 $outer;

                        public final String apply(String v) {
                            return new StringBuilder().append((Object)this.$outer.inputColName$1).append((Object)this.$outer.is$1).append((Object)v).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                }
                {
                    this.is$1 = is$1;
                    this.inputColName$1 = inputColName$1;
                }
            }) : new Some(Array$.MODULE$.tabulate(2, (Function1)new Serializable(this, is, inputColName){
                public static final long serialVersionUID = 0L;
                private final String is$1;
                private final String inputColName$1;

                public final String apply(int i) {
                    return new StringBuilder().append((Object)this.inputColName$1).append((Object)this.is$1).append((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                }
                {
                    this.is$1 = is$1;
                    this.inputColName$1 = inputColName$1;
                }
            }, ClassTag$.MODULE$.apply(String.class)));
        } else {
            if (attribute instanceof NumericAttribute) {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " cannot be numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inputColName})));
            }
            none$ = None$.MODULE$;
        }
        None$ outputAttrNames = none$;
        Option filteredOutputAttrNames = outputAttrNames.map((Function1)new Serializable(this, inputColName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OneHotEncoder $outer;
            public final String inputColName$1;

            public final String[] apply(String[] names) {
                String[] stringArray;
                if (BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.dropLast()))) {
                    Predef$.MODULE$.require(names.length > 1, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$7 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The input column ", " should have at least two distinct values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$1}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    stringArray = (String[])Predef$.MODULE$.refArrayOps((Object[])names).dropRight(1);
                } else {
                    stringArray = names;
                }
                return stringArray;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.inputColName$1 = inputColName$1;
            }
        });
        if (filteredOutputAttrNames.isDefined()) {
            Attribute[] attrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filteredOutputAttrNames.get()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            attributeGroup = new AttributeGroup(this.$(this.outputCol()), attrs);
        } else {
            attributeGroup = new AttributeGroup(this.$(this.outputCol()));
        }
        AttributeGroup outputAttrGroup = attributeGroup;
        StructField[] outputFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])inputFields).$colon$plus((Object)outputAttrGroup.toStructField(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(outputFields);
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        String is = "_is_";
        String inputColName = this.$(this.inputCol());
        String outputColName = this.$(this.outputCol());
        boolean shouldDropLast = BoxesRunTime.unboxToBoolean((Object)this.$(this.dropLast()));
        AttributeGroup outputAttrGroup = AttributeGroup$.MODULE$.fromStructField(this.transformSchema(dataset.schema()).apply(outputColName));
        if (outputAttrGroup.size() < 0) {
            int numAttrs = (int)BoxesRunTime.unboxToDouble((Object)dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Row x$4) {
                    return x$4.getDouble(0);
                }
            }, ClassTag$.MODULE$.Double()).aggregate((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this, inputColName){
                public static final long serialVersionUID = 0L;
                public final String inputColName$2;

                public final double apply(double m, double x) {
                    return this.apply$mcDDD$sp(m, x);
                }

                public double apply$mcDDD$sp(double m, double x) {
                    Predef$.MODULE$.assert(x >= 0.0 && x == (double)((int)x), (Function0)new Serializable(this, x){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;
                        private final double x$5;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Values from column ", " must be indices, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.inputColName$2, BoxesRunTime.boxToDouble((double)this.x$5)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.x$5 = x$5;
                        }
                    });
                    return scala.math.package$.MODULE$.max(m, x);
                }
                {
                    this.inputColName$2 = inputColName$2;
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double m0, double m1) {
                    return this.apply$mcDDD$sp(m0, m1);
                }

                public double apply$mcDDD$sp(double m0, double m1) {
                    return scala.math.package$.MODULE$.max(m0, m1);
                }
            }, ClassTag$.MODULE$.Double())) + 1;
            String[] outputAttrNames = (String[])Array$.MODULE$.tabulate(numAttrs, (Function1)new Serializable(this, is, inputColName){
                public static final long serialVersionUID = 0L;
                private final String is$2;
                private final String inputColName$2;

                public final String apply(int i) {
                    return new StringBuilder().append((Object)this.inputColName$2).append((Object)this.is$2).append((Object)BoxesRunTime.boxToInteger((int)i)).toString();
                }
                {
                    this.is$2 = is$2;
                    this.inputColName$2 = inputColName$2;
                }
            }, ClassTag$.MODULE$.apply(String.class));
            String[] filtered = shouldDropLast ? (String[])Predef$.MODULE$.refArrayOps((Object[])outputAttrNames).dropRight(1) : outputAttrNames;
            Attribute[] outputAttrs = (Attribute[])Predef$.MODULE$.refArrayOps((Object[])filtered).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BinaryAttribute apply(String name) {
                    return BinaryAttribute$.MODULE$.defaultAttr().withName(name);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Attribute.class)));
            outputAttrGroup = new AttributeGroup(outputColName, outputAttrs);
        }
        Metadata metadata = outputAttrGroup.toMetadata();
        int size = outputAttrGroup.size();
        double[] oneValue = new double[]{1.0};
        double[] emptyValues = (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double());
        int[] emptyIndices = (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(OneHotEncoder.class.getClassLoader());
        public final class Org_apache_spark_ml_feature_OneHotEncoder$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_feature_OneHotEncoder$$typecreator1$1(OneHotEncoder $outer) {
            }
        }
        UserDefinedFunction encode = functions$.MODULE$.udf((Function1)new Serializable(this, size, oneValue, emptyValues, emptyIndices){
            public static final long serialVersionUID = 0L;
            private final int size$1;
            private final double[] oneValue$1;
            private final double[] emptyValues$1;
            private final int[] emptyIndices$1;

            public final Vector apply(double label) {
                return label < (double)this.size$1 ? Vectors$.MODULE$.sparse(this.size$1, new int[]{(int)label}, this.oneValue$1) : Vectors$.MODULE$.sparse(this.size$1, this.emptyIndices$1, this.emptyValues$1);
            }
            {
                this.size$1 = size$1;
                this.oneValue$1 = oneValue$1;
                this.emptyValues$1 = emptyValues$1;
                this.emptyIndices$1 = emptyIndices$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_feature_OneHotEncoder$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("*"), encode.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(inputColName).cast((DataType)DoubleType$.MODULE$)})).as(outputColName, metadata)}));
    }

    @Override
    public OneHotEncoder copy(ParamMap extra) {
        return (OneHotEncoder)this.defaultCopy(extra);
    }

    public OneHotEncoder(String uid) {
        this.uid = uid;
        HasInputCol$class.$init$(this);
        HasOutputCol$class.$init$(this);
        this.dropLast = new BooleanParam(this, "dropLast", "whether to drop the last category");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.dropLast().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
    }

    public OneHotEncoder() {
        this(Identifiable$.MODULE$.randomUID("oneHot"));
    }
}

