/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.Vector$;
import breeze.linalg.diag$;
import breeze.storage.Zero;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.ExpectationSum;
import org.apache.spark.mllib.clustering.ExpectationSum$;
import org.apache.spark.mllib.clustering.GaussianMixture$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Double$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.IndexedSeq;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u00015\u0011qbR1vgNL\u0017M\\'jqR,(/\u001a\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u0007\u0001\u0003\u0002\u0004%I!G\u0001\u0002WV\t!\u0004\u0005\u0002\u00107%\u0011A\u0004\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u0010\u0001\u0005\u0003\u0007I\u0011B\u0010\u0002\u000b-|F%Z9\u0015\u0005\u0001\u001a\u0003CA\b\"\u0013\t\u0011\u0003C\u0001\u0003V]&$\bb\u0002\u0013\u001e\u0003\u0003\u0005\rAG\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u0005-\u0004\u0003\u0002\u0003\u0015\u0001\u0005\u0003\u0007I\u0011B\u0015\u0002\u001d\r|gN^3sO\u0016t7-\u001a+pYV\t!\u0006\u0005\u0002\u0010W%\u0011A\u0006\u0005\u0002\u0007\t>,(\r\\3\t\u00119\u0002!\u00111A\u0005\n=\n!cY8om\u0016\u0014x-\u001a8dKR{Gn\u0018\u0013fcR\u0011\u0001\u0005\r\u0005\bI5\n\t\u00111\u0001+\u0011!\u0011\u0004A!A!B\u0013Q\u0013aD2p]Z,'oZ3oG\u0016$v\u000e\u001c\u0011\t\u0011Q\u0002!\u00111A\u0005\ne\tQ\"\\1y\u0013R,'/\u0019;j_:\u001c\b\u0002\u0003\u001c\u0001\u0005\u0003\u0007I\u0011B\u001c\u0002#5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002!q!9A%NA\u0001\u0002\u0004Q\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u000e\u0002\u001d5\f\u00070\u0013;fe\u0006$\u0018n\u001c8tA!AA\b\u0001BA\u0002\u0013%Q(\u0001\u0003tK\u0016$W#\u0001 \u0011\u0005=y\u0014B\u0001!\u0011\u0005\u0011auN\\4\t\u0011\t\u0003!\u00111A\u0005\n\r\u000b\u0001b]3fI~#S-\u001d\u000b\u0003A\u0011Cq\u0001J!\u0002\u0002\u0003\u0007a\b\u0003\u0005G\u0001\t\u0005\t\u0015)\u0003?\u0003\u0015\u0019X-\u001a3!\u0011\u0015A\u0005\u0001\"\u0003J\u0003\u0019a\u0014N\\5u}Q)!\nT'O\u001fB\u00111\nA\u0007\u0002\u0005!)\u0001d\u0012a\u00015!)\u0001f\u0012a\u0001U!)Ag\u0012a\u00015!)Ah\u0012a\u0001}!)\u0001\n\u0001C\u0001#R\t!\nC\u0004T\u0001\t\u0007I\u0011B\r\u0002\u00119\u001c\u0016-\u001c9mKNDa!\u0016\u0001!\u0002\u0013Q\u0012!\u00038TC6\u0004H.Z:!\u0011\u001d9\u0006\u00011A\u0005\na\u000bA\"\u001b8ji&\fG.T8eK2,\u0012!\u0017\t\u0004\u001fic\u0016BA.\u0011\u0005\u0019y\u0005\u000f^5p]B\u00111*X\u0005\u0003=\n\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d\u0007b\u00021\u0001\u0001\u0004%I!Y\u0001\u0011S:LG/[1m\u001b>$W\r\\0%KF$\"\u0001\t2\t\u000f\u0011z\u0016\u0011!a\u00013\"1A\r\u0001Q!\ne\u000bQ\"\u001b8ji&\fG.T8eK2\u0004\u0003\"\u00024\u0001\t\u00039\u0017aD:fi&s\u0017\u000e^5bY6{G-\u001a7\u0015\u0005!LW\"\u0001\u0001\t\u000b),\u0007\u0019\u0001/\u0002\u000b5|G-\u001a7\t\u000b1\u0004A\u0011\u0001-\u0002\u001f\u001d,G/\u00138ji&\fG.T8eK2DQA\u001c\u0001\u0005\u0002=\fAa]3u\u0017R\u0011\u0001\u000e\u001d\u0005\u000615\u0004\rA\u0007\u0005\u0006e\u0002!\t!G\u0001\u0005O\u0016$8\nC\u0003u\u0001\u0011\u0005Q/\u0001\ttKRl\u0015\r_%uKJ\fG/[8ogR\u0011\u0001N\u001e\u0005\u0006iM\u0004\rA\u0007\u0005\u0006q\u0002!\t!G\u0001\u0011O\u0016$X*\u0019=Ji\u0016\u0014\u0018\r^5p]NDQA\u001f\u0001\u0005\u0002m\f\u0011c]3u\u0007>tg/\u001a:hK:\u001cW\rV8m)\tAG\u0010C\u0003)s\u0002\u0007!\u0006C\u0003\u007f\u0001\u0011\u0005\u0011&A\thKR\u001cuN\u001c<fe\u001e,gnY3U_2Dq!!\u0001\u0001\t\u0003\t\u0019!A\u0004tKR\u001cV-\u001a3\u0015\u0007!\f)\u0001C\u0003=\u007f\u0002\u0007a\b\u0003\u0004\u0002\n\u0001!\t!P\u0001\bO\u0016$8+Z3e\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\t1A];o)\ra\u0016\u0011\u0003\u0005\t\u0003'\tY\u00011\u0001\u0002\u0016\u0005!A-\u0019;b!\u0019\t9\"!\b\u0002\"5\u0011\u0011\u0011\u0004\u0006\u0004\u000371\u0011a\u0001:eI&!\u0011qDA\r\u0005\r\u0011F\t\u0012\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u0003\u0002\r1Lg.\u00197h\u0013\u0011\tY#!\n\u0003\rY+7\r^8s\u0011\u001d\ti\u0001\u0001C\u0001\u0003_!2\u0001XA\u0019\u0011!\t\u0019\"!\fA\u0002\u0005M\u0002CBA\u001b\u0003\u007f\t\t#\u0004\u0002\u00028)!\u0011\u0011HA\u001e\u0003\u0011Q\u0017M^1\u000b\u0007\u0005ub!A\u0002ba&LA!!\u0011\u00028\t9!*\u0019<b%\u0012#\u0005bBA#\u0001\u0011%\u0011qI\u0001\u000bm\u0016\u001cGo\u001c:NK\u0006tG\u0003BA%\u0003/\u0002R!a\u0013\u0002T)j!!!\u0014\u000b\t\u0005\u001d\u0012q\n\u0006\u0003\u0003#\naA\u0019:fKj,\u0017\u0002BA+\u0003\u001b\u00121\u0002R3og\u00164Vm\u0019;pe\"A\u0011\u0011LA\"\u0001\u0004\tY&A\u0001y!\u0019\ti&a\u001a\u0002l5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0004nkR\f'\r\\3\u000b\u0007\u0005\u0015\u0004#\u0001\u0006d_2dWm\u0019;j_:LA!!\u001b\u0002`\tQ\u0011J\u001c3fq\u0016$7+Z9\u0011\u000b\u0005-\u0013Q\u000e\u0016\n\t\u0005-\u0012Q\n\u0005\b\u0003c\u0002A\u0011BA:\u00039Ig.\u001b;D_Z\f'/[1oG\u0016$B!!\u001e\u0002|A)\u00111JA<U%!\u0011\u0011PA'\u0005-!UM\\:f\u001b\u0006$(/\u001b=\t\u0011\u0005e\u0013q\u000ea\u0001\u00037B3\u0001AA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u00151\u0011\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class GaussianMixture
implements Serializable {
    private int org$apache$spark$mllib$clustering$GaussianMixture$$k;
    private double convergenceTol;
    private int maxIterations;
    private long seed;
    private final int org$apache$spark$mllib$clustering$GaussianMixture$$nSamples;
    private Option<GaussianMixtureModel> initialModel;

    public int org$apache$spark$mllib$clustering$GaussianMixture$$k() {
        return this.org$apache$spark$mllib$clustering$GaussianMixture$$k;
    }

    private void org$apache$spark$mllib$clustering$GaussianMixture$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$GaussianMixture$$k = x$1;
    }

    private double convergenceTol() {
        return this.convergenceTol;
    }

    private void convergenceTol_$eq(double x$1) {
        this.convergenceTol = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public int org$apache$spark$mllib$clustering$GaussianMixture$$nSamples() {
        return this.org$apache$spark$mllib$clustering$GaussianMixture$$nSamples;
    }

    private Option<GaussianMixtureModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<GaussianMixtureModel> x$1) {
        this.initialModel = x$1;
    }

    public GaussianMixture setInitialModel(GaussianMixtureModel model) {
        if (model.k() == this.org$apache$spark$mllib$clustering$GaussianMixture$$k()) {
            this.initialModel_$eq((Option<GaussianMixtureModel>)new Some((Object)model));
            return this;
        }
        throw new IllegalArgumentException("mismatched cluster count (model.k != k)");
    }

    public Option<GaussianMixtureModel> getInitialModel() {
        return this.initialModel();
    }

    public GaussianMixture setK(int k) {
        this.org$apache$spark$mllib$clustering$GaussianMixture$$k_$eq(k);
        return this;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$GaussianMixture$$k();
    }

    public GaussianMixture setMaxIterations(int maxIterations) {
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public GaussianMixture setConvergenceTol(double convergenceTol) {
        this.convergenceTol_$eq(convergenceTol);
        return this;
    }

    public double getConvergenceTol() {
        return this.convergenceTol();
    }

    public GaussianMixture setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public GaussianMixtureModel run(RDD<Vector> data) {
        Option<GaussianMixtureModel> option;
        block8: {
            Tuple2 tuple2;
            int d;
            RDD breezeData;
            SparkContext sc;
            block7: {
                block6: {
                    sc = data.sparkContext();
                    breezeData = data.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final breeze.linalg.Vector<Object> apply(Vector x$1) {
                            return x$1.toBreeze();
                        }
                    }, ClassTag$.MODULE$.apply(breeze.linalg.Vector.class)).cache();
                    d = ((breeze.linalg.Vector)breezeData.first()).length();
                    option = this.initialModel();
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    GaussianMixtureModel gmm = (GaussianMixtureModel)some.x();
                    tuple2 = new Tuple2((Object)gmm.weights(), (Object)gmm.gaussians());
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<GaussianMixtureModel> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                breeze.linalg.Vector[] samples = (breeze.linalg.Vector[])breezeData.takeSample(true, this.org$apache$spark$mllib$clustering$GaussianMixture$$k() * this.org$apache$spark$mllib$clustering$GaussianMixture$$nSamples(), this.seed());
                tuple2 = new Tuple2(Array$.MODULE$.fill(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), (Function0)new $anonfun$1(this), ClassTag$.MODULE$.Double()), Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), (Function1)new $anonfun$3(this, samples), ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                double[] weights = (double[])tuple22._1();
                MultivariateGaussian[] gaussians = (MultivariateGaussian[])tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)weights, (Object)gaussians);
                double[] weights2 = (double[])tuple24._1();
                MultivariateGaussian[] gaussians2 = (MultivariateGaussian[])tuple24._2();
                double llh = Double$.MODULE$.MinValue();
                double llhp = 0.0;
                for (int iter = 0; iter < this.maxIterations() && package$.MODULE$.abs(llh - llhp) > this.convergenceTol(); ++iter) {
                    Broadcast compute2 = sc.broadcast((Object)new Serializable(this, weights2, gaussians2){
                        public static final long serialVersionUID = 0L;
                        private final double[] weights$1;
                        private final MultivariateGaussian[] gaussians$1;

                        public final ExpectationSum apply(ExpectationSum sums, breeze.linalg.Vector<Object> x) {
                            return ExpectationSum$.MODULE$.add(this.weights$1, this.gaussians$1, sums, x);
                        }
                        {
                            this.weights$1 = weights$1;
                            this.gaussians$1 = gaussians$1;
                        }
                    }, ClassTag$.MODULE$.apply(Function2.class));
                    ExpectationSum sums = (ExpectationSum)breezeData.aggregate((Object)ExpectationSum$.MODULE$.zero(this.org$apache$spark$mllib$clustering$GaussianMixture$$k(), d), (Function2)compute2.value(), (Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final ExpectationSum apply(ExpectationSum x$3, ExpectationSum x$4) {
                            return x$3.$plus$eq(x$4);
                        }
                    }, ClassTag$.MODULE$.apply(ExpectationSum.class));
                    double sumWeights = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(sums.weights()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    for (int i = 0; i < this.org$apache$spark$mllib$clustering$GaussianMixture$$k(); ++i) {
                        DenseVector mu = (DenseVector)sums.means()[i].$div((Object)BoxesRunTime.boxToDouble((double)sums.weights()[i]), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv());
                        BLAS$.MODULE$.syr(-sums.weights()[i], Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)mu), (DenseMatrix)Matrices$.MODULE$.fromBreeze((Matrix<Object>)sums.sigmas()[i]));
                        weights2[i] = sums.weights()[i] / sumWeights;
                        gaussians2[i] = new MultivariateGaussian((DenseVector<Object>)mu, (breeze.linalg.DenseMatrix<Object>)((breeze.linalg.DenseMatrix)sums.sigmas()[i].$div((Object)BoxesRunTime.boxToDouble((double)sums.weights()[i]), DenseMatrix$.MODULE$.op_DM_S_Double_OpDiv())));
                    }
                    llhp = llh;
                    llh = sums.logLikelihood();
                }
                return new GaussianMixtureModel(weights2, gaussians2);
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError(option);
    }

    public GaussianMixtureModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    public DenseVector<Object> org$apache$spark$mllib$clustering$GaussianMixture$$vectorMean(IndexedSeq<breeze.linalg.Vector<Object>> x) {
        DenseVector v = DenseVector$.MODULE$.zeros$mDc$sp(((breeze.linalg.Vector)x.apply(0)).length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        x.foreach((Function1)new Serializable(this, v){
            public static final long serialVersionUID = 0L;
            private final DenseVector v$1;

            public final DenseVector<Object> apply(breeze.linalg.Vector<Object> xi) {
                return (DenseVector)this.v$1.$plus$eq(xi, (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
            }
            {
                this.v$1 = v$1;
            }
        });
        return (DenseVector)v.$div((Object)BoxesRunTime.boxToDouble((double)x.length()), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv());
    }

    public breeze.linalg.DenseMatrix<Object> org$apache$spark$mllib$clustering$GaussianMixture$$initCovariance(IndexedSeq<breeze.linalg.Vector<Object>> x) {
        DenseVector<Object> mu = this.org$apache$spark$mllib$clustering$GaussianMixture$$vectorMean(x);
        DenseVector ss = DenseVector$.MODULE$.zeros$mDc$sp(((breeze.linalg.Vector)x.apply(0)).length(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        x.foreach((Function1)new Serializable(this, mu, ss){
            public static final long serialVersionUID = 0L;
            private final DenseVector mu$1;
            private final DenseVector ss$1;

            public final DenseVector<Object> apply(breeze.linalg.Vector<Object> xi) {
                return (DenseVector)this.ss$1.$plus$eq(((ImmutableNumericOps)xi.$minus((Object)this.mu$1, Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.v_v_Idempotent_Op_Double_OpSub()))).$colon$up((Object)BoxesRunTime.boxToDouble((double)2.0), (UFunc.UImpl2)Vector$.MODULE$.v_s_Op_Double_OpPow()), (UFunc.InPlaceImpl2)DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd());
            }
            {
                this.mu$1 = mu$1;
                this.ss$1 = ss$1;
            }
        });
        return (breeze.linalg.DenseMatrix)diag$.MODULE$.apply(ss.$div((Object)BoxesRunTime.boxToDouble((double)x.length()), DenseVector$.MODULE$.dv_s_Op_Double_OpDiv()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
    }

    private GaussianMixture(int k, double convergenceTol, int maxIterations, long seed) {
        this.org$apache$spark$mllib$clustering$GaussianMixture$$k = k;
        this.convergenceTol = convergenceTol;
        this.maxIterations = maxIterations;
        this.seed = seed;
        this.org$apache$spark$mllib$clustering$GaussianMixture$$nSamples = 5;
        this.initialModel = None$.MODULE$;
    }

    public GaussianMixture() {
        this(2, 0.01, 100, Utils$.MODULE$.random().nextLong());
    }
}

