/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$;
import org.apache.spark.mllib.clustering.GaussianMixtureModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.stat.distribution.MultivariateGaussian;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0001\u0003\u00015\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001dG\u0007\u00023)\u0011!\u0004B\u0001\u0005kRLG.\u0003\u0002\u001d3\tA1+\u0019<fC\ndW\r\u0003\u0005\u001f\u0001\t\u0015\r\u0011\"\u0001 \u0003\u001d9X-[4iiN,\u0012\u0001\t\t\u0004\u001f\u0005\u001a\u0013B\u0001\u0012\u0011\u0005\u0015\t%O]1z!\tyA%\u0003\u0002&!\t1Ai\\;cY\u0016D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\to\u0016Lw\r\u001b;tA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0005hCV\u001c8/[1ogV\t1\u0006E\u0002\u0010C1\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0019\u0011L7\u000f\u001e:jEV$\u0018n\u001c8\u000b\u0005E\"\u0011\u0001B:uCRL!a\r\u0018\u0003)5+H\u000e^5wCJL\u0017\r^3HCV\u001c8/[1o\u0011!)\u0004A!A!\u0002\u0013Y\u0013AC4bkN\u001c\u0018.\u00198tA!)q\u0007\u0001C\u0001q\u00051A(\u001b8jiz\"2!O\u001e=!\tQ\u0004!D\u0001\u0003\u0011\u0015qb\u00071\u0001!\u0011\u0015Ic\u00071\u0001,\u0011\u0015q\u0004\u0001\"\u0015@\u000351wN]7biZ+'o]5p]V\t\u0001\t\u0005\u0002B\r6\t!I\u0003\u0002D\t\u0006!A.\u00198h\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012\"\u0003\rM#(/\u001b8h\u0011\u0015I\u0005\u0001\"\u0011K\u0003\u0011\u0019\u0018M^3\u0015\u0007-sE\u000b\u0005\u0002\u0010\u0019&\u0011Q\n\u0005\u0002\u0005+:LG\u000fC\u0003P\u0011\u0002\u0007\u0001+\u0001\u0002tGB\u0011\u0011KU\u0007\u0002\r%\u00111K\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006+\"\u0003\rAV\u0001\u0005a\u0006$\b\u000e\u0005\u0002X5:\u0011q\u0002W\u0005\u00033B\ta\u0001\u0015:fI\u00164\u0017BA$\\\u0015\tI\u0006\u0003C\u0003^\u0001\u0011\u0005a,A\u0001l+\u0005y\u0006CA\ba\u0013\t\t\u0007CA\u0002J]RDQa\u0019\u0001\u0005\u0002\u0011\fq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002fWB\u0019a-[0\u000e\u0003\u001dT!\u0001\u001b\u0004\u0002\u0007I$G-\u0003\u0002kO\n\u0019!\u000b\u0012#\t\u000b1\u0014\u0007\u0019A7\u0002\rA|\u0017N\u001c;t!\r1\u0017N\u001c\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c\u0012\ta\u0001\\5oC2<\u0017BA:q\u0005\u00191Vm\u0019;pe\")1\r\u0001C\u0001kR\u0019a/!\u0001\u0011\u0007]\\X0D\u0001y\u0015\t)\u0015P\u0003\u0002{\r\u0005\u0019\u0011\r]5\n\u0005qD(a\u0002&bm\u0006\u0014F\t\u0012\t\u0003\u0003zL!a \"\u0003\u000f%sG/Z4fe\"1A\u000e\u001ea\u0001\u0003\u0007\u00012a^>o\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t1\u0002\u001d:fI&\u001cGoU8giR!\u00111BA\u0007!\r1\u0017\u000e\t\u0005\u0007Y\u0006\u0015\u0001\u0019A7\t\u000f\u0005E\u0001\u0001\"\u0003\u0002\u0014\u000512m\\7qkR,7k\u001c4u\u0003N\u001c\u0018n\u001a8nK:$8\u000fF\u0005!\u0003+\t9#a\u000b\u0002.!A\u0011qCA\b\u0001\u0004\tI\"\u0001\u0002qiB)\u00111DA\u0012G5\u0011\u0011Q\u0004\u0006\u0004c\u0006}!BAA\u0011\u0003\u0019\u0011'/Z3{K&!\u0011QEA\u000f\u0005-!UM\\:f-\u0016\u001cGo\u001c:\t\u000f\u0005%\u0012q\u0002a\u0001W\u0005)A-[:ug\"1a$a\u0004A\u0002\u0001Ba!XA\b\u0001\u0004y\u0006f\u0001\u0001\u00022A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY$!\u000e\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005}\"\u0001#\u0001\u0002B\u0005!r)Y;tg&\fg.T5yiV\u0014X-T8eK2\u00042AOA\"\r\u0019\t!\u0001#\u0001\u0002FM1\u00111\t\b\u0002HQ\u0001B\u0001GA%s%\u0019\u00111J\r\u0003\r1{\u0017\rZ3s\u0011\u001d9\u00141\tC\u0001\u0003\u001f\"\"!!\u0011\b\u0011\u0005M\u00131\tE\u0005\u0003+\nAbU1wK2{\u0017\r\u001a,2?B\u0002B!a\u0016\u0002Z5\u0011\u00111\t\u0004\t\u00037\n\u0019\u0005#\u0003\u0002^\ta1+\u0019<f\u0019>\fGMV\u0019`aM\u0019\u0011\u0011\f\b\t\u000f]\nI\u0006\"\u0001\u0002bQ\u0011\u0011Q\u000b\u0004\b\u0003K\nI\u0006QA4\u0005\u0011!\u0015\r^1\u0014\r\u0005\rd\"!\u001b\u0015!\ry\u00111N\u0005\u0004\u0003[\u0002\"a\u0002)s_\u0012,8\r\u001e\u0005\f\u0003c\n\u0019G!f\u0001\n\u0003\t\u0019(\u0001\u0004xK&<\u0007\u000e^\u000b\u0002G!Q\u0011qOA2\u0005#\u0005\u000b\u0011B\u0012\u0002\u000f],\u0017n\u001a5uA!Y\u00111PA2\u0005+\u0007I\u0011AA?\u0003\tiW/F\u0001o\u0011)\t\t)a\u0019\u0003\u0012\u0003\u0006IA\\\u0001\u0004[V\u0004\u0003bCAC\u0003G\u0012)\u001a!C\u0001\u0003\u000f\u000bQa]5h[\u0006,\"!!#\u0011\u0007=\fY)C\u0002\u0002\u000eB\u0014a!T1ue&D\bbCAI\u0003G\u0012\t\u0012)A\u0005\u0003\u0013\u000baa]5h[\u0006\u0004\u0003bB\u001c\u0002d\u0011\u0005\u0011Q\u0013\u000b\t\u0003/\u000bY*!(\u0002 B!\u0011\u0011TA2\u001b\t\tI\u0006C\u0004\u0002r\u0005M\u0005\u0019A\u0012\t\u000f\u0005m\u00141\u0013a\u0001]\"A\u0011QQAJ\u0001\u0004\tI\t\u0003\u0006\u0002$\u0006\r\u0014\u0011!C\u0001\u0003K\u000bAaY8qsRA\u0011qSAT\u0003S\u000bY\u000bC\u0005\u0002r\u0005\u0005\u0006\u0013!a\u0001G!I\u00111PAQ!\u0003\u0005\rA\u001c\u0005\u000b\u0003\u000b\u000b\t\u000b%AA\u0002\u0005%\u0005BCAX\u0003G\n\n\u0011\"\u0001\u00022\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAZU\r\u0019\u0013QW\u0016\u0003\u0003o\u0003B!!/\u0002B6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0007\t\n\t\u0005\r\u00171\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCAd\u0003G\n\n\u0011\"\u0001\u0002J\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAfU\rq\u0017Q\u0017\u0005\u000b\u0003\u001f\f\u0019'%A\u0005\u0002\u0005E\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003'TC!!#\u00026\"I\u0011q[A2\u0003\u0003%\teP\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0013\u0005m\u00171MA\u0001\n\u0003q\u0016\u0001\u00049s_\u0012,8\r^!sSRL\bBCAp\u0003G\n\t\u0011\"\u0001\u0002b\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAr\u0003S\u00042aDAs\u0013\r\t9\u000f\u0005\u0002\u0004\u0003:L\b\"CAv\u0003;\f\t\u00111\u0001`\u0003\rAH%\r\u0005\u000b\u0003_\f\u0019'!A\u0005B\u0005E\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005M\bCBA{\u0003w\f\u0019/\u0004\u0002\u0002x*\u0019\u0011\u0011 \t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002~\u0006](\u0001C%uKJ\fGo\u001c:\t\u0015\t\u0005\u00111MA\u0001\n\u0003\u0011\u0019!\u0001\u0005dC:,\u0015/^1m)\u0011\u0011)Aa\u0003\u0011\u0007=\u00119!C\u0002\u0003\nA\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002l\u0006}\u0018\u0011!a\u0001\u0003GD!Ba\u0004\u0002d\u0005\u0005I\u0011\tB\t\u0003!A\u0017m\u001d5D_\u0012,G#A0\t\u0015\tU\u00111MA\u0001\n\u0003\u00129\"\u0001\u0005u_N#(/\u001b8h)\u0005\u0001\u0005B\u0003B\u000e\u0003G\n\t\u0011\"\u0011\u0003\u001e\u00051Q-];bYN$BA!\u0002\u0003 !Q\u00111\u001eB\r\u0003\u0003\u0005\r!a9\b\u0015\t\r\u0012\u0011LA\u0001\u0012\u0003\u0011)#\u0001\u0003ECR\f\u0007\u0003BAM\u0005O1!\"!\u001a\u0002Z\u0005\u0005\t\u0012\u0001B\u0015'\u0015\u00119Ca\u000b\u0015!)\u0011iCa\r$]\u0006%\u0015qS\u0007\u0003\u0005_Q1A!\r\u0011\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u000e\u00030\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\t\u000f]\u00129\u0003\"\u0001\u0003:Q\u0011!Q\u0005\u0005\u000b\u0005+\u00119#!A\u0005F\t]\u0001B\u0003B \u0005O\t\t\u0011\"!\u0003B\u0005)\u0011\r\u001d9msRA\u0011q\u0013B\"\u0005\u000b\u00129\u0005C\u0004\u0002r\tu\u0002\u0019A\u0012\t\u000f\u0005m$Q\ba\u0001]\"A\u0011Q\u0011B\u001f\u0001\u0004\tI\t\u0003\u0006\u0003L\t\u001d\u0012\u0011!CA\u0005\u001b\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003P\tm\u0003#B\b\u0003R\tU\u0013b\u0001B*!\t1q\n\u001d;j_:\u0004ra\u0004B,G9\fI)C\u0002\u0003ZA\u0011a\u0001V;qY\u0016\u001c\u0004B\u0003B/\u0005\u0013\n\t\u00111\u0001\u0002\u0018\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t\u0005$qEA\u0001\n\u0013\u0011\u0019'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B3!\r\t%qM\u0005\u0004\u0005S\u0012%AB(cU\u0016\u001cG\u000fC\u0005\u0003n\u0005e#\u0019!C\u0001\u007f\u0005\tbm\u001c:nCR4VM]:j_:4\u0016g\u0018\u0019\t\u0011\tE\u0014\u0011\fQ\u0001\n\u0001\u000b!CZ8s[\u0006$h+\u001a:tS>tg+M01A!I!QOA-\u0005\u0004%\taP\u0001\u000eG2\f7o\u001d(b[\u00164\u0016g\u0018\u0019\t\u0011\te\u0014\u0011\fQ\u0001\n\u0001\u000bab\u00197bgNt\u0015-\\3Wc}\u0003\u0004\u0005C\u0004J\u00033\"\tA! \u0015\u0013-\u0013yH!!\u0003\u0004\n\u0015\u0005BB(\u0003|\u0001\u0007\u0001\u000b\u0003\u0004V\u0005w\u0002\rA\u0016\u0005\u0007=\tm\u0004\u0019\u0001\u0011\t\r%\u0012Y\b1\u0001,\u0011!\u0011I)!\u0017\u0005\u0002\t-\u0015\u0001\u00027pC\u0012$R!\u000fBG\u0005\u001fCaa\u0014BD\u0001\u0004\u0001\u0006BB+\u0003\b\u0002\u0007a\u000b\u0003\u0005\u0003\n\u0006\rC\u0011\tBJ)\u0015I$Q\u0013BL\u0011\u0019y%\u0011\u0013a\u0001!\"1QK!%A\u0002YC!B!\u0019\u0002D\u0005\u0005I\u0011\u0002B2Q\u0011\t\u0019%!\r)\t\u0005u\u0012\u0011\u0007")
public class GaussianMixtureModel
implements Serializable,
Saveable {
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;

    public static GaussianMixtureModel load(SparkContext sparkContext, String string) {
        return GaussianMixtureModel$.MODULE$.load(sparkContext, string);
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        GaussianMixtureModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.weights(), this.gaussians());
    }

    public int k() {
        return this.weights().length;
    }

    public RDD<Object> predict(RDD<Vector> points) {
        RDD<double[]> responsibilityMatrix = this.predictSoft(points);
        return responsibilityMatrix.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(double[] r) {
                return Predef$.MODULE$.doubleArrayOps(r).indexOf(Predef$.MODULE$.doubleArrayOps(r).max((Ordering)Ordering.Double$.MODULE$));
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaRDD<Integer> predict(JavaRDD<Vector> points) {
        return this.predict((RDD<Vector>)points.rdd()).toJavaRDD();
    }

    public RDD<double[]> predictSoft(RDD<Vector> points) {
        SparkContext sc = points.sparkContext();
        Broadcast bcDists = sc.broadcast((Object)this.gaussians(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(MultivariateGaussian.class)));
        Broadcast bcWeights = sc.broadcast((Object)this.weights(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return points.map((Function1)new Serializable(this, bcDists, bcWeights){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureModel $outer;
            private final Broadcast bcDists$1;
            private final Broadcast bcWeights$1;

            public final double[] apply(Vector x) {
                return this.$outer.org$apache$spark$mllib$clustering$GaussianMixtureModel$$computeSoftAssignments((DenseVector<Object>)x.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), (MultivariateGaussian[])this.bcDists$1.value(), (double[])this.bcWeights$1.value(), this.$outer.k());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcDists$1 = bcDists$1;
                this.bcWeights$1 = bcWeights$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[] org$apache$spark$mllib$clustering$GaussianMixtureModel$$computeSoftAssignments(DenseVector<Object> pt, MultivariateGaussian[] dists, double[] weights, int k) {
        double[] p = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(weights).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])dists), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, pt){
            public static final long serialVersionUID = 0L;
            private final DenseVector pt$1;

            public final double apply(Tuple2<Object, MultivariateGaussian> x0$1) {
                Tuple2<Object, MultivariateGaussian> tuple2 = x0$1;
                if (tuple2 != null) {
                    double weight = tuple2._1$mcD$sp();
                    MultivariateGaussian dist = (MultivariateGaussian)tuple2._2();
                    double d = MLUtils$.MODULE$.EPSILON() + weight * dist.pdf((breeze.linalg.Vector<Object>)this.pt$1);
                    return d;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pt$1 = pt$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double pSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(p).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k).foreach$mVc$sp((Function1)new Serializable(this, p, pSum){
            public static final long serialVersionUID = 0L;
            private final double[] p$1;
            private final double pSum$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.p$1[i] = this.p$1[i] / this.pSum$1;
            }
            {
                this.p$1 = p$1;
                this.pSum$1 = pSum$1;
            }
        });
        return p;
    }

    public GaussianMixtureModel(double[] weights, MultivariateGaussian[] gaussians) {
        this.weights = weights;
        this.gaussians = gaussians;
        Predef$.MODULE$.require(weights.length == gaussians.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Length of weight and Gaussian arrays must match";
            }
        });
    }
}

