/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Logging;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u00015\u00111\u0001\u0014#B\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u00051\u0011BA\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0004%IAG\u0001\u0002WV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\b\u0002C\u0010\u0001\u0005\u0003\u0007I\u0011\u0002\u0011\u0002\u000b-|F%Z9\u0015\u0005\u0005\"\u0003CA\b#\u0013\t\u0019\u0003C\u0001\u0003V]&$\bbB\u0013\u001f\u0003\u0003\u0005\raG\u0001\u0004q\u0012\n\u0004\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0015B\u000e\u0002\u0005-\u0004\u0003\u0002C\u0015\u0001\u0005\u0003\u0007I\u0011\u0002\u000e\u0002\u001b5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0011!Y\u0003A!a\u0001\n\u0013a\u0013!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u0011\u0011%\f\u0005\bK)\n\t\u00111\u0001\u001c\u0011!y\u0003A!A!B\u0013Y\u0012AD7bq&#XM]1uS>t7\u000f\t\u0005\tc\u0001\u0011\t\u0019!C\u0005e\u0005\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002gA\u0011q\u0002N\u0005\u0003kA\u0011a\u0001R8vE2,\u0007\u0002C\u001c\u0001\u0005\u0003\u0007I\u0011\u0002\u001d\u0002)\u0011|7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t\t\u0013\bC\u0004&m\u0005\u0005\t\u0019A\u001a\t\u0011m\u0002!\u0011!Q!\nM\n\u0011\u0003Z8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8!\u0011!i\u0004A!a\u0001\n\u0013\u0011\u0014A\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:D\u0001b\u0010\u0001\u0003\u0002\u0004%I\u0001Q\u0001\u0017i>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|gn\u0018\u0013fcR\u0011\u0011%\u0011\u0005\bKy\n\t\u00111\u00014\u0011!\u0019\u0005A!A!B\u0013\u0019\u0014a\u0005;pa&\u001c7i\u001c8dK:$(/\u0019;j_:\u0004\u0003\u0002C#\u0001\u0005\u0003\u0007I\u0011\u0002$\u0002\tM,W\rZ\u000b\u0002\u000fB\u0011q\u0002S\u0005\u0003\u0013B\u0011A\u0001T8oO\"A1\n\u0001BA\u0002\u0013%A*\u0001\u0005tK\u0016$w\fJ3r)\t\tS\nC\u0004&\u0015\u0006\u0005\t\u0019A$\t\u0011=\u0003!\u0011!Q!\n\u001d\u000bQa]3fI\u0002B\u0001\"\u0015\u0001\u0003\u0002\u0004%IAG\u0001\u0013G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0003\u0005T\u0001\t\u0005\r\u0011\"\u0003U\u0003Y\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197`I\u0015\fHCA\u0011V\u0011\u001d)#+!AA\u0002mA\u0001b\u0016\u0001\u0003\u0002\u0003\u0006KaG\u0001\u0014G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\t\u0005\t3\u0002\u0011\t\u0019!C\u00055\u0006aA\u000eZ1PaRLW.\u001b>feV\t1\f\u0005\u0002];6\t!!\u0003\u0002_\u0005\taA\nR!PaRLW.\u001b>fe\"A\u0001\r\u0001BA\u0002\u0013%\u0011-\u0001\tmI\u0006|\u0005\u000f^5nSj,'o\u0018\u0013fcR\u0011\u0011E\u0019\u0005\bK}\u000b\t\u00111\u0001\\\u0011!!\u0007A!A!B\u0013Y\u0016!\u00047eC>\u0003H/[7ju\u0016\u0014\b\u0005C\u0003g\u0001\u0011%q-\u0001\u0004=S:LGO\u0010\u000b\tQ&T7\u000e\\7o_B\u0011A\f\u0001\u0005\u00063\u0015\u0004\ra\u0007\u0005\u0006S\u0015\u0004\ra\u0007\u0005\u0006c\u0015\u0004\ra\r\u0005\u0006{\u0015\u0004\ra\r\u0005\u0006\u000b\u0016\u0004\ra\u0012\u0005\u0006#\u0016\u0004\ra\u0007\u0005\u00063\u0016\u0004\ra\u0017\u0005\u0006M\u0002!\t!\u001d\u000b\u0002Q\")1\u000f\u0001C\u00015\u0005!q-\u001a;L\u0011\u0015)\b\u0001\"\u0001w\u0003\u0011\u0019X\r^&\u0015\u0005]DX\"\u0001\u0001\t\u000be!\b\u0019A\u000e\t\u000bi\u0004A\u0011\u0001\u001a\u0002'\u001d,G\u000fR8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\t\u000bq\u0004A\u0011A?\u0002'M,G\u000fR8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0015\u0005]t\b\"B\u0019|\u0001\u0004\u0019\u0004BBA\u0001\u0001\u0011\u0005!'\u0001\u0005hKR\fE\u000e\u001d5b\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t\u0001b]3u\u00032\u0004\b.\u0019\u000b\u0004o\u0006%\u0001bBA\u0006\u0003\u0007\u0001\raM\u0001\u0006C2\u0004\b.\u0019\u0005\u0007\u0003\u001f\u0001A\u0011\u0001\u001a\u0002+\u001d,G\u000fV8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011!F:fiR{\u0007/[2D_:\u001cWM\u001c;sCRLwN\u001c\u000b\u0004o\u0006]\u0001BB\u001f\u0002\u0012\u0001\u00071\u0007\u0003\u0004\u0002\u001c\u0001!\tAM\u0001\bO\u0016$()\u001a;b\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\tqa]3u\u0005\u0016$\u0018\rF\u0002x\u0003GAq!!\n\u0002\u001e\u0001\u00071'\u0001\u0003cKR\f\u0007BBA\u0015\u0001\u0011\u0005!$\u0001\thKRl\u0015\r_%uKJ\fG/[8og\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012\u0001E:fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8t)\r9\u0018\u0011\u0007\u0005\u0007S\u0005-\u0002\u0019A\u000e\t\r\u0005U\u0002\u0001\"\u0001G\u0003\u001d9W\r^*fK\u0012Dq!!\u000f\u0001\t\u0003\tY$A\u0004tKR\u001cV-\u001a3\u0015\u0007]\fi\u0004\u0003\u0004F\u0003o\u0001\ra\u0012\u0005\u0007\u0003\u0003\u0002A\u0011\u0001\u000e\u0002+\u001d,Go\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\"9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013!F:fi\u000eCWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\u000b\u0004o\u0006%\u0003BB)\u0002D\u0001\u00071\u0004\u0003\u0004\u0002N\u0001!\tAW\u0001\rO\u0016$x\n\u001d;j[&TXM\u001d\u0015\u0005\u0003\u0017\n\t\u0006\u0005\u0003\u0002T\u0005eSBAA+\u0015\r\t9FB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA.\u0003+\u0012A\u0002R3wK2|\u0007/\u001a:Ba&Dq!a\u0018\u0001\t\u0003\t\t'\u0001\u0007tKR|\u0005\u000f^5nSj,'\u000fF\u0002x\u0003GBq!!\u001a\u0002^\u0001\u00071,A\u0005paRLW.\u001b>fe\"\"\u0011QLA)\u0011\u001d\ty\u0006\u0001C\u0001\u0003W\"2a^A7\u0011!\ty'!\u001bA\u0002\u0005E\u0014!D8qi&l\u0017N_3s\u001d\u0006lW\r\u0005\u0003\u0002t\u0005edbA\b\u0002v%\u0019\u0011q\u000f\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tY(! \u0003\rM#(/\u001b8h\u0015\r\t9\b\u0005\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u000b\u000bY\tE\u0002]\u0003\u000fK1!!#\u0003\u0005!aE)Q'pI\u0016d\u0007\u0002CAG\u0003\u007f\u0002\r!a$\u0002\u0013\u0011|7-^7f]R\u001c\bCBAI\u0003/\u000bY*\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013\u0004\u0002\u0007I$G-\u0003\u0003\u0002\u001a\u0006M%a\u0001*E\tB1q\"!(H\u0003CK1!a(\u0011\u0005\u0019!V\u000f\u001d7feA!\u00111UAU\u001b\t\t)KC\u0002\u0002(\u0012\ta\u0001\\5oC2<\u0017\u0002BAV\u0003K\u0013aAV3di>\u0014\bbBAA\u0001\u0011\u0005\u0011q\u0016\u000b\u0005\u0003\u000b\u000b\t\f\u0003\u0005\u0002\u000e\u00065\u0006\u0019AAZ!!\t),a0\u0002D\u0006\u0005VBAA\\\u0015\u0011\tI,a/\u0002\t)\fg/\u0019\u0006\u0004\u0003{3\u0011aA1qS&!\u0011\u0011YA\\\u0005-Q\u0015M^1QC&\u0014(\u000b\u0012#\u0011\t\u0005\u0015\u0017QZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006!A.\u00198h\u0015\t\tI,C\u0002J\u0003\u000fD3\u0001AAi!\u0011\t\u0019&a5\n\t\u0005U\u0017Q\u000b\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\\\u0004\t\u00033\u0014\u0001\u0012\u0001\u0002\u0002\\\u0006\u0019A\nR!\u0011\u0007q\u000biNB\u0004\u0002\u0005!\u0005!!a8\u0014\u0007\u0005ug\u0002C\u0004g\u0003;$\t!a9\u0015\u0005\u0005mW\u0001CAt\u0003;\u0004!!!;\u0003\u0017Q{\u0007/[2D_VtGo\u001d\t\u0006\u0003W\f\u0019pM\u0007\u0003\u0003[TA!a*\u0002p*\u0011\u0011\u0011_\u0001\u0007EJ,WM_3\n\t\u0005U\u0018Q\u001e\u0002\f\t\u0016t7/\u001a,fGR|'/B\u0004\u0002z\u0006u\u0007AA\u001a\u0003\u0015Q{7.\u001a8D_VtG\u000fC\u0005\u0002~\u0006uG\u0011\u0001\u0002\u0002\u0000\u0006QA/\u001a:ne%tG-\u001a=\u0015\u0007\u001d\u0013\t\u0001C\u0004\u0003\u0004\u0005m\b\u0019A\u000e\u0002\tQ,'/\u001c\u0005\n\u0005\u000f\ti\u000e\"\u0001\u0003\u0005\u0013\t!\"\u001b8eKb\u0014D/\u001a:n)\rY\"1\u0002\u0005\b\u0005\u001b\u0011)\u00011\u0001H\u0003%!XM]7J]\u0012,\u0007\u0010C\u0005\u0003\u0012\u0005uG\u0011\u0001\u0002\u0003\u0014\u0005\u0001\u0012n\u001d#pGVlWM\u001c;WKJ$X\r\u001f\u000b\u0005\u0005+\u0011Y\u0002E\u0002\u0010\u0005/I1A!\u0007\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001B!\b\u0003\u0010\u0001\u0007!qD\u0001\u0002mB\"!\u0011\u0005B(!\u001dy\u0011Q\u0014B\u0012\u0005\u0017\u0002BA!\n\u0003F9!!q\u0005B \u001d\u0011\u0011ICa\u000f\u000f\t\t-\"\u0011\b\b\u0005\u0005[\u00119D\u0004\u0003\u00030\tURB\u0001B\u0019\u0015\r\u0011\u0019\u0004D\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011b\u0001B\u001f\r\u00051qM]1qQbLAA!\u0011\u0003D\u00059\u0001/Y2lC\u001e,'b\u0001B\u001f\r%!!q\tB%\u0005!1VM\u001d;fq&#'\u0002\u0002B!\u0005\u0007\u0002BA!\u0014\u0003P1\u0001A\u0001\u0004B)\u00057\t\t\u0011!A\u0003\u0002\tM#aA0%cE!!Q\u000bB.!\ry!qK\u0005\u0004\u00053\u0002\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\tu\u0013b\u0001B0!\t\u0019\u0011I\\=\t\u0013\t\r\u0014Q\u001cC\u0001\u0005\t\u0015\u0014\u0001D5t)\u0016\u0014XNV3si\u0016DH\u0003\u0002B\u000b\u0005OB\u0001B!\b\u0003b\u0001\u0007!\u0011\u000e\u0019\u0005\u0005W\u0012y\u0007E\u0004\u0010\u0003;\u0013\u0019C!\u001c\u0011\t\t5#q\u000e\u0003\r\u0005c\u00129'!A\u0001\u0002\u000b\u0005!1\u000b\u0002\u0004?\u0012\u0012\u0004\"\u0003B;\u0003;$\tA\u0001B<\u00035\u0019w.\u001c9vi\u0016\u0004Fk\u001c9jGRq!\u0011\u0010B?\u0005\u0003\u0013)I!#\u0003\u000e\nE\u0005\u0003\u0002B>\u0003Kl!!!8\t\u0011\t}$1\u000fa\u0001\u0005s\na\u0002Z8d)>\u0004\u0018nY\"pk:$8\u000f\u0003\u0005\u0003\u0004\nM\u0004\u0019\u0001B=\u0003=!XM]7U_BL7mQ8v]R\u001c\b\u0002\u0003BD\u0005g\u0002\rA!\u001f\u0002!Q|G/\u00197U_BL7mQ8v]R\u001c\bb\u0002BF\u0005g\u0002\raG\u0001\nm>\u001c\u0017MY*ju\u0016DqAa$\u0003t\u0001\u00071'A\u0002fi\u0006Dq!a\u0003\u0003t\u0001\u00071\u0007")
public class LDA
implements Logging {
    private int k;
    private int maxIterations;
    private double docConcentration;
    private double topicConcentration;
    private long seed;
    private int checkpointInterval;
    private LDAOptimizer ldaOptimizer;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double docConcentration() {
        return this.docConcentration;
    }

    private void docConcentration_$eq(double x$1) {
        this.docConcentration = x$1;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    private void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private LDAOptimizer ldaOptimizer() {
        return this.ldaOptimizer;
    }

    private void ldaOptimizer_$eq(LDAOptimizer x$1) {
        this.ldaOptimizer = x$1;
    }

    public int getK() {
        return this.k();
    }

    public LDA setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA k (number of clusters) must be > 0, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public double getDocConcentration() {
        return this.docConcentration();
    }

    public LDA setDocConcentration(double docConcentration) {
        this.docConcentration_$eq(docConcentration);
        return this;
    }

    public double getAlpha() {
        return this.getDocConcentration();
    }

    public LDA setAlpha(double alpha) {
        return this.setDocConcentration(alpha);
    }

    public double getTopicConcentration() {
        return this.topicConcentration();
    }

    public LDA setTopicConcentration(double topicConcentration) {
        this.topicConcentration_$eq(topicConcentration);
        return this;
    }

    public double getBeta() {
        return this.getTopicConcentration();
    }

    public LDA setBeta(double beta) {
        return this.setTopicConcentration(beta);
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public LDA setMaxIterations(int maxIterations) {
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public LDA setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public LDA setCheckpointInterval(int checkpointInterval) {
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    @DeveloperApi
    public LDAOptimizer getOptimizer() {
        return this.ldaOptimizer();
    }

    @DeveloperApi
    public LDA setOptimizer(LDAOptimizer optimizer) {
        this.ldaOptimizer_$eq(optimizer);
        return this;
    }

    public LDA setOptimizer(String optimizerName) {
        String string;
        block4: {
            LDAOptimizer lDAOptimizer;
            block3: {
                block2: {
                    String string2 = string = optimizerName.toLowerCase();
                    if ("em" != null ? !"em".equals(string2) : string2 != null) break block2;
                    lDAOptimizer = new EMLDAOptimizer();
                    break block3;
                }
                String string3 = string;
                if ("online" != null ? !"online".equals(string3) : string3 != null) break block4;
                lDAOptimizer = new OnlineLDAOptimizer();
            }
            this.ldaOptimizer_$eq(lDAOptimizer);
            return this;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only em, online are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public LDAModel run(RDD<Tuple2<Object, Vector>> documents) {
        LDAOptimizer state = this.ldaOptimizer().initialize(documents, this);
        double[] iterationTimes = (double[])Array$.MODULE$.fill(this.maxIterations(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        for (int iter = 0; iter < this.maxIterations(); ++iter) {
            double elapsedSeconds;
            long start = System.nanoTime();
            state.next();
            iterationTimes[iter] = elapsedSeconds = (double)(System.nanoTime() - start) / 1.0E9;
        }
        return state.getLDAModel(iterationTimes);
    }

    public LDAModel run(JavaPairRDD<Long, Vector> documents) {
        return this.run((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private LDA(int k, int maxIterations, double docConcentration, double topicConcentration, long seed, int checkpointInterval, LDAOptimizer ldaOptimizer) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.seed = seed;
        this.checkpointInterval = checkpointInterval;
        this.ldaOptimizer = ldaOptimizer;
        Logging.class.$init$((Logging)this);
    }

    public LDA() {
        this(10, 20, -1.0, -1.0, Utils$.MODULE$.random().nextLong(), 10, new EMLDAOptimizer());
    }
}

