/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.BroadcastedColumns$;
import breeze.linalg.BroadcastedRows$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose;
import breeze.linalg.Transpose$;
import breeze.linalg.sum$;
import breeze.linalg.support.CanTranspose$;
import breeze.math.Semiring$;
import breeze.numerics.package;
import breeze.stats.distributions.Gamma;
import breeze.stats.distributions.Gamma$;
import breeze.stats.distributions.RandBasis;
import breeze.storage.Zero;
import java.util.Random;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\tma\u0001B\u0001\u0003\u00055\u0011!c\u00148mS:,G\nR!PaRLW.\u001b>fe*\u00111\u0001B\u0001\u000bG2,8\u000f^3sS:<'BA\u0003\u0007\u0003\u0015iG\u000e\\5c\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\taA\nR!PaRLW.\u001b>fe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u0003+\u0001Aq!\b\u0001A\u0002\u0013%a$A\u0001l+\u0005y\u0002CA\b!\u0013\t\t\u0003CA\u0002J]RDqa\t\u0001A\u0002\u0013%A%A\u0003l?\u0012*\u0017\u000f\u0006\u0002&QA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\"9\u0011FIA\u0001\u0002\u0004y\u0012a\u0001=%c!11\u0006\u0001Q!\n}\t!a\u001b\u0011\t\u000f5\u0002\u0001\u0019!C\u0005]\u0005Q1m\u001c:qkN\u001c\u0016N_3\u0016\u0003=\u0002\"a\u0004\u0019\n\u0005E\u0002\"\u0001\u0002'p]\u001eDqa\r\u0001A\u0002\u0013%A'\u0001\bd_J\u0004Xo]*ju\u0016|F%Z9\u0015\u0005\u0015*\u0004bB\u00153\u0003\u0003\u0005\ra\f\u0005\u0007o\u0001\u0001\u000b\u0015B\u0018\u0002\u0017\r|'\u000f];t'&TX\r\t\u0005\bs\u0001\u0001\r\u0011\"\u0003\u001f\u0003%1xnY1c'&TX\rC\u0004<\u0001\u0001\u0007I\u0011\u0002\u001f\u0002\u001bY|7-\u00192TSj,w\fJ3r)\t)S\bC\u0004*u\u0005\u0005\t\u0019A\u0010\t\r}\u0002\u0001\u0015)\u0003 \u0003)1xnY1c'&TX\r\t\u0005\b\u0003\u0002\u0001\r\u0011\"\u0003C\u0003\u0015\tG\u000e\u001d5b+\u0005\u0019\u0005CA\bE\u0013\t)\u0005C\u0001\u0004E_V\u0014G.\u001a\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003I\u0003%\tG\u000e\u001d5b?\u0012*\u0017\u000f\u0006\u0002&\u0013\"9\u0011FRA\u0001\u0002\u0004\u0019\u0005BB&\u0001A\u0003&1)\u0001\u0004bYBD\u0017\r\t\u0005\u0007\u001b\u0002!\tA\u0001\"\u0002\u0011\u001d,G/\u00117qQ\u0006Dqa\u0014\u0001A\u0002\u0013%!)A\u0002fi\u0006Dq!\u0015\u0001A\u0002\u0013%!+A\u0004fi\u0006|F%Z9\u0015\u0005\u0015\u001a\u0006bB\u0015Q\u0003\u0003\u0005\ra\u0011\u0005\u0007+\u0002\u0001\u000b\u0015B\"\u0002\t\u0015$\u0018\r\t\u0005\u0007/\u0002!\tA\u0001\"\u0002\r\u001d,G/\u0012;b\u0011\u001dI\u0006\u00011A\u0005\ni\u000bqB]1oI>lw)\u001a8fe\u0006$xN]\u000b\u00027B\u0011A,Y\u0007\u0002;*\u0011alX\u0001\u0005kRLGNC\u0001a\u0003\u0011Q\u0017M^1\n\u0005\tl&A\u0002*b]\u0012|W\u000eC\u0004e\u0001\u0001\u0007I\u0011B3\u0002'I\fg\u000eZ8n\u000f\u0016tWM]1u_J|F%Z9\u0015\u0005\u00152\u0007bB\u0015d\u0003\u0003\u0005\ra\u0017\u0005\u0007Q\u0002\u0001\u000b\u0015B.\u0002!I\fg\u000eZ8n\u000f\u0016tWM]1u_J\u0004\u0003b\u00026\u0001\u0001\u0004%IAQ\u0001\u0005i\u0006,\b\u0007C\u0004m\u0001\u0001\u0007I\u0011B7\u0002\u0011Q\fW\u000fM0%KF$\"!\n8\t\u000f%Z\u0017\u0011!a\u0001\u0007\"1\u0001\u000f\u0001Q!\n\r\u000bQ\u0001^1va\u0001BqA\u001d\u0001A\u0002\u0013%!)A\u0003lCB\u0004\u0018\rC\u0004u\u0001\u0001\u0007I\u0011B;\u0002\u0013-\f\u0007\u000f]1`I\u0015\fHCA\u0013w\u0011\u001dI3/!AA\u0002\rCa\u0001\u001f\u0001!B\u0013\u0019\u0015AB6baB\f\u0007\u0005C\u0004{\u0001\u0001\u0007I\u0011\u0002\"\u0002#5Lg.\u001b\"bi\u000eDgI]1di&|g\u000eC\u0004}\u0001\u0001\u0007I\u0011B?\u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011QE \u0005\bSm\f\t\u00111\u0001D\u0011\u001d\t\t\u0001\u0001Q!\n\r\u000b!#\\5oS\n\u000bGo\u00195Ge\u0006\u001cG/[8oA!I\u0011Q\u0001\u0001A\u0002\u0013%\u0011qA\u0001\u0005I>\u001c7/\u0006\u0002\u0002\nA1\u00111BA\t\u0003+i!!!\u0004\u000b\u0007\u0005=a!A\u0002sI\u0012LA!a\u0005\u0002\u000e\t\u0019!\u000b\u0012#\u0011\r=\t9bLA\u000e\u0013\r\tI\u0002\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\u0005\u0003\u0019a\u0017N\\1mO&!\u0011QEA\u0010\u0005\u00191Vm\u0019;pe\"I\u0011\u0011\u0006\u0001A\u0002\u0013%\u00111F\u0001\tI>\u001c7o\u0018\u0013fcR\u0019Q%!\f\t\u0013%\n9#!AA\u0002\u0005%\u0001\u0002CA\u0019\u0001\u0001\u0006K!!\u0003\u0002\u000b\u0011|7m\u001d\u0011\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005]\u0012A\u00027b[\n$\u0017-\u0006\u0002\u0002:A)\u00111HA\"\u00076\u0011\u0011Q\b\u0006\u0005\u0003C\tyD\u0003\u0002\u0002B\u00051!M]3fu\u0016LA!!\u0012\u0002>\tYA)\u001a8tK6\u000bGO]5y\u0011%\tI\u0005\u0001a\u0001\n\u0013\tY%\u0001\u0006mC6\u0014G-Y0%KF$2!JA'\u0011%I\u0013qIA\u0001\u0002\u0004\tI\u0004\u0003\u0005\u0002R\u0001\u0001\u000b\u0015BA\u001d\u0003\u001da\u0017-\u001c2eC\u0002B\u0001\"!\u0016\u0001\t\u0003\u0011\u0011qG\u0001\nO\u0016$H*Y7cI\u0006D\u0001\"!\u0017\u0001\u0001\u0004%IAH\u0001\nSR,'/\u0019;j_:D\u0011\"!\u0018\u0001\u0001\u0004%I!a\u0018\u0002\u001b%$XM]1uS>tw\fJ3r)\r)\u0013\u0011\r\u0005\tS\u0005m\u0013\u0011!a\u0001?!9\u0011Q\r\u0001!B\u0013y\u0012AC5uKJ\fG/[8oA!A\u0011\u0011\u000e\u0001A\u0002\u0013%!)\u0001\u0006hC6l\u0017m\u00155ba\u0016D\u0011\"!\u001c\u0001\u0001\u0004%I!a\u001c\u0002\u001d\u001d\fW.\\1TQ\u0006\u0004Xm\u0018\u0013fcR\u0019Q%!\u001d\t\u0011%\nY'!AA\u0002\rCq!!\u001e\u0001A\u0003&1)A\u0006hC6l\u0017m\u00155ba\u0016\u0004\u0003BBA=\u0001\u0011\u0005!)A\u0004hKR$\u0016-\u001e\u0019\t\u000f\u0005u\u0004\u0001\"\u0001\u0002\u0000\u000591/\u001a;UCV\u0004D\u0003BAA\u0003\u0007k\u0011\u0001\u0001\u0005\u0007U\u0006m\u0004\u0019A\"\t\r\u0005\u001d\u0005\u0001\"\u0001C\u0003!9W\r^&baB\f\u0007bBAF\u0001\u0011\u0005\u0011QR\u0001\tg\u0016$8*\u00199qCR!\u0011\u0011QAH\u0011\u0019\u0011\u0018\u0011\u0012a\u0001\u0007\"1\u00111\u0013\u0001\u0005\u0002\t\u000bAcZ3u\u001b&t\u0017NQ1uG\"4%/Y2uS>t\u0007bBAL\u0001\u0011\u0005\u0011\u0011T\u0001\u0015g\u0016$X*\u001b8j\u0005\u0006$8\r\u001b$sC\u000e$\u0018n\u001c8\u0015\t\u0005\u0005\u00151\u0014\u0005\u0007u\u0006U\u0005\u0019A\"\t\u0011\u0005}\u0005\u0001\"\u0001\u0003\u0003C\u000b\u0011b]3u\u0019\u0006l'\rZ1\u0015\t\u0005\u0005\u00151\u0015\u0005\t\u0003k\ti\n1\u0001\u0002:!A\u0011q\u0015\u0001\u0005\u0002\t\tI+A\u0007tKR<\u0015-\\7b'\"\f\u0007/\u001a\u000b\u0005\u0003\u0003\u000bY\u000bC\u0004\u0002.\u0006\u0015\u0006\u0019A\"\u0002\u000bMD\u0017\r]3\t\u0011\u0005E\u0006\u0001\"\u0011\u0003\u0003g\u000b!\"\u001b8ji&\fG.\u001b>f)\u0015Y\u0012QWA\\\u0011!\t)!a,A\u0002\u0005%\u0001\u0002CA]\u0003_\u0003\r!a/\u0002\u00071$\u0017\rE\u0002\u0016\u0003{K1!a0\u0003\u0005\raE)\u0011\u0005\b\u0003\u0007\u0004A\u0011\t\u0002\u001b\u0003\u0011qW\r\u001f;\t\u0011\u0005\u001d\u0007\u0001\"\u0001\u0003\u0003\u0013\fqb];c[&$X*\u001b8j\u0005\u0006$8\r\u001b\u000b\u00047\u0005-\u0007\u0002CAg\u0003\u000b\u0004\r!!\u0003\u0002\u000b\t\fGo\u00195\t\u0011\u0005E\u0007\u0001\"\u0011\u0003\u0003'\f1bZ3u\u0019\u0012\u000bUj\u001c3fYR!\u0011Q[An!\r)\u0012q[\u0005\u0004\u00033\u0014!\u0001\u0003'E\u00036{G-\u001a7\t\u0011\u0005u\u0017q\u001aa\u0001\u0003?\fa\"\u001b;fe\u0006$\u0018n\u001c8US6,7\u000f\u0005\u0003\u0010\u0003C\u001c\u0015bAAr!\t)\u0011I\u001d:bs\"A\u0011q\u001d\u0001\u0005\u0002\t\tI/\u0001\u0004va\u0012\fG/\u001a\u000b\bK\u0005-\u0018q^Az\u0011!\ti/!:A\u0002\u0005e\u0012\u0001B:uCRDq!!=\u0002f\u0002\u0007q$\u0001\u0003ji\u0016\u0014\bbBA{\u0003K\u0004\raH\u0001\nE\u0006$8\r[*ju\u0016Dq!!?\u0001\t\u0013\tY0\u0001\bhKR<\u0015-\\7b\u001b\u0006$(/\u001b=\u0015\r\u0005e\u0012Q B\u0001\u0011\u001d\ty0a>A\u0002}\t1A]8x\u0011\u001d\u0011\u0019!a>A\u0002}\t1aY8m\u0011\u001d\u00119\u0001\u0001C\u0005\u0005\u0013\tA\u0003Z5sS\u000eDG.\u001a;FqB,7\r^1uS>tG\u0003BA\u001d\u0005\u0017Aq!\u0011B\u0003\u0001\u0004\tI\u0004K\u0002\u0001\u0005\u001f\u0001BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+1\u0011AC1o]>$\u0018\r^5p]&!!\u0011\u0004B\n\u00051!UM^3m_B,'/\u00119j\u0001")
public final class OnlineLDAOptimizer
implements LDAOptimizer {
    private int k = 0;
    private long corpusSize = 0L;
    private int vocabSize = 0;
    private double alpha = 0.0;
    private double eta = 0.0;
    private Random randomGenerator = null;
    private double tau0 = 1024.0;
    private double kappa = 0.51;
    private double miniBatchFraction = 0.05;
    private RDD<Tuple2<Object, Vector>> docs = null;
    private DenseMatrix<Object> lambda = null;
    private int iteration = 0;
    private double gammaShape = 100.0;

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private long corpusSize() {
        return this.corpusSize;
    }

    private void corpusSize_$eq(long x$1) {
        this.corpusSize = x$1;
    }

    private int vocabSize() {
        return this.vocabSize;
    }

    private void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    private double alpha() {
        return this.alpha;
    }

    private void alpha_$eq(double x$1) {
        this.alpha = x$1;
    }

    public double getAlpha() {
        return this.alpha();
    }

    private double eta() {
        return this.eta;
    }

    private void eta_$eq(double x$1) {
        this.eta = x$1;
    }

    public double getEta() {
        return this.eta();
    }

    private Random randomGenerator() {
        return this.randomGenerator;
    }

    private void randomGenerator_$eq(Random x$1) {
        this.randomGenerator = x$1;
    }

    private double tau0() {
        return this.tau0;
    }

    private void tau0_$eq(double x$1) {
        this.tau0 = x$1;
    }

    private double kappa() {
        return this.kappa;
    }

    private void kappa_$eq(double x$1) {
        this.kappa = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private RDD<Tuple2<Object, Vector>> docs() {
        return this.docs;
    }

    private void docs_$eq(RDD<Tuple2<Object, Vector>> x$1) {
        this.docs = x$1;
    }

    private DenseMatrix<Object> lambda() {
        return this.lambda;
    }

    private void lambda_$eq(DenseMatrix<Object> x$1) {
        this.lambda = x$1;
    }

    public DenseMatrix<Object> getLambda() {
        return this.lambda();
    }

    private int iteration() {
        return this.iteration;
    }

    private void iteration_$eq(int x$1) {
        this.iteration = x$1;
    }

    private double gammaShape() {
        return this.gammaShape;
    }

    private void gammaShape_$eq(double x$1) {
        this.gammaShape = x$1;
    }

    public double getTau0() {
        return this.tau0();
    }

    public OnlineLDAOptimizer setTau0(double tau0) {
        Predef$.MODULE$.require(tau0 > 0.0, (Function0)new Serializable(this, tau0){
            public static final long serialVersionUID = 0L;
            private final double tau0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA tau0 must be positive, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.tau0$1)}));
            }
            {
                this.tau0$1 = tau0$1;
            }
        });
        this.tau0_$eq(tau0);
        return this;
    }

    public double getKappa() {
        return this.kappa();
    }

    public OnlineLDAOptimizer setKappa(double kappa) {
        Predef$.MODULE$.require(kappa >= 0.0, (Function0)new Serializable(this, kappa){
            public static final long serialVersionUID = 0L;
            private final double kappa$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Online LDA kappa must be nonnegative, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.kappa$1)}));
            }
            {
                this.kappa$1 = kappa$1;
            }
        });
        this.kappa_$eq(kappa);
        return this;
    }

    public double getMiniBatchFraction() {
        return this.miniBatchFraction();
    }

    public OnlineLDAOptimizer setMiniBatchFraction(double miniBatchFraction) {
        Predef$.MODULE$.require(miniBatchFraction > 0.0 && miniBatchFraction <= 1.0, (Function0)new Serializable(this, miniBatchFraction){
            public static final long serialVersionUID = 0L;
            private final double miniBatchFraction$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Online LDA miniBatchFraction must be in range (0,1], but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.miniBatchFraction$1)}));
            }
            {
                this.miniBatchFraction$1 = miniBatchFraction$1;
            }
        });
        this.miniBatchFraction_$eq(miniBatchFraction);
        return this;
    }

    public OnlineLDAOptimizer setLambda(DenseMatrix<Object> lambda) {
        this.lambda_$eq(lambda);
        return this;
    }

    public OnlineLDAOptimizer setGammaShape(double shape) {
        this.gammaShape_$eq(shape);
        return this;
    }

    @Override
    public OnlineLDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        this.k_$eq(lda.getK());
        this.corpusSize_$eq(docs.count());
        this.vocabSize_$eq(((Vector)((Tuple2)docs.first())._2()).size());
        this.alpha_$eq(lda.getDocConcentration() == (double)-1 ? 1.0 / (double)this.k() : lda.getDocConcentration());
        this.eta_$eq(lda.getTopicConcentration() == (double)-1 ? 1.0 / (double)this.k() : lda.getTopicConcentration());
        this.randomGenerator_$eq(new Random(lda.getSeed()));
        this.docs_$eq(docs);
        this.lambda_$eq(this.getGammaMatrix(this.k(), this.vocabSize()));
        this.iteration_$eq(0);
        return this;
    }

    @Override
    public OnlineLDAOptimizer next() {
        RDD batch = this.docs().sample(true, this.miniBatchFraction(), this.randomGenerator().nextLong());
        if (batch.isEmpty()) {
            return this;
        }
        return this.submitMiniBatch((RDD<Tuple2<Object, Vector>>)batch);
    }

    public OnlineLDAOptimizer submitMiniBatch(RDD<Tuple2<Object, Vector>> batch) {
        this.iteration_$eq(this.iteration() + 1);
        int k = this.k();
        int vocabSize = this.vocabSize();
        DenseMatrix<Object> Elogbeta = this.dirichletExpectation(this.lambda());
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(Elogbeta, package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
        double alpha = this.alpha();
        double gammaShape = this.gammaShape();
        RDD stats = batch.mapPartitions((Function1)new Serializable(this, k, vocabSize, expElogbeta, alpha, gammaShape){
            public static final long serialVersionUID = 0L;
            public final int k$2;
            private final int vocabSize$1;
            public final DenseMatrix expElogbeta$1;
            public final double alpha$2;
            public final double gammaShape$1;

            public final Iterator<DenseMatrix<Object>> apply(Iterator<Tuple2<Object, Vector>> docs) {
                DenseMatrix stat = DenseMatrix$.MODULE$.zeros$mDc$sp(this.k$2, this.vocabSize$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                docs.foreach((Function1)new Serializable(this, stat){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final DenseMatrix stat$1;

                    public final void apply(Tuple2<Object, Vector> doc) {
                        Vector vector;
                        block10: {
                            Tuple2 tuple2;
                            block9: {
                                block8: {
                                    Vector termCounts = (Vector)doc._2();
                                    vector = termCounts;
                                    if (!(vector instanceof DenseVector)) break block8;
                                    DenseVector denseVector = (DenseVector)vector;
                                    tuple2 = new Tuple2((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), denseVector.size()).toList(), (Object)denseVector.values());
                                    break block9;
                                }
                                if (!(vector instanceof SparseVector)) break block10;
                                SparseVector sparseVector = (SparseVector)vector;
                                tuple2 = new Tuple2((Object)Predef$.MODULE$.intArrayOps(sparseVector.indices()).toList(), (Object)sparseVector.values());
                            }
                            Tuple2 tuple22 = tuple2;
                            if (tuple22 != null) {
                                List ids = (List)tuple22._1();
                                double[] cts = (double[])tuple22._2();
                                if (ids != null) {
                                    List list = ids;
                                    if (cts != null) {
                                        Tuple2 tuple23;
                                        double[] dArray = cts;
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)list, (Object)dArray);
                                        List ids2 = (List)tuple24._1();
                                        double[] cts2 = (double[])tuple24._2();
                                        double x$13 = this.$outer.gammaShape$1;
                                        double x$14 = 1.0 / this.$outer.gammaShape$1;
                                        RandBasis x$15 = Gamma$.MODULE$.$lessinit$greater$default$3(x$13, x$14);
                                        Transpose gammad = (Transpose)new Gamma(x$13, x$14, x$15).samplesVector(this.$outer.k$2, ClassTag$.MODULE$.Double()).t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms()));
                                        Transpose Elogthetad = (Transpose)((ImmutableNumericOps)package.digamma$.MODULE$.apply((Object)gammad, Transpose$.MODULE$.liftUFunc(package.digamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.digamma$.digammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.digamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad, Transpose$.MODULE$.liftUFunc(sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()), CanTranspose$.MODULE$.transposeOfScalarIsScalar()))), (UFunc.UImpl)package.digamma$.digammaImplDouble$.MODULE$)), Tensor$.MODULE$.liftTransposeOps(Predef$.MODULE$.conforms(), DenseVector$.MODULE$.dv_s_Op_Double_OpSub(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                        Transpose expElogthetad = (Transpose)package.exp$.MODULE$.apply((Object)Elogthetad, Transpose$.MODULE$.liftUFunc(package.exp$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                        DenseMatrix expElogbetad = ((Matrix)this.$outer.expElogbeta$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)ids2, DenseMatrix$.MODULE$.canSliceWeirdCols(Semiring$.MODULE$.semiringD(), ClassTag$.MODULE$.Double()))).toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                                        Transpose phinorm = (Transpose)((NumericOps)expElogthetad.$times((Object)expElogbetad, DenseMatrix$.MODULE$.implOpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()))).$plus((Object)BoxesRunTime.boxToDouble((double)1.0E-100), Tensor$.MODULE$.liftTransposeOps(Predef$.MODULE$.conforms(), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                        double meanchange = 1.0;
                                        Transpose ctsVector = (Transpose)new DenseVector.mcD.sp(cts2).t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms()));
                                        while (meanchange > 0.001) {
                                            Transpose lastgamma = gammad;
                                            gammad = (Transpose)((NumericOps)expElogthetad.$colon$times(((ImmutableNumericOps)ctsVector.$div((Object)phinorm, Transpose$.MODULE$.liftOps(DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())))).$times(expElogbetad.t(DenseMatrix$.MODULE$.canTranspose()), DenseMatrix$.MODULE$.implOpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD())), Transpose$.MODULE$.liftOps(DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())))).$plus((Object)BoxesRunTime.boxToDouble((double)this.$outer.alpha$2), Tensor$.MODULE$.liftTransposeOps(Predef$.MODULE$.conforms(), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                            Elogthetad = (Transpose)((ImmutableNumericOps)package.digamma$.MODULE$.apply((Object)gammad, Transpose$.MODULE$.liftUFunc(package.digamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.digamma$.digammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.digamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad, Transpose$.MODULE$.liftUFunc(sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()), CanTranspose$.MODULE$.transposeOfScalarIsScalar()))), (UFunc.UImpl)package.digamma$.digammaImplDouble$.MODULE$)), Tensor$.MODULE$.liftTransposeOps(Predef$.MODULE$.conforms(), DenseVector$.MODULE$.dv_s_Op_Double_OpSub(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                            expElogthetad = (Transpose)package.exp$.MODULE$.apply((Object)Elogthetad, Transpose$.MODULE$.liftUFunc(package.exp$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                            phinorm = (Transpose)((NumericOps)expElogthetad.$times((Object)expElogbetad, DenseMatrix$.MODULE$.implOpMulMatrix_DVTt_DMT_eq_DMT((UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD()))).$plus((Object)BoxesRunTime.boxToDouble((double)1.0E-100), Tensor$.MODULE$.liftTransposeOps(Predef$.MODULE$.conforms(), DenseVector$.MODULE$.dv_s_Op_Double_OpAdd(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())));
                                            meanchange = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(package.abs$.MODULE$.apply(gammad.$minus((Object)lastgamma, Transpose$.MODULE$.liftOps(DenseVector$.MODULE$.canSubD(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms()))), Transpose$.MODULE$.liftUFunc(package.abs$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.abs$.absDoubleImpl$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms()))), Transpose$.MODULE$.liftUFunc(sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()), CanTranspose$.MODULE$.transposeOfScalarIsScalar()))) / (double)this.$outer.k$2;
                                        }
                                        breeze.linalg.DenseVector m1 = (breeze.linalg.DenseVector)expElogthetad.t(Transpose$.MODULE$.canUntranspose());
                                        breeze.linalg.DenseVector m2 = ((breeze.linalg.Vector)((ImmutableNumericOps)ctsVector.$div((Object)phinorm, Transpose$.MODULE$.liftOps(DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv(), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())))).t(Transpose$.MODULE$.canUntranspose())).toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
                                        for (int i = 0; i < ids2.size(); ++i) {
                                            ((NumericOps)this.stat$1.apply((Object)package$.MODULE$.$colon$colon(), ids2.apply(i), DenseMatrix$.MODULE$.canSliceCol())).$colon$eq(((NumericOps)this.stat$1.apply((Object)package$.MODULE$.$colon$colon(), ids2.apply(i), DenseMatrix$.MODULE$.canSliceCol())).$plus(m1.$times((Object)BoxesRunTime.boxToDouble((double)m2.apply$mcD$sp(i)), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.canAddD()), DenseVector$.MODULE$.canSetD());
                                        }
                                        return;
                                    }
                                }
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"Online LDA does not support vector type ").append(vector.getClass()).toString());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.stat$1 = stat$1;
                    }
                });
                return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{stat}));
            }
            {
                this.k$2 = k$2;
                this.vocabSize$1 = vocabSize$1;
                this.expElogbeta$1 = expElogbeta$1;
                this.alpha$2 = alpha$2;
                this.gammaShape$1 = gammaShape$1;
            }
        }, batch.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DenseMatrix.class));
        DenseMatrix statsSum = (DenseMatrix)stats.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseMatrix<Object> apply(DenseMatrix<Object> x$8, DenseMatrix<Object> x$9) {
                return (DenseMatrix)x$8.$plus$eq(x$9, DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpAdd());
            }
        });
        DenseMatrix batchResult = (DenseMatrix)statsSum.$colon$times((Object)expElogbeta, DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar());
        this.update((DenseMatrix<Object>)batchResult, this.iteration(), (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(this.miniBatchFraction() * (double)this.corpusSize())));
        return this;
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        return new LocalLDAModel(Matrices$.MODULE$.fromBreeze((Matrix<Object>)this.lambda()).transpose());
    }

    public void update(DenseMatrix<Object> stat, int iter, int batchSize) {
        double weight = scala.math.package$.MODULE$.pow(this.getTau0() + (double)iter, -this.getKappa());
        this.lambda_$eq((DenseMatrix<Object>)((DenseMatrix)((NumericOps)this.lambda().$times((Object)BoxesRunTime.boxToDouble((double)(1.0 - weight)), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulMatrix())).$plus(((ImmutableNumericOps)((NumericOps)stat.$times((Object)BoxesRunTime.boxToDouble((double)((double)this.corpusSize() / (double)batchSize)), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulMatrix())).$plus((Object)BoxesRunTime.boxToDouble((double)this.eta()), DenseMatrix$.MODULE$.op_DM_S_Double_OpAdd())).$times((Object)BoxesRunTime.boxToDouble((double)weight), DenseMatrix$.MODULE$.op_DM_S_Double_OpMulMatrix()), DenseMatrix$.MODULE$.op_DM_DM_Double_OpAdd())));
    }

    private DenseMatrix<Object> getGammaMatrix(int row, int col) {
        RandBasis randBasis = new RandBasis((RandomGenerator)new MersenneTwister(this.randomGenerator().nextLong()));
        Gamma gammaRandomGenerator = new Gamma(this.gammaShape(), 1.0 / this.gammaShape(), randBasis);
        double[] temp = (double[])gammaRandomGenerator.sample(row * col).toArray(ClassTag$.MODULE$.Double());
        return (DenseMatrix)new DenseMatrix.mcD.sp(col, row, temp).t(DenseMatrix$.MODULE$.canTranspose());
    }

    private DenseMatrix<Object> dirichletExpectation(DenseMatrix<Object> alpha) {
        breeze.linalg.DenseVector rowSum = (breeze.linalg.DenseVector)sum$.MODULE$.apply(alpha.apply((Object)$times$.MODULE$, (Object)package$.MODULE$.$colon$colon(), Broadcaster$.MODULE$.canBroadcastRows(DenseMatrix$.MODULE$.handholdCanMapCols())), BroadcastedRows$.MODULE$.broadcastOp(DenseMatrix$.MODULE$.handholdCanMapCols(), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()), DenseMatrix$.MODULE$.canCollapseCols(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)));
        DenseMatrix digAlpha = (DenseMatrix)package.digamma$.MODULE$.apply(alpha, package.digamma$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.handholdCMV(), (UFunc.UImpl)package.digamma$.digammaImplDouble$.MODULE$, DenseMatrix$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
        breeze.linalg.DenseVector digRowSum = (breeze.linalg.DenseVector)package.digamma$.MODULE$.apply((Object)rowSum, package.digamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.digamma$.digammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
        DenseMatrix result = (DenseMatrix)((ImmutableNumericOps)digAlpha.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows()))).$minus((Object)digRowSum, BroadcastedColumns$.MODULE$.broadcastOp2(DenseMatrix$.MODULE$.handholdCanMapRows(), DenseVector$.MODULE$.canSubD(), DenseMatrix$.MODULE$.canMapRows(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$)));
        return result;
    }
}

