/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.mllib.clustering.StreamingKMeans$;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStream$;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u00015\u0011qb\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00151A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\u0019I!a\u0006\u0004\u0003\u000f1{wmZ5oOB\u0011q\"G\u0005\u00035A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\b\u0001\u0003\u0002\u0004%\t!H\u0001\u0002WV\ta\u0004\u0005\u0002\u0010?%\u0011\u0001\u0005\u0005\u0002\u0004\u0013:$\b\u0002\u0003\u0012\u0001\u0005\u0003\u0007I\u0011A\u0012\u0002\u000b-|F%Z9\u0015\u0005\u0011:\u0003CA\b&\u0013\t1\u0003C\u0001\u0003V]&$\bb\u0002\u0015\"\u0003\u0003\u0005\rAH\u0001\u0004q\u0012\n\u0004\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u0005-\u0004\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0007I\u0011A\u0017\u0002\u0017\u0011,7-Y=GC\u000e$xN]\u000b\u0002]A\u0011qbL\u0005\u0003aA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0007I\u0011A\u001a\u0002\u001f\u0011,7-Y=GC\u000e$xN]0%KF$\"\u0001\n\u001b\t\u000f!\n\u0014\u0011!a\u0001]!Aa\u0007\u0001B\u0001B\u0003&a&\u0001\u0007eK\u000e\f\u0017PR1di>\u0014\b\u0005\u0003\u00059\u0001\t\u0005\r\u0011\"\u0001:\u0003!!\u0018.\\3V]&$X#\u0001\u001e\u0011\u0005mrdBA\b=\u0013\ti\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f\u0011\u0011!\u0011\u0005A!a\u0001\n\u0003\u0019\u0015\u0001\u0004;j[\u0016,f.\u001b;`I\u0015\fHC\u0001\u0013E\u0011\u001dA\u0013)!AA\u0002iB\u0001B\u0012\u0001\u0003\u0002\u0003\u0006KAO\u0001\ni&lW-\u00168ji\u0002BQ\u0001\u0013\u0001\u0005\u0002%\u000ba\u0001P5oSRtD\u0003\u0002&M\u001b:\u0003\"a\u0013\u0001\u000e\u0003\tAQ\u0001H$A\u0002yAQ\u0001L$A\u00029BQ\u0001O$A\u0002iBQ\u0001\u0013\u0001\u0005\u0002A#\u0012A\u0013\u0005\b%\u0002\u0001\r\u0011\"\u0005T\u0003\u0015iw\u000eZ3m+\u0005!\u0006CA&V\u0013\t1&A\u0001\u000bTiJ,\u0017-\\5oO.kU-\u00198t\u001b>$W\r\u001c\u0005\b1\u0002\u0001\r\u0011\"\u0005Z\u0003%iw\u000eZ3m?\u0012*\u0017\u000f\u0006\u0002%5\"9\u0001fVA\u0001\u0002\u0004!\u0006B\u0002/\u0001A\u0003&A+\u0001\u0004n_\u0012,G\u000e\t\u0005\u0006=\u0002!\taX\u0001\u0005g\u0016$8\n\u0006\u0002aC6\t\u0001\u0001C\u0003\u001d;\u0002\u0007a\u0004C\u0003d\u0001\u0011\u0005A-\u0001\btKR$UmY1z\r\u0006\u001cGo\u001c:\u0015\u0005\u0001,\u0007\"\u00024c\u0001\u0004q\u0013!A1\t\u000b!\u0004A\u0011A5\u0002\u0017M,G\u000fS1mM2Kg-\u001a\u000b\u0004A*d\u0007\"B6h\u0001\u0004q\u0013\u0001\u00035bY\u001ad\u0015NZ3\t\u000ba:\u0007\u0019\u0001\u001e\t\u000b9\u0004A\u0011A8\u0002#M,G/\u00138ji&\fGnQ3oi\u0016\u00148\u000fF\u0002aanDQ!]7A\u0002I\fqaY3oi\u0016\u00148\u000fE\u0002\u0010gVL!\u0001\u001e\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YLX\"A<\u000b\u0005a$\u0011A\u00027j]\u0006dw-\u0003\u0002{o\n1a+Z2u_JDQ\u0001`7A\u0002u\fqa^3jO\"$8\u000fE\u0002\u0010g:Baa \u0001\u0005\u0002\u0005\u0005\u0011\u0001E:fiJ\u000bg\u000eZ8n\u0007\u0016tG/\u001a:t)\u001d\u0001\u00171AA\u0004\u0003\u0017Aa!!\u0002\u007f\u0001\u0004q\u0012a\u00013j[\"1\u0011\u0011\u0002@A\u00029\naa^3jO\"$\b\"CA\u0007}B\u0005\t\u0019AA\b\u0003\u0011\u0019X-\u001a3\u0011\u0007=\t\t\"C\u0002\u0002\u0014A\u0011A\u0001T8oO\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011a\u00037bi\u0016\u001cH/T8eK2$\u0012\u0001\u0016\u0005\b\u0003;\u0001A\u0011AA\u0010\u0003\u001d!(/Y5o\u001f:$2\u0001JA\u0011\u0011!\t\u0019#a\u0007A\u0002\u0005\u0015\u0012\u0001\u00023bi\u0006\u0004R!a\n\u00022Ul!!!\u000b\u000b\t\u0005-\u0012QF\u0001\bIN$(/Z1n\u0015\r\tyCB\u0001\ngR\u0014X-Y7j]\u001eLA!a\r\u0002*\t9Ai\u0015;sK\u0006l\u0007bBA\u000f\u0001\u0011\u0005\u0011q\u0007\u000b\u0004I\u0005e\u0002\u0002CA\u0012\u0003k\u0001\r!a\u000f\u0011\u000b\u0005u\u0012qI;\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nAA[1wC*!\u0011QIA\u0017\u0003\r\t\u0007/[\u0005\u0005\u0003\u0013\nyDA\u0006KCZ\fGi\u0015;sK\u0006l\u0007bBA'\u0001\u0011\u0005\u0011qJ\u0001\naJ,G-[2u\u001f:$B!!\u0015\u0002TA)\u0011qEA\u0019=!A\u00111EA&\u0001\u0004\t)\u0003C\u0004\u0002N\u0001!\t!a\u0016\u0015\t\u0005e\u0013\u0011\u000e\t\u0007\u0003{\t9%a\u0017\u0011\t\u0005u\u0013QM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t\t%\u0003\u0003\u0002h\u0005}#aB%oi\u0016<WM\u001d\u0005\t\u0003G\t)\u00061\u0001\u0002<!9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0014a\u00049sK\u0012L7\r^(o-\u0006dW/Z:\u0016\t\u0005E\u0014\u0011\u0011\u000b\u0005\u0003g\n\u0019\u000b\u0006\u0003\u0002v\u0005M\u0005CBA\u0014\u0003c\t9\b\u0005\u0004\u0010\u0003s\niHH\u0005\u0004\u0003w\u0002\"A\u0002+va2,'\u0007\u0005\u0003\u0002\u0000\u0005\u0005E\u0002\u0001\u0003\t\u0003\u0007\u000bYG1\u0001\u0002\u0006\n\t1*\u0005\u0003\u0002\b\u00065\u0005cA\b\u0002\n&\u0019\u00111\u0012\t\u0003\u000f9{G\u000f[5oOB\u0019q\"a$\n\u0007\u0005E\u0005CA\u0002B]fD!\"!&\u0002l\u0005\u0005\t9AAL\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u00033\u000by*! \u000e\u0005\u0005m%bAAO!\u00059!/\u001a4mK\u000e$\u0018\u0002BAQ\u00037\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\t\u0003G\tY\u00071\u0001\u0002&B1\u0011qEA\u0019\u0003O\u0003baDA=\u0003{*\bbBA7\u0001\u0011\u0005\u00111V\u000b\u0005\u0003[\u000b9\f\u0006\u0003\u00020\u0006e\u0006\u0003CA\u001f\u0003c\u000b),a\u0017\n\t\u0005M\u0016q\b\u0002\u0010\u0015\u00064\u0018\rU1je\u0012\u001bFO]3b[B!\u0011qPA\\\t!\t\u0019)!+C\u0002\u0005\u0015\u0005\u0002CA\u0012\u0003S\u0003\r!a/\u0011\u000f\u0005u\u0012\u0011WA[k\"A\u0011q\u0018\u0001!\n\u0013\t\t-A\tbgN,'\u000f^%oSRL\u0017\r\\5{K\u0012$\u0012\u0001\n\u0005\n\u0003\u000b\u0004\u0011\u0013!C\u0001\u0003\u000f\f!d]3u%\u0006tGm\\7DK:$XM]:%I\u00164\u0017-\u001e7uIM*\"!!3+\t\u0005=\u00111Z\u0016\u0003\u0003\u001b\u0004B!a4\u0002Z6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u001b\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\\\u0006E'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"\u001a\u0001!a8\u0011\t\u0005\u0005\u0018Q]\u0007\u0003\u0003GT1!a6\u0007\u0013\u0011\t9/a9\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u0011\u0005-(\u0001#\u0001\u0003\u0003[\fqb\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn\u001d\t\u0004\u0017\u0006=haB\u0001\u0003\u0011\u0003\u0011\u0011\u0011_\n\u0005\u0003_t\u0001\u0004C\u0004I\u0003_$\t!!>\u0015\u0005\u00055\bBCA}\u0003_\u0014\r\u0011\"\u0002\u0002|\u00069!)\u0011+D\u0011\u0016\u001bVCAA\u007f\u001f\t\ty0\t\u0002\u0003\u0002\u00059!-\u0019;dQ\u0016\u001c\b\"\u0003B\u0003\u0003_\u0004\u000bQBA\u007f\u0003!\u0011\u0015\tV\"I\u000bN\u0003\u0003B\u0003B\u0005\u0003_\u0014\r\u0011\"\u0002\u0003\f\u00051\u0001kT%O)N+\"A!\u0004\u0010\u0005\t=\u0011E\u0001B\t\u0003\u0019\u0001x.\u001b8ug\"I!QCAxA\u00035!QB\u0001\b!>Ke\nV*!\u0011)\u0011I\"a<\u0002\u0002\u0013%!1D\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u001eA!\u0011Q\fB\u0010\u0013\u0011\u0011\t#a\u0018\u0003\r=\u0013'.Z2u\u0001")
public class StreamingKMeans
implements Logging,
Serializable {
    private int k;
    private double decayFactor;
    private String timeUnit;
    private StreamingKMeansModel model;
    private transient Logger org$apache$spark$Logging$$log_;

    public static String POINTS() {
        return StreamingKMeans$.MODULE$.POINTS();
    }

    public static String BATCHES() {
        return StreamingKMeans$.MODULE$.BATCHES();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public double decayFactor() {
        return this.decayFactor;
    }

    public void decayFactor_$eq(double x$1) {
        this.decayFactor = x$1;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public void timeUnit_$eq(String x$1) {
        this.timeUnit = x$1;
    }

    public StreamingKMeansModel model() {
        return this.model;
    }

    public void model_$eq(StreamingKMeansModel x$1) {
        this.model = x$1;
    }

    public StreamingKMeans setK(int k) {
        this.k_$eq(k);
        return this;
    }

    public StreamingKMeans setDecayFactor(double a) {
        this.decayFactor_$eq(a);
        return this;
    }

    public StreamingKMeans setHalfLife(double halfLife, String timeUnit) {
        block3: {
            block2: {
                String string = timeUnit;
                String string2 = "batches";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = timeUnit;
                String string4 = "points";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.decayFactor_$eq(package$.MODULE$.exp(package$.MODULE$.log(0.5) / halfLife));
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamingKMeans $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Setting decay factor to: %g ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.decayFactor())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.timeUnit_$eq(timeUnit);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid time unit for decay: ").append((Object)timeUnit).toString());
    }

    public StreamingKMeans setInitialCenters(Vector[] centers, double[] weights) {
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public StreamingKMeans setRandomCenters(int dim, double weight, long seed) {
        XORShiftRandom random = new XORShiftRandom(seed);
        Vector[] centers = (Vector[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this, dim, random){
            public static final long serialVersionUID = 0L;
            private final int dim$1;
            public final XORShiftRandom random$1;

            public final Vector apply() {
                return Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.dim$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.random$1.nextGaussian();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
            {
                this.dim$1 = dim$1;
                this.random$1 = random$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        double[] weights = (double[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this, weight){
            public static final long serialVersionUID = 0L;
            private final double weight$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.weight$1;
            }
            {
                this.weight$1 = weight$1;
            }
        }, ClassTag$.MODULE$.Double());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public long setRandomCenters$default$3() {
        return Utils$.MODULE$.random().nextLong();
    }

    public StreamingKMeansModel latestModel() {
        return this.model();
    }

    public void trainOn(DStream<Vector> data) {
        this.assertInitialized();
        data.foreachRDD((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeans $outer;

            public final void apply(RDD<Vector> rdd, Time time) {
                this.$outer.model_$eq(this.$outer.model().update(rdd, this.$outer.decayFactor(), this.$outer.timeUnit()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void trainOn(JavaDStream<Vector> data) {
        this.trainOn((DStream<Vector>)data.dstream());
    }

    public DStream<Object> predictOn(DStream<Vector> data) {
        this.assertInitialized();
        StreamingKMeansModel streamingKMeansModel = this.model();
        return data.map((Function1)new Serializable(this, streamingKMeansModel){
            public static final long serialVersionUID = 0L;
            private final StreamingKMeansModel eta$0$1$1;

            public final int apply(Vector point) {
                return this.eta$0$1$1.predict(point);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaDStream<Integer> predictOn(JavaDStream<Vector> data) {
        return JavaDStream$.MODULE$.fromDStream(this.predictOn((DStream<Vector>)data.dstream()), ClassTag$.MODULE$.apply(Integer.class));
    }

    public <K> DStream<Tuple2<K, Object>> predictOnValues(DStream<Tuple2<K, Vector>> data, ClassTag<K> evidence$1) {
        this.assertInitialized();
        DStream<Tuple2<K, Vector>> x$5 = data;
        ClassTag<K> x$6 = evidence$1;
        ClassTag x$7 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$8 = DStream$.MODULE$.toPairDStreamFunctions$default$4(x$5);
        StreamingKMeansModel streamingKMeansModel = this.model();
        return DStream$.MODULE$.toPairDStreamFunctions(x$5, x$6, x$7, null).mapValues((Function1)new Serializable(this, streamingKMeansModel){
            public static final long serialVersionUID = 0L;
            private final StreamingKMeansModel eta$0$2$1;

            public final int apply(Vector point) {
                return this.eta$0$2$1.predict(point);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public <K> JavaPairDStream<K, Integer> predictOnValues(JavaPairDStream<K, Vector> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return JavaPairDStream$.MODULE$.fromPairDStream(this.predictOnValues(data.dstream(), tag), tag, ClassTag$.MODULE$.apply(Integer.class));
    }

    private void assertInitialized() {
        if (this.model().clusterCenters() == null) {
            throw new IllegalStateException("Initial cluster centers must be set before starting predictions");
        }
    }

    public StreamingKMeans(int k, double decayFactor, String timeUnit) {
        this.k = k;
        this.decayFactor = decayFactor;
        this.timeUnit = timeUnit;
        Logging.class.$init$((Logging)this);
        this.model = new StreamingKMeansModel(null, null);
    }

    public StreamingKMeans() {
        this(2, 1.0, "batches");
    }
}

