/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.IndexedSeq;
import scala.collection.Map;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011\u0011#T;mi&d\u0017MY3m\u001b\u0016$(/[2t\u0015\t\u0019A!\u0001\u0006fm\u0006dW/\u0019;j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aD\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0014aJ,G-[2uS>t\u0017I\u001c3MC\n,Gn\u001d\t\u0004/iaR\"\u0001\r\u000b\u0005e1\u0011a\u0001:eI&\u00111\u0004\u0007\u0002\u0004%\u0012#\u0005\u0003B\b\u001e?}I!A\b\t\u0003\rQ+\b\u000f\\33!\ry\u0001EI\u0005\u0003CA\u0011Q!\u0011:sCf\u0004\"aD\u0012\n\u0005\u0011\u0002\"A\u0002#pk\ndW\rC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q)\u0002\"!\u000b\u0001\u000e\u0003\tAQ!F\u0013A\u0002YAaA\n\u0001\u0005\u0002\u0011aCC\u0001\u0015.\u0011\u0015)2\u00061\u0001/!\ty#'D\u00011\u0015\t\td!A\u0002tc2L!a\r\u0019\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\u0002C\u001b\u0001\u0011\u000b\u0007I\u0011\u0002\u001c\u0002\u000f9,X\u000eR8dgV\tq\u0007\u0005\u0002\u0010q%\u0011\u0011\b\u0005\u0002\u0005\u0019>tw\r\u0003\u0005<\u0001!\u0005\t\u0015)\u00038\u0003!qW/\u001c#pGN\u0004\u0003\u0002C\u001f\u0001\u0011\u000b\u0007I\u0011\u0002\u001c\u0002\u00139,X\u000eT1cK2\u001c\b\u0002C \u0001\u0011\u0003\u0005\u000b\u0015B\u001c\u0002\u00159,X\u000eT1cK2\u001c\b\u0005\u0003\u0005B\u0001!\u0015\r\u0011\"\u0001C\u00039\u0019XOY:fi\u0006\u001b7-\u001e:bGf,\u0012A\t\u0005\t\t\u0002A\t\u0011)Q\u0005E\u0005y1/\u001e2tKR\f5mY;sC\u000eL\b\u0005\u0003\u0005G\u0001!\u0015\r\u0011\"\u0001C\u0003!\t7mY;sC\u000eL\b\u0002\u0003%\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0012\u0002\u0013\u0005\u001c7-\u001e:bGf\u0004\u0003\u0002\u0003&\u0001\u0011\u000b\u0007I\u0011\u0001\"\u0002\u0017!\fW.\\5oO2{7o\u001d\u0005\t\u0019\u0002A\t\u0011)Q\u0005E\u0005a\u0001.Y7nS:<Gj\\:tA!Aa\n\u0001EC\u0002\u0013\u0005!)A\u0005qe\u0016\u001c\u0017n]5p]\"A\u0001\u000b\u0001E\u0001B\u0003&!%\u0001\u0006qe\u0016\u001c\u0017n]5p]\u0002B\u0001B\u0015\u0001\t\u0006\u0004%\tAQ\u0001\u0007e\u0016\u001c\u0017\r\u001c7\t\u0011Q\u0003\u0001\u0012!Q!\n\t\nqA]3dC2d\u0007\u0005\u0003\u0005W\u0001!\u0015\r\u0011\"\u0001C\u0003%1\u0017'T3bgV\u0014X\r\u0003\u0005Y\u0001!\u0005\t\u0015)\u0003#\u0003)1\u0017'T3bgV\u0014X\r\t\u0005\t5\u0002A)\u0019!C\u00057\u0006QA\u000f\u001d)fe\u000ec\u0017m]:\u0016\u0003q\u0003B!\u00181#o5\taL\u0003\u0002`!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0005t&aA'ba\"A1\r\u0001E\u0001B\u0003&A,A\u0006uaB+'o\u00117bgN\u0004\u0003\u0002C3\u0001\u0011\u000b\u0007I\u0011B.\u0002\u0015\u0019\u0004\b+\u001a:DY\u0006\u001c8\u000f\u0003\u0005h\u0001!\u0005\t\u0015)\u0003]\u0003-1\u0007\u000fU3s\u00072\f7o\u001d\u0011\t\u0011%\u0004\u0001R1A\u0005\nm\u000b!B\u001a8QKJ\u001cE.Y:t\u0011!Y\u0007\u0001#A!B\u0013a\u0016a\u00034o!\u0016\u00148\t\\1tg\u0002BQA\u0014\u0001\u0005\u00025$\"A\t8\t\u000b=d\u0007\u0019\u0001\u0012\u0002\u000b1\f'-\u001a7\t\u000bI\u0003A\u0011A9\u0015\u0005\t\u0012\b\"B8q\u0001\u0004\u0011\u0003\"\u0002,\u0001\t\u0003!HC\u0001\u0012v\u0011\u0015y7\u000f1\u0001#\u0011!9\b\u0001#b\u0001\n\u00131\u0014!B:v[R\u0003\b\u0002C=\u0001\u0011\u0003\u0005\u000b\u0015B\u001c\u0002\rM,X\u000e\u00169!\u0011!Y\b\u0001#b\u0001\n\u00131\u0014AC:v[\u001a\u00038\t\\1tg\"AQ\u0010\u0001E\u0001B\u0003&q'A\u0006tk64\u0005o\u00117bgN\u0004\u0003\u0002C@\u0001\u0011\u000b\u0007I\u0011\u0002\u001c\u0002\u0015M,XN\u00128DY\u0006\u001c8\u000fC\u0005\u0002\u0004\u0001A\t\u0011)Q\u0005o\u0005Y1/^7G]\u000ec\u0017m]:!\u0011%\t9\u0001\u0001EC\u0002\u0013\u0005!)\u0001\bnS\u000e\u0014x\u000e\u0015:fG&\u001c\u0018n\u001c8\t\u0013\u0005-\u0001\u0001#A!B\u0013\u0011\u0013aD7jGJ|\u0007K]3dSNLwN\u001c\u0011\t\u0013\u0005=\u0001\u0001#b\u0001\n\u0003\u0011\u0015aC7jGJ|'+Z2bY2D\u0011\"a\u0005\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0012\u0002\u00195L7M]8SK\u000e\fG\u000e\u001c\u0011\t\u0013\u0005]\u0001\u0001#b\u0001\n\u0003\u0011\u0015AD7jGJ|g)M'fCN,(/\u001a\u0005\n\u00037\u0001\u0001\u0012!Q!\n\t\nq\"\\5de>4\u0015'T3bgV\u0014X\r\t\u0005\u000b\u0003?\u0001\u0001R1A\u0005\u0002\u0005\u0005\u0012A\u00027bE\u0016d7/F\u0001 \u0011%\t)\u0003\u0001E\u0001B\u0003&q$A\u0004mC\n,Gn\u001d\u0011")
public class MultilabelMetrics {
    private final RDD<Tuple2<double[], double[]>> predictionAndLabels;
    private long numDocs;
    private long numLabels;
    private double subsetAccuracy;
    private double accuracy;
    private double hammingLoss;
    private double precision;
    private double recall;
    private double f1Measure;
    private Map<Object, Object> tpPerClass;
    private Map<Object, Object> fpPerClass;
    private Map<Object, Object> fnPerClass;
    private long sumTp;
    private long sumFpClass;
    private long sumFnClass;
    private double microPrecision;
    private double microRecall;
    private double microF1Measure;
    private double[] labels;
    private volatile int bitmap$0;

    private long numDocs$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 1) == 0) {
                this.numDocs = this.predictionAndLabels.count();
                this.bitmap$0 |= 1;
            }
            return this.numDocs;
        }
    }

    private long numLabels$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 2) == 0) {
                this.numLabels = this.predictionAndLabels.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Object> apply(Tuple2<double[], double[]> x0$7) {
                        Tuple2<double[], double[]> tuple2 = x0$7;
                        if (tuple2 != null) {
                            double[] labels = (double[])tuple2._2();
                            ArrayOps arrayOps = Predef$.MODULE$.doubleArrayOps(labels);
                            return arrayOps;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double()).distinct().count();
                this.bitmap$0 |= 2;
            }
            return this.numLabels;
        }
    }

    private double subsetAccuracy$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 4) == 0) {
                this.subsetAccuracy = (double)this.predictionAndLabels.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<double[], double[]> x0$8) {
                        Tuple2<double[], double[]> tuple2 = x0$8;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            IndexedSeq indexedSeq = Predef$.MODULE$.doubleArrayOps(predictions).deep();
                            IndexedSeq indexedSeq2 = Predef$.MODULE$.doubleArrayOps(labels).deep();
                            boolean bl = !(indexedSeq != null ? !indexedSeq.equals(indexedSeq2) : indexedSeq2 != null);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }).count() / (double)this.numDocs();
                this.bitmap$0 |= 4;
            }
            return this.subsetAccuracy;
        }
    }

    private double accuracy$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 8) == 0) {
                this.accuracy = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<double[], double[]> x0$9) {
                        Tuple2<double[], double[]> tuple2 = x0$9;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            double d = (double)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(labels).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(predictions))).size() / (double)(Predef$.MODULE$.doubleArrayOps(labels).size() + Predef$.MODULE$.doubleArrayOps(predictions).size() - Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(labels).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(predictions))).size());
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double())).sum() / (double)this.numDocs();
                this.bitmap$0 |= 8;
            }
            return this.accuracy;
        }
    }

    private double hammingLoss$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.hammingLoss = RDD$.MODULE$.numericRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<double[], double[]> x0$10) {
                        Tuple2<double[], double[]> tuple2 = x0$10;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            int n = Predef$.MODULE$.doubleArrayOps(labels).size() + Predef$.MODULE$.doubleArrayOps(predictions).size() - 2 * Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(labels).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(predictions))).size();
                            return n;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum() / (double)(this.numDocs() * this.numLabels());
                this.bitmap$0 |= 0x10;
            }
            return this.hammingLoss;
        }
    }

    private double precision$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.precision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<double[], double[]> x0$11) {
                        Tuple2<double[], double[]> tuple2 = x0$11;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            double d = Predef$.MODULE$.doubleArrayOps(predictions).size() > 0 ? (double)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(predictions).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(labels))).size() / (double)Predef$.MODULE$.doubleArrayOps(predictions).size() : 0.0;
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double())).sum() / (double)this.numDocs();
                this.bitmap$0 |= 0x20;
            }
            return this.precision;
        }
    }

    private double recall$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.recall = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<double[], double[]> x0$12) {
                        Tuple2<double[], double[]> tuple2 = x0$12;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            double d = (double)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(labels).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(predictions))).size() / (double)Predef$.MODULE$.doubleArrayOps(labels).size();
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double())).sum() / (double)this.numDocs();
                this.bitmap$0 |= 0x40;
            }
            return this.recall;
        }
    }

    private double f1Measure$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.f1Measure = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(Tuple2<double[], double[]> x0$13) {
                        Tuple2<double[], double[]> tuple2 = x0$13;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            double d = 2.0 * (double)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(predictions).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(labels))).size() / (double)(Predef$.MODULE$.doubleArrayOps(predictions).size() + Predef$.MODULE$.doubleArrayOps(labels).size());
                            return d;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double())).sum() / (double)this.numDocs();
                this.bitmap$0 |= 0x80;
            }
            return this.f1Measure;
        }
    }

    private Map tpPerClass$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.tpPerClass = this.predictionAndLabels.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Object> apply(Tuple2<double[], double[]> x0$1) {
                        Tuple2<double[], double[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            ArrayOps arrayOps = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(predictions).intersect((GenSeq)Predef$.MODULE$.wrapDoubleArray(labels)));
                            return arrayOps;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.Double$.MODULE$);
                this.bitmap$0 |= 0x100;
            }
            return this.tpPerClass;
        }
    }

    private Map fpPerClass$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.fpPerClass = this.predictionAndLabels.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Object> apply(Tuple2<double[], double[]> x0$2) {
                        Tuple2<double[], double[]> tuple2 = x0$2;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            ArrayOps arrayOps = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(predictions).diff((GenSeq)Predef$.MODULE$.wrapDoubleArray(labels)));
                            return arrayOps;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.Double$.MODULE$);
                this.bitmap$0 |= 0x200;
            }
            return this.fpPerClass;
        }
    }

    private Map fnPerClass$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.fnPerClass = this.predictionAndLabels.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ArrayOps<Object> apply(Tuple2<double[], double[]> x0$3) {
                        Tuple2<double[], double[]> tuple2 = x0$3;
                        if (tuple2 != null) {
                            double[] predictions = (double[])tuple2._1();
                            double[] labels = (double[])tuple2._2();
                            ArrayOps arrayOps = Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(labels).diff((GenSeq)Predef$.MODULE$.wrapDoubleArray(predictions)));
                            return arrayOps;
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.Double()).countByValue((Ordering)Ordering.Double$.MODULE$);
                this.bitmap$0 |= 0x400;
            }
            return this.fnPerClass;
        }
    }

    private long sumTp$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.sumTp = BoxesRunTime.unboxToLong((Object)this.tpPerClass().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x0$4, Tuple2<Object, Object> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$4), x1$1);
                        if (tuple2 != null) {
                            long sum = tuple2._1$mcJ$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long tp = tuple22._2$mcJ$sp();
                                long l = sum + tp;
                                return l;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }));
                this.bitmap$0 |= 0x800;
            }
            return this.sumTp;
        }
    }

    private long sumFpClass$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.sumFpClass = BoxesRunTime.unboxToLong((Object)this.fpPerClass().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x0$5, Tuple2<Object, Object> x1$2) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$5), x1$2);
                        if (tuple2 != null) {
                            long sum = tuple2._1$mcJ$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long fp = tuple22._2$mcJ$sp();
                                long l = sum + fp;
                                return l;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }));
                this.bitmap$0 |= 0x1000;
            }
            return this.sumFpClass;
        }
    }

    private long sumFnClass$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.sumFnClass = BoxesRunTime.unboxToLong((Object)this.fnPerClass().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x0$6, Tuple2<Object, Object> x1$3) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$6), x1$3);
                        if (tuple2 != null) {
                            long sum = tuple2._1$mcJ$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long fn = tuple22._2$mcJ$sp();
                                long l = sum + fn;
                                return l;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }));
                this.bitmap$0 |= 0x2000;
            }
            return this.sumFnClass;
        }
    }

    private double microPrecision$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                long sumFp = BoxesRunTime.unboxToLong((Object)this.fpPerClass().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(long x0$14, Tuple2<Object, Object> x1$4) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$14), x1$4);
                        if (tuple2 != null) {
                            long cum = tuple2._1$mcJ$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long fp = tuple22._2$mcJ$sp();
                                long l = cum + fp;
                                return l;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }));
                this.microPrecision = (double)this.sumTp() / (double)(this.sumTp() + sumFp);
                this.bitmap$0 |= 0x4000;
            }
            return this.microPrecision;
        }
    }

    private double microRecall$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                double sumFn = BoxesRunTime.unboxToDouble((Object)this.fnPerClass().foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x0$15, Tuple2<Object, Object> x1$5) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$15), x1$5);
                        if (tuple2 != null) {
                            double cum = tuple2._1$mcD$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                long fn = tuple22._2$mcJ$sp();
                                double d = cum + (double)fn;
                                return d;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                }));
                this.microRecall = (double)this.sumTp() / ((double)this.sumTp() + sumFn);
                this.bitmap$0 |= 0x8000;
            }
            return this.microRecall;
        }
    }

    private double microF1Measure$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.microF1Measure = 2.0 * (double)this.sumTp() / (double)(2L * this.sumTp() + this.sumFnClass() + this.sumFpClass());
                this.bitmap$0 |= 0x10000;
            }
            return this.microF1Measure;
        }
    }

    private double[] labels$lzycompute() {
        MultilabelMetrics multilabelMetrics = this;
        synchronized (multilabelMetrics) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.labels = (double[])Predef$.MODULE$.doubleArrayOps((double[])this.tpPerClass().keys().toArray(ClassTag$.MODULE$.Double())).sorted((Ordering)Ordering.Double$.MODULE$);
                this.bitmap$0 |= 0x20000;
            }
            return this.labels;
        }
    }

    private long numDocs() {
        return (this.bitmap$0 & 1) == 0 ? this.numDocs$lzycompute() : this.numDocs;
    }

    private long numLabels() {
        return (this.bitmap$0 & 2) == 0 ? this.numLabels$lzycompute() : this.numLabels;
    }

    public double subsetAccuracy() {
        return (this.bitmap$0 & 4) == 0 ? this.subsetAccuracy$lzycompute() : this.subsetAccuracy;
    }

    public double accuracy() {
        return (this.bitmap$0 & 8) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    public double hammingLoss() {
        return (this.bitmap$0 & 0x10) == 0 ? this.hammingLoss$lzycompute() : this.hammingLoss;
    }

    public double precision() {
        return (this.bitmap$0 & 0x20) == 0 ? this.precision$lzycompute() : this.precision;
    }

    public double recall() {
        return (this.bitmap$0 & 0x40) == 0 ? this.recall$lzycompute() : this.recall;
    }

    public double f1Measure() {
        return (this.bitmap$0 & 0x80) == 0 ? this.f1Measure$lzycompute() : this.f1Measure;
    }

    private Map<Object, Object> tpPerClass() {
        return (this.bitmap$0 & 0x100) == 0 ? this.tpPerClass$lzycompute() : this.tpPerClass;
    }

    private Map<Object, Object> fpPerClass() {
        return (this.bitmap$0 & 0x200) == 0 ? this.fpPerClass$lzycompute() : this.fpPerClass;
    }

    private Map<Object, Object> fnPerClass() {
        return (this.bitmap$0 & 0x400) == 0 ? this.fnPerClass$lzycompute() : this.fnPerClass;
    }

    public double precision(double label) {
        long fp;
        long tp = BoxesRunTime.unboxToLong((Object)this.tpPerClass().apply((Object)BoxesRunTime.boxToDouble((double)label)));
        return tp + (fp = BoxesRunTime.unboxToLong((Object)this.fpPerClass().getOrElse((Object)BoxesRunTime.boxToDouble((double)label), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }))) == 0L ? 0.0 : (double)tp / (double)(tp + fp);
    }

    public double recall(double label) {
        long fn;
        long tp = BoxesRunTime.unboxToLong((Object)this.tpPerClass().apply((Object)BoxesRunTime.boxToDouble((double)label)));
        return tp + (fn = BoxesRunTime.unboxToLong((Object)this.fnPerClass().getOrElse((Object)BoxesRunTime.boxToDouble((double)label), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }))) == 0L ? 0.0 : (double)tp / (double)(tp + fn);
    }

    public double f1Measure(double label) {
        double r;
        double p = this.precision(label);
        return p + (r = this.recall(label)) == 0.0 ? 0.0 : (double)2 * p * r / (p + r);
    }

    private long sumTp() {
        return (this.bitmap$0 & 0x800) == 0 ? this.sumTp$lzycompute() : this.sumTp;
    }

    private long sumFpClass() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.sumFpClass$lzycompute() : this.sumFpClass;
    }

    private long sumFnClass() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.sumFnClass$lzycompute() : this.sumFnClass;
    }

    public double microPrecision() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.microPrecision$lzycompute() : this.microPrecision;
    }

    public double microRecall() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.microRecall$lzycompute() : this.microRecall;
    }

    public double microF1Measure() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.microF1Measure$lzycompute() : this.microF1Measure;
    }

    public double[] labels() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.labels$lzycompute() : this.labels;
    }

    public MultilabelMetrics(RDD<Tuple2<double[], double[]>> predictionAndLabels) {
        this.predictionAndLabels = predictionAndLabels;
    }

    public MultilabelMetrics(DataFrame predictionAndLabels) {
        this((RDD<Tuple2<double[], double[]>>)predictionAndLabels.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<double[], double[]> apply(Row r) {
                return new Tuple2(r.getSeq(0).toArray(ClassTag$.MODULE$.Double()), r.getSeq(1).toArray(ClassTag$.MODULE$.Double()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

