/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.SparseVector;
import breeze.storage.Zero;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vector$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@SQLUserDefinedType(udt=VectorUDT.class)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,g+Z2u_JT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007-\u0016\u001cGo\u001c:\t\u0011e\u0001!Q1A\u0005Bi\tAa]5{KV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000bML'0\u001a\u0011\t\u0011\u0005\u0002!Q1A\u0005\u0002\t\nq!\u001b8eS\u000e,7/F\u0001$!\ryAeG\u0005\u0003KA\u0011Q!\u0011:sCfD\u0001b\n\u0001\u0003\u0002\u0003\u0006IaI\u0001\tS:$\u0017nY3tA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0004wC2,Xm]\u000b\u0002WA\u0019q\u0002\n\u0017\u0011\u0005=i\u0013B\u0001\u0018\u0011\u0005\u0019!u.\u001e2mK\"A\u0001\u0007\u0001B\u0001B\u0003%1&A\u0004wC2,Xm\u001d\u0011\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\u0011!TGN\u001c\u0011\u0005U\u0001\u0001\"B\r2\u0001\u0004Y\u0002\"B\u00112\u0001\u0004\u0019\u0003\"B\u00152\u0001\u0004Y\u0003\"B\u001d\u0001\t\u0003R\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003m\u0002\"\u0001P \u000f\u0005=i\u0014B\u0001 \u0011\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005y\u0002\u0002\"B\"\u0001\t\u0003R\u0013a\u0002;p\u0003J\u0014\u0018-\u001f\u0005\u0006\u000b\u0002!\tER\u0001\u0005G>\u0004\u00180F\u00015\u0011\u0019A\u0005\u0001\"\u0011\u0007\u0013\u0006AAo\u001c\"sK\u0016TX-F\u0001K!\rYu\nL\u0007\u0002\u0019*\u00111!\u0014\u0006\u0002\u001d\u00061!M]3fu\u0016L!a\u0006'\t\rE\u0003A\u0011\t\u0004S\u000351wN]3bG\"\f5\r^5wKR\u00111K\u0016\t\u0003\u001fQK!!\u0016\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006/B\u0003\r\u0001W\u0001\u0002MB)q\"W\u000e-'&\u0011!\f\u0005\u0002\n\rVt7\r^5p]JBQ\u0001\u0018\u0001\u0005Bu\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00027!)q\f\u0001C!5\u0005Qa.^7BGRLg/Z:\t\u000b\u0005\u0004A\u0011\t\u000e\u0002\u00179,XNT8ou\u0016\u0014xn\u001d\u0005\u0006G\u0002!\tER\u0001\ti>\u001c\u0006/\u0019:tK\"\"\u0001!Z7o!\t17.D\u0001h\u0015\tA\u0017.A\u0003usB,7O\u0003\u0002k\r\u0005\u00191/\u001d7\n\u00051<'AE*R\u0019V\u001bXM\u001d#fM&tW\r\u001a+za\u0016\f1!\u001e3uG\u0005y\u0007CA\u000bq\u0013\t\t(AA\u0005WK\u000e$xN]+E)\u001e)1O\u0001E\u0001i\u0006a1\u000b]1sg\u00164Vm\u0019;peB\u0011Q#\u001e\u0004\u0006\u0003\tA\tA^\n\u0004k:9\bCA\by\u0013\tI\bC\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u00033k\u0012\u00051\u0010F\u0001u\u0011\u0015iX\u000f\"\u0001\u007f\u0003\u001d)h.\u00199qYf$2a`A\u0006!\u0015y\u0011\u0011AA\u0003\u0013\r\t\u0019\u0001\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r=\t9aG\u0012,\u0013\r\tI\u0001\u0005\u0002\u0007)V\u0004H.Z\u001a\t\r\u00055A\u00101\u00015\u0003\t\u0019h\u000fC\u0005\u0002\u0012U\f\t\u0011\"\u0003\u0002\u0014\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019y%M[3di\u0002")
public class SparseVector
implements Vector {
    private final int size;
    private final int[] indices;
    private final double[] values;

    public static Option<Tuple3<Object, int[], double[]>> unapply(SparseVector sparseVector) {
        return SparseVector$.MODULE$.unapply(sparseVector);
    }

    @Override
    public boolean equals(Object other) {
        return Vector$class.equals(this, other);
    }

    @Override
    public double apply(int i) {
        return Vector$class.apply(this, i);
    }

    @Override
    public DenseVector toDense() {
        return Vector$class.toDense(this);
    }

    @Override
    public Vector compressed() {
        return Vector$class.compressed(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    public int[] indices() {
        return this.indices;
    }

    public double[] values() {
        return this.values;
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ",", ",", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.size()), Predef$.MODULE$.intArrayOps(this.indices()).mkString("[", ",", "]"), Predef$.MODULE$.doubleArrayOps(this.values()).mkString("[", ",", "]")}));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArray() {
        void var1_1;
        double[] data = new double[this.size()];
        int nnz = this.indices().length;
        for (int i = 0; i < nnz; ++i) {
            data[this.indices()[i]] = this.values()[i];
        }
        return var1_1;
    }

    @Override
    public SparseVector copy() {
        return new SparseVector(this.size(), (int[])this.indices().clone(), (double[])this.values().clone());
    }

    @Override
    public breeze.linalg.Vector<Object> toBreeze() {
        return new SparseVector.mcD.sp(this.indices(), this.values(), this.size(), (Zero)Zero.DoubleZero$.MODULE$);
    }

    @Override
    public void foreachActive(Function2<Object, Object, BoxedUnit> f) {
        int localValuesSize = this.values().length;
        int[] localIndices = this.indices();
        double[] localValues = this.values();
        for (int i = 0; i < localValuesSize; ++i) {
            f.apply$mcVID$sp(localIndices[i], localValues[i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = 31 + this.size();
        int end = this.values().length;
        boolean bl = true;
        int k = 0;
        while (k < end & bl) {
            int i = this.indices()[k];
            if (i < 16) {
                double v = this.values()[k];
                if (v != 0.0) {
                    result = 31 * result + i;
                    long bits = Double.doubleToLongBits(v);
                    result = 31 * result + (int)(bits ^ bits >>> 32);
                }
            } else {
                bl = false;
            }
            ++k;
        }
        return (int)var1_1;
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    @Override
    public int numNonzeros() {
        IntRef nnz = new IntRef(0);
        Predef$.MODULE$.doubleArrayOps(this.values()).foreach((Function1)new Serializable(this, nnz){
            public static final long serialVersionUID = 0L;
            private final IntRef nnz$2;

            public final void apply(double v) {
                this.apply$mcVD$sp(v);
            }

            public void apply$mcVD$sp(double v) {
                if (v != 0.0) {
                    ++this.nnz$2.elem;
                }
            }
            {
                this.nnz$2 = nnz$2;
            }
        });
        return nnz.elem;
    }

    @Override
    public SparseVector toSparse() {
        SparseVector sparseVector;
        int nnz = this.numNonzeros();
        if (nnz == this.numActives()) {
            sparseVector = this;
        } else {
            int[] ii = new int[nnz];
            double[] vv = new double[nnz];
            IntRef k = new IntRef(0);
            this.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, ii, vv, k){
                public static final long serialVersionUID = 0L;
                private final int[] ii$2;
                private final double[] vv$2;
                private final IntRef k$2;

                public final void apply(int i, double v) {
                    this.apply$mcVID$sp(i, v);
                }

                public void apply$mcVID$sp(int i, double v) {
                    if (v != 0.0) {
                        this.ii$2[this.k$2.elem] = i;
                        this.vv$2[this.k$2.elem] = v;
                        ++this.k$2.elem;
                    }
                }
                {
                    this.ii$2 = ii$2;
                    this.vv$2 = vv$2;
                    this.k$2 = k$2;
                }
            });
            sparseVector = new SparseVector(this.size(), ii, vv);
        }
        return sparseVector;
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this.size = size;
        this.indices = indices;
        this.values = values;
        Vector$class.$init$(this);
        Predef$.MODULE$.require(indices.length == values.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseVector $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"Sparse vectors require that the dimension of the").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" indices match the dimension of the values. You provided ", " indices and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.indices().length)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " values."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

