/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector$;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$$anonfun$21$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$2$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001=\u0011\u0011BU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002\u001c95\t\u0001\"\u0003\u0002\u001e\u0011\t9Aj\\4hS:<\u0007\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\u0001\u0011\u0002\tI|wo]\u000b\u0002CA\u0019!%J\u0014\u000e\u0003\rR!\u0001\n\u0005\u0002\u0007I$G-\u0003\u0002'G\t\u0019!\u000b\u0012#\u0011\u0005!JS\"\u0001\u0003\n\u0005)\"!A\u0002,fGR|'\u000f\u0003\u0005-\u0001\t\u0005\t\u0015!\u0003\"\u0003\u0015\u0011xn^:!\u0011!q\u0003A!a\u0001\n\u0013y\u0013!\u00028S_^\u001cX#\u0001\u0019\u0011\u0005E\t\u0014B\u0001\u001a\u0013\u0005\u0011auN\\4\t\u0011Q\u0002!\u00111A\u0005\nU\n\u0011B\u001c*poN|F%Z9\u0015\u0005YJ\u0004CA\t8\u0013\tA$C\u0001\u0003V]&$\bb\u0002\u001e4\u0003\u0003\u0005\r\u0001M\u0001\u0004q\u0012\n\u0004\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0019\u0002\r9\u0014vn^:!\u0011!q\u0004A!a\u0001\n\u0013y\u0014!\u00028D_2\u001cX#\u0001!\u0011\u0005E\t\u0015B\u0001\"\u0013\u0005\rIe\u000e\u001e\u0005\t\t\u0002\u0011\t\u0019!C\u0005\u000b\u0006IanQ8mg~#S-\u001d\u000b\u0003m\u0019CqAO\"\u0002\u0002\u0003\u0007\u0001\t\u0003\u0005I\u0001\t\u0005\t\u0015)\u0003A\u0003\u0019q7i\u001c7tA!)!\n\u0001C\u0001\u0017\u00061A(\u001b8jiz\"B\u0001T'O\u001fB\u0011q\u0003\u0001\u0005\u0006?%\u0003\r!\t\u0005\u0006]%\u0003\r\u0001\r\u0005\u0006}%\u0003\r\u0001\u0011\u0005\u0006\u0015\u0002!\t!\u0015\u000b\u0003\u0019JCQa\b)A\u0002\u0005BQ\u0001\u0016\u0001\u0005BU\u000bqA\\;n\u0007>d7\u000fF\u00011\u0011\u00159\u0006\u0001\"\u0011V\u0003\u001dqW/\u001c*poNDa!\u0017\u0001\u0005\u0002\u0019Q\u0016aF7vYRL\u0007\u000f\\=He\u0006l\u0017.\u00198NCR\u0014\u0018\u000e\u001f\"z)\tYV\rE\u0002]A\nl\u0011!\u0018\u0006\u0003\u000byS\u0011aX\u0001\u0007EJ,WM_3\n\u0005\u0005l&a\u0003#f]N,g+Z2u_J\u0004\"!E2\n\u0005\u0011\u0014\"A\u0002#pk\ndW\rC\u0003g1\u0002\u00071,A\u0001w\u0011\u0015A\u0007\u0001\"\u0001j\u0003Q\u0019w.\u001c9vi\u0016<%/Y7jC:l\u0015\r\u001e:jqR\t!\u000e\u0005\u0002)W&\u0011A\u000e\u0002\u0002\u0007\u001b\u0006$(/\u001b=\t\u000b9\u0004A\u0011B8\u0002\u001f\rDWmY6Ok6\u001cu\u000e\\;n]N$\"A\u000e9\t\u000bEl\u0007\u0019\u0001!\u0002\t\r|Gn\u001d\u0005\u0006g\u0002!\t\u0001^\u0001\u000bG>l\u0007/\u001e;f'Z#E\u0003B;yu~\u0004B\u0001\u000b<MU&\u0011q\u000f\u0002\u0002\u001b'&tw-\u001e7beZ\u000bG.^3EK\u000e|W\u000e]8tSRLwN\u001c\u0005\u0006sJ\u0004\r\u0001Q\u0001\u0002W\"91P\u001dI\u0001\u0002\u0004a\u0018\u0001C2p[B,H/Z+\u0011\u0005Ei\u0018B\u0001@\u0013\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0001s!\u0003\u0005\rAY\u0001\u0006e\u000e{g\u000e\u001a\u0005\bg\u0002!\tABA\u0003)5)\u0018qAA\u0005\u0003\u0017\ti!!\u0005\u0002\u0016!1\u00110a\u0001A\u0002\u0001Caa_A\u0002\u0001\u0004a\bbBA\u0001\u0003\u0007\u0001\rA\u0019\u0005\b\u0003\u001f\t\u0019\u00011\u0001A\u0003\u001di\u0017\r_%uKJDq!a\u0005\u0002\u0004\u0001\u0007!-A\u0002u_2D\u0001\"a\u0006\u0002\u0004\u0001\u0007\u0011\u0011D\u0001\u0005[>$W\r\u0005\u0003\u0002\u001c\u0005\u0005bbA\t\u0002\u001e%\u0019\u0011q\u0004\n\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\rM#(/\u001b8h\u0015\r\tyB\u0005\u0005\u0007\u0003S\u0001A\u0011A5\u0002#\r|W\u000e];uK\u000e{g/\u0019:jC:\u001cW\rC\u0004\u0002.\u0001!\t!a\f\u00025\r|W\u000e];uKB\u0013\u0018N\\2ja\u0006d7i\\7q_:,g\u000e^:\u0015\u0007)\f\t\u0004\u0003\u0004z\u0003W\u0001\r\u0001\u0011\u0005\b\u0003k\u0001A\u0011AA\u001c\u0003y\u0019w.\u001c9vi\u0016\u001cu\u000e\\;n]N+X.\\1ssN#\u0018\r^5ti&\u001c7\u000f\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@\u0019\tAa\u001d;bi&!\u00111IA\u001f\u0005yiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f'R\fG/[:uS\u000e\fGnU;n[\u0006\u0014\u0018\u0010C\u0004\u0002H\u0001!\t!!\u0013\u0002\u00115,H\u000e^5qYf$2\u0001TA&\u0011\u001d\ti%!\u0012A\u0002)\f\u0011A\u0011\u0005\b\u0003#\u0002A\u0011AA*\u0003I\u0019w\u000e\\;n]NKW.\u001b7be&$\u0018.Z:\u0015\u0005\u0005U\u0003cA\f\u0002X%\u0019\u0011\u0011\f\u0002\u0003!\r{wN\u001d3j]\u0006$X-T1ue&D\bbBA)\u0001\u0011\u0005\u0011Q\f\u000b\u0005\u0003+\ny\u0006C\u0004\u0002b\u0005m\u0003\u0019\u00012\u0002\u0013QD'/Z:i_2$\u0007\u0002CA3\u0001\u0011\u0005a!a\u001a\u00021\r|G.^7o'&l\u0017\u000e\\1sSRLWm\u001d#J\u001bN+V\n\u0006\u0004\u0002V\u0005%\u00141\u000f\u0005\t\u0003W\n\u0019\u00071\u0001\u0002n\u000591m\u001c7NC\u001e\u001c\b\u0003B\t\u0002p\tL1!!\u001d\u0013\u0005\u0015\t%O]1z\u0011\u001d\t)(a\u0019A\u0002\t\fQaZ1n[\u0006D\u0001\"!\u001f\u0001\t\u00032\u00111P\u0001\ti>\u0014%/Z3{KR\u0011\u0011Q\u0010\t\u00059\u0006}$-C\u0002\u0002\u0002v\u00131\u0002R3og\u0016l\u0015\r\u001e:jq\"9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0015!D;qI\u0006$XMT;n%><8\u000fF\u00027\u0003\u0013Cq!a#\u0002\u0004\u0002\u0007\u0001'A\u0001n\u0011%\ty\tAI\u0001\n\u0003\t\t*\u0001\u000bd_6\u0004X\u000f^3T-\u0012#C-\u001a4bk2$HEM\u000b\u0003\u0003'S3\u0001`AKW\t\t9\n\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u0013Ut7\r[3dW\u0016$'bAAQ%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00161\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAU\u0001E\u0005I\u0011AAV\u0003Q\u0019w.\u001c9vi\u0016\u001cf\u000b\u0012\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0016\u0016\u0004E\u0006U\u0005f\u0001\u0001\u00022B!\u00111WA\\\u001b\t\t)LC\u0002\u0002\"\"IA!!/\u00026\naQ\t\u001f9fe&lWM\u001c;bY\u001e9\u0011Q\u0018\u0002\t\u0002\u0005}\u0016!\u0003*po6\u000bGO]5y!\r9\u0012\u0011\u0019\u0004\u0007\u0003\tA\t!a1\u0014\u000b\u0005\u0005\u0007#!2\u0011\u0007E\t9-C\u0002\u0002JJ\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqASAa\t\u0003\ti\r\u0006\u0002\u0002@\"A\u0011\u0011[Aa\t\u0013\t\u0019.\u0001\u0003egB\u0014Hc\u0002\u001c\u0002V\u0006e\u00171\u001c\u0005\b\u0003/\fy\r1\u0001c\u0003\u0015\tG\u000e\u001d5b\u0011\u00191\u0017q\u001aa\u0001O!A\u0011Q\\Ah\u0001\u0004\ti'A\u0001V\u0011!\t\t/!1\u0005\n\u0005\r\u0018A\u0003;sSV$vNR;mYR)!.!:\u0002j\"9\u0011q]Ap\u0001\u0004\u0001\u0015!\u00018\t\u0011\u0005u\u0017q\u001ca\u0001\u0003[B!\"!<\u0002B\u0006\u0005I\u0011BAx\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\b\u0003BAz\u0003{l!!!>\u000b\t\u0005]\u0018\u0011`\u0001\u0005Y\u0006twM\u0003\u0002\u0002|\u0006!!.\u0019<b\u0013\u0011\ty0!>\u0003\r=\u0013'.Z2uQ\u0011\t\t-!-)\t\u0005m\u0016\u0011\u0017")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    private int nCols;
    private transient Logger org$apache$spark$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowMatrix$SVDMode$2$ SVDMode$1$lzycompute(VolatileObjectRef x$1) {
        RowMatrix rowMatrix = this;
        synchronized (rowMatrix) {
            if (x$1.elem != null) return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
            x$1.elem = new RowMatrix$SVDMode$2$(this);
            return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
        }
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    public long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long numCols() {
        if (this.nCols() > 0) return this.nCols();
        try {
            this.nCols_$eq(((Vector)this.rows().first()).size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(this.rows().count());
            if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        breeze.linalg.DenseVector x$6 = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Serializable x$7 = new Serializable(this, vbr){
            public static final long serialVersionUID = 0L;
            private final Broadcast vbr$1;

            /*
             * WARNING - void declaration
             */
            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U, Vector r) {
                void var3_3;
                block4: {
                    block3: {
                        breeze.linalg.Vector<Object> vector;
                        double a;
                        breeze.linalg.Vector<Object> rBrz;
                        block2: {
                            rBrz = r.toBreeze();
                            a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(this.vbr$1.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                            vector = rBrz;
                            if (!(vector instanceof breeze.linalg.DenseVector)) break block2;
                            breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(vector instanceof breeze.linalg.SparseVector)) break block4;
                        breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), U, breeze.linalg.SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return U;
                }
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support vector operation from type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getClass().getName()})));
            }
            {
                this.vbr$1 = vbr$1;
            }
        };
        Serializable x$8 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U1, breeze.linalg.DenseVector<Object> U2) {
                return (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$9 = this.rows().treeAggregate$default$4((Object)x$6);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$6, (Function2)x$7, (Function2)x$8, x$9, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        DenseVector.mcD.sp x$10 = new DenseVector.mcD.sp(new double[nt]);
        Serializable x$11 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U, Vector v) {
                RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$dspr(1.0, v, U.data$mcD$sp());
                return U;
            }
        };
        Serializable x$12 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U1, breeze.linalg.DenseVector<Object> U2) {
                return (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$13 = this.rows().treeAggregate$default$4((Object)x$10);
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$10, (Function2)x$11, (Function2)x$12, x$13, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private void checkNumColumns(int cols) {
        if (cols > 65535) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Argument with more than 65535 cols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cols)})));
        }
        if (cols > 10000) {
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning((Function0<String>)new Serializable(this, cols, memMB){
                public static final long serialVersionUID = 0L;
                private final int cols$1;
                private final long memMB$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " columns will require at least ", " megabytes of memory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cols$1), BoxesRunTime.boxToLong((long)this.memMB$1)}));
                }
                {
                    this.cols$1 = cols$1;
                    this.memMB$1 = memMB$1;
                }
            });
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        block21: {
            Enumeration.Value value;
            block26: {
                Tuple2 tuple2;
                Enumeration.Value computeMode;
                int n;
                VolatileObjectRef SVDMode$module;
                block23: {
                    block24: {
                        svd.SVD sVD;
                        block25: {
                            Tuple2 tuple22;
                            block22: {
                                Enumeration.Value value2;
                                block18: {
                                    String string;
                                    block20: {
                                        block19: {
                                            block17: {
                                                SVDMode$module = new VolatileObjectRef(null);
                                                n = (int)this.numCols();
                                                Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int k$2;
                                                    private final int n$1;

                                                    public final String apply() {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested k singular values but got k=", " and numCols=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                    }
                                                    {
                                                        this.k$2 = k$2;
                                                        this.n$1 = n$1;
                                                    }
                                                });
                                                String string2 = string = mode;
                                                if ("auto" != null ? !"auto".equals(string2) : string2 != null) break block17;
                                                if (k > 5000) {
                                                    this.logWarning((Function0<String>)new Serializable(this, k, n){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int k$2;
                                                        private final int n$1;

                                                        public final String apply() {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"computing svd with k=", " and n=", ", please check necessity"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                        }
                                                        {
                                                            this.k$2 = k$2;
                                                            this.n$1 = n$1;
                                                        }
                                                    });
                                                }
                                                value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$1(SVDMode$module).LocalARPACK() : this.SVDMode$1(SVDMode$module).LocalLAPACK()) : this.SVDMode$1(SVDMode$module).DistARPACK();
                                                break block18;
                                            }
                                            String string3 = string;
                                            if ("local-svd" != null ? !"local-svd".equals(string3) : string3 != null) break block19;
                                            value2 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                                            break block18;
                                        }
                                        String string4 = string;
                                        if ("local-eigs" != null ? !"local-eigs".equals(string4) : string4 != null) break block20;
                                        value2 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                        break block18;
                                    }
                                    String string5 = string;
                                    if ("dist-eigs" != null ? !"dist-eigs".equals(string5) : string5 != null) break block21;
                                    value2 = this.SVDMode$1(SVDMode$module).DistARPACK();
                                }
                                value = computeMode = value2;
                                Enumeration.Value value3 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                Enumeration.Value value4 = value;
                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block22;
                                Predef$.MODULE$.require(k < n, (Function0)new $anonfun$10(this, k, n));
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
                                tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)new $anonfun$11(this, G), n, k, tol, maxIter);
                                break block23;
                            }
                            Enumeration.Value value5 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                            Enumeration.Value value6 = value;
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block24;
                            Predef$.MODULE$.require(n < 17515, (Function0)new $anonfun$12(this, n));
                            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
                            sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                            if (sVD == null) break block25;
                            breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                            breeze.linalg.DenseVector sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                            if (uFull == null) break block25;
                            breeze.linalg.DenseMatrix denseMatrix = uFull;
                            if (sigmaSquaresFull == null) break block25;
                            breeze.linalg.DenseVector denseVector = sigmaSquaresFull;
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)denseMatrix, (Object)denseVector);
                            breeze.linalg.DenseMatrix uFull2 = (breeze.linalg.DenseMatrix)tuple23._1();
                            breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple23._2();
                            tuple2 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull2);
                            break block23;
                        }
                        throw new MatchError((Object)sVD);
                    }
                    Enumeration.Value value7 = this.SVDMode$1(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (value7 != null ? !value7.equals(value8) : value8 != null) break block26;
                    StorageLevel storageLevel = this.rows().getStorageLevel();
                    StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                    if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                        this.logWarning((Function0<String>)new $anonfun$13(this));
                    }
                    Predef$.MODULE$.require(k < n, (Function0)new $anonfun$14(this, k, n));
                    tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)new $anonfun$15(this), n, k, tol, maxIter);
                }
                Tuple2 tuple24 = tuple2;
                if (tuple24 != null) {
                    breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple24._1();
                    breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple24._2();
                    if (sigmaSquares != null) {
                        breeze.linalg.DenseVector denseVector = sigmaSquares;
                        if (u != null) {
                            SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
                            Tuple2 tuple25;
                            breeze.linalg.DenseMatrix denseMatrix = u;
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)denseVector, (Object)denseMatrix);
                            breeze.linalg.DenseVector sigmaSquares2 = (breeze.linalg.DenseVector)tuple26._1();
                            breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple26._2();
                            breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares2, package.sqrt$.MODULE$.fromLowOrderCanMapValues(breeze.linalg.DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, breeze.linalg.DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
                            double sigma0 = sigmas.apply$mcD$sp(0);
                            double threshold = rCond * sigma0;
                            int i = 0;
                            if (sigmas.length() < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sigmas){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$2;
                                    private final breeze.linalg.DenseVector sigmas$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " converged."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.sigmas$1.length())}));
                                    }
                                    {
                                        this.k$2 = k$2;
                                        this.sigmas$1 = sigmas$1;
                                    }
                                });
                            }
                            while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
                                ++i;
                            }
                            int sk = i;
                            if (sk < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sk){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$2;
                                    private final int sk$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " nonzeros."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.sk$1)}));
                                    }
                                    {
                                        this.k$2 = k$2;
                                        this.sk$1 = sk$1;
                                    }
                                });
                            }
                            Enumeration.Value value9 = computeMode;
                            Enumeration.Value value10 = this.SVDMode$1(SVDMode$module).DistARPACK();
                            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                StorageLevel storageLevel = this.rows().getStorageLevel();
                                StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
                                if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                                    this.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                                        }
                                    });
                                }
                            }
                            Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
                            Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                            if (computeU) {
                                DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                                int i2 = 0;
                                for (int j = 0; j < sk; ++j) {
                                    i2 = 0;
                                    double sigma = sigmas.apply$mcD$sp(j);
                                    while (i2 < n) {
                                        int n2 = i2++;
                                        int n3 = j;
                                        N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                                    }
                                }
                                RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
                            } else {
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
                            }
                            return singularValueDecomposition;
                        }
                    }
                }
                throw new MatchError(tuple24);
            }
            throw new MatchError((Object)value);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support mode ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode})));
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        Tuple2 x$14 = new Tuple2((Object)BoxesRunTime.boxToLong((long)0L), (Object)breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        Serializable x$15 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, breeze.linalg.DenseVector<Object>> apply(Tuple2<Object, breeze.linalg.DenseVector<Object>> s, Vector v) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(s._1$mcJ$sp() + 1L)), ((NumericOps)s._2()).$plus$eq(v.toBreeze(), (UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_ZeroIdempotent_InPlaceOp_Double_OpAdd()));
            }
        };
        Serializable x$16 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, breeze.linalg.DenseVector<Object>> apply(Tuple2<Object, breeze.linalg.DenseVector<Object>> s1, Tuple2<Object, breeze.linalg.DenseVector<Object>> s2) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)(s1._1$mcJ$sp() + s2._1$mcJ$sp())), ((NumericOps)s1._2()).$plus$eq(s2._2(), breeze.linalg.DenseVector$.MODULE$.canAddIntoD()));
            }
        };
        int x$17 = this.rows().treeAggregate$default$4((Object)x$14);
        Tuple2 tuple2 = (Tuple2)this.rows().treeAggregate((Object)x$14, (Function2)x$15, (Function2)x$16, x$17, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long m = tuple2._1$mcJ$sp();
            breeze.linalg.DenseVector mean2 = (breeze.linalg.DenseVector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)m), (Object)mean2);
            long m2 = tuple23._1$mcJ$sp();
            breeze.linalg.DenseVector mean3 = (breeze.linalg.DenseVector)tuple23._2();
            if (m2 <= 1L) {
                throw scala.sys.package$.MODULE$.error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RowMatrix.computeCovariance called on matrix with only ", " rows."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)m2)}))).append((Object)"  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString());
            }
            this.updateNumRows(m2);
            mean3.$colon$div$eq((Object)BoxesRunTime.boxToDouble((double)m2), breeze.linalg.DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpDiv());
            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().toBreeze();
            int j = 0;
            double m1 = (double)m2 - 1.0;
            double alpha = 0.0;
            for (int i = 0; i < n; ++i) {
                alpha = (double)m2 / m1 * mean3.apply$mcD$sp(i);
                for (j = 0; j < n; ++j) {
                    G.update$mcD$sp(i, j, G.apply$mcD$sp(i, j) / m1 - alpha * mean3.apply$mcD$sp(j));
                }
            }
            return Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)G);
        }
        throw new MatchError((Object)tuple2);
    }

    public Matrix computePrincipalComponents(int k) {
        breeze.linalg.DenseMatrix u;
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int n$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = ", " out of range (0, n = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$2)}));
            }
            {
                this.k$1 = k$1;
                this.n$2 = n$2;
            }
        });
        breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().toBreeze();
        svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (sVD != null && (u = (breeze.linalg.DenseMatrix)sVD.leftVectors()) != null) {
            breeze.linalg.DenseMatrix denseMatrix;
            breeze.linalg.DenseMatrix denseMatrix2;
            breeze.linalg.DenseMatrix u2 = denseMatrix2 = (denseMatrix = u);
            return k == n ? Matrices$.MODULE$.dense(n, k, u2.data$mcD$sp()) : Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * k));
        }
        throw new MatchError((Object)sVD);
    }

    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        MultivariateOnlineSummarizer x$18 = new MultivariateOnlineSummarizer();
        Serializable x$19 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator, Vector data) {
                return aggregator.add(data);
            }
        };
        Serializable x$20 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator1, MultivariateOnlineSummarizer aggregator2) {
                return aggregator1.merge(aggregator2);
            }
        };
        int x$21 = this.rows().treeAggregate$default$4((Object)x$18);
        MultivariateOnlineSummarizer summary = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$18, (Function2)x$19, (Function2)x$20, x$21, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return summary;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0)new Serializable(this, B, n){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;
            private final int n$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch: ", " vs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$3), BoxesRunTime.boxToInteger((int)this.B$1.numRows())}));
            }
            {
                this.B$1 = B$1;
                this.n$3 = n$3;
            }
        });
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0)new Serializable(this, B){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support dense matrix at this time but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.B$1.getClass().getName()}));
            }
            {
                this.B$1 = B$1;
            }
        });
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.toBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1)new Serializable(this, n, k, Bb){
            public static final long serialVersionUID = 0L;
            public final int n$3;
            public final int k$3;
            private final Broadcast Bb$1;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                double[] Bi = (double[])this.Bb$1.value();
                return iter.map((Function1)new Serializable(this, Bi){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;
                    private final double[] Bi$1;

                    public final Vector apply(Vector row) {
                        breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(this.$outer.k$3, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                        for (int i = 0; i < this.$outer.k$3; ++i) {
                            v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.toBreeze().dot((Object)new DenseVector.mcD.sp(this.Bi$1, i * this.$outer.n$3, 1, this.$outer.n$3), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                        }
                        return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.Bi$1 = Bi$1;
                    }
                });
            }
            {
                this.n$3 = n$3;
                this.k$3 = k$3;
                this.Bb$1 = Bb$1;
            }
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0)new Serializable(this, threshold){
            public static final long serialVersionUID = 0L;
            private final double threshold$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.threshold$1)}));
            }
            {
                this.threshold$1 = threshold$1;
            }
        });
        if (threshold > 1.0) {
            this.logWarning((Function0<String>)new Serializable(this, threshold){
                public static final long serialVersionUID = 0L;
                private final double threshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold is greater than 1: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.threshold$1)}))).append((Object)"Computation will be more efficient with promoted sparsity, ").append((Object)" however there is no correctness guarantee.").toString();
                }
                {
                    this.threshold$1 = threshold$1;
                }
            });
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        return this.columnSimilaritiesDIMSUM(this.computeColumnSummaryStatistics().normL2().toArray(), gamma);
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0)new Serializable(this, gamma){
            public static final long serialVersionUID = 0L;
            private final double gamma$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Oversampling should be greater than 1: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.gamma$1)}));
            }
            {
                this.gamma$1 = gamma$1;
            }
        });
        Predef$.MODULE$.require((long)Predef$.MODULE$.doubleArrayOps(colMags).size() == this.numCols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of magnitudes didn't match column dimension";
            }
        });
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])Predef$.MODULE$.doubleArrayOps(colMags).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x == 0.0 ? 1.0 : x;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(Predef$.MODULE$.doubleArrayOps(colMagsCorrected).map((Function1)new Serializable(this, sg){
            public static final long serialVersionUID = 0L;
            private final double sg$1;

            public final double apply(double c) {
                return this.apply$mcDD$sp(c);
            }

            public double apply$mcDD$sp(double c) {
                return this.sg$1 / c;
            }
            {
                this.sg$1 = sg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(Predef$.MODULE$.doubleArrayOps(colMagsCorrected).map((Function1)new Serializable(this, sg){
            public static final long serialVersionUID = 0L;
            private final double sg$1;

            public final double apply(double c) {
                return this.apply$mcDD$sp(c);
            }

            public double apply$mcDD$sp(double c) {
                return package$.MODULE$.min(this.sg$1, c);
            }
            {
                this.sg$1 = sg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2)new Serializable(this, pBV, qBV){
            public static final long serialVersionUID = 0L;
            private final Broadcast pBV$1;
            private final Broadcast qBV$1;

            public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(int indx, Iterator<Vector> iter) {
                double[] p = (double[])this.pBV$1.value();
                double[] q = (double[])this.qBV$1.value();
                XORShiftRandom rand2 = new XORShiftRandom((long)indx);
                double[] scaled = new double[Predef$.MODULE$.doubleArrayOps(p).size()];
                return iter.flatMap((Function1)new Serializable(this, p, q, rand2, scaled){
                    public static final long serialVersionUID = 0L;
                    public final double[] p$1;
                    private final double[] q$1;
                    public final XORShiftRandom rand$1;
                    public final double[] scaled$1;

                    public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(Vector row) {
                        Vector vector;
                        block6: {
                            Iterator iterator;
                            block5: {
                                DenseVector denseVector;
                                Option<double[]> option;
                                block4: {
                                    SparseVector sparseVector;
                                    Option<Tuple3<Object, int[], double[]>> option2;
                                    vector = row;
                                    if (!(vector instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block4;
                                    int[] indices = (int[])((Tuple3)option2.get())._2();
                                    double[] values = (double[])((Tuple3)option2.get())._3();
                                    int nnz = Predef$.MODULE$.intArrayOps(indices).size();
                                    for (int k = 0; k < nnz; ++k) {
                                        this.scaled$1[k] = values[k] / this.q$1[indices[k]];
                                    }
                                    iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1)new Serializable(this, indices, nnz){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$21$$anonfun$apply$3 $outer;
                                        private final int[] indices$1;
                                        private final int nnz$1;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final ListBuffer<Tuple2<Tuple2<Object, Object>, Object>> apply(int k) {
                                            void var2_2;
                                            ListBuffer buf = new ListBuffer();
                                            int i = this.indices$1[k];
                                            double iVal = this.$outer.scaled$1[k];
                                            if (iVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[i]) {
                                                for (int l = k + 1; l < this.nnz$1; ++l) {
                                                    int j = this.indices$1[l];
                                                    double jVal = this.$outer.scaled$1[l];
                                                    Object object = jVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
                                                }
                                            }
                                            return var2_2;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.indices$1 = indices$1;
                                            this.nnz$1 = nnz$1;
                                        }
                                    }), (Function1)Predef$.MODULE$.conforms()).flatten();
                                    break block5;
                                }
                                if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block6;
                                double[] values = (double[])option.get();
                                int n = Predef$.MODULE$.doubleArrayOps(values).size();
                                for (int i = 0; i < n; ++i) {
                                    this.scaled$1[i] = values[i] / this.q$1[i];
                                }
                                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(n, (Function1)new Serializable(this, n){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$21$$anonfun$apply$3 $outer;
                                    private final int n$4;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final ListBuffer<Tuple2<Tuple2<Object, Object>, Object>> apply(int i) {
                                        void var2_2;
                                        ListBuffer buf = new ListBuffer();
                                        double iVal = this.$outer.scaled$1[i];
                                        if (iVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[i]) {
                                            for (int j = i + 1; j < this.n$4; ++j) {
                                                double jVal = this.$outer.scaled$1[j];
                                                Object object = jVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
                                            }
                                        }
                                        return var2_2;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.n$4 = n$4;
                                    }
                                }), (Function1)Predef$.MODULE$.conforms()).flatten();
                            }
                            return iterator;
                        }
                        throw new MatchError((Object)vector);
                    }
                    {
                        this.p$1 = p$1;
                        this.q$1 = q$1;
                        this.rand$1 = rand$1;
                        this.scaled$1 = scaled$1;
                    }
                });
            }
            {
                this.pBV$1 = pBV$1;
                this.qBV$1 = qBV$1;
            }
        }, this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$4, double x$5) {
                return this.apply$mcDDD$sp(x$4, x$5);
            }

            public double apply$mcDDD$sp(double x$4, double x$5) {
                return x$4 + x$5;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MatrixEntry apply(Tuple2<Tuple2<Object, Object>, Object> x0$1) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    double sim = tuple2._2$mcD$sp();
                    if (tuple22 != null) {
                        int i = tuple22._1$mcI$sp();
                        int j = tuple22._2$mcI$sp();
                        MatrixEntry matrixEntry = new MatrixEntry(i, j, sim);
                        return matrixEntry;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = new IntRef(0);
        Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()).foreach((Function1)new Serializable(this, mat, i){
            public static final long serialVersionUID = 0L;
            public final breeze.linalg.DenseMatrix mat$1;
            public final IntRef i$1;

            public final void apply(Vector vector) {
                vector.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$toBreeze$1 $outer;

                    public final void apply(int x0$2, double x1$1) {
                        this.apply$mcVID$sp(x0$2, x1$1);
                    }

                    public void apply$mcVID$sp(int x0$2, double x1$1) {
                        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                        if (sp2 != null) {
                            int j = sp2._1$mcI$sp();
                            double v = sp2._2$mcD$sp();
                            this.$outer.mat$1.update$mcD$sp(this.$outer.i$1.elem, j, v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)sp2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ++this.i$1.elem;
            }
            {
                this.mat$1 = mat$1;
                this.i$1 = i$1;
            }
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == m, (Function0)new Serializable(this, m){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowMatrix $outer;
                private final long m$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is different from what specified or previously computed: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.m$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                }
            });
        }
    }

    private final RowMatrix$SVDMode$2$ SVDMode$1(VolatileObjectRef SVDMode$module$1) {
        return SVDMode$module$1.elem == null ? this.SVDMode$1$lzycompute(SVDMode$module$1) : (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.elem);
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = nRows;
        this.nCols = nCols;
        Logging.class.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

