/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ed!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1e\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007C\u0001\t\u001b\u0013\tY\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0019\u0001\u0005A\u0011\u000e\u0003\t\u0001\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\t\tQ*\u0005\u0002'SA\u0011\u0001cJ\u0005\u0003QE\u0011qAT8uQ&tw\r\u0005\u0002!U%\u00111F\u0001\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"9Q\u0006\u0001b\u0001\n#q\u0013A\u0003<bY&$\u0017\r^8sgV\tq\u0006E\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Qb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t9\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011q'\u0005\t\u0005!qrt)\u0003\u0002>#\tIa)\u001e8di&|g.\r\t\u0004\u007f\t#U\"\u0001!\u000b\u0005\u00053\u0011a\u0001:eI&\u00111\t\u0011\u0002\u0004%\u0012#\u0005C\u0001\u0011F\u0013\t1%A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0005\u0002\u0011\u0011&\u0011\u0011*\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0005\u0001)A\u0005_\u0005Ya/\u00197jI\u0006$xN]:!\u0011\u0015i\u0005A\"\u0001O\u0003%y\u0007\u000f^5nSj,'/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002U#\nIq\n\u001d;j[&TXM\u001d\u0005\b-\u0002\u0001\r\u0011\"\u0005X\u00031\tG\rZ%oi\u0016\u00148-\u001a9u+\u00059\u0005bB-\u0001\u0001\u0004%\tBW\u0001\u0011C\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f^0%KF$\"a\u00170\u0011\u0005Aa\u0016BA/\u0012\u0005\u0011)f.\u001b;\t\u000f}C\u0016\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\t\r\u0005\u0004\u0001\u0015)\u0003H\u00035\tG\rZ%oi\u0016\u00148-\u001a9uA!91\r\u0001a\u0001\n#9\u0016\u0001\u0004<bY&$\u0017\r^3ECR\f\u0007bB3\u0001\u0001\u0004%\tBZ\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y0%KF$\"aW4\t\u000f}#\u0017\u0011!a\u0001\u000f\"1\u0011\u000e\u0001Q!\n\u001d\u000bQB^1mS\u0012\fG/\u001a#bi\u0006\u0004\u0003bB6\u0001\u0001\u0004%\t\u0002\\\u0001\u0015]VlwJ\u001a'j]\u0016\f'\u000f\u0015:fI&\u001cGo\u001c:\u0016\u00035\u0004\"\u0001\u00058\n\u0005=\f\"aA%oi\"9\u0011\u000f\u0001a\u0001\n#\u0011\u0018\u0001\u00078v[>3G*\u001b8fCJ\u0004&/\u001a3jGR|'o\u0018\u0013fcR\u00111l\u001d\u0005\b?B\f\t\u00111\u0001n\u0011\u0019)\b\u0001)Q\u0005[\u0006)b.^7PM2Kg.Z1s!J,G-[2u_J\u0004\u0003bB<\u0001\u0001\u0004%IaV\u0001\u0012kN,g)Z1ukJ,7kY1mS:<\u0007bB=\u0001\u0001\u0004%IA_\u0001\u0016kN,g)Z1ukJ,7kY1mS:<w\fJ3r)\tY6\u0010C\u0004`q\u0006\u0005\t\u0019A$\t\ru\u0004\u0001\u0015)\u0003H\u0003I)8/\u001a$fCR,(/Z*dC2Lgn\u001a\u0011\t\u000b}\u0004A\u0011\u00017\u0002\u001d\u001d,GOT;n\r\u0016\fG/\u001e:fg\"A\u00111\u0001\u0001A\u0002\u0013EA.A\u0006ok64U-\u0019;ve\u0016\u001c\b\"CA\u0004\u0001\u0001\u0007I\u0011CA\u0005\u0003=qW/\u001c$fCR,(/Z:`I\u0015\fHcA.\u0002\f!Aq,!\u0002\u0002\u0002\u0003\u0007Q\u000eC\u0004\u0002\u0010\u0001\u0001\u000b\u0015B7\u0002\u00199,XNR3biV\u0014Xm\u001d\u0011\t\u0011\u0005M\u0001\u0001\"\u0001\u0005\u0003+\t\u0011c]3u\r\u0016\fG/\u001e:f'\u000e\fG.\u001b8h)\u0011\t9\"!\u0007\u000e\u0003\u0001Aaa^A\t\u0001\u00049\u0005bBA\u000f\u0001\u0019E\u0011qD\u0001\fGJ,\u0017\r^3N_\u0012,G\u000eF\u0003\"\u0003C\t\t\u0004\u0003\u0005\u0002$\u0005m\u0001\u0019AA\u0013\u0003\u001d9X-[4iiN\u0004B!a\n\u0002.5\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0011A\u00027j]\u0006dw-\u0003\u0003\u00020\u0005%\"A\u0002,fGR|'\u000f\u0003\u0005\u00024\u0005m\u0001\u0019AA\u001b\u0003%Ig\u000e^3sG\u0016\u0004H\u000fE\u0002\u0011\u0003oI1!!\u000f\u0012\u0005\u0019!u.\u001e2mK\"1\u0011Q\b\u0001\u0005\u0002]\u000ba\"[:BI\u0012Le\u000e^3sG\u0016\u0004H\u000fC\u0004\u0002B\u0001!\t!a\u0011\u0002\u0019M,G/\u00138uKJ\u001cW\r\u001d;\u0015\t\u0005]\u0011Q\t\u0005\u0007-\u0006}\u0002\u0019A$\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005y1/\u001a;WC2LG-\u0019;f\t\u0006$\u0018\r\u0006\u0003\u0002\u0018\u00055\u0003BB2\u0002H\u0001\u0007q\tC\u0004\u0002R\u0001!\t!a\u0015\u0002\u0007I,h\u000eF\u0002\"\u0003+Bq!a\u0016\u0002P\u0001\u0007a(A\u0003j]B,H\u000fC\u0004\u0002R\u0001!\t!a\u0017\u0015\u000b\u0005\ni&a\u0018\t\u000f\u0005]\u0013\u0011\fa\u0001}!A\u0011\u0011MA-\u0001\u0004\t)#\u0001\bj]&$\u0018.\u00197XK&<\u0007\u000e^:)\u0007\u0001\t)\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\r\tYGB\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA8\u0003S\u0012A\u0002R3wK2|\u0007/\u001a:Ba&\u0004")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private int numOfLinearPredictor;
    private boolean useFeatureScaling;
    private int numFeatures;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean x$1) {
        this.validateData = x$1;
    }

    public int numOfLinearPredictor() {
        return this.numOfLinearPredictor;
    }

    public void numOfLinearPredictor_$eq(int x$1) {
        this.numOfLinearPredictor = x$1;
    }

    private boolean useFeatureScaling() {
        return this.useFeatureScaling;
    }

    private void useFeatureScaling_$eq(boolean x$1) {
        this.useFeatureScaling = x$1;
    }

    public int getNumFeatures() {
        return this.numFeatures();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public void numFeatures_$eq(int x$1) {
        this.numFeatures = x$1;
    }

    public GeneralizedLinearAlgorithm<M> setFeatureScaling(boolean useFeatureScaling) {
        this.useFeatureScaling_$eq(useFeatureScaling);
        return this;
    }

    public abstract M createModel(Vector var1, double var2);

    public boolean isAddIntercept() {
        return this.addIntercept();
    }

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public M run(RDD<LabeledPoint> input) {
        if (this.numFeatures() < 0) {
            this.numFeatures_$eq(BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LabeledPoint x$1) {
                    return x$1.features().size();
                }
            }, ClassTag$.MODULE$.Int()).first()));
        }
        Vector initialWeights = this.numOfLinearPredictor() == 1 ? Vectors$.MODULE$.dense(new double[this.numFeatures()]) : (this.addIntercept() ? Vectors$.MODULE$.dense(new double[(this.numFeatures() + 1) * this.numOfLinearPredictor()]) : Vectors$.MODULE$.dense(new double[this.numFeatures() * this.numOfLinearPredictor()]));
        return this.run(input, initialWeights);
    }

    public M run(RDD<LabeledPoint> input, Vector initialWeights) {
        Vector weights;
        StandardScalerModel scaler;
        StandardScalerModel standardScalerModel;
        if (this.numFeatures() < 0) {
            this.numFeatures_$eq(BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LabeledPoint x$2) {
                    return x$2.features().size();
                }
            }, ClassTag$.MODULE$.Int()).first()));
        }
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = input$1;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        if (this.useFeatureScaling()) {
            boolean x$4 = true;
            boolean x$5 = false;
            standardScalerModel = new StandardScaler(x$5, x$4).fit((RDD<Vector>)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(LabeledPoint x$3) {
                    return x$3.features();
                }
            }, ClassTag$.MODULE$.apply(Vector.class)));
        } else {
            standardScalerModel = scaler = null;
        }
        RDD data = this.addIntercept() ? (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)MLUtils$.MODULE$.appendBias(this.scaler$1.transform(lp.features())));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache() : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)MLUtils$.MODULE$.appendBias(lp.features()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache()) : (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)this.scaler$1.transform(lp.features()));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache() : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Vector initialWeightsWithIntercept = this.addIntercept() && this.numOfLinearPredictor() == 1 ? MLUtils$.MODULE$.appendBias(initialWeights) : initialWeights;
        Vector weightsWithIntercept = this.optimizer().optimize((RDD<Tuple2<Object, Vector>>)data, initialWeightsWithIntercept);
        double intercept = this.addIntercept() && this.numOfLinearPredictor() == 1 ? weightsWithIntercept.apply(weightsWithIntercept.size() - 1) : 0.0;
        Vector vector = weights = this.addIntercept() && this.numOfLinearPredictor() == 1 ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsWithIntercept.toArray()).slice(0, weightsWithIntercept.size() - 1)) : weightsWithIntercept;
        if (this.useFeatureScaling()) {
            if (this.numOfLinearPredictor() == 1) {
                weights = scaler.transform(weights);
            } else {
                int n = weights.size() / this.numOfLinearPredictor();
                double[] weightsArray = weights.toArray();
                for (int i = 0; i < this.numOfLinearPredictor(); ++i) {
                    int start = i * n;
                    int end = (i + 1) * n - (this.addIntercept() ? 1 : 0);
                    double[] partialWeightsArray = scaler.transform(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsArray).slice(start, end))).toArray();
                    System.arraycopy(partialWeightsArray, 0, weightsArray, start, Predef$.MODULE$.doubleArrayOps(partialWeightsArray).size());
                }
                weights = Vectors$.MODULE$.dense(weightsArray);
            }
        }
        StorageLevel storageLevel3 = input.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return this.createModel(weights, intercept);
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = false;
        this.validateData = true;
        this.numOfLinearPredictor = 1;
        this.useFeatureScaling = false;
        this.numFeatures = -1;
    }
}

