/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0001\u0003\u00015\u0011q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011A\u0003:fOJ,7o]5p]*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f)q\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\tIwNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"\u0001D*fe&\fG.\u001b>bE2,\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0011)H/\u001b7\n\u0005\u0005r\"\u0001C*bm\u0016\f'\r\\3\t\u0011\r\u0002!Q1A\u0005\u0002\u0011\n!BY8v]\u0012\f'/[3t+\u0005)\u0003cA\b'Q%\u0011q\u0005\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u001f%J!A\u000b\t\u0003\r\u0011{WO\u00197f\u0011!a\u0003A!A!\u0002\u0013)\u0013a\u00032pk:$\u0017M]5fg\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\t\u0001J\u0001\faJ,G-[2uS>t7\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u0003&\u00031\u0001(/\u001a3jGRLwN\\:!\u0011!\u0011\u0004A!b\u0001\n\u0003\u0019\u0014\u0001C5t_R|g.[2\u0016\u0003Q\u0002\"aD\u001b\n\u0005Y\u0002\"a\u0002\"p_2,\u0017M\u001c\u0005\tq\u0001\u0011\t\u0011)A\u0005i\u0005I\u0011n]8u_:L7\r\t\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqrt\b\u0011\t\u0003{\u0001i\u0011A\u0001\u0005\u0006Ge\u0002\r!\n\u0005\u0006]e\u0002\r!\n\u0005\u0006ee\u0002\r\u0001\u000e\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u00035\u0001(/\u001a3jGRLwN\\(sIV\tA\tE\u0002F\u0011\"j\u0011A\u0012\u0006\u0003\u000fB\tA!\\1uQ&\u0011\u0011J\u0012\u0002\t\u001fJ$WM]5oO\"11\n\u0001Q\u0001\n\u0011\u000ba\u0002\u001d:fI&\u001cG/[8o\u001fJ$\u0007\u0005C\u0003;\u0001\u0011\u0005Q\n\u0006\u0003=\u001dV3\u0006\"B\u0012M\u0001\u0004y\u0005c\u0001)TQ5\t\u0011K\u0003\u0002S1\u0005!A.\u00198h\u0013\t!\u0016K\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u0015qC\n1\u0001P\u0011\u0015\u0011D\n1\u0001X!\t\u0001\u0006,\u0003\u00027#\")!\f\u0001C\u00057\u0006i\u0011m]:feR|%\u000fZ3sK\u0012$\"\u0001X7\u0015\u0005u\u0003\u0007CA\b_\u0013\ty\u0006C\u0001\u0003V]&$\b\"B1Z\u0001\b\u0011\u0017aA8sIB\u00191m\u001b\u0015\u000f\u0005\u0011LgBA3i\u001b\u00051'BA4\r\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002k!\u00059\u0001/Y2lC\u001e,\u0017BA%m\u0015\tQ\u0007\u0003C\u0003o3\u0002\u0007Q%\u0001\u0002yg\")\u0001\u000f\u0001C\u0001c\u00069\u0001O]3eS\u000e$HC\u0001:y!\r\u0019h\u000fK\u0007\u0002i*\u0011QOB\u0001\u0004e\u0012$\u0017BA<u\u0005\r\u0011F\t\u0012\u0005\u0006s>\u0004\rA]\u0001\ti\u0016\u001cH\u000fR1uC\")\u0001\u000f\u0001C\u0001wR\u0019A0a\u0002\u0011\u0007u\f\u0019!D\u0001\u007f\u0015\tIrPC\u0002\u0002\u0002\u0019\t1!\u00199j\u0013\r\t)A \u0002\u000e\u0015\u00064\u0018\rR8vE2,'\u000b\u0012#\t\u000beT\b\u0019\u0001?\t\rA\u0004A\u0011AA\u0006)\rA\u0013Q\u0002\u0005\u0007s\u0006%\u0001\u0019\u0001\u0015\t\u0011\u0005E\u0001\u0001\"\u0001\u0005\u0003'\taBY8v]\u0012\f'/\u001f,fGR|'/\u0006\u0002\u0002\u0016A!\u0011qCA\u000f\u001b\t\tIBC\u0002\u0002\u001c\u0011\ta\u0001\\5oC2<\u0017\u0002BA\u0010\u00033\u0011aAV3di>\u0014\b\u0002CA\u0012\u0001\u0011\u0005A!a\u0005\u0002!A\u0014X\rZ5di&|gNV3di>\u0014\bbBA\u0014\u0001\u0011\u0005\u0013\u0011F\u0001\u0005g\u00064X\rF\u0003^\u0003W\t9\u0004\u0003\u0005\u0002.\u0005\u0015\u0002\u0019AA\u0018\u0003\t\u00198\r\u0005\u0003\u00022\u0005MR\"\u0001\u0004\n\u0007\u0005UbA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000f\u0003\u0005\u0002:\u0005\u0015\u0002\u0019AA\u001e\u0003\u0011\u0001\u0018\r\u001e5\u0011\t\u0005u\u00121\t\b\u0004\u001f\u0005}\u0012bAA!!\u00051\u0001K]3eK\u001aLA!!\u0012\u0002H\t11\u000b\u001e:j]\u001eT1!!\u0011\u0011\u0011\u001d\tY\u0005\u0001C)\u0003\u001b\nQBZ8s[\u0006$h+\u001a:tS>tWCAA\u001eQ\r\u0001\u0011\u0011\u000b\t\u0005\u0003'\nI&\u0004\u0002\u0002V)\u0019\u0011q\u000b\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\\\u0005U#\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006dwaBA0\u0005!\u0005\u0011\u0011M\u0001\u0018\u0013N|Go\u001c8jGJ+wM]3tg&|g.T8eK2\u00042!PA2\r\u0019\t!\u0001#\u0001\u0002fM9\u00111\r\b\u0002h\u00055\u0004\u0003B\u000f\u0002jqJ1!a\u001b\u001f\u0005\u0019au.\u00193feB\u0019q\"a\u001c\n\u0005m\u0001\u0002b\u0002\u001e\u0002d\u0011\u0005\u00111\u000f\u000b\u0003\u0003C:\u0001\"a\u001e\u0002d!%\u0011\u0011P\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u0003w\ni(\u0004\u0002\u0002d\u0019A\u0011qPA2\u0011\u0013\t\tI\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0002~9AqAOA?\t\u0003\t)\t\u0006\u0002\u0002z!A\u0011\u0011RA?\t\u0003\ti%A\tuQ&\u001chi\u001c:nCR4VM]:j_:D\u0001\"!$\u0002~\u0011\u0005\u0011QJ\u0001\u000ei\"L7o\u00117bgNt\u0015-\\3\u0007\u000f\u0005E\u0015Q\u0010!\u0002\u0014\n!A)\u0019;b'\u001d\tyIDAK\u0003[\u00022aDAL\u0013\r\tI\n\u0005\u0002\b!J|G-^2u\u0011-\ti*a$\u0003\u0016\u0004%\t!a(\u0002\u0011\t|WO\u001c3bef,\u0012\u0001\u000b\u0005\u000b\u0003G\u000byI!E!\u0002\u0013A\u0013!\u00032pk:$\u0017M]=!\u0011-\t9+a$\u0003\u0016\u0004%\t!a(\u0002\u0015A\u0014X\rZ5di&|g\u000e\u0003\u0006\u0002,\u0006=%\u0011#Q\u0001\n!\n1\u0002\u001d:fI&\u001cG/[8oA!9!(a$\u0005\u0002\u0005=FCBAY\u0003k\u000b9\f\u0005\u0003\u00024\u0006=UBAA?\u0011\u001d\ti*!,A\u0002!Bq!a*\u0002.\u0002\u0007\u0001\u0006\u0003\u0006\u0002<\u0006=\u0015\u0011!C\u0001\u0003{\u000bAaY8qsR1\u0011\u0011WA`\u0003\u0003D\u0011\"!(\u0002:B\u0005\t\u0019\u0001\u0015\t\u0013\u0005\u001d\u0016\u0011\u0018I\u0001\u0002\u0004A\u0003BCAc\u0003\u001f\u000b\n\u0011\"\u0001\u0002H\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAeU\rA\u00131Z\u0016\u0003\u0003\u001b\u0004B!a4\u0002X6\u0011\u0011\u0011\u001b\u0006\u0005\u0003'\f).A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u000b\t\n\t\u0005e\u0017\u0011\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007BCAo\u0003\u001f\u000b\n\u0011\"\u0001\u0002H\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004BCAq\u0003\u001f\u000b\t\u0011\"\u0011\u0002d\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!:\u0011\u0007A\u000b9/C\u0002\u0002FEC!\"a;\u0002\u0010\u0006\u0005I\u0011AAw\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\u000fE\u0002\u0010\u0003cL1!a=\u0011\u0005\rIe\u000e\u001e\u0005\u000b\u0003o\fy)!A\u0005\u0002\u0005e\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003w\u0014\t\u0001E\u0002\u0010\u0003{L1!a@\u0011\u0005\r\te.\u001f\u0005\u000b\u0005\u0007\t)0!AA\u0002\u0005=\u0018a\u0001=%c!Q!qAAH\u0003\u0003%\tE!\u0003\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0003\u0011\r\t5!1CA~\u001b\t\u0011yAC\u0002\u0003\u0012A\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011)Ba\u0004\u0003\u0011%#XM]1u_JD!B!\u0007\u0002\u0010\u0006\u0005I\u0011\u0001B\u000e\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001\u001b\u0003\u001e!Q!1\u0001B\f\u0003\u0003\u0005\r!a?\t\u0015\t\u0005\u0012qRA\u0001\n\u0003\u0012\u0019#\u0001\u0005iCND7i\u001c3f)\t\ty\u000f\u0003\u0006\u0003(\u0005=\u0015\u0011!C!\u0005S\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003KD!B!\f\u0002\u0010\u0006\u0005I\u0011\tB\u0018\u0003\u0019)\u0017/^1mgR\u0019AG!\r\t\u0015\t\r!1FA\u0001\u0002\u0004\tYp\u0002\u0006\u00036\u0005u\u0014\u0011!E\u0001\u0005o\tA\u0001R1uCB!\u00111\u0017B\u001d\r)\t\t*! \u0002\u0002#\u0005!1H\n\u0007\u0005s\u0011i$!\u001c\u0011\u0011\t}\"Q\t\u0015)\u0003ck!A!\u0011\u000b\u0007\t\r\u0003#A\u0004sk:$\u0018.\\3\n\t\t\u001d#\u0011\t\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002\u001e\u0003:\u0011\u0005!1\n\u000b\u0003\u0005oA!Ba\n\u0003:\u0005\u0005IQ\tB\u0015\u0011)\u0011\tF!\u000f\u0002\u0002\u0013\u0005%1K\u0001\u0006CB\u0004H.\u001f\u000b\u0007\u0003c\u0013)Fa\u0016\t\u000f\u0005u%q\na\u0001Q!9\u0011q\u0015B(\u0001\u0004A\u0003B\u0003B.\u0005s\t\t\u0011\"!\u0003^\u00059QO\\1qa2LH\u0003\u0002B0\u0005W\u0002Ra\u0004B1\u0005KJ1Aa\u0019\u0011\u0005\u0019y\u0005\u000f^5p]B)qBa\u001a)Q%\u0019!\u0011\u000e\t\u0003\rQ+\b\u000f\\33\u0011)\u0011iG!\u0017\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0004q\u0012\u0002\u0004B\u0003B9\u0005s\t\t\u0011\"\u0003\u0003t\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011)\bE\u0002Q\u0005oJ1A!\u001fR\u0005\u0019y%M[3di\"A\u0011qEA?\t\u0003\u0011i\bF\u0006^\u0005\u007f\u0012\tIa!\u0003\u0006\n\u001d\u0005\u0002CA\u0017\u0005w\u0002\r!a\f\t\u0011\u0005e\"1\u0010a\u0001\u0003wAaa\tB>\u0001\u0004)\u0003B\u0002\u0018\u0003|\u0001\u0007Q\u0005\u0003\u00043\u0005w\u0002\r\u0001\u000e\u0005\t\u0005\u0017\u000bi\b\"\u0001\u0003\u000e\u0006!An\\1e)\u0019\u0011yI!%\u0003\u0014B)qBa\u001a&K!A\u0011Q\u0006BE\u0001\u0004\ty\u0003\u0003\u0005\u0002:\t%\u0005\u0019AA\u001e\u0011!\u0011Y)a\u0019\u0005B\t]E#\u0002\u001f\u0003\u001a\nm\u0005\u0002CA\u0017\u0005+\u0003\r!a\f\t\u0011\u0005e\"Q\u0013a\u0001\u0003wA!B!\u001d\u0002d\u0005\u0005I\u0011\u0002B:\u0001")
public class IsotonicRegressionModel
implements Serializable,
Saveable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public static IsotonicRegressionModel load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = new IntRef(1);
        int len = xs.length;
        while (i.elem < len) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0)new scala.Serializable(this, xs, i){
                public static final long serialVersionUID = 0L;
                private final double[] xs$1;
                private final IntRef i$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Elements (", ", ", ") are not ordered."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem - 1]), BoxesRunTime.boxToDouble((double)this.xs$1[this.i$1.elem])}));
                }
                {
                    this.xs$1 = xs$1;
                    this.i$1 = i$1;
                }
            });
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData) {
        return testData.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegressionModel $outer;

            public final double apply(double testData) {
                return this.apply$mcDD$sp(testData);
            }

            public double apply$mcDD$sp(double testData) {
                return this.$outer.predict(testData);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.predictions()).last()) : (foundIndex < 0 ? this.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    public Vector boundaryVector() {
        return Vectors$.MODULE$.dense(this.boundaries());
    }

    public Vector predictionVector() {
        return Vectors$.MODULE$.dense(this.predictions());
    }

    @Override
    public void save(SparkContext sc, String path) {
        IsotonicRegressionModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.boundaries(), this.predictions(), this.isotonic());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    private final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }

    public IsotonicRegressionModel(Iterable<Object> boundaries, Iterable<Object> predictions, Boolean isotonic) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(boundaries).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(predictions).asScala()).toArray(ClassTag$.MODULE$.Double()), Predef$.MODULE$.Boolean2boolean(isotonic));
    }
}

