/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impl;

import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.BaggedPoint$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;

public final class BaggedPoint$
implements Serializable {
    public static final BaggedPoint$ MODULE$;

    static {
        new BaggedPoint$();
    }

    public <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDD(RDD<Datum> input, double subsamplingRate, int numSubsamples, boolean withReplacement, int seed) {
        return withReplacement ? this.convertToBaggedRDDSamplingWithReplacement(input, subsamplingRate, numSubsamples, seed) : (numSubsamples == 1 && subsamplingRate == 1.0 ? this.convertToBaggedRDDWithoutSampling(input) : this.convertToBaggedRDDSamplingWithoutReplacement(input, subsamplingRate, numSubsamples, seed));
    }

    public <Datum> int convertToBaggedRDD$default$5() {
        return Utils$.MODULE$.random().nextInt();
    }

    private <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDDSamplingWithoutReplacement(RDD<Datum> input, double subsamplingRate, int numSubsamples, int seed) {
        return input.mapPartitionsWithIndex((Function2)new Serializable(subsamplingRate, numSubsamples, seed){
            public static final long serialVersionUID = 0L;
            public final double subsamplingRate$1;
            public final int numSubsamples$2;
            private final int seed$2;

            public final Iterator<BaggedPoint<Datum>> apply(int partitionIndex, Iterator<Datum> instances) {
                XORShiftRandom rng = new XORShiftRandom();
                rng.setSeed((long)(this.seed$2 + partitionIndex + 1));
                return instances.map((Function1)new Serializable(this, rng){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.convertToBaggedRDDSamplingWithoutReplacement.1 $outer;
                    private final XORShiftRandom rng$1;

                    public final BaggedPoint<Datum> apply(Datum instance) {
                        double[] subsampleWeights = new double[this.$outer.numSubsamples$2];
                        for (int subsampleIndex = 0; subsampleIndex < this.$outer.numSubsamples$2; ++subsampleIndex) {
                            double x = this.rng$1.nextDouble();
                            subsampleWeights[subsampleIndex] = x < this.$outer.subsamplingRate$1 ? 1.0 : 0.0;
                        }
                        return new BaggedPoint<Datum>(instance, subsampleWeights);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rng$1 = rng$1;
                    }
                });
            }
            {
                this.subsamplingRate$1 = subsamplingRate$1;
                this.numSubsamples$2 = numSubsamples$2;
                this.seed$2 = seed$2;
            }
        }, input.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(BaggedPoint.class));
    }

    private <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDDSamplingWithReplacement(RDD<Datum> input, double subsample, int numSubsamples, int seed) {
        return input.mapPartitionsWithIndex((Function2)new Serializable(subsample, numSubsamples, seed){
            public static final long serialVersionUID = 0L;
            private final double subsample$1;
            public final int numSubsamples$1;
            private final int seed$1;

            public final Iterator<BaggedPoint<Datum>> apply(int partitionIndex, Iterator<Datum> instances) {
                PoissonDistribution poisson = new PoissonDistribution(this.subsample$1);
                poisson.reseedRandomGenerator((long)(this.seed$1 + partitionIndex + 1));
                return instances.map((Function1)new Serializable(this, poisson){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.convertToBaggedRDDSamplingWithReplacement.1 $outer;
                    private final PoissonDistribution poisson$1;

                    public final BaggedPoint<Datum> apply(Datum instance) {
                        double[] subsampleWeights = new double[this.$outer.numSubsamples$1];
                        for (int subsampleIndex = 0; subsampleIndex < this.$outer.numSubsamples$1; ++subsampleIndex) {
                            subsampleWeights[subsampleIndex] = this.poisson$1.sample();
                        }
                        return new BaggedPoint<Datum>(instance, subsampleWeights);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.poisson$1 = poisson$1;
                    }
                });
            }
            {
                this.subsample$1 = subsample$1;
                this.numSubsamples$1 = numSubsamples$1;
                this.seed$1 = seed$1;
            }
        }, input.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(BaggedPoint.class));
    }

    private <Datum> RDD<BaggedPoint<Datum>> convertToBaggedRDDWithoutSampling(RDD<Datum> input) {
        return input.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BaggedPoint<Datum> apply(Datum datum) {
                return new BaggedPoint<Datum>(datum, new double[]{1.0});
            }
        }, ClassTag$.MODULE$.apply(BaggedPoint.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BaggedPoint$() {
        MODULE$ = this;
    }
}

