/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.impurity;

import scala.Double$;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113a!\u0001\u0002\u0002\u0002\u0011q!AE%naV\u0014\u0018\u000e^=DC2\u001cW\u000f\\1u_JT!a\u0001\u0003\u0002\u0011%l\u0007/\u001e:jifT!!\u0002\u0004\u0002\tQ\u0014X-\u001a\u0006\u0003\u000f!\tQ!\u001c7mS\nT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\n\u0003\u0001=\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007\u0002\u0003\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\u000bM$\u0018\r^:\u0004\u0001U\t\u0011\u0004E\u0002\u00115qI!aG\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005Ai\u0012B\u0001\u0010\u0012\u0005\u0019!u.\u001e2mK\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011$\u0001\u0004ti\u0006$8\u000f\t\u0005\u0006E\u0001!\taI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u00112\u0003CA\u0013\u0001\u001b\u0005\u0011\u0001\"\u0002\f\"\u0001\u0004I\u0002\"\u0002\u0015\u0001\r\u0003I\u0013\u0001B2paf,\u0012\u0001\n\u0005\u0006W\u00011\t\u0001L\u0001\nG\u0006d7-\u001e7bi\u0016$\u0012\u0001\b\u0005\u0006]\u0001!\taL\u0001\u0004C\u0012$GC\u0001\u00131\u0011\u0015\tT\u00061\u0001%\u0003\u0015yG\u000f[3s\u0011\u0015\u0019\u0004\u0001\"\u00015\u0003!\u0019XO\u0019;sC\u000e$HC\u0001\u00136\u0011\u0015\t$\u00071\u0001%\u0011\u00159\u0004A\"\u00019\u0003\u0015\u0019w.\u001e8u+\u0005I\u0004C\u0001\t;\u0013\tY\u0014C\u0001\u0003M_:<\u0007\"B\u001f\u0001\r\u0003q\u0014a\u00029sK\u0012L7\r^\u000b\u00029!)\u0001\t\u0001C\u0001\u0003\u0006!\u0001O]8c)\ta\"\tC\u0003D\u007f\u0001\u0007A$A\u0003mC\n,G\u000eC\u0003F\u0001\u0011Ea)\u0001\u000ej]\u0012,\u0007p\u00144MCJ<Wm\u001d;BeJ\f\u00170\u00127f[\u0016tG\u000f\u0006\u0002H\u0015B\u0011\u0001\u0003S\u0005\u0003\u0013F\u00111!\u00138u\u0011\u0015YE\t1\u0001\u001a\u0003\u0015\t'O]1z\u0001")
public abstract class ImpurityCalculator {
    private final double[] stats;

    public double[] stats() {
        return this.stats;
    }

    public abstract ImpurityCalculator copy();

    public abstract double calculate();

    public ImpurityCalculator add(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ImpurityCalculator $outer;
            private final ImpurityCalculator other$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Two ImpurityCalculator instances cannot be added with different counts sizes."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Sizes are ", " and ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stats().length), BoxesRunTime.boxToInteger((int)this.other$1.stats().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] + other.stats()[i];
        }
        return this;
    }

    public ImpurityCalculator subtract(ImpurityCalculator other) {
        Predef$.MODULE$.require(this.stats().length == other.stats().length, (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ImpurityCalculator $outer;
            private final ImpurityCalculator other$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Two ImpurityCalculator instances cannot be subtracted with different counts sizes."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Sizes are ", " and ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.stats().length), BoxesRunTime.boxToInteger((int)this.other$2.stats().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$2 = other$2;
            }
        });
        int len = other.stats().length;
        for (int i = 0; i < len; ++i) {
            int n = i;
            this.stats()[n] = this.stats()[n] - other.stats()[i];
        }
        return this;
    }

    public abstract long count();

    public abstract double predict();

    public double prob(double label) {
        return -1.0;
    }

    public int indexOfLargestArrayElement(double[] array) {
        Tuple3 result = (Tuple3)Predef$.MODULE$.doubleArrayOps(array).foldLeft((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToDouble((double)Double$.MODULE$.MinValue()), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x0$1, double x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$1, (Object)BoxesRunTime.boxToDouble((double)x1$1));
                if (tuple2 != null) {
                    Tuple3 tuple3 = (Tuple3)tuple2._1();
                    double currentValue = tuple2._2$mcD$sp();
                    if (tuple3 != null) {
                        int maxIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                        double maxValue = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                        int currentIndex = BoxesRunTime.unboxToInt((Object)tuple3._3());
                        Tuple3 tuple32 = currentValue > maxValue ? new Tuple3((Object)BoxesRunTime.boxToInteger((int)currentIndex), (Object)BoxesRunTime.boxToDouble((double)currentValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1))) : new Tuple3((Object)BoxesRunTime.boxToInteger((int)maxIndex), (Object)BoxesRunTime.boxToDouble((double)maxValue), (Object)BoxesRunTime.boxToInteger((int)(currentIndex + 1)));
                        return tuple32;
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        });
        if (BoxesRunTime.unboxToInt((Object)result._1()) < 0) {
            throw new RuntimeException("ImpurityCalculator internal error: indexOfLargestArrayElement failed");
        }
        return BoxesRunTime.unboxToInt((Object)result._1());
    }

    public ImpurityCalculator(double[] stats) {
        this.stats = stats;
    }
}

