/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.regression.LeastSquaresCostFun;
import org.apache.spark.ml.regression.LinearRegression$;
import org.apache.spark.ml.regression.LinearRegressionModel;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.StatCounter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u001b\t\u0001B*\u001b8fCJ\u0014Vm\u001a:fgNLwN\u001c\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa$\t\t\u0006\u001fA\u0011\"dG\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\n%\u0016<'/Z:t_J\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\r1Lg.\u00197h\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t1a+Z2u_J\u0004\"a\u0004\u0001\u0011\u0005=a\u0012BA\u000f\u0003\u0005Ua\u0015N\\3beJ+wM]3tg&|g.T8eK2\u0004\"aD\u0010\n\u0005\u0001\u0012!A\u0006'j]\u0016\f'OU3he\u0016\u001c8/[8o!\u0006\u0014\u0018-\\:\u0011\u0005\t\u001aS\"\u0001\u0004\n\u0005\u00112!a\u0002'pO\u001eLgn\u001a\u0005\tM\u0001\u0011)\u0019!C!O\u0005\u0019Q/\u001b3\u0016\u0003!\u0002\"!K\u0018\u000f\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0005k&$\u0007\u0005C\u00036\u0001\u0011\u0005a'\u0001\u0004=S:LGO\u0010\u000b\u00035]BQA\n\u001bA\u0002!BQ!\u000e\u0001\u0005\u0002e\"\u0012A\u0007\u0005\u0006w\u0001!\t\u0001P\u0001\fg\u0016$(+Z4QCJ\fW\u000e\u0006\u0002>}5\t\u0001\u0001C\u0003@u\u0001\u0007\u0001)A\u0003wC2,X\r\u0005\u0002+\u0003&\u0011!i\u000b\u0002\u0007\t>,(\r\\3\t\u000b\u0011\u0003A\u0011A#\u0002\u001fM,GOR5u\u0013:$XM]2faR$\"!\u0010$\t\u000b}\u001a\u0005\u0019A$\u0011\u0005)B\u0015BA%,\u0005\u001d\u0011un\u001c7fC:DQa\u0013\u0001\u0005\u00021\u000b!c]3u'R\fg\u000eZ1sI&T\u0018\r^5p]R\u0011Q(\u0014\u0005\u0006\u007f)\u0003\ra\u0012\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u0013g\u0016$X\t\\1ti&\u001cg*\u001a;QCJ\fW\u000e\u0006\u0002>#\")qH\u0014a\u0001\u0001\")1\u000b\u0001C\u0001)\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005u*\u0006\"B S\u0001\u00041\u0006C\u0001\u0016X\u0013\tA6FA\u0002J]RDQA\u0017\u0001\u0005\u0002m\u000baa]3u)>dGCA\u001f]\u0011\u0015y\u0014\f1\u0001A\u0011\u0015q\u0006\u0001\"\u0015`\u0003\u0015!(/Y5o)\tY\u0002\rC\u0003b;\u0002\u0007!-A\u0004eCR\f7/\u001a;\u0011\u0005\r4W\"\u00013\u000b\u0005\u00154\u0011aA:rY&\u0011q\r\u001a\u0002\n\t\u0006$\u0018M\u0012:b[\u0016DQ!\u001b\u0001\u0005B)\fAaY8qsR\u0011!d\u001b\u0005\u0006Y\"\u0004\r!\\\u0001\u0006Kb$(/\u0019\t\u0003]Fl\u0011a\u001c\u0006\u0003a\u0012\tQ\u0001]1sC6L!A]8\u0003\u0011A\u000b'/Y7NCBD#\u0001\u0001;\u0011\u0005UDX\"\u0001<\u000b\u0005]4\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011P\u001e\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class LinearRegression
extends Regressor<Vector, LinearRegression, LinearRegressionModel>
implements LinearRegressionParams,
Logging {
    private final String uid;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearRegression setRegParam(double value) {
        return (LinearRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setFitIntercept(boolean value) {
        return (LinearRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setStandardization(boolean value) {
        return (LinearRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearRegression setElasticNetParam(double value) {
        return (LinearRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearRegression setMaxIter(int value) {
        return (LinearRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearRegression setTol(double value) {
        return (LinearRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public LinearRegressionModel train(DataFrame dataset) {
        RDD instances = this.extractLabeledPoints(dataset).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint x0$1) {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector features = labeledPoint.features();
                    double d = label;
                    if (features != null) {
                        Vector vector = features;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                        return tuple2;
                    }
                }
                throw new MatchError((Object)labeledPoint);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Tuple2 x$4 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new StatCounter());
        Serializable x$5 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, StatCounter> apply(Tuple2<MultivariateOnlineSummarizer, StatCounter> c, Tuple2<Object, Vector> v) {
                Tuple2 tuple2 = new Tuple2(c, v);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple22._1();
                        StatCounter statCounter = (StatCounter)tuple22._2();
                        if (summarizer != null) {
                            MultivariateOnlineSummarizer multivariateOnlineSummarizer = summarizer;
                            if (statCounter != null) {
                                StatCounter statCounter2 = statCounter;
                                if (tuple23 != null) {
                                    double label = tuple23._1$mcD$sp();
                                    Vector features = (Vector)tuple23._2();
                                    double d = label;
                                    if (features != null) {
                                        Vector vector = features;
                                        Tuple2 tuple24 = new Tuple2((Object)multivariateOnlineSummarizer.add(vector), (Object)statCounter2.merge(d));
                                        return tuple24;
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        };
        Serializable x$6 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, StatCounter> apply(Tuple2<MultivariateOnlineSummarizer, StatCounter> c1, Tuple2<MultivariateOnlineSummarizer, StatCounter> c2) {
                Tuple2 tuple2 = new Tuple2(c1, c2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        MultivariateOnlineSummarizer summarizer1 = (MultivariateOnlineSummarizer)tuple22._1();
                        StatCounter statCounter1 = (StatCounter)tuple22._2();
                        if (summarizer1 != null) {
                            MultivariateOnlineSummarizer multivariateOnlineSummarizer = summarizer1;
                            if (statCounter1 != null) {
                                StatCounter statCounter = statCounter1;
                                if (tuple23 != null) {
                                    MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
                                    StatCounter statCounter2 = (StatCounter)tuple23._2();
                                    if (summarizer2 != null) {
                                        MultivariateOnlineSummarizer multivariateOnlineSummarizer2 = summarizer2;
                                        if (statCounter2 != null) {
                                            StatCounter statCounter3 = statCounter2;
                                            Tuple2 tuple24 = new Tuple2((Object)multivariateOnlineSummarizer.merge(multivariateOnlineSummarizer2), (Object)statCounter.merge(statCounter3));
                                            return tuple24;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        };
        int x$7 = instances.treeAggregate$default$4((Object)x$4);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$4, (Function2)x$5, (Function2)x$6, x$7, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple2 tuple22;
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            StatCounter statCounter = (StatCounter)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summarizer, (Object)statCounter);
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            StatCounter statCounter2 = (StatCounter)tuple23._2();
            int numFeatures = summarizer2.mean().size();
            double yMean = statCounter2.mean();
            double yStd = package$.MODULE$.sqrt(statCounter2.variance());
            if (yStd == 0.0) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the weights will be zeros "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"and the intercept will be the mean of the label; as a result, training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                });
                Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                Vector weights2 = Vectors$.MODULE$.sparse(numFeatures, (Seq<Tuple2<Object, Object>>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                double intercept2 = yMean;
                LinearRegressionModel model = new LinearRegressionModel(this.uid(), weights2, intercept2);
                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.labelCol()), this.$(this.featuresCol()), new double[]{0.0});
                return this.copyValues(model.setSummary(trainingSummary), this.copyValues$default$2());
            }
            double[] featuresMean = summarizer2.mean().toArray();
            double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.sqrt(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double effectiveRegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) / yStd;
            double effectiveL1RegParam = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * effectiveRegParam;
            double effectiveL2RegParam = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * effectiveRegParam;
            LeastSquaresCostFun costFun = new LeastSquaresCostFun((RDD<Tuple2<Object, Vector>>)instances, yStd, yMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), featuresStd, featuresMean, effectiveL2RegParam);
            LBFGS optimizer = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || effectiveRegParam == 0.0 ? new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double())) : new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.effectiveL1RegFun$1(featuresStd, effectiveL1RegParam), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            Vector initialWeights = Vectors$.MODULE$.zeros(numFeatures);
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialWeights.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            if (state == null) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                this.logError((Function0<String>)new $anonfun$7(this, msg));
                throw new SparkException(msg);
            }
            double[] rawWeights = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            int len = rawWeights.length;
            for (int i = 0; i < len; ++i) {
                int n = i;
                rawWeights[n] = rawWeights[n] * (featuresStd[i] != 0.0 ? yStd / featuresStd[i] : 0.0);
            }
            Tuple2 tuple24 = new Tuple2((Object)Vectors$.MODULE$.dense(rawWeights).compressed(), arrayBuilder.result());
            if (tuple24 != null) {
                Tuple2 tuple25;
                Vector weights3 = (Vector)tuple24._1();
                double[] objectiveHistory = (double[])tuple24._2();
                Tuple2 tuple26 = tuple25 = new Tuple2((Object)weights3, (Object)objectiveHistory);
                Vector weights4 = (Vector)tuple26._1();
                double[] objectiveHistory2 = (double[])tuple26._2();
                double intercept3 = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? yMean - BLAS$.MODULE$.dot(weights4, Vectors$.MODULE$.dense(featuresMean)) : 0.0;
                Object object3 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LinearRegressionModel model = this.copyValues(new LinearRegressionModel(this.uid(), weights4, intercept3), this.copyValues$default$2());
                LinearRegressionTrainingSummary trainingSummary = new LinearRegressionTrainingSummary(model.transform(dataset), this.$(this.predictionCol()), this.$(this.labelCol()), this.$(this.featuresCol()), objectiveHistory2);
                return model.setSummary(trainingSummary);
            }
            throw new MatchError((Object)tuple24);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LinearRegression copy(ParamMap extra) {
        return (LinearRegression)this.defaultCopy(extra);
    }

    private final Function1 effectiveL1RegFun$1(double[] featuresStd$1, double effectiveL1RegParam$1) {
        return new Serializable(this, featuresStd$1, effectiveL1RegParam$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LinearRegression $outer;
            private final double[] featuresStd$1;
            private final double effectiveL1RegParam$1;

            public final double apply(int index) {
                return this.apply$mcDI$sp(index);
            }

            public double apply$mcDI$sp(int index) {
                return BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization())) ? this.effectiveL1RegParam$1 : (this.featuresStd$1[index] != 0.0 ? this.effectiveL1RegParam$1 / this.featuresStd$1[index] : 0.0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.featuresStd$1 = featuresStd$1;
                this.effectiveL1RegParam$1 = effectiveL1RegParam$1;
            }
        };
    }

    public LinearRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
    }

    public LinearRegression() {
        this(Identifiable$.MODULE$.randomUID("linReg"));
    }
}

