/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.RandomForestParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\u0001\u0003\u00055\u0011QCU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgN|'O\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019yR\u0005E\u0003\u0010!IQB$D\u0001\u0005\u0013\t\tBAA\u0005Qe\u0016$\u0017n\u0019;peB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007Y&t\u0017\r\\4\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005\u00191Vm\u0019;peB\u00111\u0004A\u0007\u0002\u0005A\u00111$H\u0005\u0003=\t\u00111DU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\u0011!(/Z3\n\u0005\u0011\n#A\u0005*b]\u0012|WNR8sKN$\b+\u0019:b[N\u0004\"\u0001\t\u0014\n\u0005\u001d\n#a\u0005+sK\u0016\u0014Vm\u001a:fgN|'\u000fU1sC6\u001c\b\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\t\u0016\u0002\u0007ULG-F\u0001,!\ta#G\u0004\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\td&\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019/\u0011!1\u0004A!A!\u0002\u0013Y\u0013\u0001B;jI\u0002BQ\u0001\u000f\u0001\u0005\u0002e\na\u0001P5oSRtDC\u0001\u000e;\u0011\u0015Is\u00071\u0001,\u0011\u0015A\u0004\u0001\"\u0001=)\u0005Q\u0002\"\u0002 \u0001\t\u0003z\u0014aC:fi6\u000b\u0007\u0010R3qi\"$\"\u0001Q!\u000e\u0003\u0001AQAQ\u001fA\u0002\r\u000bQA^1mk\u0016\u0004\"!\f#\n\u0005\u0015s#aA%oi\")q\t\u0001C!\u0011\u0006Q1/\u001a;NCb\u0014\u0015N\\:\u0015\u0005\u0001K\u0005\"\u0002\"G\u0001\u0004\u0019\u0005\"B&\u0001\t\u0003b\u0015AF:fi6Kg.\u00138ti\u0006t7-Z:QKJtu\u000eZ3\u0015\u0005\u0001k\u0005\"\u0002\"K\u0001\u0004\u0019\u0005\"B(\u0001\t\u0003\u0002\u0016AD:fi6Kg.\u00138g_\u001e\u000b\u0017N\u001c\u000b\u0003\u0001FCQA\u0011(A\u0002I\u0003\"!L*\n\u0005Qs#A\u0002#pk\ndW\rC\u0003W\u0001\u0011\u0005s+\u0001\ttKRl\u0015\r_'f[>\u0014\u00180\u00138N\u0005R\u0011\u0001\t\u0017\u0005\u0006\u0005V\u0003\ra\u0011\u0005\u00065\u0002!\teW\u0001\u0010g\u0016$8)Y2iK:{G-Z%egR\u0011\u0001\t\u0018\u0005\u0006\u0005f\u0003\r!\u0018\t\u0003[yK!a\u0018\u0018\u0003\u000f\t{w\u000e\\3b]\")\u0011\r\u0001C!E\u0006)2/\u001a;DQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dGC\u0001!d\u0011\u0015\u0011\u0005\r1\u0001D\u0011\u0015)\u0007\u0001\"\u0011g\u0003-\u0019X\r^%naV\u0014\u0018\u000e^=\u0015\u0005\u0001;\u0007\"\u0002\"e\u0001\u0004Y\u0003\"B5\u0001\t\u0003R\u0017AE:fiN+(m]1na2Lgn\u001a*bi\u0016$\"\u0001Q6\t\u000b\tC\u0007\u0019\u0001*\t\u000b5\u0004A\u0011\t8\u0002\u000fM,GoU3fIR\u0011\u0001i\u001c\u0005\u0006\u00052\u0004\r\u0001\u001d\t\u0003[EL!A\u001d\u0018\u0003\t1{gn\u001a\u0005\u0006i\u0002!\t%^\u0001\fg\u0016$h*^7Ue\u0016,7\u000f\u0006\u0002Am\")!i\u001da\u0001\u0007\")\u0001\u0010\u0001C!s\u0006A2/\u001a;GK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ=\u0015\u0005\u0001S\b\"\u0002\"x\u0001\u0004Y\u0003\"\u0002?\u0001\t#j\u0018!\u0002;sC&tGC\u0001\u000f\u007f\u0011\u0019y8\u00101\u0001\u0002\u0002\u00059A-\u0019;bg\u0016$\b\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da!A\u0002tc2LA!a\u0003\u0002\u0006\tIA)\u0019;b\rJ\fW.\u001a\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0003\u0011\u0019w\u000e]=\u0015\u0007i\t\u0019\u0002\u0003\u0005\u0002\u0016\u00055\u0001\u0019AA\f\u0003\u0015)\u0007\u0010\u001e:b!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\t\u0005)\u0001/\u0019:b[&!\u0011\u0011EA\u000e\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001\u0001\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\u000b\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005M\"\u0001#\u0001\u00026\u0005)\"+\u00198e_64uN]3tiJ+wM]3tg>\u0014\bcA\u000e\u00028\u00191\u0011A\u0001E\u0001\u0003s\u0019b!a\u000e\u0002<\u0005\u0005\u0003cA\u0017\u0002>%\u0019\u0011q\b\u0018\u0003\r\u0005s\u0017PU3g!\ri\u00131I\u0005\u0004\u0003\u000br#\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\u001d\u00028\u0011\u0005\u0011\u0011\n\u000b\u0003\u0003kA!\"!\u0014\u00028\t\u0007IQAA(\u0003M\u0019X\u000f\u001d9peR,G-S7qkJLG/[3t+\t\t\t\u0006\u0005\u0003.\u0003'Z\u0013bAA+]\t)\u0011I\u001d:bs\"I\u0011\u0011LA\u001cA\u00035\u0011\u0011K\u0001\u0015gV\u0004\bo\u001c:uK\u0012LU\u000e];sSRLWm\u001d\u0011\t\u0015\u0005u\u0013q\u0007b\u0001\n\u000b\ty%\u0001\u0011tkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKN+(m]3u'R\u0014\u0018\r^3hS\u0016\u001c\b\"CA1\u0003o\u0001\u000bQBA)\u0003\u0005\u001aX\u000f\u001d9peR,GMR3biV\u0014XmU;cg\u0016$8\u000b\u001e:bi\u0016<\u0017.Z:!\u0011)\t)'a\u000e\u0002\u0002\u0013%\u0011qM\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001\u00027b]\u001eT!!a\u001d\u0002\t)\fg/Y\u0005\u0005\u0003o\niG\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003o\t)\u0003\u000b\u0003\u00022\u0005\u0015\u0002")
public final class RandomForestRegressor
extends Predictor<Vector, RandomForestRegressor, RandomForestRegressionModel>
implements RandomForestParams,
TreeRegressorParams {
    private final String uid;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final Param<String> featureSubsetStrategy;
    private final DoubleParam subsamplingRate;
    private final LongParam seed;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final IntParam checkpointInterval;

    public static String[] supportedFeatureSubsetStrategies() {
        return RandomForestRegressor$.MODULE$.supportedFeatureSubsetStrategies();
    }

    public static String[] supportedImpurities() {
        return RandomForestRegressor$.MODULE$.supportedImpurities();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams$class.getNumTrees(this);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return RandomForestParams$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    public Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return DecisionTreeParams$class.getCheckpointInterval(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public RandomForestRegressor setMaxDepth(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public RandomForestRegressor setMaxBins(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public RandomForestRegressor setMinInstancesPerNode(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public RandomForestRegressor setMinInfoGain(double value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public RandomForestRegressor setMaxMemoryInMB(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public RandomForestRegressor setCacheNodeIds(boolean value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public RandomForestRegressor setCheckpointInterval(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public RandomForestRegressor setImpurity(String value) {
        return (RandomForestRegressor)TreeRegressorParams$class.setImpurity(this, value);
    }

    @Override
    public RandomForestRegressor setSubsamplingRate(double value) {
        return (RandomForestRegressor)TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public RandomForestRegressor setSeed(long value) {
        return (RandomForestRegressor)TreeEnsembleParams$class.setSeed(this, value);
    }

    @Override
    public RandomForestRegressor setNumTrees(int value) {
        return (RandomForestRegressor)RandomForestParams$class.setNumTrees(this, value);
    }

    @Override
    public RandomForestRegressor setFeatureSubsetStrategy(String value) {
        return (RandomForestRegressor)RandomForestParams$class.setFeatureSubsetStrategy(this, value);
    }

    @Override
    public RandomForestRegressionModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        Strategy strategy = TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, 0, Algo$.MODULE$.Regression(), this.getOldImpurity());
        DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(oldDataset, strategy, this.getNumTrees(), this.getFeatureSubsetStrategy(), this.getSeed(), RandomForest$.MODULE$.run$default$6())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeRegressionModel apply(DecisionTreeModel x$1) {
                return (DecisionTreeRegressionModel)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
        int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
        return new RandomForestRegressionModel(trees, numFeatures);
    }

    @Override
    public RandomForestRegressor copy(ParamMap extra) {
        return (RandomForestRegressor)this.defaultCopy(extra);
    }

    public RandomForestRegressor(String uid) {
        this.uid = uid;
        DecisionTreeParams$class.$init$(this);
        HasSeed$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        RandomForestParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
    }

    public RandomForestRegressor() {
        this(Identifiable$.MODULE$.randomUID("rfr"));
    }
}

