/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.normalize$;
import breeze.storage.Zero;
import java.util.Random;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.impl.GraphImpl;
import org.apache.spark.graphx.impl.GraphImpl$;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$;
import org.apache.spark.mllib.clustering.EMLDAOptimizer$;
import org.apache.spark.mllib.clustering.EMLDAOptimizer$$anonfun$3$;
import org.apache.spark.mllib.clustering.LDA;
import org.apache.spark.mllib.clustering.LDA$;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.impl.PeriodicGraphCheckpointer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u00055\u0011a\"R'M\t\u0006{\u0005\u000f^5nSj,'O\u0003\u0002\u0004\t\u0005Q1\r\\;ti\u0016\u0014\u0018N\\4\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0007M\t\u0006{\u0005\u000f^5nSj,'\u000fC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011Q\u0003\u0001\u0005\t;\u0001\u0001\r\u0011\"\u0001\u0003=\u0005)qM]1qQV\tq\u0004\u0005\u0003!G\u0015bS\"A\u0011\u000b\u0005\t2\u0011AB4sCBD\u00070\u0003\u0002%C\t)qI]1qQB\u0011a%\u000b\b\u0003+\u001dJ!\u0001\u000b\u0002\u0002\u00071#\u0015)\u0003\u0002+W\tYAk\u001c9jG\u000e{WO\u001c;t\u0015\tA#\u0001\u0005\u0002'[%\u0011af\u000b\u0002\u000b)>\\WM\\\"pk:$\b\u0002\u0003\u0019\u0001\u0001\u0004%\tAA\u0019\u0002\u0013\u001d\u0014\u0018\r\u001d5`I\u0015\fHC\u0001\u001a6!\ty1'\u0003\u00025!\t!QK\\5u\u0011\u001d1t&!AA\u0002}\t1\u0001\u001f\u00132\u0011\u0019A\u0004\u0001)Q\u0005?\u00051qM]1qQ\u0002B\u0001B\u000f\u0001A\u0002\u0013\u0005!aO\u0001\u0002WV\tA\b\u0005\u0002\u0010{%\u0011a\b\u0005\u0002\u0004\u0013:$\b\u0002\u0003!\u0001\u0001\u0004%\tAA!\u0002\u000b-|F%Z9\u0015\u0005I\u0012\u0005b\u0002\u001c@\u0003\u0003\u0005\r\u0001\u0010\u0005\u0007\t\u0002\u0001\u000b\u0015\u0002\u001f\u0002\u0005-\u0004\u0003\u0002\u0003$\u0001\u0001\u0004%\tAA\u001e\u0002\u0013Y|7-\u00192TSj,\u0007\u0002\u0003%\u0001\u0001\u0004%\tAA%\u0002\u001bY|7-\u00192TSj,w\fJ3r)\t\u0011$\nC\u00047\u000f\u0006\u0005\t\u0019\u0001\u001f\t\r1\u0003\u0001\u0015)\u0003=\u0003)1xnY1c'&TX\r\t\u0005\t\u001d\u0002\u0001\r\u0011\"\u0001\u0003\u001f\u0006\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002!B\u0011q\"U\u0005\u0003%B\u0011a\u0001R8vE2,\u0007\u0002\u0003+\u0001\u0001\u0004%\tAA+\u0002)\u0011|7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t\u0011d\u000bC\u00047'\u0006\u0005\t\u0019\u0001)\t\ra\u0003\u0001\u0015)\u0003Q\u0003E!wnY\"p]\u000e,g\u000e\u001e:bi&|g\u000e\t\u0005\t5\u0002\u0001\r\u0011\"\u0001\u0003\u001f\u0006\u0011Bo\u001c9jG\u000e{gnY3oiJ\fG/[8o\u0011!a\u0006\u00011A\u0005\u0002\ti\u0016A\u0006;pa&\u001c7i\u001c8dK:$(/\u0019;j_:|F%Z9\u0015\u0005Ir\u0006b\u0002\u001c\\\u0003\u0003\u0005\r\u0001\u0015\u0005\u0007A\u0002\u0001\u000b\u0015\u0002)\u0002'Q|\u0007/[2D_:\u001cWM\u001c;sCRLwN\u001c\u0011\t\u0011\t\u0004\u0001\u0019!C\u0001\u0005m\n!c\u00195fG.\u0004x.\u001b8u\u0013:$XM\u001d<bY\"AA\r\u0001a\u0001\n\u0003\u0011Q-\u0001\fdQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006dw\fJ3r)\t\u0011d\rC\u00047G\u0006\u0005\t\u0019\u0001\u001f\t\r!\u0004\u0001\u0015)\u0003=\u0003M\u0019\u0007.Z2la>Lg\u000e^%oi\u0016\u0014h/\u00197!\u0011\u001dQ\u0007\u00011A\u0005\n-\f\u0011c\u001a:ba\"\u001c\u0005.Z2la>Lg\u000e^3s+\u0005a\u0007\u0003B7qK1j\u0011A\u001c\u0006\u0003_\u0012\tA![7qY&\u0011\u0011O\u001c\u0002\u001a!\u0016\u0014\u0018n\u001c3jG\u001e\u0013\u0018\r\u001d5DQ\u0016\u001c7\u000e]8j]R,'\u000fC\u0004t\u0001\u0001\u0007I\u0011\u0002;\u0002+\u001d\u0014\u0018\r\u001d5DQ\u0016\u001c7\u000e]8j]R,'o\u0018\u0013fcR\u0011!'\u001e\u0005\bmI\f\t\u00111\u0001m\u0011\u00199\b\u0001)Q\u0005Y\u0006\u0011rM]1qQ\u000eCWmY6q_&tG/\u001a:!\u0011\u0019I\b\u0001\"\u0011\u0003u\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\tQY\u0018q\u0004\u0005\u0006yb\u0004\r!`\u0001\u0005I>\u001c7\u000fE\u0003\u007f\u0003\u0007\t9!D\u0001\u0000\u0015\r\t\tAB\u0001\u0004e\u0012$\u0017bAA\u0003\u007f\n\u0019!\u000b\u0012#\u0011\u000f=\tI!!\u0004\u0002\u0014%\u0019\u00111\u0002\t\u0003\rQ+\b\u000f\\33!\ry\u0011qB\u0005\u0004\u0003#\u0001\"\u0001\u0002'p]\u001e\u0004B!!\u0006\u0002\u001c5\u0011\u0011q\u0003\u0006\u0004\u00033!\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002\u001e\u0005]!A\u0002,fGR|'\u000fC\u0004\u0002\"a\u0004\r!a\t\u0002\u00071$\u0017\rE\u0002\u0016\u0003KI1!a\n\u0003\u0005\raE)\u0011\u0005\b\u0003W\u0001A\u0011\t\u0002\u001b\u0003\u0011qW\r\u001f;\t\u0015\u0005=\u0002\u00011A\u0005\u0002\t\t\t$A\thY>\u0014\u0017\r\u001c+pa&\u001cGk\u001c;bYN,\u0012!\n\u0005\u000b\u0003k\u0001\u0001\u0019!C\u0001\u0005\u0005]\u0012!F4m_\n\fG\u000eV8qS\u000e$v\u000e^1mg~#S-\u001d\u000b\u0004e\u0005e\u0002\u0002\u0003\u001c\u00024\u0005\u0005\t\u0019A\u0013\t\u000f\u0005u\u0002\u0001)Q\u0005K\u0005\u0011r\r\\8cC2$v\u000e]5d)>$\u0018\r\\:!\u0011\u001d\t\t\u0005\u0001C\u0005\u0003\u0007\n\u0001dY8naV$Xm\u00127pE\u0006dGk\u001c9jGR{G/\u00197t)\u0005)\u0003\u0002CA$\u0001\u0011\u0005#!!\u0013\u0002\u0017\u001d,G\u000f\u0014#B\u001b>$W\r\u001c\u000b\u0005\u0003\u0017\n\t\u0006E\u0002\u0016\u0003\u001bJ1!a\u0014\u0003\u0005!aE)Q'pI\u0016d\u0007\u0002CA*\u0003\u000b\u0002\r!!\u0016\u0002\u001d%$XM]1uS>tG+[7fgB!q\"a\u0016Q\u0013\r\tI\u0006\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004\u0001\u0005u\u0003\u0003BA0\u0003Kj!!!\u0019\u000b\u0007\u0005\rd!\u0001\u0006b]:|G/\u0019;j_:LA!a\u001a\u0002b\taA)\u001a<fY>\u0004XM]!qS\"*\u0001!a\u001b\u0002rA!\u0011qLA7\u0013\u0011\ty'!\u0019\u0003\u000bMKgnY3\"\u0005\u0005M\u0014!B\u0019/i9\u0002\u0004")
public final class EMLDAOptimizer
implements LDAOptimizer {
    private Graph<DenseVector<Object>, Object> graph = null;
    private int k = 0;
    private int vocabSize = 0;
    private double docConcentration = 0.0;
    private double topicConcentration = 0.0;
    private int checkpointInterval = 10;
    private PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer = null;
    private DenseVector<Object> globalTopicTotals = null;

    public Graph<DenseVector<Object>, Object> graph() {
        return this.graph;
    }

    public void graph_$eq(Graph<DenseVector<Object>, Object> x$1) {
        this.graph = x$1;
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public void vocabSize_$eq(int x$1) {
        this.vocabSize = x$1;
    }

    public double docConcentration() {
        return this.docConcentration;
    }

    public void docConcentration_$eq(double x$1) {
        this.docConcentration = x$1;
    }

    public double topicConcentration() {
        return this.topicConcentration;
    }

    public void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    public void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private PeriodicGraphCheckpointer<DenseVector<Object>, Object> graphCheckpointer() {
        return this.graphCheckpointer;
    }

    private void graphCheckpointer_$eq(PeriodicGraphCheckpointer<DenseVector<Object>, Object> x$1) {
        this.graphCheckpointer = x$1;
    }

    @Override
    public LDAOptimizer initialize(RDD<Tuple2<Object, Vector>> docs, LDA lda) {
        double docConcentration = lda.getDocConcentration();
        double topicConcentration = lda.getTopicConcentration();
        int k = lda.getK();
        Predef$.MODULE$.require(docConcentration > 1.0 || docConcentration == -1.0, (Function0)new Serializable(this, docConcentration){
            public static final long serialVersionUID = 0L;
            private final double docConcentration$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA docConcentration must be"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" > 1.0 (or -1 for auto) for EM Optimizer, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.docConcentration$1)}))).toString();
            }
            {
                this.docConcentration$1 = docConcentration$1;
            }
        });
        Predef$.MODULE$.require(topicConcentration > 1.0 || topicConcentration == -1.0, (Function0)new Serializable(this, topicConcentration){
            public static final long serialVersionUID = 0L;
            private final double topicConcentration$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA topicConcentration "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"must be > 1.0 (or -1 for auto) for EM Optimizer, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.topicConcentration$1)}))).toString();
            }
            {
                this.topicConcentration$1 = topicConcentration$1;
            }
        });
        this.docConcentration_$eq(docConcentration == (double)-1 ? 50.0 / (double)k + 1.0 : docConcentration);
        this.topicConcentration_$eq(topicConcentration == (double)-1 ? 1.1 : topicConcentration);
        long randomSeed = lda.getSeed();
        RDD edges = docs.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TraversableOnce<Edge<Object>> apply(Tuple2<Object, Vector> x0$1) {
                Tuple2<Object, Vector> tuple2 = x0$1;
                if (tuple2 != null) {
                    long docID = tuple2._1$mcJ$sp();
                    Vector termCounts = (Vector)tuple2._2();
                    long l = docID;
                    if (termCounts != null) {
                        Vector vector = termCounts;
                        Iterator iterator = vector.toBreeze().activeIterator().filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<Object, Object> x$1) {
                                return x$1._2$mcD$sp() != 0.0;
                            }
                        }).map((Function1)new Serializable(this, l){
                            public static final long serialVersionUID = 0L;
                            private final long x2$1;

                            public final Edge<Object> apply(Tuple2<Object, Object> x0$2) {
                                Tuple2<Object, Object> tuple2 = x0$2;
                                if (tuple2 != null) {
                                    int term2 = tuple2._1$mcI$sp();
                                    double cnt = tuple2._2$mcD$sp();
                                    Edge.mcD.sp sp2 = new Edge.mcD.sp(this.x2$1, LDA$.MODULE$.term2index(term2), cnt);
                                    return sp2;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        });
                        return iterator;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Edge.class));
        RDD verticesTMP = edges.mapPartitionsWithIndex((Function2)new Serializable(this, k, randomSeed){
            public static final long serialVersionUID = 0L;
            public final int k$1;
            private final long randomSeed$1;

            public final Iterator<Tuple2<Object, DenseVector<Object>>> apply(int x0$3, Iterator<Edge<Object>> x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$3), x1$1);
                if (tuple2 != null) {
                    int partIndex = tuple2._1$mcI$sp();
                    Iterator partEdges = (Iterator)tuple2._2();
                    Random random = new Random((long)partIndex + this.randomSeed$1);
                    Iterator iterator = partEdges.flatMap((Function1)new Serializable(this, random){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$3 $outer;
                        public final Random random$1;

                        public final Seq<Tuple2<Object, DenseVector<Object>>> apply(Edge<Object> edge) {
                            DenseVector gamma = (DenseVector)normalize$.MODULE$.apply((Object)DenseVector$.MODULE$.fill(this.$outer.k$1, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$3$$anonfun$apply$3 $outer;

                                public final double apply() {
                                    return this.apply$mcD$sp();
                                }

                                public double apply$mcD$sp() {
                                    return this.$outer.random$1.nextDouble();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }, ClassTag$.MODULE$.Double()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
                            DenseVector sum = (DenseVector)gamma.$times((Object)BoxesRunTime.boxToDouble((double)edge.attr$mcD$sp()), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix());
                            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.srcId()), (Object)sum), new Tuple2((Object)BoxesRunTime.boxToLong((long)edge.dstId()), (Object)sum)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.random$1 = random$1;
                        }
                    });
                    return iterator;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.k$1 = k$1;
                this.randomSeed$1 = randomSeed$1;
            }
        }, edges.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD docTermVertices = RDD$.MODULE$.rddToPairRDDFunctions(verticesTMP, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> x$2, DenseVector<Object> x$3) {
                return (DenseVector)x$2.$plus(x$3, DenseVector$.MODULE$.canAddD());
            }
        });
        this.graph_$eq((Graph<DenseVector<Object>, Object>)Graph$.MODULE$.apply(docTermVertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE)).partitionBy((PartitionStrategy)PartitionStrategy.EdgePartition1D$.MODULE$));
        this.k_$eq(k);
        this.vocabSize_$eq(((Vector)((Tuple2)Predef$.MODULE$.refArrayOps((Object[])docs.take(1)).head())._2()).size());
        this.checkpointInterval_$eq(lda.getCheckpointInterval());
        this.graphCheckpointer_$eq(new PeriodicGraphCheckpointer<DenseVector<Object>, Object>(this.checkpointInterval(), this.graph().vertices().sparkContext()));
        this.graphCheckpointer().update(this.graph());
        this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
        return this;
    }

    @Override
    public EMLDAOptimizer next() {
        Predef$.MODULE$.require(this.graph() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "graph is null, EMLDAOptimizer not initialized.";
            }
        });
        double eta = this.topicConcentration();
        int W = this.vocabSize();
        double alpha = this.docConcentration();
        DenseVector<Object> N_k = this.globalTopicTotals();
        Serializable sendMsg = new Serializable(this, eta, W, alpha, N_k){
            public static final long serialVersionUID = 0L;
            private final double eta$1;
            private final int W$1;
            private final double alpha$1;
            private final DenseVector N_k$1;

            public final void apply(EdgeContext<DenseVector<Object>, Object, Tuple2<Object, DenseVector<Object>>> edgeContext) {
                double N_wj = BoxesRunTime.unboxToDouble((Object)edgeContext.attr());
                DenseVector scaledTopicDistribution = (DenseVector)LDA$.MODULE$.computePTopic((DenseVector<Object>)((DenseVector)edgeContext.srcAttr()), (DenseVector<Object>)((DenseVector)edgeContext.dstAttr()), (DenseVector<Object>)this.N_k$1, this.W$1, this.eta$1, this.alpha$1).$times$eq((Object)BoxesRunTime.boxToDouble((double)N_wj), DenseVector$.MODULE$.canScaleIntoD());
                edgeContext.sendToDst((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
                edgeContext.sendToSrc((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)scaledTopicDistribution));
            }
            {
                this.eta$1 = eta$1;
                this.W$1 = W$1;
                this.alpha$1 = alpha$1;
                this.N_k$1 = N_k$1;
            }
        };
        Serializable mergeMsg = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, DenseVector<Object>> apply(Tuple2<Object, DenseVector<Object>> m0, Tuple2<Object, DenseVector<Object>> m1) {
                DenseVector sum = m0._1$mcZ$sp() ? (DenseVector)((NumericOps)m0._2()).$plus$eq(m1._2(), DenseVector$.MODULE$.canAddIntoD()) : (m1._1$mcZ$sp() ? (DenseVector)((NumericOps)m1._2()).$plus$eq(m0._2(), DenseVector$.MODULE$.canAddIntoD()) : (DenseVector)((NumericOps)m0._2()).$plus(m1._2(), DenseVector$.MODULE$.canAddD()));
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)sum);
            }
        };
        Graph<DenseVector<Object>, Object> qual$1 = this.graph();
        Serializable x$18 = sendMsg;
        Serializable x$19 = mergeMsg;
        TripletFields x$20 = qual$1.aggregateMessages$default$3();
        VertexRDD docTopicDistributions = qual$1.aggregateMessages((Function1)x$18, (Function2)x$19, x$20, ClassTag$.MODULE$.apply(Tuple2.class)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(Tuple2<Object, DenseVector<Object>> x$4) {
                return (DenseVector)x$4._2();
            }
        }, ClassTag$.MODULE$.apply(DenseVector.class));
        GraphImpl newGraph = GraphImpl$.MODULE$.fromExistingRDDs(docTopicDistributions, this.graph().edges(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
        this.graph_$eq((Graph<DenseVector<Object>, Object>)newGraph);
        this.graphCheckpointer().update(newGraph);
        this.globalTopicTotals_$eq(this.computeGlobalTopicTotals());
        return this;
    }

    public DenseVector<Object> globalTopicTotals() {
        return this.globalTopicTotals;
    }

    public void globalTopicTotals_$eq(DenseVector<Object> x$1) {
        this.globalTopicTotals = x$1;
    }

    private DenseVector<Object> computeGlobalTopicTotals() {
        int numTopics = this.k();
        return (DenseVector)RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.graph().vertices().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, ?> v) {
                return LDA$.MODULE$.isTermVertex(v);
            }
        }), ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.apply(DenseVector.class), (Ordering)Ordering.Long$.MODULE$).values().fold((Object)DenseVector$.MODULE$.zeros$mDc$sp(numTopics, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DenseVector<Object> apply(DenseVector<Object> x$5, DenseVector<Object> x$6) {
                return (DenseVector)x$5.$plus$eq(x$6, DenseVector$.MODULE$.canAddIntoD());
            }
        });
    }

    @Override
    public LDAModel getLDAModel(double[] iterationTimes) {
        Predef$.MODULE$.require(this.graph() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "graph is null, EMLDAOptimizer not initialized.";
            }
        });
        this.graphCheckpointer().deleteAllCheckpoints();
        return new DistributedLDAModel(this.graph(), this.globalTopicTotals(), this.k(), this.vocabSize(), Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EMLDAOptimizer $outer;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.$outer.docConcentration();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.Double())), this.topicConcentration(), iterationTimes, DistributedLDAModel$.MODULE$.$lessinit$greater$default$8());
    }
}

