/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.util.List;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.mllib.fpm.PrefixSpan$;
import org.apache.spark.mllib.fpm.PrefixSpan$$anonfun$2$;
import org.apache.spark.mllib.fpm.PrefixSpan$$anonfun$6$;
import org.apache.spark.mllib.fpm.PrefixSpan$Prefix$;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\rea\u0001B\u0001\u0003\u00015\u0011!\u0002\u0015:fM&D8\u000b]1o\u0015\t\u0019A!A\u0002ga6T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQA\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\t9Aj\\4hS:<\u0007CA\b\u001a\u0013\tQ\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001d\u0001\t\u0005\r\u0011\"\u0003\u001e\u0003)i\u0017N\\*vaB|'\u000f^\u000b\u0002=A\u0011qbH\u0005\u0003AA\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0012\u0001\u0005\u0003\u0007I\u0011B\u0012\u0002\u001d5LgnU;qa>\u0014Ho\u0018\u0013fcR\u0011Ae\n\t\u0003\u001f\u0015J!A\n\t\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u0005\n\t\u00111\u0001\u001f\u0003\rAH%\r\u0005\tU\u0001\u0011\t\u0011)Q\u0005=\u0005YQ.\u001b8TkB\u0004xN\u001d;!\u0011!a\u0003A!a\u0001\n\u0013i\u0013\u0001E7bqB\u000bG\u000f^3s]2+gn\u001a;i+\u0005q\u0003CA\b0\u0013\t\u0001\u0004CA\u0002J]RD\u0001B\r\u0001\u0003\u0002\u0004%IaM\u0001\u0015[\u0006D\b+\u0019;uKJtG*\u001a8hi\"|F%Z9\u0015\u0005\u0011\"\u0004b\u0002\u00152\u0003\u0003\u0005\rA\f\u0005\tm\u0001\u0011\t\u0011)Q\u0005]\u0005\tR.\u0019=QCR$XM\u001d8MK:<G\u000f\u001b\u0011\t\u0011a\u0002!\u00111A\u0005\ne\n!#\\1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KV\t!\b\u0005\u0002\u0010w%\u0011A\b\u0005\u0002\u0005\u0019>tw\r\u0003\u0005?\u0001\t\u0005\r\u0011\"\u0003@\u0003Yi\u0017\r\u001f'pG\u0006d\u0007K]8k\t\n\u001b\u0016N_3`I\u0015\fHC\u0001\u0013A\u0011\u001dAS(!AA\u0002iB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006KAO\u0001\u0014[\u0006DHj\\2bYB\u0013xN\u001b#C'&TX\r\t\u0005\u0006\t\u0002!I!R\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u0019C\u0015J\u0013\t\u0003\u000f\u0002i\u0011A\u0001\u0005\u00069\r\u0003\rA\b\u0005\u0006Y\r\u0003\rA\f\u0005\u0006q\r\u0003\rA\u000f\u0005\u0006\t\u0002!\t\u0001\u0014\u000b\u0002\r\"\u001a1J\u0014+\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E3\u0011AC1o]>$\u0018\r^5p]&\u00111\u000b\u0015\u0002\u0006'&t7-Z\u0011\u0002+\u0006)\u0011GL\u001b/a!)q\u000b\u0001C\u0001;\u0005iq-\u001a;NS:\u001cV\u000f\u001d9peRD3A\u0016(U\u0011\u0015Q\u0006\u0001\"\u0001\\\u00035\u0019X\r^'j]N+\b\u000f]8siR\u0011A,X\u0007\u0002\u0001!)A$\u0017a\u0001=!\u001a\u0011L\u0014+\t\u000b\u0001\u0004A\u0011A\u0017\u0002'\u001d,G/T1y!\u0006$H/\u001a:o\u0019\u0016tw\r\u001e5)\u0007}sE\u000bC\u0003d\u0001\u0011\u0005A-A\ntKRl\u0015\r\u001f)biR,'O\u001c'f]\u001e$\b\u000e\u0006\u0002]K\")AF\u0019a\u0001]!\u001a!M\u0014+\t\u000b!\u0004A\u0011A\u001d\u0002+\u001d,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{K\"\u001aqM\u0014+\t\u000b-\u0004A\u0011\u00017\u0002+M,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KR\u0011A,\u001c\u0005\u0006q)\u0004\rA\u000f\u0015\u0004U:#\u0006\"\u00029\u0001\t\u0003\t\u0018a\u0001:v]V\u0011!/\u001f\u000b\u0004g\u0006UAc\u0001;\u0002\u0006A\u0019q)^<\n\u0005Y\u0014!a\u0004)sK\u001aL\u0007p\u00159b]6{G-\u001a7\u0011\u0005aLH\u0002\u0001\u0003\u0006u>\u0014\ra\u001f\u0002\u0005\u0013R,W.\u0005\u0002}\u007fB\u0011q\"`\u0005\u0003}B\u0011qAT8uQ&tw\rE\u0002\u0010\u0003\u0003I1!a\u0001\u0011\u0005\r\te.\u001f\u0005\n\u0003\u000fy\u0017\u0011!a\u0002\u0003\u0013\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015\tY!!\u0005x\u001b\t\tiAC\u0002\u0002\u0010A\tqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u0014\u00055!\u0001C\"mCN\u001cH+Y4\t\u000f\u0005]q\u000e1\u0001\u0002\u001a\u0005!A-\u0019;b!\u0019\tY\"!\t\u0002&5\u0011\u0011Q\u0004\u0006\u0004\u0003?1\u0011a\u0001:eI&!\u00111EA\u000f\u0005\r\u0011F\t\u0012\t\u0006\u001f\u0005\u001d\u00121F\u0005\u0004\u0003S\u0001\"!B!se\u0006L\b\u0003B\b\u0002(]D3a\u001c(U\u0011\u0019\u0001\b\u0001\"\u0001\u00022UA\u00111GA\u001d\u0003K\ny\u0005\u0006\u0003\u00026\u0005m\u0002\u0003B$v\u0003o\u00012\u0001_A\u001d\t\u0019Q\u0018q\u0006b\u0001w\"A\u0011qCA\u0018\u0001\u0004\ti\u0004\u0005\u0004\u0002@\u0005%\u0013QJ\u0007\u0003\u0003\u0003RA!a\u0011\u0002F\u0005!!.\u0019<b\u0015\r\t9EB\u0001\u0004CBL\u0017\u0002BA&\u0003\u0003\u0012qAS1wCJ#E\tE\u0002y\u0003\u001f\"\u0001\"!\u0015\u00020\t\u0007\u00111\u000b\u0002\t'\u0016\fX/\u001a8dKF\u0019A0!\u0016\u0011\r\u0005]\u0013qLA2\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013\u0001\u00027b]\u001eT!!a\u0011\n\t\u0005\u0005\u0014\u0011\f\u0002\t\u0013R,'/\u00192mKB\u0019\u00010!\u001a\u0005\u0011\u0005\u001d\u0014q\u0006b\u0001\u0003S\u0012q!\u0013;f[N,G/E\u0002}\u0003W\u0002b!a\u0016\u0002`\u0005]\u0002\u0006BA\u0018\u001dRC3\u0001\u0001(UQ\r\u0001\u00111\u000f\t\u0004\u001f\u0006U\u0014bAA<!\naQ\t\u001f9fe&lWM\u001c;bY\u001e9\u00111\u0010\u0002\t\u0002\u0005u\u0014A\u0003)sK\u001aL\u0007p\u00159b]B\u0019q)a \u0007\r\u0005\u0011\u0001\u0012AAA'\u0015\tyH\u0004\u000b\u0019\u0011\u001d!\u0015q\u0010C\u0001\u0003\u000b#\"!! \t\u0013\u0005%\u0015q\u0010C\u0001\u0005\u0005-\u0015aD4f]\u001a\u0013X-\u001d)biR,'O\\:\u0015\u0015\u00055\u0015qSAN\u0003?\u000b\t\u000b\u0005\u0004\u0002\u001c\u0005\u0005\u0012q\u0012\t\u0007\u001f\u0005E\u0015Q\u0013\u001e\n\u0007\u0005M\u0005C\u0001\u0004UkBdWM\r\t\u0005\u001f\u0005\u001db\u0006\u0003\u0005\u0002\u0018\u0005\u001d\u0005\u0019AAM!\u0019\tY\"!\t\u0002\u0016\"9\u0011QTAD\u0001\u0004Q\u0014\u0001C7j]\u000e{WO\u001c;\t\r1\n9\t1\u0001/\u0011\u0019A\u0014q\u0011a\u0001u\u0019A\u0011QUA@\u0001\t\t9K\u0001\u0004Qe\u00164\u0017\u000e_\n\u0005\u0003Gs\u0001\u0004C\u0006\u0002,\u0006\r&Q1A\u0005\u0002\u00055\u0016!B5uK6\u001cXCAAK\u0011-\t\t,a)\u0003\u0002\u0003\u0006I!!&\u0002\r%$X-\\:!\u0011)\t),a)\u0003\u0006\u0004%\t!L\u0001\u0007Y\u0016tw\r\u001e5\t\u0015\u0005e\u00161\u0015B\u0001B\u0003%a&A\u0004mK:<G\u000f\u001b\u0011\t\u000f\u0011\u000b\u0019\u000b\"\u0003\u0002>R1\u0011qXAb\u0003\u000b\u0004B!!1\u0002$6\u0011\u0011q\u0010\u0005\t\u0003W\u000bY\f1\u0001\u0002\u0016\"9\u0011QWA^\u0001\u0004q\u0003\"CAe\u0003G\u0013\r\u0011\"\u0001.\u0003\tIG\r\u0003\u0005\u0002N\u0006\r\u0006\u0015!\u0003/\u0003\rIG\r\t\u0005\t\u0003#\f\u0019\u000b\"\u0001\u0002T\u0006YAeY8m_:$\u0003\u000f\\;t)\u0011\ty,!6\t\u000f\u0005]\u0017q\u001aa\u0001]\u0005!\u0011\u000e^3n\u000f%\tY.a \t\u0002\t\ti.\u0001\u0004Qe\u00164\u0017\u000e\u001f\t\u0005\u0003\u0003\fyNB\u0005\u0002&\u0006}\u0004\u0012\u0001\u0002\u0002bN!\u0011q\u001c\b\u0019\u0011\u001d!\u0015q\u001cC\u0001\u0003K$\"!!8\t\u0015\u0005%\u0018q\u001cb\u0001\n\u0013\tY/A\u0004d_VtG/\u001a:\u0016\u0005\u00055\b\u0003BAx\u0003{l!!!=\u000b\t\u0005M\u0018Q_\u0001\u0007CR|W.[2\u000b\t\u0005]\u0018\u0011`\u0001\u000bG>t7-\u001e:sK:$(\u0002BA~\u0003;\nA!\u001e;jY&!\u0011q`Ay\u00055\tEo\\7jG&sG/Z4fe\"I!1AApA\u0003%\u0011Q^\u0001\tG>,h\u000e^3sA!9!qAAp\t\u0013i\u0013A\u00028fqRLE\r\u0003\u0006\u0003\f\u0005}'\u0019!C\u0001\u0005\u001b\tQ!Z7qif,\"!a0\t\u0013\tE\u0011q\u001cQ\u0001\n\u0005}\u0016AB3naRL\b\u0005\u0003\u0006\u0003\u0016\u0005}\u0017\u0011!C\u0005\u0005/\t1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u0004\t\u0005\u0003/\u0012Y\"\u0003\u0003\u0003\u001e\u0005e#AB(cU\u0016\u001cGO\u0002\u0005\u0003\"\u0005}\u0004A\u0001B\u0012\u0005\u001d\u0001vn\u001d;gSb\u001cBAa\b\u000f1!Y\u00111\u0016B\u0010\u0005\u000b\u0007I\u0011AAW\u0011-\t\tLa\b\u0003\u0002\u0003\u0006I!!&\t\u0015\t-\"q\u0004BC\u0002\u0013\u0005Q&A\u0003ti\u0006\u0014H\u000f\u0003\u0006\u00030\t}!\u0011!Q\u0001\n9\naa\u001d;beR\u0004\u0003b\u0003B\u001a\u0005?\u0011)\u0019!C\u0001\u0003[\u000bQ\u0002]1si&\fGn\u0015;beR\u001c\bb\u0003B\u001c\u0005?\u0011\t\u0011)A\u0005\u0003+\u000ba\u0002]1si&\fGn\u0015;beR\u001c\b\u0005C\u0004E\u0005?!\tAa\u000f\u0015\u0011\tu\"q\bB!\u0005\u0007\u0002B!!1\u0003 !A\u00111\u0016B\u001d\u0001\u0004\t)\nC\u0005\u0003,\te\u0002\u0013!a\u0001]!Q!1\u0007B\u001d!\u0003\u0005\r!!&\t\u0011\t\u001d#q\u0004Q\u0005\n5\n\u0011BZ;mYN#\u0018M\u001d;\t\u0011\t-#q\u0004C\u0001\u0005\u001b\nabZ3o!J,g-\u001b=Ji\u0016l7/\u0006\u0002\u0003PA1!\u0011\u000bB1\u0005OrAAa\u0015\u0003^9!!Q\u000bB.\u001b\t\u00119FC\u0002\u0003Z1\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0007\t}\u0003#A\u0004qC\u000e\\\u0017mZ3\n\t\t\r$Q\r\u0002\t\u0013R,'/\u0019;pe*\u0019!q\f\t\u0011\u000b=\t\tJ\f\u001e\t\u0011\t-$q\u0004C\u0001\u0005[\n\u0001B\\8o\u000b6\u0004H/_\u000b\u0003\u0005_\u00022a\u0004B9\u0013\r\u0011\u0019\b\u0005\u0002\b\u0005>|G.Z1o\u0011!\u00119Ha\b\u0005\u0002\te\u0014a\u00029s_*,7\r\u001e\u000b\u0005\u0005{\u0011Y\bC\u0004\u0003~\tU\u0004\u0019\u0001\u0018\u0002\rA\u0014XMZ5y\u0011!\u00119Ha\b\u0005\n\t\u0005E\u0003\u0002B\u001f\u0005\u0007C\u0001B! \u0003\u0000\u0001\u0007\u0011Q\u0013\u0005\t\u0005o\u0012y\u0002\"\u0001\u0003\bR!!Q\bBE\u0011!\u0011iH!\"A\u0002\u0005}\u0006\u0002\u0003BG\u0005?!\tAa$\u0002\u0015\r|W\u000e\u001d:fgN,G-\u0006\u0002\u0003>\u001dY!1SA@\u0003\u0003E\tA\u0001BK\u0003\u001d\u0001vn\u001d;gSb\u0004B!!1\u0003\u0018\u001aY!\u0011EA@\u0003\u0003E\tA\u0001BM'\u0011\u00119J\u0004\r\t\u000f\u0011\u00139\n\"\u0001\u0003\u001eR\u0011!Q\u0013\u0005\u000b\u0005C\u00139*%A\u0005\u0002\t\r\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003&*\u001aaFa*,\u0005\t%\u0006\u0003\u0002BV\u0005gk!A!,\u000b\t\t=&\u0011W\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u0015\t\n\t\tU&Q\u0016\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B]\u0005/\u000b\n\u0011\"\u0001\u0003<\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"A!0+\t\u0005U%q\u0015\u0005\u000b\u0005+\u00119*!A\u0005\n\t]aa\u0002Bb\u0003\u007f\u0002!Q\u0019\u0002\r\rJ,\u0017oU3rk\u0016t7-Z\u000b\u0005\u0005\u000f\u0014)n\u0005\u0003\u0003B:A\u0002b\u0003Bf\u0005\u0003\u0014)\u0019!C\u0001\u0005\u001b\f\u0001b]3rk\u0016t7-Z\u000b\u0003\u0005\u001f\u0004RaDA\u0014\u0005#\u0004RaDA\u0014\u0005'\u00042\u0001\u001fBk\t\u0019Q(\u0011\u0019b\u0001w\"\"!\u0011\u001a(U\u0011-\u0011YN!1\u0003\u0002\u0003\u0006IAa4\u0002\u0013M,\u0017/^3oG\u0016\u0004\u0003\u0006\u0002Bm\u001dRC!B!9\u0003B\n\u0015\r\u0011\"\u0001:\u0003\u00111'/Z9)\t\t}g\n\u0016\u0005\u000b\u0005O\u0014\tM!A!\u0002\u0013Q\u0014!\u00024sKF\u0004\u0003\u0006\u0002Bs\u001dRCq\u0001\u0012Ba\t\u0003\u0011i\u000f\u0006\u0004\u0003p\nE(Q\u001f\t\u0007\u0003\u0003\u0014\tMa5\t\u0011\t-'1\u001ea\u0001\u0005\u001fDCA!=O)\"9!\u0011\u001dBv\u0001\u0004Q\u0004\u0006\u0002B{\u001dRCCAa;O)\"A!Q Ba\t\u0003\u0011y0\u0001\u0007kCZ\f7+Z9vK:\u001cW-\u0006\u0002\u0004\u0002A111AB\u0003\u0007\u0013i!!!?\n\t\r\u001d\u0011\u0011 \u0002\u0005\u0019&\u001cH\u000f\u0005\u0004\u0004\u0004\r\u0015!1\u001b\u0015\u0005\u0005wtE\u000b\u000b\u0003\u0003B:#\u0006B\u0003B\u000b\u0003\u007f\n\t\u0011\"\u0003\u0003\u0018!\"\u0011q\u0010(UQ\u0011\ty(a\u001d)\t\u0005ed\n\u0016\u0015\u0005\u0003s\n\u0019\b")
public class PrefixSpan
implements Logging,
Serializable {
    private double minSupport;
    private int maxPatternLength;
    private long maxLocalProjDBSize;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int maxPatternLength() {
        return this.maxPatternLength;
    }

    private void maxPatternLength_$eq(int x$1) {
        this.maxPatternLength = x$1;
    }

    private long maxLocalProjDBSize() {
        return this.maxLocalProjDBSize;
    }

    private void maxLocalProjDBSize_$eq(long x$1) {
        this.maxLocalProjDBSize = x$1;
    }

    public double getMinSupport() {
        return this.minSupport();
    }

    public PrefixSpan setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0)new Serializable(this, minSupport){
            public static final long serialVersionUID = 0L;
            private final double minSupport$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The minimum support value must be in [0, 1], but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minSupport$1)}));
            }
            {
                this.minSupport$1 = minSupport$1;
            }
        });
        this.minSupport_$eq(minSupport);
        return this;
    }

    public int getMaxPatternLength() {
        return this.maxPatternLength();
    }

    public PrefixSpan setMaxPatternLength(int maxPatternLength) {
        Predef$.MODULE$.require(maxPatternLength >= 1, (Function0)new Serializable(this, maxPatternLength){
            public static final long serialVersionUID = 0L;
            private final int maxPatternLength$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The maximum pattern length value must be greater than 0, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxPatternLength$1)}));
            }
            {
                this.maxPatternLength$1 = maxPatternLength$1;
            }
        });
        this.maxPatternLength_$eq(maxPatternLength);
        return this;
    }

    public long getMaxLocalProjDBSize() {
        return this.maxLocalProjDBSize();
    }

    public PrefixSpan setMaxLocalProjDBSize(long maxLocalProjDBSize) {
        Predef$.MODULE$.require(maxLocalProjDBSize >= 0L, (Function0)new Serializable(this, maxLocalProjDBSize){
            public static final long serialVersionUID = 0L;
            private final long maxLocalProjDBSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The maximum local projected database size must be nonnegative, but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.maxLocalProjDBSize$1)}));
            }
            {
                this.maxLocalProjDBSize$1 = maxLocalProjDBSize$1;
            }
        });
        this.maxLocalProjDBSize_$eq(maxLocalProjDBSize);
        return this;
    }

    public <Item> PrefixSpanModel<Item> run(RDD<Object[]> data, ClassTag<Item> evidence$1) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Input data is not cached.";
                }
            });
        }
        long totalCount = data.count();
        this.logInfo((Function0<String>)new Serializable(this, totalCount){
            public static final long serialVersionUID = 0L;
            private final long totalCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of sequences: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.totalCount$1)}));
            }
            {
                this.totalCount$1 = totalCount$1;
            }
        });
        long minCount = (long)scala.math.package$.MODULE$.ceil(this.minSupport() * (double)totalCount);
        this.logInfo((Function0<String>)new Serializable(this, minCount){
            public static final long serialVersionUID = 0L;
            private final long minCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"minimum count for a frequent pattern: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.minCount$1)}));
            }
            {
                this.minCount$1 = minCount$1;
            }
        });
        RDD x$12 = data.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterator<Tuple2<Item, Object>> apply(Object[] itemsets) {
                Set uniqItems = Set$.MODULE$.empty();
                Predef$.MODULE$.refArrayOps(itemsets).foreach((Function1)new Serializable(this, uniqItems){
                    public static final long serialVersionUID = 0L;
                    public final Set uniqItems$1;

                    public final void apply(Object x$1) {
                        Predef$.MODULE$.genericArrayOps(x$1).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$1 $outer;

                            public final Set<Item> apply(Item item) {
                                return (Set)this.$outer.uniqItems$1.$plus$eq(item);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.uniqItems$1 = uniqItems$1;
                    }
                });
                return uniqItems.toIterator().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Item, Object> apply(Item x$2) {
                        return new Tuple2(x$2, (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                });
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        ClassTag<Item> x$13 = evidence$1;
        ClassTag x$14 = ClassTag$.MODULE$.Long();
        Null$ x$15 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$12);
        Tuple2[] freqItemAndCounts = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(x$12, x$13, x$14, null).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$3, long x$4) {
                return this.apply$mcJJJ$sp(x$3, x$4);
            }

            public long apply$mcJJJ$sp(long x$3, long x$4) {
                return x$3 + x$4;
            }
        }).filter((Function1)new Serializable(this, minCount){
            public static final long serialVersionUID = 0L;
            private final long minCount$1;

            public final boolean apply(Tuple2<Item, Object> x0$1) {
                Tuple2<Item, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    long count = tuple2._2$mcJ$sp();
                    boolean bl = count >= this.minCount$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.minCount$1 = minCount$1;
            }
        }).collect();
        Object freqItems = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])freqItemAndCounts).sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Tuple2<Item, Object> x$5) {
                return -x$5._2$mcJ$sp();
            }
        }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Item apply(Tuple2<Item, Object> x$6) {
                return (Item)x$6._1();
            }
        }, Array$.MODULE$.canBuildFrom(evidence$1));
        this.logInfo((Function0<String>)new Serializable(this, freqItems){
            public static final long serialVersionUID = 0L;
            private final Object freqItems$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"number of frequent items: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)ScalaRunTime$.MODULE$.array_length(this.freqItems$1))}));
            }
            {
                this.freqItems$1 = freqItems$1;
            }
        });
        Map itemToInt = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(freqItems).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        RDD dataInternalRepr = data.flatMap((Function1)new Serializable(this, itemToInt){
            public static final long serialVersionUID = 0L;
            public final Map itemToInt$1;

            public final Iterator<int[]> apply(Object[] itemsets) {
                ArrayBuilder allItems = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
                BooleanRef containsFreqItems = new BooleanRef(false);
                allItems.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
                Predef$.MODULE$.refArrayOps(itemsets).foreach((Function1)new Serializable(this, allItems, containsFreqItems){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final ArrayBuilder allItems$1;
                    private final BooleanRef containsFreqItems$1;

                    public final ArrayBuilder<Object> apply(Object itemsets) {
                        BoxedUnit boxedUnit;
                        ArrayBuilder items = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
                        Predef$.MODULE$.genericArrayOps(itemsets).foreach((Function1)new Serializable(this, items){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6$$anonfun$apply$4 $outer;
                            private final ArrayBuilder items$1;

                            public final Object apply(Item item) {
                                return this.$outer.org$apache$spark$mllib$fpm$PrefixSpan$$anonfun$$anonfun$$$outer().itemToInt$1.contains(item) ? this.items$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)this.$outer.org$apache$spark$mllib$fpm$PrefixSpan$$anonfun$$anonfun$$$outer().itemToInt$1.apply(item)) + 1))) : BoxedUnit.UNIT;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.items$1 = items$1;
                            }
                        });
                        int[] result = (int[])items.result();
                        if (Predef$.MODULE$.intArrayOps(result).nonEmpty()) {
                            this.containsFreqItems$1.elem = true;
                            boxedUnit = this.allItems$1.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(result).sorted((Ordering)Ordering.Int$.MODULE$)));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return (ArrayBuilder)this.allItems$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
                    }

                    public /* synthetic */ $anonfun$6 org$apache$spark$mllib$fpm$PrefixSpan$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.allItems$1 = allItems$1;
                        this.containsFreqItems$1 = containsFreqItems$1;
                    }
                });
                return containsFreqItems.elem ? package$.MODULE$.Iterator().single(allItems.result()) : package$.MODULE$.Iterator().empty();
            }
            {
                this.itemToInt$1 = itemToInt$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE))).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD<Tuple2<int[], Object>> results = PrefixSpan$.MODULE$.genFreqPatterns((RDD<int[]>)dataInternalRepr, minCount, this.maxPatternLength(), this.maxLocalProjDBSize());
        RDD freqSequences = results.map((Function1)new Serializable(this, evidence$1, freqItems){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrefixSpan $outer;
            private final ClassTag evidence$1$1;
            private final Object freqItems$1;

            public final FreqSequence<Item> apply(Tuple2<int[], Object> x0$2) {
                Tuple2<int[], Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int[] seq = (int[])tuple2._1();
                    long count = tuple2._2$mcJ$sp();
                    if (seq != null) {
                        int[] nArray = seq;
                        long l = count;
                        FreqSequence<Item> freqSequence = new FreqSequence<Item>(this.$outer.org$apache$spark$mllib$fpm$PrefixSpan$$toPublicRepr$1(nArray, this.evidence$1$1, this.freqItems$1), l);
                        return freqSequence;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.evidence$1$1 = evidence$1$1;
                this.freqItems$1 = freqItems$1;
            }
        }, ClassTag$.MODULE$.apply(FreqSequence.class));
        return new PrefixSpanModel(freqSequences);
    }

    public <Item, Itemset extends Iterable<Item>, Sequence extends Iterable<Itemset>> PrefixSpanModel<Item> run(JavaRDD<Sequence> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object[]>)data.rdd().map((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            public final ClassTag tag$1;

            public final Object[] apply(Sequence x$7) {
                return (Object[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$7).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$run$5 $outer;

                    public final Object apply(Itemset x$8) {
                        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$8).asScala()).toArray(this.$outer.tag$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(this.tag$1.runtimeClass())));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass())))), tag);
    }

    public final Object[] org$apache$spark$mllib$fpm$PrefixSpan$$toPublicRepr$1(int[] pattern, ClassTag evidence$1$1, Object freqItems$1) {
        ArrayBuilder sequenceBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1$1.runtimeClass())));
        ArrayBuilder itemsetBuilder = ArrayBuilder$.MODULE$.make(evidence$1$1);
        int n = pattern.length;
        for (int i = 1; i < n; ++i) {
            BoxedUnit boxedUnit;
            int x = pattern[i];
            if (x == 0) {
                sequenceBuilder.$plus$eq(itemsetBuilder.result());
                itemsetBuilder.clear();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = itemsetBuilder.$plus$eq(ScalaRunTime$.MODULE$.array_apply(freqItems$1, x - 1));
        }
        return (Object[])sequenceBuilder.result();
    }

    private PrefixSpan(double minSupport, int maxPatternLength, long maxLocalProjDBSize) {
        this.minSupport = minSupport;
        this.maxPatternLength = maxPatternLength;
        this.maxLocalProjDBSize = maxLocalProjDBSize;
        Logging.class.$init$((Logging)this);
    }

    public PrefixSpan() {
        this(0.1, 10, 32000000L);
    }

    public static class Prefix
    implements Serializable {
        private final int[] items;
        private final int length;
        private final int id;

        public int[] items() {
            return this.items;
        }

        public int length() {
            return this.length;
        }

        public int id() {
            return this.id;
        }

        public Prefix $colon$plus(int item) {
            Predef$.MODULE$.require(item != 0);
            return item < 0 ? new Prefix((int[])Predef$.MODULE$.intArrayOps(this.items()).$colon$plus((Object)BoxesRunTime.boxToInteger((int)(-item)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), this.length() + 1) : new Prefix((int[])Predef$.MODULE$.intArrayOps(this.items()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.intArrayOps(new int[]{0, item}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), this.length() + 1);
        }

        public Prefix(int[] items, int length) {
            this.items = items;
            this.length = length;
            this.id = PrefixSpan$Prefix$.MODULE$.org$apache$spark$mllib$fpm$PrefixSpan$Prefix$$nextId();
        }
    }

    public static class Postfix
    implements Serializable {
        private final int[] items;
        private final int start;
        private final int[] partialStarts;

        public int[] items() {
            return this.items;
        }

        public int start() {
            return this.start;
        }

        public int[] partialStarts() {
            return this.partialStarts;
        }

        /*
         * WARNING - void declaration
         */
        private int fullStart() {
            void var1_1;
            int i = this.start();
            while (this.items()[i] != 0) {
                ++i;
            }
            return (int)var1_1;
        }

        public Iterator<Tuple2<Object, Object>> genPrefixItems() {
            int n1 = this.items().length - 1;
            scala.collection.mutable.Map prefixes = Map$.MODULE$.empty();
            Predef$.MODULE$.intArrayOps(this.partialStarts()).foreach((Function1)new Serializable(this, n1, prefixes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Postfix $outer;
                private final int n1$1;
                private final scala.collection.mutable.Map prefixes$1;

                public final void apply(int start2) {
                    this.apply$mcVI$sp(start2);
                }

                public void apply$mcVI$sp(int start2) {
                    int i = start2;
                    int x = -this.$outer.items()[i];
                    while (x != 0) {
                        if (!this.prefixes$1.contains((Object)BoxesRunTime.boxToInteger((int)x))) {
                            this.prefixes$1.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(this.n1$1 - i)));
                        }
                        x = -this.$outer.items()[++i];
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.n1$1 = n1$1;
                    this.prefixes$1 = prefixes$1;
                }
            });
            for (int i = this.fullStart(); i < n1; ++i) {
                int x = this.items()[i];
                if (x == 0 || prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) continue;
                prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
            }
            return prefixes.toIterator();
        }

        public boolean nonEmpty() {
            return this.items().length > this.start() + 1;
        }

        public Postfix project(int prefix) {
            Predef$.MODULE$.require(prefix != 0);
            int n1 = this.items().length - 1;
            BooleanRef matched = new BooleanRef(false);
            IntRef newStart = new IntRef(n1);
            ArrayBuilder newPartialStarts = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
            if (prefix < 0) {
                int target = -prefix;
                Predef$.MODULE$.intArrayOps(this.partialStarts()).foreach((Function1)new Serializable(this, matched, newStart, newPartialStarts, target){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Postfix $outer;
                    private final BooleanRef matched$1;
                    private final IntRef newStart$1;
                    private final ArrayBuilder newPartialStarts$1;
                    private final int target$1;

                    public final Object apply(int start2) {
                        Object object;
                        int i = start2;
                        int x = this.$outer.items()[i];
                        while (x != this.target$1 && x != 0) {
                            x = this.$outer.items()[++i];
                        }
                        if (x == this.target$1) {
                            ++i;
                            if (!this.matched$1.elem) {
                                this.newStart$1.elem = i;
                                this.matched$1.elem = true;
                            }
                            object = this.$outer.items()[i] != 0 ? this.newPartialStarts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i)) : BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.matched$1 = matched$1;
                        this.newStart$1 = newStart$1;
                        this.newPartialStarts$1 = newPartialStarts$1;
                        this.target$1 = target$1;
                    }
                });
            } else {
                int target = prefix;
                for (int i = this.fullStart(); i < n1; ++i) {
                    BoxedUnit boxedUnit;
                    int x = this.items()[i];
                    if (x == target) {
                        if (!matched.elem) {
                            newStart.elem = i;
                            matched.elem = true;
                        }
                        if (this.items()[i + 1] != 0) {
                            boxedUnit = newPartialStarts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return new Postfix(this.items(), newStart.elem, (int[])newPartialStarts.result());
        }

        /*
         * WARNING - void declaration
         */
        private Postfix project(int[] prefix) {
            void var3_3;
            boolean partial = true;
            Postfix cur = this;
            int np = prefix.length;
            for (int i = 0; i < np && cur.nonEmpty(); ++i) {
                int x = prefix[i];
                if (x == 0) {
                    partial = false;
                    continue;
                }
                if (partial) {
                    cur = cur.project(-x);
                    continue;
                }
                cur = cur.project(x);
                partial = true;
            }
            return var3_3;
        }

        public Postfix project(Prefix prefix) {
            return this.project(prefix.items());
        }

        public Postfix compressed() {
            return this.start() > 0 ? new Postfix((int[])Predef$.MODULE$.intArrayOps(this.items()).slice(this.start(), this.items().length), 0, (int[])Predef$.MODULE$.intArrayOps(this.partialStarts()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Postfix $outer;

                public final int apply(int x$10) {
                    return this.apply$mcII$sp(x$10);
                }

                public int apply$mcII$sp(int x$10) {
                    return x$10 - this.$outer.start();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))) : this;
        }

        public Postfix(int[] items, int start2, int[] partialStarts) {
            this.items = items;
            this.start = start2;
            this.partialStarts = partialStarts;
            Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(items).last()) == 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Postfix $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The last item in a postfix must be zero, but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(this.$outer.items()).last()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (Predef$.MODULE$.intArrayOps(partialStarts).nonEmpty()) {
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(partialStarts).head()) >= start2, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Postfix $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"The first partial start cannot be smaller than the start index,").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but got partialStarts.head = ", " < start = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.intArrayOps(this.$outer.partialStarts()).head(), BoxesRunTime.boxToInteger((int)this.$outer.start())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
        }
    }

    public static class FreqSequence<Item>
    implements Serializable {
        private final Object[] sequence;
        private final long freq;

        public Object[] sequence() {
            return this.sequence;
        }

        public long freq() {
            return this.freq;
        }

        public List<List<Item>> javaSequence() {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(this.sequence()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final List<Item> apply(Object x$11) {
                    return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(x$11).toList()).asJava();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class)))).toList()).asJava();
        }

        public FreqSequence(Object[] sequence, long freq) {
            this.sequence = sequence;
            this.freq = freq;
        }
    }
}

