/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import breeze.linalg.CSCMatrix;
import breeze.linalg.CSCMatrix$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Matrix$class;
import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.SparseMatrix$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.types.SQLUserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@SQLUserDefinedType(udt=MatrixUDT.class)
@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0001\u0003\u00015\u0011Ab\u00159beN,W*\u0019;sSbT!a\u0001\u0003\u0002\r1Lg.\u00197h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011QCF\u0007\u0002\u0005%\u0011qC\u0001\u0002\u0007\u001b\u0006$(/\u001b=\t\u0011e\u0001!Q1A\u0005\u0002i\tqA\\;n%><8/F\u0001\u001c!\tyA$\u0003\u0002\u001e!\t\u0019\u0011J\u001c;)\u0007ayR\u0005\u0005\u0002!G5\t\u0011E\u0003\u0002#\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0011\n#!B*j]\u000e,\u0017%\u0001\u0014\u0002\u000bEr#G\f\u0019\t\u0011!\u0002!\u0011!Q\u0001\nm\t\u0001B\\;n%><8\u000f\t\u0015\u0004O})\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011\u0001\u000e\u0002\u000f9,XnQ8mg\"\u001a!fH\u0013\t\u00119\u0002!\u0011!Q\u0001\nm\t\u0001B\\;n\u0007>d7\u000f\t\u0015\u0004[})\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011\u0001\u001a\u0002\u000f\r|G\u000e\u0015;sgV\t1\u0007E\u0002\u0010imI!!\u000e\t\u0003\u000b\u0005\u0013(/Y=)\u0007AzR\u0005\u0003\u00059\u0001\t\u0005\t\u0015!\u00034\u0003!\u0019w\u000e\u001c)ueN\u0004\u0003fA\u001c K!A1\b\u0001BC\u0002\u0013\u0005!'\u0001\u0006s_^Le\u000eZ5dKND3AO\u0010&\u0011!q\u0004A!A!\u0002\u0013\u0019\u0014a\u0003:po&sG-[2fg\u0002B3!P\u0010&\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015A\u0002<bYV,7/F\u0001D!\ryA\u0007\u0012\t\u0003\u001f\u0015K!A\u0012\t\u0003\r\u0011{WO\u00197fQ\r\u0001u$\n\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0007\u00069a/\u00197vKN\u0004\u0003f\u0001% K!AA\n\u0001BC\u0002\u0013\u0005S*\u0001\u0007jgR\u0013\u0018M\\:q_N,G-F\u0001O!\tyq*\u0003\u0002Q!\t9!i\\8mK\u0006t\u0007fA& %\u0006\n1+A\u00032]Mr\u0003\u0007\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003O\u00035I7\u000f\u0016:b]N\u0004xn]3eA!\u001aAk\b*\t\u000ba\u0003A\u0011A-\u0002\rqJg.\u001b;?)\u001dQ6,X0bG\u0016\u0004\"!\u0006\u0001\t\u000be9\u0006\u0019A\u000e)\u0007m{R\u0005C\u0003,/\u0002\u00071\u0004K\u0002^?\u0015BQ!M,A\u0002MB3aX\u0010&\u0011\u0015Yt\u000b1\u00014Q\r\tw$\n\u0005\u0006\u0003^\u0003\ra\u0011\u0015\u0004G~)\u0003\"\u0002'X\u0001\u0004q\u0005fA3 %\"\u001aqk\b*\t\u000ba\u0003A\u0011A5\u0015\riS7\u000e\\7o\u0011\u0015I\u0002\u000e1\u0001\u001c\u0011\u0015Y\u0003\u000e1\u0001\u001c\u0011\u0015\t\u0004\u000e1\u00014\u0011\u0015Y\u0004\u000e1\u00014\u0011\u0015\t\u0005\u000e1\u0001DQ\rAw$\n\u0005\u0006c\u0002!\tE]\u0001\u0007KF,\u0018\r\\:\u0015\u00059\u001b\b\"\u0002;q\u0001\u0004)\u0018!A8\u0011\u0005=1\u0018BA<\u0011\u0005\r\te.\u001f\u0005\u0007s\u0002!\t\u0001\u0002>\u0002\u0011Q|'I]3fu\u0016,\u0012a\u001f\t\u0005y\u0006\u0005A)D\u0001~\u0015\t\u0019aPC\u0001\u0000\u0003\u0019\u0011'/Z3{K&\u0011q# \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0003\u0015\t\u0007\u000f\u001d7z)\u0015!\u0015\u0011BA\u0007\u0011\u001d\tY!a\u0001A\u0002m\t\u0011!\u001b\u0005\b\u0003\u001f\t\u0019\u00011\u0001\u001c\u0003\u0005Q\u0007\u0006BA\u0002?IC\u0001\"!\u0006\u0001\t\u0003!\u0011qC\u0001\u0006S:$W\r\u001f\u000b\u00067\u0005e\u00111\u0004\u0005\b\u0003\u0017\t\u0019\u00021\u0001\u001c\u0011\u001d\ty!a\u0005A\u0002mA\u0001\"a\b\u0001\t\u0003!\u0011\u0011E\u0001\u0007kB$\u0017\r^3\u0015\u0011\u0005\r\u0012\u0011FA\u0016\u0003[\u00012aDA\u0013\u0013\r\t9\u0003\u0005\u0002\u0005+:LG\u000fC\u0004\u0002\f\u0005u\u0001\u0019A\u000e\t\u000f\u0005=\u0011Q\u0004a\u00017!9\u0011qFA\u000f\u0001\u0004!\u0015!\u0001<\t\u000f\u0005M\u0002\u0001\"\u0011\u00026\u0005!1m\u001c9z+\u0005Q\u0006&BA\u0019?\u0005e\u0012EAA\u001e\u0003\u0015\td\u0006\u000e\u00181\u0011!\ty\u0004\u0001C\u0001\r\u0005\u0005\u0013aA7baR\u0019!,a\u0011\t\u0011\u0005\u0015\u0013Q\ba\u0001\u0003\u000f\n\u0011A\u001a\t\u0006\u001f\u0005%C\tR\u0005\u0004\u0003\u0017\u0002\"!\u0003$v]\u000e$\u0018n\u001c82\u0011!\ty\u0002\u0001C\u0001\t\u0005=Cc\u0001.\u0002R!A\u0011QIA'\u0001\u0004\t9\u0005C\u0004\u0002V\u0001!\t%!\u000e\u0002\u0013Q\u0014\u0018M\\:q_N,\u0007\u0006BA*?IC\u0001\"a\u0017\u0001\t\u00032\u0011QL\u0001\u000eM>\u0014X-Y2i\u0003\u000e$\u0018N^3\u0015\t\u0005\r\u0012q\f\u0005\t\u0003\u000b\nI\u00061\u0001\u0002bAAq\"a\u0019\u001c7\u0011\u000b\u0019#C\u0002\u0002fA\u0011\u0011BR;oGRLwN\\\u001a\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l\u00059Ao\u001c#f]N,WCAA7!\r)\u0012qN\u0005\u0004\u0003c\u0012!a\u0003#f]N,W*\u0019;sSbDC!a\u001a %\"1\u0011q\u000f\u0001\u0005Bi\t1B\\;n\u001d>t'0\u001a:pg\"*\u0011QO\u0010\u0002|\u0005\u0012\u0011QP\u0001\u0006c9*d\u0006\r\u0005\u0007\u0003\u0003\u0003A\u0011\t\u000e\u0002\u00159,X.Q2uSZ,7\u000fK\u0003\u0002\u0000}\tY\bK\u0004\u0001\u0003\u000f\u000b9*!'\u0011\t\u0005%\u00151S\u0007\u0003\u0003\u0017SA!!$\u0002\u0010\u0006)A/\u001f9fg*\u0019\u0011\u0011\u0013\u0004\u0002\u0007M\fH.\u0003\u0003\u0002\u0016\u0006-%AE*R\u0019V\u001bXM\u001d#fM&tW\r\u001a+za\u0016\f1!\u001e3uG\t\tY\nE\u0002\u0016\u0003;K1!a(\u0003\u0005%i\u0015\r\u001e:jqV#E\u000bK\u0002\u0001?\u0015:q!!*\u0003\u0011\u0003\t9+\u0001\u0007Ta\u0006\u00148/Z'biJL\u0007\u0010E\u0002\u0016\u0003S3a!\u0001\u0002\t\u0002\u0005-6#BAU\u001d\u00055\u0006cA\b\u00020&\u0019\u0011\u0011\u0017\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fa\u000bI\u000b\"\u0001\u00026R\u0011\u0011q\u0015\u0005\t\u0003s\u000bI\u000b\"\u0001\u0002<\u00069aM]8n\u0007>{Ec\u0002.\u0002>\u0006}\u0016\u0011\u0019\u0005\u00073\u0005]\u0006\u0019A\u000e\t\r-\n9\f1\u0001\u001c\u0011!\t\u0019-a.A\u0002\u0005\u0015\u0017aB3oiJLWm\u001d\t\u0007\u0003\u000f\f9.!8\u000f\t\u0005%\u00171\u001b\b\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*\u0019\u0011q\u001a\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012bAAk!\u00059\u0001/Y2lC\u001e,\u0017\u0002BAm\u00037\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003+\u0004\u0002CB\b\u0002`nYB)C\u0002\u0002bB\u0011a\u0001V;qY\u0016\u001c\u0004\u0006BA\\?IC\u0001\"a:\u0002*\u0012\u0005\u0011\u0011^\u0001\u0006gB,\u00170\u001a\u000b\u00045\u0006-\bbBAw\u0003K\u0004\raG\u0001\u0002]\"\"\u0011Q]\u0010S\u0011!\t\u00190!+\u0005\n\u0005U\u0018!D4f]J\u000bg\u000eZ'biJL\u0007\u0010F\u0005[\u0003o\fI0a?\u0002\u0000\"1\u0011$!=A\u0002mAaaKAy\u0001\u0004Y\u0002bBA\u007f\u0003c\u0004\r\u0001R\u0001\bI\u0016t7/\u001b;z\u0011!\u0011\t!!=A\u0002\t\r\u0011a\u0001:oOB!!Q\u0001B\b\u001b\t\u00119A\u0003\u0003\u0003\n\t-\u0011\u0001B;uS2T!A!\u0004\u0002\t)\fg/Y\u0005\u0005\u0005#\u00119A\u0001\u0004SC:$w.\u001c\u0005\t\u0005+\tI\u000b\"\u0001\u0003\u0018\u000511\u000f\u001d:b]\u0012$\u0012B\u0017B\r\u00057\u0011iBa\b\t\re\u0011\u0019\u00021\u0001\u001c\u0011\u0019Y#1\u0003a\u00017!9\u0011Q B\n\u0001\u0004!\u0005\u0002\u0003B\u0001\u0005'\u0001\rAa\u0001)\t\tMqD\u0015\u0005\t\u0005K\tI\u000b\"\u0001\u0003(\u000591\u000f\u001d:b]\u0012tG#\u0003.\u0003*\t-\"Q\u0006B\u0018\u0011\u0019I\"1\u0005a\u00017!11Fa\tA\u0002mAq!!@\u0003$\u0001\u0007A\t\u0003\u0005\u0003\u0002\t\r\u0002\u0019\u0001B\u0002Q\u0011\u0011\u0019c\b*\t\u0011\tU\u0012\u0011\u0016C\u0001\u0005o\taa\u001d9eS\u0006<Gc\u0001.\u0003:!A!1\bB\u001a\u0001\u0004\u0011i$\u0001\u0004wK\u000e$xN\u001d\t\u0004+\t}\u0012b\u0001B!\u0005\t1a+Z2u_JDCAa\r %\"Q!qIAU\u0003\u0003%IA!\u0013\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0017\u0002BA!\u0014\u0003T5\u0011!q\n\u0006\u0005\u0005#\u0012Y!\u0001\u0003mC:<\u0017\u0002\u0002B+\u0005\u001f\u0012aa\u00142kK\u000e$\b\u0006BAU?ICC!a) %\u0002")
public class SparseMatrix
implements Matrix {
    private final int numRows;
    private final int numCols;
    private final int[] colPtrs;
    private final int[] rowIndices;
    private final double[] values;
    private final boolean isTransposed;

    public static SparseMatrix spdiag(Vector vector) {
        return SparseMatrix$.MODULE$.spdiag(vector);
    }

    public static SparseMatrix sprandn(int n, int n2, double d, Random random) {
        return SparseMatrix$.MODULE$.sprandn(n, n2, d, random);
    }

    public static SparseMatrix sprand(int n, int n2, double d, Random random) {
        return SparseMatrix$.MODULE$.sprand(n, n2, d, random);
    }

    public static SparseMatrix speye(int n) {
        return SparseMatrix$.MODULE$.speye(n);
    }

    public static SparseMatrix fromCOO(int n, int n2, Iterable<Tuple3<Object, Object, Object>> iterable) {
        return SparseMatrix$.MODULE$.fromCOO(n, n2, iterable);
    }

    @Override
    public void org$apache$spark$mllib$linalg$Matrix$_setter_$isTransposed_$eq(boolean x$1) {
    }

    @Override
    public double[] toArray() {
        return Matrix$class.toArray(this);
    }

    @Override
    public DenseMatrix multiply(DenseMatrix y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(DenseVector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public DenseVector multiply(Vector y) {
        return Matrix$class.multiply((Matrix)this, y);
    }

    @Override
    public String toString() {
        return Matrix$class.toString(this);
    }

    @Override
    public String toString(int maxLines, int maxLineWidth) {
        return Matrix$class.toString(this, maxLines, maxLineWidth);
    }

    @Override
    public int numRows() {
        return this.numRows;
    }

    @Override
    public int numCols() {
        return this.numCols;
    }

    public int[] colPtrs() {
        return this.colPtrs;
    }

    public int[] rowIndices() {
        return this.rowIndices;
    }

    public double[] values() {
        return this.values;
    }

    @Override
    public boolean isTransposed() {
        return this.isTransposed;
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            breeze.linalg.Matrix<Object> matrix2 = this.toBreeze();
            breeze.linalg.Matrix<Object> matrix3 = matrix.toBreeze();
            bl = !(matrix2 != null ? !matrix2.equals(matrix3) : matrix3 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public breeze.linalg.Matrix<Object> toBreeze() {
        CSCMatrix.mcD.sp sp2;
        if (this.isTransposed()) {
            CSCMatrix.mcD.sp breezeMatrix = new CSCMatrix.mcD.sp(this.values(), this.numCols(), this.numRows(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
            sp2 = (breeze.linalg.Matrix)breezeMatrix.t(CSCMatrix$.MODULE$.canTranspose(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD()));
        } else {
            sp2 = new CSCMatrix.mcD.sp(this.values(), this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (Zero)Zero.DoubleZero$.MODULE$);
        }
        return sp2;
    }

    @Override
    public double apply(int i, int j) {
        int ind = this.index(i, j);
        return ind < 0 ? 0.0 : this.values()[ind];
    }

    @Override
    public int index(int i, int j) {
        return this.isTransposed() ? Arrays.binarySearch(this.rowIndices(), this.colPtrs()[i], this.colPtrs()[i + 1], j) : Arrays.binarySearch(this.rowIndices(), this.colPtrs()[j], this.colPtrs()[j + 1], i);
    }

    @Override
    public void update(int i, int j, double v) {
        int ind = this.index(i, j);
        if (ind == -1) {
            throw new NoSuchElementException("The given row and column indices correspond to a zero value. Only non-zero elements in Sparse Matrices can be updated.");
        }
        this.values()[ind] = v;
    }

    @Override
    public SparseMatrix copy() {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])this.values().clone());
    }

    @Override
    public SparseMatrix map(Function1<Object, Object> f) {
        return new SparseMatrix(this.numRows(), this.numCols(), this.colPtrs(), this.rowIndices(), (double[])Predef$.MODULE$.doubleArrayOps(this.values()).map(f, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), this.isTransposed());
    }

    @Override
    public SparseMatrix update(Function1<Object, Object> f) {
        int len = this.values().length;
        for (int i = 0; i < len; ++i) {
            this.values()[i] = f.apply$mcDD$sp(this.values()[i]);
        }
        return this;
    }

    @Override
    public SparseMatrix transpose() {
        return new SparseMatrix(this.numCols(), this.numRows(), this.colPtrs(), this.rowIndices(), this.values(), !this.isTransposed());
    }

    @Override
    public void foreachActive(Function3<Object, Object, Object, BoxedUnit> f) {
        if (this.isTransposed()) {
            for (int i = 0; i < this.numRows(); ++i) {
                int idxEnd = this.colPtrs()[i + 1];
                for (int idx = this.colPtrs()[i]; idx < idxEnd; ++idx) {
                    int j = this.rowIndices()[idx];
                    f.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[idx]));
                }
            }
        } else {
            for (int j = 0; j < this.numCols(); ++j) {
                int idxEnd = this.colPtrs()[j + 1];
                for (int idx = this.colPtrs()[j]; idx < idxEnd; ++idx) {
                    f.apply((Object)BoxesRunTime.boxToInteger((int)this.rowIndices()[idx]), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToDouble((double)this.values()[idx]));
                }
            }
        }
    }

    public DenseMatrix toDense() {
        return new DenseMatrix(this.numRows(), this.numCols(), this.toArray());
    }

    @Override
    public int numNonzeros() {
        return Predef$.MODULE$.doubleArrayOps(this.values()).count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$6) {
                return this.apply$mcZD$sp(x$6);
            }

            public boolean apply$mcZD$sp(double x$6) {
                return x$6 != 0.0;
            }
        });
    }

    @Override
    public int numActives() {
        return this.values().length;
    }

    public SparseMatrix(int numRows2, int numCols, int[] colPtrs, int[] rowIndices, double[] values, boolean isTransposed) {
        this.numRows = numRows2;
        this.numCols = numCols;
        this.colPtrs = colPtrs;
        this.rowIndices = rowIndices;
        this.values = values;
        this.isTransposed = isTransposed;
        Matrix$class.$init$(this);
        Predef$.MODULE$.require(values.length == rowIndices.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of row indices and values don't match! ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"values.length: ", ", rowIndices.length: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), BoxesRunTime.boxToInteger((int)this.$outer.rowIndices().length)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(colPtrs.length == numCols + 1 || colPtrs.length == numRows2 + 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The length of the column indices should be the number of columns + 1. Currently, colPointers.length: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.colPtrs().length), BoxesRunTime.boxToInteger((int)this.$outer.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(values.length == BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(colPtrs).last()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SparseMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The last value of colPtrs must equal the number of ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"elements. values.length: ", ", colPtrs.last: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.values().length), Predef$.MODULE$.intArrayOps(this.$outer.colPtrs()).last()}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public SparseMatrix(int numRows2, int numCols, int[] colPtrs, int[] rowIndices, double[] values) {
        this(numRows2, numCols, colPtrs, rowIndices, values, false);
    }
}

