/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.IOException;
import java.util.Map;
import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.BaggedPoint$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.mllib.tree.impl.NodeIdCache;
import org.apache.spark.mllib.tree.impl.NodeIdCache$;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.impl.TreePoint$;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\t5\u0011ABU1oI>lgi\u001c:fgRT!a\u0001\u0003\u0002\tQ\u0014X-\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0013i\u0012\u0001C:ue\u0006$XmZ=\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0002\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\u0019\u0003E\u0001\u0005TiJ\fG/Z4z\u0011!)\u0003A!A!\u0002\u0013q\u0012!C:ue\u0006$XmZ=!\u0011!9\u0003A!b\u0001\n\u0013A\u0013\u0001\u00038v[R\u0013X-Z:\u0016\u0003%\u0002\"a\u0004\u0016\n\u0005-\u0002\"aA%oi\"AQ\u0006\u0001B\u0001B\u0003%\u0011&A\u0005ok6$&/Z3tA!Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u000bgK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ=\u0011\u0005E\"dBA\b3\u0013\t\u0019\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u0011\u0011!A\u0004A!b\u0001\n\u0013A\u0013\u0001B:fK\u0012D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0006g\u0016,G\r\t\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\u0002\u0015IQ\"\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000bqY\u0004\u0019\u0001\u0010\t\u000b\u001dZ\u0004\u0019A\u0015\t\u000b=Z\u0004\u0019\u0001\u0019\t\u000baZ\u0004\u0019A\u0015\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0007I,h\u000e\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JA\u0001\u0006[>$W\r\\\u0005\u0003\u0019&\u0013\u0011CU1oI>lgi\u001c:fgRlu\u000eZ3m\u0011\u0015qE\t1\u0001P\u0003\u0015Ig\u000e];u!\r\u00016+V\u0007\u0002#*\u0011!KB\u0001\u0004e\u0012$\u0017B\u0001+R\u0005\r\u0011F\t\u0012\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\t!B]3he\u0016\u001c8/[8o\u0013\tQvK\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u000b\u0002\u00019B\u0011Q\fY\u0007\u0002=*\u0011qLB\u0001\u000bC:tw\u000e^1uS>t\u0017BA1_\u00051)\u0005\u0010]3sS6,g\u000e^1m\u000f\u0015\u0019'\u0001#\u0001e\u00031\u0011\u0016M\u001c3p[\u001a{'/Z:u!\tyTMB\u0003\u0002\u0005!\u0005am\u0005\u0003f\u001dQ9\u0002\"\u0002\u001ff\t\u0003AG#\u00013\t\u000b),G\u0011A6\u0002\u001fQ\u0014\u0018-\u001b8DY\u0006\u001c8/\u001b4jKJ$ba\u00127n]>\u0004\b\"\u0002(j\u0001\u0004y\u0005\"\u0002\u000fj\u0001\u0004q\u0002\"B\u0014j\u0001\u0004I\u0003\"B\u0018j\u0001\u0004\u0001\u0004\"\u0002\u001dj\u0001\u0004I\u0003fA5skB\u0011Ql]\u0005\u0003iz\u0013QaU5oG\u0016\f\u0013A^\u0001\u0006c9\u0012d\u0006\r\u0005\u0006U\u0016$\t\u0001\u001f\u000b\u0011\u000ffTH0a\u0001\u0002\u0006\u0005\u001d\u00111BA\b\u0003'AQAT<A\u0002=CQa_<A\u0002%\n!B\\;n\u00072\f7o]3t\u0011\u0015ix\u000f1\u0001\u007f\u0003]\u0019\u0017\r^3h_JL7-\u00197GK\u0006$XO]3t\u0013:4w\u000e\u0005\u00032\u007f&J\u0013bAA\u0001m\t\u0019Q*\u00199\t\u000b\u001d:\b\u0019A\u0015\t\u000b=:\b\u0019\u0001\u0019\t\r\u0005%q\u000f1\u00011\u0003!IW\u000e];sSRL\bBBA\u0007o\u0002\u0007\u0011&\u0001\u0005nCb$U\r\u001d;i\u0011\u0019\t\tb\u001ea\u0001S\u00059Q.\u0019=CS:\u001c\bb\u0002\u001dx!\u0003\u0005\r!\u000b\u0015\u0004oJ,\bB\u00026f\t\u0003\tI\u0002F\nH\u00037\ti#a\f\u0002J\u0005-\u0013QJA(\u0003#\n\u0019\u0006C\u0004O\u0003/\u0001\r!!\b\u0011\u000b\u0005}\u0011\u0011F+\u000e\u0005\u0005\u0005\"\u0002BA\u0012\u0003K\tAA[1wC*\u0019\u0011q\u0005\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002,\u0005\u0005\"a\u0002&bm\u0006\u0014F\t\u0012\u0005\u0007w\u0006]\u0001\u0019A\u0015\t\u000fu\f9\u00021\u0001\u00022AA\u00111GA\u001e\u0003{\ti$\u0004\u0002\u00026)!\u0011qGA\u001d\u0003\u0011)H/\u001b7\u000b\u0005\u0005\r\u0012\u0002BA\u0001\u0003k\u0001B!a\u0010\u0002F5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\nI$\u0001\u0003mC:<\u0017\u0002BA$\u0003\u0003\u0012q!\u00138uK\u001e,'\u000f\u0003\u0004(\u0003/\u0001\r!\u000b\u0005\u0007_\u0005]\u0001\u0019\u0001\u0019\t\u000f\u0005%\u0011q\u0003a\u0001a!9\u0011QBA\f\u0001\u0004I\u0003bBA\t\u0003/\u0001\r!\u000b\u0005\u0007q\u0005]\u0001\u0019A\u0015)\t\u0005]!/\u001e\u0005\b\u00033*G\u0011AA.\u00039!(/Y5o%\u0016<'/Z:t_J$2bRA/\u0003?\n\t'a\u0019\u0002f!1a*a\u0016A\u0002=Ca\u0001HA,\u0001\u0004q\u0002BB\u0014\u0002X\u0001\u0007\u0011\u0006\u0003\u00040\u0003/\u0002\r\u0001\r\u0005\u0007q\u0005]\u0003\u0019A\u0015)\t\u0005]#/\u001e\u0005\b\u00033*G\u0011AA6)E9\u0015QNA8\u0003c\n\u0019(!\u001e\u0002x\u0005e\u00141\u0010\u0005\u0007\u001d\u0006%\u0004\u0019A(\t\ru\fI\u00071\u0001\u007f\u0011\u00199\u0013\u0011\u000ea\u0001S!1q&!\u001bA\u0002ABq!!\u0003\u0002j\u0001\u0007\u0001\u0007C\u0004\u0002\u000e\u0005%\u0004\u0019A\u0015\t\u000f\u0005E\u0011\u0011\u000ea\u0001S!A\u0001(!\u001b\u0011\u0002\u0003\u0007\u0011\u0006\u000b\u0003\u0002jI,\bbBA-K\u0012\u0005\u0011\u0011\u0011\u000b\u0012\u000f\u0006\r\u0015QQAD\u0003\u0013\u000bY)!$\u0002\u0010\u0006E\u0005b\u0002(\u0002\u0000\u0001\u0007\u0011Q\u0004\u0005\b{\u0006}\u0004\u0019AA\u0019\u0011\u00199\u0013q\u0010a\u0001S!1q&a A\u0002ABq!!\u0003\u0002\u0000\u0001\u0007\u0001\u0007C\u0004\u0002\u000e\u0005}\u0004\u0019A\u0015\t\u000f\u0005E\u0011q\u0010a\u0001S!1\u0001(a A\u0002%BC!a sk\"I\u0011qS3C\u0002\u0013\u0005\u0011\u0011T\u0001!gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001cVOY:fiN#(/\u0019;fO&,7/\u0006\u0002\u0002\u001cB!q\"!(1\u0013\r\ty\n\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0005\u0003+\u0013X\u000f\u0003\u0005\u0002&\u0016\u0004\u000b\u0011BAN\u0003\u0005\u001aX\u000f\u001d9peR,GMR3biV\u0014XmU;cg\u0016$8\u000b\u001e:bi\u0016<\u0017.Z:!Q\u0011\t\u0019K];\u0007\u000f\u0005-V\r\u0001\u0002\u0002.\niaj\u001c3f\u0013:$W\r_%oM>\u001cB!!+\u000f)!Q\u0011\u0011WAU\u0005\u000b\u0007I\u0011\u0001\u0015\u0002!9|G-Z%oI\u0016D\u0018J\\$s_V\u0004\bBCA[\u0003S\u0013\t\u0011)A\u0005S\u0005\tbn\u001c3f\u0013:$W\r_%o\u000fJ|W\u000f\u001d\u0011\t\u0017\u0005e\u0016\u0011\u0016BC\u0002\u0013\u0005\u00111X\u0001\u000eM\u0016\fG/\u001e:f'V\u00147/\u001a;\u0016\u0005\u0005u\u0006#B\b\u0002@\u0006\r\u0017bAAa!\t1q\n\u001d;j_:\u0004BaDAOS!Y\u0011qYAU\u0005\u0003\u0005\u000b\u0011BA_\u000391W-\u0019;ve\u0016\u001cVOY:fi\u0002Bq\u0001PAU\t\u0003\tY\r\u0006\u0004\u0002N\u0006E\u00171\u001b\t\u0005\u0003\u001f\fI+D\u0001f\u0011\u001d\t\t,!3A\u0002%B\u0001\"!/\u0002J\u0002\u0007\u0011Q\u0018\u0005\t\u0003/,G\u0011\u0001\u0002\u0002Z\u0006\u00112/\u001a7fGRtu\u000eZ3t)>\u001c\u0006\u000f\\5u))\tY.a<\u0003\u0006\t=!q\u0004\t\b\u001f\u0005u\u0017\u0011]Av\u0013\r\ty\u000e\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000bEz\u0018&a9\u0011\u000b=\ti*!:\u0011\u0007!\u000b9/C\u0002\u0002j&\u0013AAT8eKB)\u0011g`\u0015\u0002nB)\u0011g`\u0015\u0002N\"A\u0011\u0011_Ak\u0001\u0004\t\u00190A\u0005o_\u0012,\u0017+^3vKB1\u0011Q_A\u0000\u0005\u0007i!!a>\u000b\t\u0005e\u00181`\u0001\b[V$\u0018M\u00197f\u0015\r\ti\u0010E\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0001\u0003o\u0014Q!U;fk\u0016\u0004baDAoS\u0005\u0015\b\u0002\u0003B\u0004\u0003+\u0004\rA!\u0003\u0002\u001d5\f\u00070T3n_JLXk]1hKB\u0019qBa\u0003\n\u0007\t5\u0001C\u0001\u0003M_:<\u0007\u0002\u0003B\t\u0003+\u0004\rAa\u0005\u0002\u00115,G/\u00193bi\u0006\u0004BA!\u0006\u0003\u001c5\u0011!q\u0003\u0006\u0004\u00053\u0011\u0011\u0001B5na2LAA!\b\u0003\u0018\t!B)Z2jg&|g\u000e\u0016:fK6+G/\u00193bi\u0006D\u0001B!\t\u0002V\u0002\u0007!1E\u0001\u0004e:<\u0007\u0003\u0002B\u0013\u0005Si!Aa\n\u000b\u0007\u0005]\u0002#\u0003\u0003\u0003,\t\u001d\"A\u0002*b]\u0012|W\u000e\u0003\u0005\u00030\u0015$\tA\u0001B\u0019\u0003Q\twm\u001a:fO\u0006$XmU5{K\u001a{'OT8eKR1!\u0011\u0002B\u001a\u0005kA\u0001B!\u0005\u0003.\u0001\u0007!1\u0003\u0005\t\u0003s\u0013i\u00031\u0001\u0002>\"I!\u0011H3\u0012\u0002\u0013\u0005!1H\u0001\u001aiJ\f\u0017N\\\"mCN\u001c\u0018NZ5fe\u0012\"WMZ1vYR$\u0013(\u0006\u0002\u0003>)\u001a\u0011Fa\u0010,\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u0017j!A!\u0012\u000b\t\t\u001d#\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0018\t\n\t\t5#Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B)KF\u0005I\u0011\u0001B\u001e\u0003a!(/Y5o%\u0016<'/Z:t_J$C-\u001a4bk2$H\u0005\u000f\u0005\n\u0005+*\u0017\u0011!C\u0005\u0005/\n1B]3bIJ+7o\u001c7wKR\u0011!\u0011\f\t\u0005\u0003\u007f\u0011Y&\u0003\u0003\u0003^\u0005\u0005#AB(cU\u0016\u001cG\u000fK\u0002feVD3A\u0019:v\u0001")
public class RandomForest
implements Serializable,
Logging {
    private final Strategy org$apache$spark$mllib$tree$RandomForest$$strategy;
    private final int org$apache$spark$mllib$tree$RandomForest$$numTrees;
    public final String org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy;
    private final int org$apache$spark$mllib$tree$RandomForest$$seed;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int trainRegressor$default$8() {
        return RandomForest$.MODULE$.trainRegressor$default$8();
    }

    public static int trainClassifier$default$9() {
        return RandomForest$.MODULE$.trainClassifier$default$9();
    }

    public static String[] supportedFeatureSubsetStrategies() {
        return RandomForest$.MODULE$.supportedFeatureSubsetStrategies();
    }

    public static RandomForestModel trainRegressor(JavaRDD<LabeledPoint> javaRDD, Map<Integer, Integer> map, int n, String string, String string2, int n2, int n3, int n4) {
        return RandomForest$.MODULE$.trainRegressor(javaRDD, map, n, string, string2, n2, n3, n4);
    }

    public static RandomForestModel trainRegressor(RDD<LabeledPoint> rDD, scala.collection.immutable.Map<Object, Object> map, int n, String string, String string2, int n2, int n3, int n4) {
        return RandomForest$.MODULE$.trainRegressor(rDD, map, n, string, string2, n2, n3, n4);
    }

    public static RandomForestModel trainRegressor(RDD<LabeledPoint> rDD, Strategy strategy, int n, String string, int n2) {
        return RandomForest$.MODULE$.trainRegressor(rDD, strategy, n, string, n2);
    }

    public static RandomForestModel trainClassifier(JavaRDD<LabeledPoint> javaRDD, int n, Map<Integer, Integer> map, int n2, String string, String string2, int n3, int n4, int n5) {
        return RandomForest$.MODULE$.trainClassifier(javaRDD, n, map, n2, string, string2, n3, n4, n5);
    }

    public static RandomForestModel trainClassifier(RDD<LabeledPoint> rDD, int n, scala.collection.immutable.Map<Object, Object> map, int n2, String string, String string2, int n3, int n4, int n5) {
        return RandomForest$.MODULE$.trainClassifier(rDD, n, map, n2, string, string2, n3, n4, n5);
    }

    public static RandomForestModel trainClassifier(RDD<LabeledPoint> rDD, Strategy strategy, int n, String string, int n2) {
        return RandomForest$.MODULE$.trainClassifier(rDD, strategy, n, string, n2);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Strategy org$apache$spark$mllib$tree$RandomForest$$strategy() {
        return this.org$apache$spark$mllib$tree$RandomForest$$strategy;
    }

    public int org$apache$spark$mllib$tree$RandomForest$$numTrees() {
        return this.org$apache$spark$mllib$tree$RandomForest$$numTrees;
    }

    public int org$apache$spark$mllib$tree$RandomForest$$seed() {
        return this.org$apache$spark$mllib$tree$RandomForest$$seed;
    }

    public RandomForestModel run(RDD<LabeledPoint> input) {
        Node[] topNodes;
        block5: {
            Tuple2<Split[][], Bin[][]> tuple2;
            block4: {
                Tuple2 tuple22;
                TimeTracker timer = new TimeTracker();
                timer.start("total");
                timer.start("init");
                RDD retaggedInput = input.retag(LabeledPoint.class);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<LabeledPoint>)retaggedInput, this.org$apache$spark$mllib$tree$RandomForest$$strategy(), this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), this.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy);
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"algo = ").append((Object)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().algo()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"numTrees = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$numTrees())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"seed = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$seed())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeMetadata metadata$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"maxBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.maxBins())).toString();
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"featureSubsetStrategy = ").append((Object)this.$outer.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeMetadata metadata$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"numFeaturesPerNode = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numFeaturesPerNode())).toString();
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"subsamplingRate = ").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().subsamplingRate())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                timer.start("findSplitsBins");
                tuple2 = DecisionTree$.MODULE$.findSplitsBins((RDD<LabeledPoint>)retaggedInput, metadata);
                if (tuple2 == null) break block4;
                Split[][] splits = (Split[][])tuple2._1();
                Bin[][] bins = (Bin[][])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                Split[][] splits2 = (Split[][])tuple23._1();
                Bin[][] bins2 = (Bin[][])tuple23._2();
                timer.stop("findSplitsBins");
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "numBins: feature: number of bins";
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    public final DecisionTreeMetadata metadata$1;

                    public final String apply() {
                        return ((TraversableOnce)package$.MODULE$.Range().apply(0, this.metadata$1.numFeatures()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$run$10 $outer;

                            public final String apply(int featureIndex) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex), BoxesRunTime.boxToInteger((int)this.$outer.metadata$1.numBins()[featureIndex])}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n");
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                RDD<TreePoint> treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<LabeledPoint>)retaggedInput, bins2, metadata);
                boolean withReplacement = this.org$apache$spark$mllib$tree$RandomForest$$numTrees() > 1;
                RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, this.org$apache$spark$mllib$tree$RandomForest$$strategy().subsamplingRate(), this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), withReplacement, this.org$apache$spark$mllib$tree$RandomForest$$seed()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                int maxDepth = this.org$apache$spark$mllib$tree$RandomForest$$strategy().maxDepth();
                Predef$.MODULE$.require(maxDepth <= 30, (Function0)new Serializable(this, maxDepth){
                    public static final long serialVersionUID = 0L;
                    private final int maxDepth$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree currently only supports maxDepth <= 30, but was given maxDepth = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxDepth$1)}));
                    }
                    {
                        this.maxDepth$1 = maxDepth$1;
                    }
                });
                long maxMemoryUsage = (long)this.org$apache$spark$mllib$tree$RandomForest$$strategy().maxMemoryInMB() * 1024L * 1024L;
                this.logDebug((Function0<String>)new Serializable(this, maxMemoryUsage){
                    public static final long serialVersionUID = 0L;
                    private final long maxMemoryUsage$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"max memory usage for aggregates = ").append((Object)BoxesRunTime.boxToLong((long)this.maxMemoryUsage$1)).append((Object)" bytes.").toString();
                    }
                    {
                        this.maxMemoryUsage$1 = maxMemoryUsage$1;
                    }
                });
                None$ featureSubset = metadata.subsamplingFeatures() ? new Some(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(metadata.numBins()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$2) {
                        return -x$2._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).take(metadata.numFeaturesPerNode())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$3) {
                        return x$3._2$mcI$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))) : None$.MODULE$;
                long maxMemoryPerNode = RandomForest$.MODULE$.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
                Predef$.MODULE$.require(maxMemoryPerNode <= maxMemoryUsage, (Function0)new Serializable(this, maxMemoryPerNode){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;
                    private final long maxMemoryPerNode$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest/DecisionTree given maxMemoryInMB = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().maxMemoryInMB())}))).append((Object)" which is too small for the given features.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Minimum value = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.maxMemoryPerNode$1 / 0x100000L))}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.maxMemoryPerNode$1 = maxMemoryPerNode$1;
                    }
                });
                timer.stop("init");
                None$ nodeIdCache = this.org$apache$spark$mllib$tree$RandomForest$$strategy().useNodeIdCache() ? new Some((Object)NodeIdCache$.MODULE$.init((RDD<BaggedPoint<TreePoint>>)baggedInput, this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), this.org$apache$spark$mllib$tree$RandomForest$$strategy().checkpointInterval(), 1)) : None$.MODULE$;
                Queue nodeQueue = new Queue();
                Random rng = new Random();
                rng.setSeed((long)this.org$apache$spark$mllib$tree$RandomForest$$seed());
                topNodes = (Node[])Array$.MODULE$.fill(this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Node apply() {
                        return Node$.MODULE$.emptyNode(1);
                    }
                }, ClassTag$.MODULE$.apply(Node.class));
                package$.MODULE$.Range().apply(0, this.org$apache$spark$mllib$tree$RandomForest$$numTrees()).foreach$mVc$sp((Function1)new Serializable(this, nodeQueue, topNodes){
                    public static final long serialVersionUID = 0L;
                    private final Queue nodeQueue$1;
                    private final Node[] topNodes$1;

                    public final void apply(int treeIndex) {
                        this.apply$mcVI$sp(treeIndex);
                    }

                    public void apply$mcVI$sp(int treeIndex) {
                        this.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)this.topNodes$1[treeIndex])}));
                    }
                    {
                        this.nodeQueue$1 = nodeQueue$1;
                        this.topNodes$1 = topNodes$1;
                    }
                });
                while (nodeQueue.nonEmpty()) {
                    Tuple2<scala.collection.immutable.Map<Object, Node[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, NodeIndexInfo>>> tuple24 = RandomForest$.MODULE$.selectNodesToSplit((Queue<Tuple2<Object, Node>>)nodeQueue, maxMemoryUsage, metadata, rng);
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)tuple24._1();
                        scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
                        scala.collection.immutable.Map nodesForGroup2 = (scala.collection.immutable.Map)tuple26._1();
                        scala.collection.immutable.Map treeToNodeToIndexInfo2 = (scala.collection.immutable.Map)tuple26._2();
                        Predef$.MODULE$.assert(nodesForGroup2.size() > 0, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest selected empty nodesForGroup.  Error for unknown reason."})).s((Seq)Nil$.MODULE$);
                            }
                        });
                        timer.start("findBestSplits");
                        DecisionTree$.MODULE$.findBestSplits((RDD<BaggedPoint<TreePoint>>)baggedInput, metadata, topNodes, (scala.collection.immutable.Map<Object, Node[]>)nodesForGroup2, (scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, NodeIndexInfo>>)treeToNodeToIndexInfo2, splits2, bins2, (Queue<Tuple2<Object, Node>>)nodeQueue, timer, (Option<NodeIdCache>)nodeIdCache);
                        timer.stop("findBestSplits");
                        continue;
                    }
                    throw new MatchError(tuple24);
                }
                baggedInput.unpersist(baggedInput.unpersist$default$1());
                timer.stop("total");
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Internal timing for DecisionTree:";
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this, timer){
                    public static final long serialVersionUID = 0L;
                    private final TimeTracker timer$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
                    }
                    {
                        this.timer$1 = timer$1;
                    }
                });
                if (!nodeIdCache.nonEmpty()) break block5;
                try {
                    ((NodeIdCache)nodeIdCache.get()).deleteAllCheckpoints();
                }
                catch (IOException iOException) {
                    this.logWarning((Function0<String>)new Serializable(this, iOException){
                        public static final long serialVersionUID = 0L;
                        private final IOException e$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete all checkpoints failed. Error reason: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            throw new MatchError(tuple2);
        }
        DecisionTreeModel[] trees = (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final DecisionTreeModel apply(Node topNode) {
                return new DecisionTreeModel(topNode, this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().algo());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
        return new RandomForestModel(this.org$apache$spark$mllib$tree$RandomForest$$strategy().algo(), trees);
    }

    public RandomForest(Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        this.org$apache$spark$mllib$tree$RandomForest$$strategy = strategy;
        this.org$apache$spark$mllib$tree$RandomForest$$numTrees = numTrees;
        this.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy = featureSubsetStrategy;
        this.org$apache$spark$mllib$tree$RandomForest$$seed = seed;
        Logging.class.$init$((Logging)this);
        strategy.assertValid();
        Predef$.MODULE$.require(numTrees > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest requires numTrees > 0, but was given numTrees = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$numTrees())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).contains((Object)featureSubsetStrategy), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest given invalid featureSubsetStrategy: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Supported values: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ")}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class NodeIndexInfo
    implements Serializable {
        private final int nodeIndexInGroup;
        private final Option<int[]> featureSubset;

        public int nodeIndexInGroup() {
            return this.nodeIndexInGroup;
        }

        public Option<int[]> featureSubset() {
            return this.featureSubset;
        }

        public NodeIndexInfo(int nodeIndexInGroup, Option<int[]> featureSubset) {
            this.nodeIndexInGroup = nodeIndexInGroup;
            this.featureSubset = featureSubset;
        }
    }
}

