/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.IsotonicRegressionModel;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001\u001b\t\u0011\u0012j]8u_:L7MU3he\u0016\u001c8/[8o\u0015\t\u0019A!\u0001\u0006sK\u001e\u0014Xm]:j_:T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u001b\u001b\u00051\"BA\f\u0019\u0003\tIwNC\u0001\u001a\u0003\u0011Q\u0017M^1\n\u0005m1\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u000f\u0001\u0005\u0003\u0007I\u0011\u0002\u0010\u0002\u0011%\u001cx\u000e^8oS\u000e,\u0012a\b\t\u0003\u001f\u0001J!!\t\t\u0003\u000f\t{w\u000e\\3b]\"A1\u0005\u0001BA\u0002\u0013%A%\u0001\u0007jg>$xN\\5d?\u0012*\u0017\u000f\u0006\u0002&QA\u0011qBJ\u0005\u0003OA\u0011A!\u00168ji\"9\u0011FIA\u0001\u0002\u0004y\u0012a\u0001=%c!A1\u0006\u0001B\u0001B\u0003&q$A\u0005jg>$xN\\5dA!)Q\u0006\u0001C\u0005]\u00051A(\u001b8jiz\"\"aL\u0019\u0011\u0005A\u0002Q\"\u0001\u0002\t\u000bua\u0003\u0019A\u0010\t\u000b5\u0002A\u0011A\u001a\u0015\u0003=B3AM\u001b<!\t1\u0014(D\u00018\u0015\tAd!\u0001\u0006b]:|G/\u0019;j_:L!AO\u001c\u0003\u000bMKgnY3\"\u0003q\nQ!\r\u00184]ABQA\u0010\u0001\u0005\u0002}\n1b]3u\u0013N|Go\u001c8jGR\u0011\u0001)Q\u0007\u0002\u0001!)Q$\u0010a\u0001?!\u001aQ(N\u001e\t\u000b\u0011\u0003A\u0011A#\u0002\u0007I,h\u000e\u0006\u0002G\u0013B\u0011\u0001gR\u0005\u0003\u0011\n\u0011q#S:pi>t\u0017n\u0019*fOJ,7o]5p]6{G-\u001a7\t\u000b)\u001b\u0005\u0019A&\u0002\u000b%t\u0007/\u001e;\u0011\u00071{\u0015+D\u0001N\u0015\tqe!A\u0002sI\u0012L!\u0001U'\u0003\u0007I#E\tE\u0003\u0010%R#F+\u0003\u0002T!\t1A+\u001e9mKN\u0002\"aD+\n\u0005Y\u0003\"A\u0002#pk\ndW\rK\u0002DkmBQ\u0001\u0012\u0001\u0005\u0002e#\"A\u0012.\t\u000b)C\u0006\u0019A.\u0011\u0007q\u0003'-D\u0001^\u0015\tIbL\u0003\u0002`\r\u0005\u0019\u0011\r]5\n\u0005\u0005l&a\u0002&bm\u0006\u0014F\t\u0012\t\u0006\u001fI\u001b7m\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003Mb\tA\u0001\\1oO&\u0011a+\u001a\u0015\u00041VZ\u0004\"\u00026\u0001\t\u0013Y\u0017!\u00069p_2\fEM[1dK:$h+[8mCR|'o\u001d\u000b\u0003Y>\u00042aD7R\u0013\tq\u0007CA\u0003BeJ\f\u0017\u0010C\u0003KS\u0002\u0007A\u000eC\u0003r\u0001\u0011%!/A\u000fqCJ\fG\u000e\\3m!>|G.\u00113kC\u000e,g\u000e\u001e,j_2\fGo\u001c:t)\ta7\u000fC\u0003Ka\u0002\u00071\nK\u0002\u0001km\u0002")
public class IsotonicRegression
implements Serializable {
    private boolean isotonic;

    private boolean isotonic() {
        return this.isotonic;
    }

    private void isotonic_$eq(boolean x$1) {
        this.isotonic = x$1;
    }

    public IsotonicRegression setIsotonic(boolean isotonic) {
        this.isotonic_$eq(isotonic);
        return this;
    }

    public IsotonicRegressionModel run(RDD<Tuple3<Object, Object, Object>> input) {
        RDD preprocessedInput = this.isotonic() ? input : input.map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)(-BoxesRunTime.unboxToDouble((Object)x._1()))), x._2(), x._3());
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        Tuple3<Object, Object, Object>[] pooled = this.parallelPoolAdjacentViolators(preprocessedInput);
        double[] predictions = this.isotonic() ? (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$5) {
                return BoxesRunTime.unboxToDouble((Object)x$5._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$6) {
                return -BoxesRunTime.unboxToDouble((Object)x$6._1());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double[] boundaries = (double[])Predef$.MODULE$.refArrayOps((Object[])pooled).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$7) {
                return BoxesRunTime.unboxToDouble((Object)x$7._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        return new IsotonicRegressionModel(boundaries, predictions, this.isotonic());
    }

    public IsotonicRegressionModel run(JavaRDD<Tuple3<Double, Double, Double>> input) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)input.rdd().retag(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    public Tuple3<Object, Object, Object>[] org$apache$spark$mllib$regression$IsotonicRegression$$poolAdjacentViolators(Tuple3<Object, Object, Object>[] input) {
        if (Predef$.MODULE$.refArrayOps((Object[])input).isEmpty()) {
            return (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        int i = 0;
        int len = input.length;
        while (i < len) {
            int j;
            for (j = i; j < len - 1 && BoxesRunTime.unboxToDouble((Object)input[j]._1()) > BoxesRunTime.unboxToDouble((Object)input[j + 1]._1()); ++j) {
            }
            if (i == j) {
                ++i;
                continue;
            }
            while (i >= 0 && BoxesRunTime.unboxToDouble((Object)input[i]._1()) > BoxesRunTime.unboxToDouble((Object)input[i + 1]._1())) {
                this.pool$1(input, i, j);
                --i;
            }
            i = j;
        }
        ArrayBuffer compressed2 = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        Tuple3 tuple3 = (Tuple3)Predef$.MODULE$.refArrayOps((Object[])input).head();
        if (tuple3 != null) {
            Tuple3 tuple32;
            double curLabel = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            double curFeature = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            double curWeight = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel), (Object)BoxesRunTime.boxToDouble((double)curFeature), (Object)BoxesRunTime.boxToDouble((double)curWeight));
            DoubleRef curLabel2 = new DoubleRef(BoxesRunTime.unboxToDouble((Object)tuple33._1()));
            DoubleRef curFeature2 = new DoubleRef(BoxesRunTime.unboxToDouble((Object)tuple33._2()));
            DoubleRef curWeight2 = new DoubleRef(BoxesRunTime.unboxToDouble((Object)tuple33._3()));
            DoubleRef rightBound = new DoubleRef(curFeature2.elem);
            for (i = 1; i < input.length; ++i) {
                Tuple3<Object, Object, Object> tuple34 = input[i];
                if (tuple34 != null) {
                    Tuple3 tuple35;
                    double label = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                    double feature = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                    double weight = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                    Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)label), (Object)BoxesRunTime.boxToDouble((double)feature), (Object)BoxesRunTime.boxToDouble((double)weight));
                    double label2 = BoxesRunTime.unboxToDouble((Object)tuple36._1());
                    double feature2 = BoxesRunTime.unboxToDouble((Object)tuple36._2());
                    double weight2 = BoxesRunTime.unboxToDouble((Object)tuple36._3());
                    if (label2 == curLabel2.elem) {
                        curWeight2.elem += weight2;
                        rightBound.elem = feature2;
                        continue;
                    }
                    this.merge$1(compressed2, curLabel2, curFeature2, curWeight2, rightBound);
                    curLabel2.elem = label2;
                    curFeature2.elem = feature2;
                    curWeight2.elem = weight2;
                    rightBound.elem = curFeature2.elem;
                    continue;
                }
                throw new MatchError(tuple34);
            }
            this.merge$1(compressed2, curLabel2, curFeature2, curWeight2, rightBound);
            return (Tuple3[])compressed2.toArray(ClassTag$.MODULE$.apply(Tuple3.class));
        }
        throw new MatchError((Object)tuple3);
    }

    private Tuple3<Object, Object, Object>[] parallelPoolAdjacentViolators(RDD<Tuple3<Object, Object, Object>> input) {
        Tuple3[] parallelStepResult = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])input.sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
            }
        }, input.sortBy$default$2(), input.sortBy$default$3(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$), ClassTag$.MODULE$.apply(Tuple2.class)).glom().flatMap((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsotonicRegression $outer;

            public final ArrayOps<Tuple3<Object, Object, Object>> apply(Tuple3<Object, Object, Object>[] input) {
                return Predef$.MODULE$.refArrayOps((Object[])this.$outer.org$apache$spark$mllib$regression$IsotonicRegression$$poolAdjacentViolators(input));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)).collect()).sortBy((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple3<Object, Object, Object> x) {
                return new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)x._2()), BoxesRunTime.unboxToDouble((Object)x._1()));
            }
        }, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Double$.MODULE$));
        return this.org$apache$spark$mllib$regression$IsotonicRegression$$poolAdjacentViolators(parallelStepResult);
    }

    private final void pool$1(Tuple3[] input, int start2, int end) {
        Tuple3[] poolSubArray = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])input).slice(start2, end + 1);
        double weightedSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])poolSubArray).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> lp) {
                return BoxesRunTime.unboxToDouble((Object)lp._1()) * BoxesRunTime.unboxToDouble((Object)lp._3());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        double weight = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])poolSubArray).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple3<Object, Object, Object> x$8) {
                return BoxesRunTime.unboxToDouble((Object)x$8._3());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        for (int i = start2; i <= end; ++i) {
            input[i] = new Tuple3((Object)BoxesRunTime.boxToDouble((double)(weightedSum / weight)), input[i]._2(), input[i]._3());
        }
    }

    private final void merge$1(ArrayBuffer compressed$1, DoubleRef curLabel$1, DoubleRef curFeature$1, DoubleRef curWeight$1, DoubleRef rightBound$1) {
        compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)curFeature$1.elem), (Object)BoxesRunTime.boxToDouble((double)curWeight$1.elem)));
        if (rightBound$1.elem > curFeature$1.elem) {
            compressed$1.$plus$eq((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)curLabel$1.elem), (Object)BoxesRunTime.boxToDouble((double)rightBound$1.elem), (Object)BoxesRunTime.boxToDouble((double)0.0)));
        }
    }

    private IsotonicRegression(boolean isotonic) {
        this.isotonic = isotonic;
    }

    public IsotonicRegression() {
        this(true);
    }
}

