/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Enumeration;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u00055\u0011Q\u0003R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgN|'O\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019yR\u0005E\u0003\u0010!IQB$D\u0001\u0005\u0013\t\tBAA\u0005Qe\u0016$\u0017n\u0019;peB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007Y&t\u0017\r\\4\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005\u00191Vm\u0019;peB\u00111\u0004A\u0007\u0002\u0005A\u00111$H\u0005\u0003=\t\u00111\u0004R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\u0011!(/Z3\n\u0005\u0011\n#A\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,\u0007+\u0019:b[N\u0004\"\u0001\t\u0014\n\u0005\u001d\n#a\u0005+sK\u0016\u0014Vm\u001a:fgN|'\u000fU1sC6\u001c\b\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\t\u0016\u0002\u0007ULG-F\u0001,!\ta#G\u0004\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\td&\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019/Q\rAc\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0019\t!\"\u00198o_R\fG/[8o\u0013\tY\u0004HA\u0003TS:\u001cW-I\u0001>\u0003\u0015\td\u0006\u000e\u00181\u0011!y\u0004A!A!\u0002\u0013Y\u0013\u0001B;jI\u0002B3A\u0010\u001c=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\u0012\u0005\u0006S\u0005\u0003\ra\u000b\u0015\u0004\tZb\u0004fA!7y!)!\t\u0001C\u0001\u0011R\t!\u0004K\u0002HmqBQa\u0013\u0001\u0005B1\u000b1b]3u\u001b\u0006DH)\u001a9uQR\u0011QJT\u0007\u0002\u0001!)qJ\u0013a\u0001!\u0006)a/\u00197vKB\u0011Q&U\u0005\u0003%:\u00121!\u00138uQ\rQe\u0007\u0010\u0005\u0006+\u0002!\tEV\u0001\u000bg\u0016$X*\u0019=CS:\u001cHCA'X\u0011\u0015yE\u000b1\u0001QQ\r!f\u0007\u0010\u0005\u00065\u0002!\teW\u0001\u0017g\u0016$X*\u001b8J]N$\u0018M\\2fgB+'OT8eKR\u0011Q\n\u0018\u0005\u0006\u001ff\u0003\r\u0001\u0015\u0015\u00043Zb\u0004\"B0\u0001\t\u0003\u0002\u0017AD:fi6Kg.\u00138g_\u001e\u000b\u0017N\u001c\u000b\u0003\u001b\u0006DQa\u00140A\u0002\t\u0004\"!L2\n\u0005\u0011t#A\u0002#pk\ndW\rK\u0002_mqBQa\u001a\u0001\u0005B!\f\u0001c]3u\u001b\u0006DX*Z7pefLe.\u0014\"\u0015\u00055K\u0007\"B(g\u0001\u0004\u0001\u0006f\u000147y!)A\u000e\u0001C![\u0006y1/\u001a;DC\u000eDWMT8eK&#7\u000f\u0006\u0002N]\")qj\u001ba\u0001_B\u0011Q\u0006]\u0005\u0003c:\u0012qAQ8pY\u0016\fg\u000eK\u0002lmqBQ\u0001\u001e\u0001\u0005BU\fQc]3u\u0007\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0006\u0002Nm\")qj\u001da\u0001!\"\u001a1O\u000e\u001f\t\u000be\u0004A\u0011\t>\u0002\u0017M,G/S7qkJLG/\u001f\u000b\u0003\u001bnDQa\u0014=A\u0002-B3\u0001\u001f\u001c=\u0011\u0015q\b\u0001\"\u0011\u0000\u0003\u001d\u0019X\r^*fK\u0012$2!TA\u0001\u0011\u0019yU\u00101\u0001\u0002\u0004A\u0019Q&!\u0002\n\u0007\u0005\u001daF\u0001\u0003M_:<\u0007bBA\u0006\u0001\u0011E\u0013QB\u0001\u0006iJ\f\u0017N\u001c\u000b\u00049\u0005=\u0001\u0002CA\t\u0003\u0013\u0001\r!a\u0005\u0002\u000f\u0011\fG/Y:fiB!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0019\t1a]9m\u0013\u0011\ti\"a\u0006\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\u0002CA\u0011\u0001\u0011\u0005A!a\t\u0002\u001d\u001d,Go\u00147e'R\u0014\u0018\r^3hsR!\u0011QEA\u001a!\u0011\t9#a\f\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQbY8oM&<WO]1uS>t'B\u0001\u0012\u0017\u0013\u0011\t\t$!\u000b\u0003\u0011M#(/\u0019;fOfD\u0001\"!\u000e\u0002 \u0001\u0007\u0011qG\u0001\u0014G\u0006$XmZ8sS\u000e\fGNR3biV\u0014Xm\u001d\t\u0006Y\u0005e\u0002\u000bU\u0005\u0004\u0003w!$aA'ba\"9\u0011q\b\u0001\u0005B\u0005\u0005\u0013\u0001B2paf$2AGA\"\u0011!\t)%!\u0010A\u0002\u0005\u001d\u0013!B3yiJ\f\u0007\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055C!A\u0003qCJ\fW.\u0003\u0003\u0002R\u0005-#\u0001\u0003)be\u0006lW*\u00199)\t\u0005ub\u0007\u0010\u0015\u0004\u0001\u0005]\u0003cA\u001c\u0002Z%\u0019\u00111\f\u001d\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u00011DhB\u0004\u0002b\tA\t!a\u0019\u0002+\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:peB\u00191$!\u001a\u0007\r\u0005\u0011\u0001\u0012AA4'\u0019\t)'!\u001b\u0002pA\u0019Q&a\u001b\n\u0007\u00055dF\u0001\u0004B]f\u0014VM\u001a\t\u0004[\u0005E\u0014bAA:]\ta1+\u001a:jC2L'0\u00192mK\"9!)!\u001a\u0005\u0002\u0005]DCAA2\u0011)\tY(!\u001aC\u0002\u0013\u0015\u0011QP\u0001\u0014gV\u0004\bo\u001c:uK\u0012LU\u000e];sSRLWm]\u000b\u0003\u0003\u007f\u0002B!LAAW%\u0019\u00111\u0011\u0018\u0003\u000b\u0005\u0013(/Y=\t\u0013\u0005\u001d\u0015Q\rQ\u0001\u000e\u0005}\u0014\u0001F:vaB|'\u000f^3e\u00136\u0004XO]5uS\u0016\u001c\b\u0005\u0003\u0006\u0002\f\u0006\u0015\u0014\u0011!C\u0005\u0003\u001b\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0012\t\u0005\u0003#\u000bY*\u0004\u0002\u0002\u0014*!\u0011QSAL\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0015\u0001\u00026bm\u0006LA!!(\u0002\u0014\n1qJ\u00196fGRDC!!\u001a\u0002X!\"\u0011Q\r\u001c=Q\u0011\ty&a\u0016)\t\u0005}c\u0007\u0010")
public final class DecisionTreeRegressor
extends Predictor<Vector, DecisionTreeRegressor, DecisionTreeRegressionModel>
implements DecisionTreeParams,
TreeRegressorParams {
    private final String uid;
    private final Param<String> impurity;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static String[] supportedImpurities() {
        return DecisionTreeRegressor$.MODULE$.supportedImpurities();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public DecisionTreeRegressor setMaxDepth(int value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public DecisionTreeRegressor setMaxBins(int value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public DecisionTreeRegressor setMinInstancesPerNode(int value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public DecisionTreeRegressor setMinInfoGain(double value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public DecisionTreeRegressor setMaxMemoryInMB(int value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public DecisionTreeRegressor setCacheNodeIds(boolean value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public DecisionTreeRegressor setCheckpointInterval(int value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public DecisionTreeRegressor setImpurity(String value) {
        return (DecisionTreeRegressor)TreeRegressorParams$class.setImpurity(this, value);
    }

    @Override
    public DecisionTreeRegressor setSeed(long value) {
        return (DecisionTreeRegressor)DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public DecisionTreeRegressionModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        Strategy strategy = this.getOldStrategy(categoricalFeatures);
        DecisionTreeModel[] trees = RandomForest$.MODULE$.run(oldDataset, strategy, 1, "all", BoxesRunTime.unboxToLong((Object)this.$(this.seed())), (Option<String>)new Some((Object)this.uid()));
        return (DecisionTreeRegressionModel)Predef$.MODULE$.refArrayOps((Object[])trees).head();
    }

    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, 0, Algo$.MODULE$.Regression(), this.getOldImpurity(), 1.0);
    }

    @Override
    public DecisionTreeRegressor copy(ParamMap extra) {
        return (DecisionTreeRegressor)this.defaultCopy(extra);
    }

    public DecisionTreeRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
    }

    public DecisionTreeRegressor() {
        this(Identifiable$.MODULE$.randomUID("dtr"));
    }
}

