/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasSolver$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.regression.LinearRegressionModel$;
import org.apache.spark.ml.regression.LinearRegressionModel$LinearRegressionModelWriter$;
import org.apache.spark.ml.regression.LinearRegressionModel$LinearRegressionModelWriter$Data$;
import org.apache.spark.ml.regression.LinearRegressionParams;
import org.apache.spark.ml.regression.LinearRegressionSummary;
import org.apache.spark.ml.regression.LinearRegressionTrainingSummary;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\t-g\u0001B\u0001\u0003\u00015\u0011Q\u0003T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019Yb\u0004\u0005\u0003\u0010!IQR\"\u0001\u0002\n\u0005E\u0011!a\u0004*fOJ,7o]5p]6{G-\u001a7\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012A\u00027j]\u0006dwM\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001d\u0013\ti\"A\u0001\fMS:,\u0017M\u001d*fOJ,7o]5p]B\u000b'/Y7t!\ty\"%D\u0001!\u0015\t\tC!\u0001\u0003vi&d\u0017BA\u0012!\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\tK\u0001\u0011)\u0019!C!M\u0005\u0019Q/\u001b3\u0016\u0003\u001d\u0002\"\u0001\u000b\u0018\u000f\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[)B\u0001B\r\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005k&$\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u00016\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t+\u0005\u0011\u0002\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u001b\r|WM\u001a4jG&,g\u000e^:!\u0011!I\u0004A!b\u0001\n\u0003Q\u0014!C5oi\u0016\u00148-\u001a9u+\u0005Y\u0004CA\u0015=\u0013\ti$F\u0001\u0004E_V\u0014G.\u001a\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005w\u0005Q\u0011N\u001c;fe\u000e,\u0007\u000f\u001e\u0011\t\r\u0005\u0003A\u0011\u0001\u0003C\u0003\u0019a\u0014N\\5u}Q!!d\u0011#F\u0011\u0015)\u0003\t1\u0001(\u0011\u0015!\u0004\t1\u0001\u0013\u0011\u0015I\u0004\t1\u0001<\u0011\u001d9\u0005\u00011A\u0005\n!\u000bq\u0002\u001e:bS:LgnZ*v[6\f'/_\u000b\u0002\u0013B\u0019\u0011F\u0013'\n\u0005-S#AB(qi&|g\u000e\u0005\u0002\u0010\u001b&\u0011aJ\u0001\u0002 \u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:$&/Y5oS:<7+^7nCJL\bb\u0002)\u0001\u0001\u0004%I!U\u0001\u0014iJ\f\u0017N\\5oON+X.\\1ss~#S-\u001d\u000b\u0003%V\u0003\"!K*\n\u0005QS#\u0001B+oSRDqAV(\u0002\u0002\u0003\u0007\u0011*A\u0002yIEBa\u0001\u0017\u0001!B\u0013I\u0015\u0001\u0005;sC&t\u0017N\\4Tk6l\u0017M]=!\u0011\u0015Q\u0006\u0001\"\u00016\u0003\u001d9X-[4iiNDC!\u0017/`CB\u0011\u0011&X\u0005\u0003=*\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005\u0001\u0017!G+tK\u0002\u001aw.\u001a4gS\u000eLWM\u001c;tA%t7\u000f^3bI:\n\u0013AY\u0001\u0006c92d\u0006\r\u0005\bI\u0002\u0011\r\u0011\"\u0011f\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003\u0019\u0004\"!K4\n\u0005!T#aA%oi\"1!\u000e\u0001Q\u0001\n\u0019\fAB\\;n\r\u0016\fG/\u001e:fg\u0002BQ\u0001\u001c\u0001\u0005\u00025\fqa];n[\u0006\u0014\u00180F\u0001MQ\rYw.\u001e\t\u0003aNl\u0011!\u001d\u0006\u0003e\u001a\t!\"\u00198o_R\fG/[8o\u0013\t!\u0018OA\u0003TS:\u001cW-I\u0001w\u0003\u0015\td&\u000e\u00181\u0011\u0019A\b\u0001\"\u0001\u0003s\u0006Q1/\u001a;Tk6l\u0017M]=\u0015\u0005i\\X\"\u0001\u0001\t\u000b1<\b\u0019\u0001'\t\u000bu\u0004A\u0011\u0001@\u0002\u0015!\f7oU;n[\u0006\u0014\u00180F\u0001\u0000!\rI\u0013\u0011A\u0005\u0004\u0003\u0007Q#a\u0002\"p_2,\u0017M\u001c\u0015\u0004y>,\b\u0002CA\u0005\u0001\u0011\u0005!!a\u0003\u0002\u0011\u00154\u0018\r\\;bi\u0016$B!!\u0004\u0002\u0014A\u0019q\"a\u0004\n\u0007\u0005E!AA\fMS:,\u0017M\u001d*fOJ,7o]5p]N+X.\\1ss\"A\u0011QCA\u0004\u0001\u0004\t9\"A\u0004eCR\f7/\u001a;\u0011\t\u0005e\u0011qD\u0007\u0003\u00037Q1!!\b\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003C\tYBA\u0005ECR\fgI]1nK\"A\u0011Q\u0005\u0001\u0005\u0002\t\t9#\u0001\u0011gS:$7+^7nCJLXj\u001c3fY\u0006sG\r\u0015:fI&\u001cG/[8o\u0007>dGCAA\u0015!\u0015I\u00131\u0006\u000e(\u0013\r\tiC\u000b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005E\u0002\u0001\"\u0015\u00024\u00059\u0001O]3eS\u000e$HcA\u001e\u00026!9\u0011qGA\u0018\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>\u0005!1m\u001c9z)\rQ\u0012q\b\u0005\t\u0003\u0003\nI\u00041\u0001\u0002D\u0005)Q\r\u001f;sCB!\u0011QIA&\u001b\t\t9EC\u0002\u0002J\u0011\tQ\u0001]1sC6LA!!\u0014\u0002H\tA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0003\u0002:=\f\t&\t\u0002\u0002T\u0005)\u0011G\f\u001b/a!9\u0011q\u000b\u0001\u0005B\u0005e\u0013!B<sSR,WCAA.!\ry\u0012QL\u0005\u0004\u0003?\u0002#\u0001C'M/JLG/\u001a:)\t\u0005Us.\u0019\u0015\u0004\u0001\u0005\u0015\u0004c\u00019\u0002h%\u0019\u0011\u0011N9\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\t\u0001y\u0017QN\u0011\u0003\u0003_\nQ!\r\u00184]A:q!a\u001d\u0003\u0011\u0003\t)(A\u000bMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7\u0011\u0007=\t9H\u0002\u0004\u0002\u0005!\u0005\u0011\u0011P\n\t\u0003o\nY(!!\u0002\bB\u0019\u0011&! \n\u0007\u0005}$F\u0001\u0004B]f\u0014VM\u001a\t\u0005?\u0005\r%$C\u0002\u0002\u0006\u0002\u0012!\"\u0014'SK\u0006$\u0017M\u00197f!\rI\u0013\u0011R\u0005\u0004\u0003\u0017S#\u0001D*fe&\fG.\u001b>bE2,\u0007bB!\u0002x\u0011\u0005\u0011q\u0012\u000b\u0003\u0003kB\u0001\"a%\u0002x\u0011\u0005\u0013QS\u0001\u0005e\u0016\fG-\u0006\u0002\u0002\u0018B!q$!'\u001b\u0013\r\tY\n\t\u0002\t\u001b2\u0013V-\u00193fe\"\"\u0011\u0011S8b\u0011!\t\t+a\u001e\u0005B\u0005\r\u0016\u0001\u00027pC\u0012$2AGAS\u0011\u001d\t9+a(A\u0002\u001d\nA\u0001]1uQ\"\"\u0011qT8b\r%\ti+a\u001e\u0001\u0003o\nyKA\u000eMS:,\u0017M\u001d*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0007\u0003W\u000bY&!-\u0011\t\u0005M\u0016QW\u0007\u0002\r%\u0019\u0011q\u0017\u0004\u0003\u000f1{wmZ5oO\"Q\u00111XAV\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0011%t7\u000f^1oG\u0016Dq!QAV\t\u0003\ty\f\u0006\u0003\u0002B\u0006\u0015\u0007\u0003BAb\u0003Wk!!a\u001e\t\u000f\u0005m\u0016Q\u0018a\u00015\u00199\u0011\u0011ZAV\t\u0006-'\u0001\u0002#bi\u0006\u001c\u0002\"a2\u0002|\u00055\u0017q\u0011\t\u0004S\u0005=\u0017bAAiU\t9\u0001K]8ek\u000e$\b\"C\u001d\u0002H\nU\r\u0011\"\u0001;\u0011%y\u0014q\u0019B\tB\u0003%1\bC\u00055\u0003\u000f\u0014)\u001a!C\u0001k!Iq'a2\u0003\u0012\u0003\u0006IA\u0005\u0005\b\u0003\u0006\u001dG\u0011AAo)\u0019\ty.a9\u0002fB!\u0011\u0011]Ad\u001b\t\tY\u000b\u0003\u0004:\u00037\u0004\ra\u000f\u0005\u0007i\u0005m\u0007\u0019\u0001\n\t\u0015\u0005m\u0012qYA\u0001\n\u0003\tI\u000f\u0006\u0004\u0002`\u0006-\u0018Q\u001e\u0005\ts\u0005\u001d\b\u0013!a\u0001w!AA'a:\u0011\u0002\u0003\u0007!\u0003\u0003\u0006\u0002r\u0006\u001d\u0017\u0013!C\u0001\u0003g\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002v*\u001a1(a>,\u0005\u0005e\b\u0003BA~\u0005\u0007i!!!@\u000b\t\u0005}(\u0011A\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001d\u0016\n\t\t\u0015\u0011Q \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007B\u0003B\u0005\u0003\u000f\f\n\u0011\"\u0001\u0003\f\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0007U\r\u0011\u0012q\u001f\u0005\u000b\u0005#\t9-!A\u0005B\tM\u0011!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0016A!!q\u0003B\u0011\u001b\t\u0011IB\u0003\u0003\u0003\u001c\tu\u0011\u0001\u00027b]\u001eT!Aa\b\u0002\t)\fg/Y\u0005\u0004_\te\u0001\"\u0003B\u0013\u0003\u000f\f\t\u0011\"\u0001f\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\u0011I#a2\u0002\u0002\u0013\u0005!1F\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011iCa\r\u0011\u0007%\u0012y#C\u0002\u00032)\u00121!\u00118z\u0011!1&qEA\u0001\u0002\u00041\u0007B\u0003B\u001c\u0003\u000f\f\t\u0011\"\u0011\u0003:\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003<A1!Q\bB\"\u0005[i!Aa\u0010\u000b\u0007\t\u0005#&\u0001\u0006d_2dWm\u0019;j_:LAA!\u0012\u0003@\tA\u0011\n^3sCR|'\u000f\u0003\u0006\u0003J\u0005\u001d\u0017\u0011!C\u0001\u0005\u0017\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004\u007f\n5\u0003\"\u0003,\u0003H\u0005\u0005\t\u0019\u0001B\u0017\u0011)\u0011\t&a2\u0002\u0002\u0013\u0005#1K\u0001\tQ\u0006\u001c\bnQ8eKR\ta\r\u0003\u0006\u0003X\u0005\u001d\u0017\u0011!C!\u00053\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005+A!B!\u0018\u0002H\u0006\u0005I\u0011\tB0\u0003\u0019)\u0017/^1mgR\u0019qP!\u0019\t\u0013Y\u0013Y&!AA\u0002\t5rA\u0003B3\u0003W\u000b\t\u0011#\u0003\u0003h\u0005!A)\u0019;b!\u0011\t\tO!\u001b\u0007\u0015\u0005%\u00171VA\u0001\u0012\u0013\u0011Yg\u0005\u0004\u0003j\t5\u0014q\u0011\t\t\u0005_\u0012)h\u000f\n\u0002`6\u0011!\u0011\u000f\u0006\u0004\u0005gR\u0013a\u0002:v]RLW.Z\u0005\u0005\u0005o\u0012\tHA\tBEN$(/Y2u\rVt7\r^5p]JBq!\u0011B5\t\u0003\u0011Y\b\u0006\u0002\u0003h!Q!q\u000bB5\u0003\u0003%)E!\u0017\t\u0015\t\u0005%\u0011NA\u0001\n\u0003\u0013\u0019)A\u0003baBd\u0017\u0010\u0006\u0004\u0002`\n\u0015%q\u0011\u0005\u0007s\t}\u0004\u0019A\u001e\t\rQ\u0012y\b1\u0001\u0013\u0011)\u0011YI!\u001b\u0002\u0002\u0013\u0005%QR\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yIa%\u0011\t%R%\u0011\u0013\t\u0006S\u0005-2H\u0005\u0005\u000b\u0005+\u0013I)!AA\u0002\u0005}\u0017a\u0001=%a!Q!\u0011\u0014B5\u0003\u0003%IAa'\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0003BAa\u0006\u0003 &!!\u0011\u0015B\r\u0005\u0019y%M[3di\"A!QUAV\t#\u00129+\u0001\u0005tCZ,\u0017*\u001c9m)\r\u0011&\u0011\u0016\u0005\b\u0003O\u0013\u0019\u000b1\u0001(\r\u001d\u0011i+a\u001e\u0005\u0005_\u00131\u0004T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148\u0003\u0002BV\u0003/Cq!\u0011BV\t\u0003\u0011\u0019\f\u0006\u0002\u00036B!\u00111\u0019BV\u0011)\u0011ILa+C\u0002\u0013%!1C\u0001\nG2\f7o\u001d(b[\u0016D\u0011B!0\u0003,\u0002\u0006IA!\u0006\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005\u0003\u0005\u0002\"\n-F\u0011\tBa)\rQ\"1\u0019\u0005\b\u0003O\u0013y\f1\u0001(\u0011)\u0011I*a\u001e\u0002\u0002\u0013%!1\u0014\u0015\u0005\u0003oz\u0017\r\u000b\u0003\u0002r=\f\u0007")
public class LinearRegressionModel
extends RegressionModel<Vector, LinearRegressionModel>
implements LinearRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private Option<LinearRegressionTrainingSummary> trainingSummary;
    private final int numFeatures;
    private final Param<String> solver;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    public static LinearRegressionModel load(String string) {
        return LinearRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LinearRegressionModel> read() {
        return LinearRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param x$1) {
        this.solver = x$1;
    }

    @Override
    public final String getSolver() {
        return HasSolver$class.getSolver(this);
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    private Option<LinearRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LinearRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public Vector weights() {
        return this.coefficients();
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public LinearRegressionTrainingSummary summary() {
        Option<LinearRegressionTrainingSummary> option = this.trainingSummary();
        if (option instanceof Some) {
            LinearRegressionTrainingSummary summ;
            Some some = (Some)option;
            LinearRegressionTrainingSummary linearRegressionTrainingSummary = summ = (LinearRegressionTrainingSummary)some.x();
            return linearRegressionTrainingSummary;
        }
        None$ none$ = None$.MODULE$;
        Option<LinearRegressionTrainingSummary> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new SparkException("No training summary available for this LinearRegressionModel", (Throwable)new NullPointerException());
        }
        throw new MatchError(option);
    }

    public LinearRegressionModel setSummary(LinearRegressionTrainingSummary summary) {
        this.trainingSummary_$eq((Option<LinearRegressionTrainingSummary>)new Some((Object)summary));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LinearRegressionSummary evaluate(DataFrame dataset) {
        Tuple2<LinearRegressionModel, String> tuple2 = this.findSummaryModelAndPredictionCol();
        if (tuple2 != null) {
            Tuple2 tuple22;
            LinearRegressionModel summaryModel = (LinearRegressionModel)tuple2._1();
            String predictionColName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)predictionColName);
            LinearRegressionModel summaryModel2 = (LinearRegressionModel)tuple23._1();
            String predictionColName2 = (String)tuple23._2();
            return new LinearRegressionSummary(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), this, new double[]{0.0});
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<LinearRegressionModel, String> findSummaryModelAndPredictionCol() {
        Tuple2 tuple2;
        String string;
        String string2 = string = this.$(this.predictionCol());
        if (!("" != null ? !"".equals(string2) : string2 != null)) {
            String predictionColName = new StringBuilder().append((Object)"prediction_").append((Object)UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setPredictionCol(predictionColName), (Object)predictionColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    @Override
    public double predict(Vector features) {
        return BLAS$.MODULE$.dot(features, this.coefficients()) + this.intercept();
    }

    @Override
    public LinearRegressionModel copy(ParamMap extra) {
        LinearRegressionModel newModel = this.copyValues(new LinearRegressionModel(this.uid(), this.coefficients(), this.intercept()), extra);
        Object object = this.trainingSummary().isDefined() ? newModel.setSummary((LinearRegressionTrainingSummary)this.trainingSummary().get()) : BoxedUnit.UNIT;
        return (LinearRegressionModel)newModel.setParent(this.parent());
    }

    @Override
    public MLWriter write() {
        return new LinearRegressionModelWriter(this);
    }

    public LinearRegressionModel(String uid, Vector coefficients, double intercept) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasSolver$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
        this.numFeatures = coefficients.size();
    }

    public static class LinearRegressionModelWriter
    extends MLWriter {
        private final LinearRegressionModel instance;
        private volatile LinearRegressionModel$LinearRegressionModelWriter$Data$ Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LinearRegressionModel$LinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$lzycompute() {
            LinearRegressionModelWriter linearRegressionModelWriter = this;
            synchronized (linearRegressionModelWriter) {
                if (this.Data$module != null) return this.Data$module;
                this.Data$module = new LinearRegressionModel$LinearRegressionModelWriter$Data$(this);
                return this.Data$module;
            }
        }

        public LinearRegressionModel$LinearRegressionModelWriter$Data$ org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data() {
            return this.Data$module == null ? this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$$Data$lzycompute() : this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.intercept(), this.instance.coefficients());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LinearRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.TypeRef().apply($u.ThisType().apply($m.staticClass("org.apache.spark.ml.regression.LinearRegressionModel.LinearRegressionModelWriter")), $u.build().selectType($m.staticClass("org.apache.spark.ml.regression.LinearRegressionModel.LinearRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelWriter$$typecreator1$1(LinearRegressionModelWriter $outer) {
                }
            }
            this.sqlContext().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_LinearRegressionModel$LinearRegressionModelWriter$$typecreator1$1(this))).repartition(1).write().parquet(dataPath);
        }

        public LinearRegressionModelWriter(LinearRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final double intercept;
            private final Vector coefficients;
            public final /* synthetic */ LinearRegressionModelWriter $outer;

            public double intercept() {
                return this.intercept;
            }

            public Vector coefficients() {
                return this.coefficients;
            }

            public Data copy(double intercept, Vector coefficients) {
                return new Data(this.org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$Data$$$outer(), intercept, coefficients);
            }

            public double copy$default$1() {
                return this.intercept();
            }

            public Vector copy$default$2() {
                return this.coefficients();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 2;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 1: {
                        object = this.coefficients();
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToDouble((double)this.intercept());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
                return Statics.finalizeHash((int)n, (int)2);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.intercept() != data.intercept()) return false;
                Vector vector = this.coefficients();
                Vector vector2 = data.coefficients();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!((Object)vector).equals(vector2)) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LinearRegressionModelWriter org$apache$spark$ml$regression$LinearRegressionModel$LinearRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LinearRegressionModelWriter $outer, double intercept, Vector coefficients) {
                this.intercept = intercept;
                this.coefficients = coefficients;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class LinearRegressionModelReader
    extends MLReader<LinearRegressionModel> {
        private final String className = LinearRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LinearRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row data = this.sqlContext().read().format("parquet").load(dataPath).select("intercept", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).head();
            double intercept = data.getDouble(0);
            Vector coefficients = (Vector)data.getAs(1);
            LinearRegressionModel model = new LinearRegressionModel(metadata.uid(), coefficients, intercept);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

