/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00114Q!\u0001\u0002\u0001\r1\u0011\u0011\"T1ue&DX\u000b\u0012+\u000b\u0005\r!\u0011A\u00027j]\u0006dwM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0005\u0002\u0001\u001bA\u0019abE\u000b\u000e\u0003=Q!\u0001E\t\u0002\u000bQL\b/Z:\u000b\u0005I1\u0011aA:rY&\u0011Ac\u0004\u0002\u0010+N,'\u000fR3gS:,G\rV=qKB\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0007\u001b\u0006$(/\u001b=\t\u000bi\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\b\t\u0003-\u0001AQa\b\u0001\u0005B\u0001\nqa]9m)f\u0004X-F\u0001\"!\tq!%\u0003\u0002$\u001f\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\u0015\u0002A\u0011\t\u0014\u0002\u0013M,'/[1mSj,GCA\u0014.!\tA3&D\u0001*\u0015\tQ\u0013#\u0001\u0005dCR\fG._:u\u0013\ta\u0013FA\u0006J]R,'O\\1m%><\b\"\u0002\u0018%\u0001\u0004y\u0013aA8cUB\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t\u0019\u0011I\\=\t\u000bY\u0002A\u0011I\u001c\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0003+aBQ!O\u001bA\u0002=\nQ\u0001Z1uk6DQa\u000f\u0001\u0005Bq\n\u0011\"^:fe\u000ec\u0017m]:\u0016\u0003u\u00022AP!\u0016\u001d\t\u0001t(\u0003\u0002Ac\u00051\u0001K]3eK\u001aL!AQ\"\u0003\u000b\rc\u0017m]:\u000b\u0005\u0001\u000b\u0004\"B#\u0001\t\u00032\u0015AB3rk\u0006d7\u000f\u0006\u0002H\u0015B\u0011\u0001\u0007S\u0005\u0003\u0013F\u0012qAQ8pY\u0016\fg\u000eC\u0003L\t\u0002\u0007q&A\u0001p\u0011\u0015i\u0005\u0001\"\u0011O\u0003!A\u0017m\u001d5D_\u0012,G#A(\u0011\u0005A\u0002\u0016BA)2\u0005\rIe\u000e\u001e\u0005\u0006'\u0002!\t\u0005V\u0001\tif\u0004XMT1nKV\tQ\u000b\u0005\u0002?-&\u0011qk\u0011\u0002\u0007'R\u0014\u0018N\\4\t\u000be\u0003A\u0011\t+\u0002\u000bALX\u000b\u0012+\t\rm\u0003A\u0011\t\u0004]\u0003)\t7OT;mY\u0006\u0014G.Z\u000b\u0002;!\u0012\u0001A\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u001a\t!\"\u00198o_R\fG/[8o\u0013\t\u0019\u0007M\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public class MatrixUDT
extends UserDefinedType<Matrix> {
    public StructType sqlType() {
        return StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numRows", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numCols", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("colPtrs", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("rowIndices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("isTransposed", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4())})));
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow serialize(Object obj) {
        Object object;
        block4: {
            void var2_2;
            block3: {
                GenericMutableRow row;
                block2: {
                    row = new GenericMutableRow(7);
                    object = obj;
                    if (!(object instanceof SparseMatrix)) break block2;
                    SparseMatrix sparseMatrix = (SparseMatrix)object;
                    row.setByte(0, (byte)0);
                    row.setInt(1, sparseMatrix.numRows());
                    row.setInt(2, sparseMatrix.numCols());
                    row.update(3, (Object)new GenericArrayData((Object[])Predef$.MODULE$.intArrayOps(sparseMatrix.colPtrs()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(int x$1) {
                            return BoxesRunTime.boxToInteger((int)x$1);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))));
                    row.update(4, (Object)new GenericArrayData((Object[])Predef$.MODULE$.intArrayOps(sparseMatrix.rowIndices()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(int x$2) {
                            return BoxesRunTime.boxToInteger((int)x$2);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))));
                    row.update(5, (Object)new GenericArrayData((Object[])Predef$.MODULE$.doubleArrayOps(sparseMatrix.values()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Object apply(double x$3) {
                            return BoxesRunTime.boxToDouble((double)x$3);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))));
                    row.setBoolean(6, sparseMatrix.isTransposed());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(object instanceof DenseMatrix)) break block4;
                DenseMatrix denseMatrix = (DenseMatrix)object;
                row.setByte(0, (byte)1);
                row.setInt(1, denseMatrix.numRows());
                row.setInt(2, denseMatrix.numCols());
                row.setNullAt(3);
                row.setNullAt(4);
                row.update(5, (Object)new GenericArrayData((Object[])Predef$.MODULE$.doubleArrayOps(denseMatrix.values()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(double x$4) {
                        return BoxesRunTime.boxToDouble((double)x$4);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))));
                row.setBoolean(6, denseMatrix.isTransposed());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return var2_2;
        }
        throw new MatchError(object);
    }

    public Matrix deserialize(Object datum) {
        Object object = datum;
        if (object instanceof InternalRow) {
            Matrix matrix;
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 7, (Function0)new Serializable(this, internalRow){
                public static final long serialVersionUID = 0L;
                private final InternalRow x2$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MatrixUDT.deserialize given row with length ", " but requires length == 7"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.x2$1.numFields())}));
                }
                {
                    this.x2$1 = x2$1;
                }
            });
            byte tpe = internalRow.getByte(0);
            int numRows2 = internalRow.getInt(1);
            int numCols = internalRow.getInt(2);
            double[] values = internalRow.getArray(5).toDoubleArray();
            boolean isTransposed = internalRow.getBoolean(6);
            byte by = tpe;
            switch (by) {
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
                case 1: {
                    matrix = new DenseMatrix(numRows2, numCols, values, isTransposed);
                    break;
                }
                case 0: {
                    int[] colPtrs = internalRow.getArray(3).toIntArray();
                    int[] rowIndices = internalRow.getArray(4).toIntArray();
                    matrix = new SparseMatrix(numRows2, numCols, colPtrs, rowIndices, values, isTransposed);
                }
            }
            DenseMatrix denseMatrix = matrix;
            return denseMatrix;
        }
        throw new MatchError(object);
    }

    public Class<Matrix> userClass() {
        return Matrix.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof MatrixUDT;
        return bl;
    }

    public int hashCode() {
        return MatrixUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "matrix";
    }

    public String pyUDT() {
        return "pyspark.mllib.linalg.MatrixUDT";
    }

    public MatrixUDT asNullable() {
        return this;
    }
}

