/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tA!\u001e;jY&\u0011A$\u0007\u0002\t'\u00064X-\u00192mK\"Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\no>\u0014H-\u00138eKb,\u0012\u0001\t\t\u0005C\u0011:#F\u0004\u0002\u0010E%\u00111\u0005E\u0001\u0007!J,G-\u001a4\n\u0005\u00152#aA'ba*\u00111\u0005\u0005\t\u0003C!J!!\u000b\u0014\u0003\rM#(/\u001b8h!\ty1&\u0003\u0002-!\t\u0019\u0011J\u001c;\t\u00119\u0002!\u0011!Q\u0001\n\u0001\n!b^8sI&sG-\u001a=!\u0011%\u0001\u0004A!b\u0001\n\u00031\u0011'A\u0006x_J$g+Z2u_J\u001cX#\u0001\u001a\u0011\u0007=\u0019T'\u0003\u00025!\t)\u0011I\u001d:bsB\u0011qBN\u0005\u0003oA\u0011QA\u00127pCRD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IAM\u0001\ro>\u0014HMV3di>\u00148\u000f\t\u0005\u0007w\u0001!\tA\u0002\u001f\u0002\rqJg.\u001b;?)\rit\b\u0011\t\u0003}\u0001i\u0011A\u0001\u0005\u0006=i\u0002\r\u0001\t\u0005\u0006ai\u0002\rA\r\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0003!qW/\\,pe\u0012\u001cX#\u0001\u0016\t\r\u0015\u0003\u0001\u0015!\u0003+\u0003%qW/\\,pe\u0012\u001c\b\u0005C\u0004H\u0001\t\u0007I\u0011B\"\u0002\u0015Y,7\r^8s'&TX\r\u0003\u0004J\u0001\u0001\u0006IAK\u0001\fm\u0016\u001cGo\u001c:TSj,\u0007\u0005C\u0004L\u0001\t\u0007I\u0011\u0002'\u0002\u0011]|'\u000f\u001a'jgR,\u0012!\u0014\t\u0004\u001fM:\u0003BB(\u0001A\u0003%Q*A\u0005x_J$G*[:uA!9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0016\u0001D<pe\u00124Vm\u0019(pe6\u001cX#A*\u0011\u0007=\u0019D\u000b\u0005\u0002\u0010+&\u0011a\u000b\u0005\u0002\u0007\t>,(\r\\3\t\ra\u0003\u0001\u0015!\u0003T\u000359xN\u001d3WK\u000etuN]7tA!)1\b\u0001C\u00015R\u0011Qh\u0017\u0005\u00069f\u0003\r!X\u0001\u0006[>$W\r\u001c\t\u0005C\u0011:#\u0007K\u0002Z?\u0016\u0004\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002eC\n)1+\u001b8dK\u0006\na-A\u00032]Ur\u0003\u0007C\u0003i\u0001\u0011E\u0013.A\u0007g_Jl\u0017\r\u001e,feNLwN\\\u000b\u0002UB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0005Y\u0006twMC\u0001p\u0003\u0011Q\u0017M^1\n\u0005%b\u0007\"\u0002:\u0001\t\u0003\u0019\u0018\u0001B:bm\u0016$2\u0001^<~!\tyQ/\u0003\u0002w!\t!QK\\5u\u0011\u0015A\u0018\u000f1\u0001z\u0003\t\u00198\r\u0005\u0002{w6\ta!\u0003\u0002}\r\ta1\u000b]1sW\u000e{g\u000e^3yi\")a0\u001da\u0001O\u0005!\u0001/\u0019;iQ\u0011\tx,!\u0001\"\u0005\u0005\r\u0011!B\u0019/i9\u0002\u0004bBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\niJ\fgn\u001d4pe6$B!a\u0003\u0002\u0018A!\u0011QBA\n\u001b\t\tyAC\u0002\u0002\u0012\u0011\ta\u0001\\5oC2<\u0017\u0002BA\u000b\u0003\u001f\u0011aAV3di>\u0014\bbBA\r\u0003\u000b\u0001\raJ\u0001\u0005o>\u0014H\rK\u0003\u0002\u0006}\u000bi\"\t\u0002\u0002 \u0005)\u0011GL\u0019/a!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012\u0001\u00044j]\u0012\u001c\u0016P\\8os6\u001cHCBA\u0014\u0003_\t\t\u0004\u0005\u0003\u0010g\u0005%\u0002#B\b\u0002,\u001d\"\u0016bAA\u0017!\t1A+\u001e9mKJBq!!\u0007\u0002\"\u0001\u0007q\u0005C\u0004\u00024\u0005\u0005\u0002\u0019\u0001\u0016\u0002\u00079,X\u000eK\u0003\u0002\"}\u000bi\u0002C\u0004\u0002$\u0001!\t!!\u000f\u0015\r\u0005\u001d\u00121HA \u0011!\ti$a\u000eA\u0002\u0005-\u0011A\u0002<fGR|'\u000fC\u0004\u00024\u0005]\u0002\u0019\u0001\u0016)\u000b\u0005]r,!\b\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005Qq-\u001a;WK\u000e$xN]:\u0016\u0003uCS!a\u0011`\u0003\u0017\n#!!\u0014\u0002\u000bEr#G\f\u0019)\t\u0001y\u0016QD\u0004\b\u0003'\u0012\u0001\u0012AA+\u000359vN\u001d33-\u0016\u001cWj\u001c3fYB\u0019a(a\u0016\u0007\r\u0005\u0011\u0001\u0012AA-'\u0019\t9FDA.)A!\u0001$!\u0018>\u0013\r\ty&\u0007\u0002\u0007\u0019>\fG-\u001a:\t\u000fm\n9\u0006\"\u0001\u0002dQ\u0011\u0011Q\u000b\u0005\t\u0003O\n9\u0006\"\u0003\u0002j\u0005q!-^5mI^{'\u000fZ%oI\u0016DHc\u0001\u0011\u0002l!1A,!\u001aA\u0002uC\u0001\"a\u001c\u0002X\u0011%\u0011\u0011O\u0001\u0011EVLG\u000eZ,pe\u00124Vm\u0019;peN$2AMA:\u0011\u0019a\u0016Q\u000ea\u0001;\u001eA\u0011qOA,\u0011\u0013\tI(\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007\u0005\u0003\u0002|\u0005uTBAA,\r!\ty(a\u0016\t\n\u0005\u0005%\u0001D*bm\u0016du.\u00193Wc}\u00034cAA?\u001d!91(! \u0005\u0002\u0005\u0015ECAA=\u0011%\tI)! C\u0002\u0013\u0005\u0011.A\tg_Jl\u0017\r\u001e,feNLwN\u001c,2?BB\u0001\"!$\u0002~\u0001\u0006IA[\u0001\u0013M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003\u0004\u0005C\u0005\u0002\u0012\u0006u$\u0019!C\u0001S\u0006i1\r\\1tg:\u000bW.\u001a,2?BB\u0001\"!&\u0002~\u0001\u0006IA[\u0001\u000fG2\f7o\u001d(b[\u00164\u0016g\u0018\u0019!\r\u001d\tI*! A\u00037\u0013A\u0001R1uCN1\u0011q\u0013\b\u0002\u001eR\u00012aDAP\u0013\r\t\t\u000b\u0005\u0002\b!J|G-^2u\u0011-\tI\"a&\u0003\u0016\u0004%\t!!*\u0016\u0003\u001dB!\"!+\u0002\u0018\nE\t\u0015!\u0003(\u0003\u00159xN\u001d3!\u0011)\ti$a&\u0003\u0016\u0004%\t!\r\u0005\u000b\u0003_\u000b9J!E!\u0002\u0013\u0011\u0014a\u0002<fGR|'\u000f\t\u0005\bw\u0005]E\u0011AAZ)\u0019\t),!/\u0002<B!\u0011qWAL\u001b\t\ti\bC\u0004\u0002\u001a\u0005E\u0006\u0019A\u0014\t\u000f\u0005u\u0012\u0011\u0017a\u0001e!Q\u0011qXAL\u0003\u0003%\t!!1\u0002\t\r|\u0007/\u001f\u000b\u0007\u0003k\u000b\u0019-!2\t\u0013\u0005e\u0011Q\u0018I\u0001\u0002\u00049\u0003\"CA\u001f\u0003{\u0003\n\u00111\u00013\u0011)\tI-a&\u0012\u0002\u0013\u0005\u00111Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tiMK\u0002(\u0003\u001f\\#!!5\u0011\t\u0005M\u00171\\\u0007\u0003\u0003+TA!a6\u0002Z\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003EBIA!!8\u0002V\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0005\u0018qSI\u0001\n\u0003\t\u0019/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015(f\u0001\u001a\u0002P\"I\u0011\u0011^AL\u0003\u0003%\t%[\u0001\u000eaJ|G-^2u!J,g-\u001b=\t\u0013\u00055\u0018qSA\u0001\n\u0003\u0019\u0015\u0001\u00049s_\u0012,8\r^!sSRL\bBCAy\u0003/\u000b\t\u0011\"\u0001\u0002t\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA{\u0003w\u00042aDA|\u0013\r\tI\u0010\u0005\u0002\u0004\u0003:L\b\"CA\u007f\u0003_\f\t\u00111\u0001+\u0003\rAH%\r\u0005\u000b\u0005\u0003\t9*!A\u0005B\t\r\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0001C\u0002B\u0004\u0005\u001b\t)0\u0004\u0002\u0003\n)\u0019!1\u0002\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0010\t%!\u0001C%uKJ\fGo\u001c:\t\u0015\tM\u0011qSA\u0001\n\u0003\u0011)\"\u0001\u0005dC:,\u0015/^1m)\u0011\u00119B!\b\u0011\u0007=\u0011I\"C\u0002\u0003\u001cA\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002~\nE\u0011\u0011!a\u0001\u0003kD!B!\t\u0002\u0018\u0006\u0005I\u0011\tB\u0012\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0016\t\u0015\t\u001d\u0012qSA\u0001\n\u0003\u0012I#\u0001\u0005u_N#(/\u001b8h)\u0005Q\u0007B\u0003B\u0017\u0003/\u000b\t\u0011\"\u0011\u00030\u00051Q-];bYN$BAa\u0006\u00032!Q\u0011Q B\u0016\u0003\u0003\u0005\r!!>\b\u0015\tU\u0012QPA\u0001\u0012\u0003\u00119$\u0001\u0003ECR\f\u0007\u0003BA\\\u0005s1!\"!'\u0002~\u0005\u0005\t\u0012\u0001B\u001e'\u0015\u0011ID!\u0010\u0015!!\u0011yD!\u0012(e\u0005UVB\u0001B!\u0015\r\u0011\u0019\u0005E\u0001\beVtG/[7f\u0013\u0011\u00119E!\u0011\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004<\u0005s!\tAa\u0013\u0015\u0005\t]\u0002B\u0003B\u0014\u0005s\t\t\u0011\"\u0012\u0003*!Q!\u0011\u000bB\u001d\u0003\u0003%\tIa\u0015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005U&Q\u000bB,\u0011\u001d\tIBa\u0014A\u0002\u001dBq!!\u0010\u0003P\u0001\u0007!\u0007\u0003\u0006\u0003\\\te\u0012\u0011!CA\u0005;\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003`\t\u001d\u0004#B\b\u0003b\t\u0015\u0014b\u0001B2!\t1q\n\u001d;j_:\u0004RaDA\u0016OIB!B!\u001b\u0003Z\u0005\u0005\t\u0019AA[\u0003\rAH\u0005\r\u0005\u000b\u0005[\u0012I$!A\u0005\n\t=\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u001d\u0011\u0007-\u0014\u0019(C\u0002\u0003v1\u0014aa\u00142kK\u000e$\b\u0002\u0003B=\u0003{\"\tAa\u001f\u0002\t1|\u0017\r\u001a\u000b\u0006{\tu$q\u0010\u0005\u0007q\n]\u0004\u0019A=\t\ry\u00149\b1\u0001(\u0011\u001d\u0011\u0018Q\u0010C\u0001\u0005\u0007#r\u0001\u001eBC\u0005\u000f\u0013I\t\u0003\u0004y\u0005\u0003\u0003\r!\u001f\u0005\u0007}\n\u0005\u0005\u0019A\u0014\t\rq\u0013\t\t1\u0001^\u0011!\u0011I(a\u0016\u0005B\t5E#B\u001f\u0003\u0010\nE\u0005B\u0002=\u0003\f\u0002\u0007\u0011\u0010\u0003\u0004\u007f\u0005\u0017\u0003\ra\n\u0015\u0006\u0005\u0017{\u0016\u0011\u0001\u0005\u000b\u0005[\n9&!A\u0005\n\t=\u0004&BA,?\u0006\u0005\u0001&BA)?\u0006\u0005\u0001")
public class Word2VecModel
implements Serializable,
Saveable {
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    private final String[] wordList;
    private final double[] wordVecNorms;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    public int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() {
        return this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    }

    private String[] wordList() {
        return this.wordList;
    }

    private double[] wordVecNorms() {
        return this.wordVecNorms;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.wordIndex().get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            int ind = BoxesRunTime.unboxToInt((Object)some.x());
            float[] vec = (float[])Predef$.MODULE$.floatArrayOps(this.wordVectors()).slice(ind * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), ind * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() + this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
            Vector vector = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.floatArrayOps(vec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(float x$8) {
                    return this.apply$mcDF$sp(x$8);
                }

                public double apply$mcDF$sp(float x$8) {
                    return x$8;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            return vector;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not in vocabulary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num);
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        Predef$.MODULE$.require(num > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of similar words should > 0";
            }
        });
        float[] fVector = (float[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(double x$9) {
                return this.apply$mcFD$sp(x$9);
            }

            public float apply$mcFD$sp(double x$9) {
                return (float)x$9;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = (float[])Array$.MODULE$.fill(this.numWords(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        float alpha = 1.0f;
        float beta = 0.0f;
        float vecNorm = BLAS.getInstance().snrm2(this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), fVector, 1);
        if (vecNorm != 0.0f) {
            BLAS.getInstance().sscal(this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), 1.0f / vecNorm, fVector, 0, 1);
        }
        BLAS.getInstance().sgemv("T", this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), this.numWords(), alpha, this.wordVectors(), this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), fVector, 1, beta, cosineVec, 1);
        double[] cosVec = (double[])Predef$.MODULE$.floatArrayOps(cosineVec).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$10) {
                return this.apply$mcDF$sp(x$10);
            }

            public double apply$mcDF$sp(float x$10) {
                return x$10;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        for (int ind = 0; ind < this.numWords(); ++ind) {
            double norm2 = this.wordVecNorms()[ind];
            if (norm2 == 0.0) {
                cosVec[ind] = 0.0;
                continue;
            }
            int n = ind;
            cosVec[n] = cosVec[n] / norm2;
        }
        return (Tuple2[])((TraversableOnce)((TraversableLike)((IterableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.wordList()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(cosVec), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<String, Object> x$11) {
                return -x$11._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).take(num + 1)).tail()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;

            public final Tuple2<String, float[]> apply(Tuple2<String, Object> x0$4) {
                Tuple2<String, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    String word = (String)tuple2._1();
                    int ind = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)word, Predef$.MODULE$.floatArrayOps(this.$outer.wordVectors()).slice(this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind, this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind + this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize = wordVectors.length / this.numWords();
        Tuple2 tuple2 = ((GenericTraversableTemplate)wordIndex.toSeq().sortBy((Function1)new $anonfun$12(this), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Seq wl;
            Seq seq;
            Seq wl2 = seq = (wl = (Seq)tuple2._1());
            this.wordList = (String[])wl2.toArray(ClassTag$.MODULE$.apply(String.class));
            double[] wordVecNorms = new double[this.numWords()];
            for (int i = 0; i < this.numWords(); ++i) {
                float[] vec = (float[])Predef$.MODULE$.floatArrayOps(wordVectors).slice(i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() + this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
                wordVecNorms[i] = BLAS.getInstance().snrm2(this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), vec, 1);
            }
            this.wordVecNorms = wordVecNorms;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

