/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix$;
import breeze.linalg.NumericOps;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.StorageVector;
import breeze.linalg.Tensor$;
import breeze.linalg.TensorLike;
import breeze.linalg.Vector$;
import breeze.storage.Zero;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseMatrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.BlockMatrix$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.apache.spark.mllib.linalg.distributed.IndexedRow;
import org.apache.spark.mllib.linalg.distributed.IndexedRowMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001=\u00111B\u00117pG.l\u0015\r\u001e:jq*\u00111\u0001B\u0001\fI&\u001cHO]5ckR,GM\u0003\u0002\u0006\r\u00051A.\u001b8bY\u001eT!a\u0002\u0005\u0002\u000b5dG.\u001b2\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!YQ\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t\tB)[:ue&\u0014W\u000f^3e\u001b\u0006$(/\u001b=\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011)\u0019!C\u0001E\u00051!\r\\8dWN,\u0012a\t\t\u0004I\u001dJS\"A\u0013\u000b\u0005\u0019B\u0011a\u0001:eI&\u0011\u0001&\n\u0002\u0004%\u0012#\u0005\u0003B\t+YAJ!a\u000b\n\u0003\rQ+\b\u000f\\33!\u0011\t\"&L\u0017\u0011\u0005Eq\u0013BA\u0018\u0013\u0005\rIe\u000e\u001e\t\u0003cIj\u0011\u0001B\u0005\u0003g\u0011\u0011a!T1ue&D\bf\u0001\u00116wA\u0011a'O\u0007\u0002o)\u0011\u0001\bC\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u001e8\u0005\u0015\u0019\u0016N\\2fC\u0005a\u0014!B\u0019/g9\u0002\u0004\u0002\u0003 \u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\u000f\tdwnY6tA!\u001aQ(N\u001e\t\u0011\u0005\u0003!Q1A\u0005\u0002\t\u000bAB]8xgB+'O\u00117pG.,\u0012!\f\u0015\u0004\u0001VZ\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u001bI|wo\u001d)fe\ncwnY6!Q\r!Ug\u000f\u0005\t\u0011\u0002\u0011)\u0019!C\u0001\u0005\u0006a1m\u001c7t!\u0016\u0014(\t\\8dW\"\u001aq)N\u001e\t\u0011-\u0003!\u0011!Q\u0001\n5\nQbY8mgB+'O\u00117pG.\u0004\u0003f\u0001&6w!Aa\n\u0001BA\u0002\u0013%q*A\u0003o%><8/F\u0001Q!\t\t\u0012+\u0003\u0002S%\t!Aj\u001c8h\u0011!!\u0006A!a\u0001\n\u0013)\u0016!\u00038S_^\u001cx\fJ3r)\t1\u0016\f\u0005\u0002\u0012/&\u0011\u0001L\u0005\u0002\u0005+:LG\u000fC\u0004['\u0006\u0005\t\u0019\u0001)\u0002\u0007a$\u0013\u0007\u0003\u0005]\u0001\t\u0005\t\u0015)\u0003Q\u0003\u0019q'k\\<tA!Aa\f\u0001BA\u0002\u0013%q*A\u0003o\u0007>d7\u000f\u0003\u0005a\u0001\t\u0005\r\u0011\"\u0003b\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u0002WE\"9!lXA\u0001\u0002\u0004\u0001\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0015\u0002)\u0002\r9\u001cu\u000e\\:!\u0011\u00151\u0007\u0001\"\u0001h\u0003\u0019a\u0014N\\5u}Q1\u0001.[6n_B\u0004\"a\u0006\u0001\t\u000b\u0005*\u0007\u0019A\u0012)\u0007%,4\bC\u0003BK\u0002\u0007Q\u0006K\u0002lkmBQ\u0001S3A\u00025B3!\\\u001b<\u0011\u0015qU\r1\u0001Q\u0011\u0015qV\r1\u0001QQ\r)WgO\u0003\u0005g\u0002!\u0011FA\u0006NCR\u0014\u0018\u000e\u001f\"m_\u000e\\\u0007\"\u00024\u0001\t\u0003)H\u0003\u00025wobDQ!\t;A\u0002\rBQ!\u0011;A\u00025BQ\u0001\u0013;A\u00025B3\u0001^\u001b<\u0011\u0015Y\b\u0001\"\u0011}\u0003\u001dqW/\u001c*poN$\u0012\u0001\u0015\u0015\u0004uVZ\u0004\"B@\u0001\t\u0003b\u0018a\u00028v[\u000e{Gn\u001d\u0015\u0004}VZ\u0004\u0002CA\u0003\u0001\t\u0007I\u0011\u0001\"\u0002\u00199,XNU8x\u00052|7m[:)\t\u0005\rQg\u000f\u0005\b\u0003\u0017\u0001\u0001\u0015!\u0003.\u00035qW/\u001c*po\ncwnY6tA!\"\u0011\u0011B\u001b<\u0011!\t\t\u0002\u0001b\u0001\n\u0003\u0011\u0015\u0001\u00048v[\u000e{GN\u00117pG.\u001c\b\u0006BA\bkmBq!a\u0006\u0001A\u0003%Q&A\u0007ok6\u001cu\u000e\u001c\"m_\u000e\\7\u000f\t\u0015\u0005\u0003+)4\b\u0003\u0005\u0002\u001e\u0001!\tABA\u0010\u0003E\u0019'/Z1uKB\u000b'\u000f^5uS>tWM\u001d\u000b\u0003\u0003C\u00012aFA\u0012\u0013\r\t)C\u0001\u0002\u0010\u000fJLG\rU1si&$\u0018n\u001c8fe\"Q\u0011\u0011\u0006\u0001\t\u0006\u0004%I!a\u000b\u0002\u0013\tdwnY6J]\u001a|WCAA\u0017!\u0011!s%a\f\u0011\tEQC\u0006\f\u0005\u000b\u0003g\u0001\u0001\u0012!Q!\n\u00055\u0012A\u00032m_\u000e\\\u0017J\u001c4pA!9\u0011q\u0007\u0001\u0005\n\u0005e\u0012aC3ti&l\u0017\r^3ES6$\u0012A\u0016\u0005\b\u0003{\u0001A\u0011AA\u001d\u0003!1\u0018\r\\5eCR,\u0007\u0006BA\u001ekmBq!a\u0011\u0001\t\u0003\t)%A\u0003dC\u000eDW\r\u0006\u0002\u0002H5\t\u0001\u0001\u000b\u0003\u0002BUZ\u0004bBA'\u0001\u0011\u0005\u0011qJ\u0001\ba\u0016\u00148/[:u)\u0011\t9%!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003+\nAb\u001d;pe\u0006<W\rT3wK2\u0004B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0004\u00037B\u0011aB:u_J\fw-Z\u0005\u0005\u0003?\nIF\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u000b\u0003\u0002LUZ\u0004bBA3\u0001\u0011\u0005\u0011qM\u0001\u0013i>\u001cun\u001c:eS:\fG/Z'biJL\u0007\u0010\u0006\u0002\u0002jA\u0019q#a\u001b\n\u0007\u00055$A\u0001\tD_>\u0014H-\u001b8bi\u0016l\u0015\r\u001e:jq\"\"\u00111M\u001b<\u0011\u001d\t\u0019\b\u0001C\u0001\u0003k\n!\u0003^8J]\u0012,\u00070\u001a3S_^l\u0015\r\u001e:jqR\u0011\u0011q\u000f\t\u0004/\u0005e\u0014bAA>\u0005\t\u0001\u0012J\u001c3fq\u0016$'k\\<NCR\u0014\u0018\u000e\u001f\u0015\u0005\u0003c*4\bC\u0004\u0002\u0002\u0002!\t!a!\u0002\u001bQ|Gj\\2bY6\u000bGO]5y)\u0005\u0001\u0004\u0006BA@kmBq!!#\u0001\t\u0003\tY)A\u0005ue\u0006t7\u000f]8tKV\t\u0001\u000e\u000b\u0003\u0002\bVZ\u0004\u0002CAI\u0001\u0011\u0005a!a%\u0002\u0011Q|'I]3fu\u0016$\"!!&\u0011\r\u0005]\u0015qTAR\u001b\t\tIJC\u0002\u0006\u00037S!!!(\u0002\r\t\u0014X-\u001a>f\u0013\u0011\t\t+!'\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\t\u0004#\u0005\u0015\u0016bAAT%\t1Ai\\;cY\u0016D\u0001\"a+\u0001\t\u00031\u0011QV\u0001\tE2|7m['baR)\u0001.a,\u00024\"9\u0011\u0011WAU\u0001\u0004A\u0017!B8uQ\u0016\u0014\b\u0002CA[\u0003S\u0003\r!a.\u0002\r\tLg.T1q!%\t\u0012\u0011XA_\u0003{\u000bi,C\u0002\u0002<J\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\r\u0005]\u0015qXAR\u0013\r\u0019\u0014\u0011\u0014\u0005\b\u0003\u0007\u0004A\u0011AAc\u0003\r\tG\r\u001a\u000b\u0004Q\u0006\u001d\u0007bBAY\u0003\u0003\u0004\r\u0001\u001b\u0015\u0005\u0003\u0003,4\bC\u0004\u0002N\u0002!\t!a4\u0002\u0011M,(\r\u001e:bGR$2\u0001[Ai\u0011\u001d\t\t,a3A\u0002!DS!a36\u0003+\f#!a6\u0002\u000bIr\u0003G\f\u0019\u0006\r\u0005m\u0007\u0001BAo\u0005E\u0011En\\2l\t\u0016\u001cH/\u001b8bi&|gn\u001d\t\b\u0003?\f)\u000fLAv\u001d\r\t\u0012\u0011]\u0005\u0004\u0003G\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002h\u0006%(aA'ba*\u0019\u00111\u001d\n\u0011\u000b\u0005}\u0017Q^\u0017\n\t\u0005=\u0018\u0011\u001e\u0002\u0004'\u0016$\b\u0002CAz\u0001\u0011\u0005!!!>\u0002!MLW.\u001e7bi\u0016lU\u000f\u001c;ja2LHCBA|\u0003w\fi\u0010\u0005\u0004\u0012U\u0005e\u0018\u0011 \t\u0005\u0003\u000f\nI\u000eC\u0004\u00022\u0006E\b\u0019\u00015\t\u0011\u0005}\u0018\u0011\u001fa\u0001\u0003C\t1\u0002]1si&$\u0018n\u001c8fe\"9!1\u0001\u0001\u0005\u0002\t\u0015\u0011\u0001C7vYRL\u0007\u000f\\=\u0015\u0007!\u00149\u0001C\u0004\u00022\n\u0005\u0001\u0019\u00015)\t\t\u0005Qg\u000f\u0015\u0004\u0001UZ\u0004")
public class BlockMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks;
    private final int rowsPerBlock;
    private final int colsPerBlock;
    private long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows;
    private long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols;
    private final int numRowBlocks;
    private final int numColBlocks;
    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    private RDD blockInfo$lzycompute() {
        BlockMatrix blockMatrix = this;
        synchronized (blockMatrix) {
            if (!this.bitmap$0) {
                this.blockInfo = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Matrix block) {
                        return new Tuple2.mcII.sp(block.numRows(), block.numCols());
                    }
                }).cache();
                this.bitmap$0 = true;
            }
            return this.blockInfo;
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks() {
        return this.blocks;
    }

    public int rowsPerBlock() {
        return this.rowsPerBlock;
    }

    public int colsPerBlock() {
        return this.colsPerBlock;
    }

    public long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows = x$1;
    }

    public long org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols() {
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols;
    }

    private void org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols = x$1;
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows() <= 0L) {
            this.estimateDim();
        }
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows();
    }

    @Override
    public long numCols() {
        if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols() <= 0L) {
            this.estimateDim();
        }
        return this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols();
    }

    public int numRowBlocks() {
        return this.numRowBlocks;
    }

    public int numColBlocks() {
        return this.numColBlocks;
    }

    public GridPartitioner createPartitioner() {
        return GridPartitioner$.MODULE$.apply(this.numRowBlocks(), this.numColBlocks(), this.blocks().partitions().length);
    }

    private RDD<Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>>> blockInfo() {
        return this.bitmap$0 ? this.blockInfo : this.blockInfo$lzycompute();
    }

    private void estimateDim() {
        Tuple2 tuple2 = (Tuple2)this.blockInfo().map((Function1)new $anonfun$3(this), ClassTag$.MODULE$.apply(Tuple2.class)).reduce((Function2)new $anonfun$4(this));
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long rows = tuple2._1$mcJ$sp();
            long cols = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(rows, cols);
            long rows2 = sp3._1$mcJ$sp();
            long cols2 = sp3._2$mcJ$sp();
            if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows() <= 0L) {
                this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows_$eq(rows2);
            }
            Predef$.MODULE$.assert(rows2 <= this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows(), (Function0)new Serializable(this, rows2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockMatrix $outer;
                private final long rows$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is more than claimed ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.rows$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.rows$1 = rows$1;
                }
            });
            if (this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols() <= 0L) {
                this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols_$eq(cols2);
            }
            Predef$.MODULE$.assert(cols2 <= this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols(), (Function0)new Serializable(this, cols2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ BlockMatrix $outer;
                private final long cols$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of columns ", " is more than claimed ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cols$1), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.cols$1 = cols$1;
                }
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public void validate() {
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Validating BlockMatrix...";
            }
        });
        this.estimateDim();
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BlockMatrix dimensions are okay...";
            }
        });
        RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).countByKey().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Tuple2<Object, Object>, Object> x0$2) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 key = (Tuple2)tuple2._1();
                    long cnt = tuple2._2$mcJ$sp();
                    if (cnt > 1L) {
                        throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found multiple MatrixBlocks with the indices ", ". Please "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).append((Object)"remove blocks with duplicate indices.").toString());
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "MatrixBlock indices are okay...";
            }
        });
        String dimensionMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimensions different than rowsPerBlock: ", ", and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rowsPerBlock())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"colsPerBlock: ", ". Blocks on the right and bottom edges can have smaller "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsPerBlock())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimensions. You may use the repartition method to fix this issue."})).s((Seq)Nil$.MODULE$)).toString();
        this.blockInfo().foreach((Function1)new Serializable(this, dimensionMsg){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final String dimensionMsg$1;

            public final void apply(Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> x0$3) {
                Tuple2<Tuple2<Object, Object>, Tuple2<Object, Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        if (tuple23 != null) {
                            int m = tuple23._1$mcI$sp();
                            int n = tuple23._2$mcI$sp();
                            if (blockRowIndex < this.$outer.numRowBlocks() - 1 && m != this.$outer.rowsPerBlock() || blockRowIndex == this.$outer.numRowBlocks() - 1 && (m <= 0 || m > this.$outer.rowsPerBlock())) {
                                throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The MatrixBlock at (", ", ", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).append((Object)this.dimensionMsg$1).toString());
                            }
                            if (blockColIndex < this.$outer.numColBlocks() - 1 && n != this.$outer.colsPerBlock() || blockColIndex == this.$outer.numColBlocks() - 1 && (n <= 0 || n > this.$outer.colsPerBlock())) {
                                throw new SparkException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The MatrixBlock at (", ", ", ") has "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).append((Object)this.dimensionMsg$1).toString());
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dimensionMsg$1 = dimensionMsg$1;
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "MatrixBlock dimensions are okay...";
            }
        });
        this.logDebug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BlockMatrix is valid!";
            }
        });
    }

    public BlockMatrix cache() {
        this.blocks().cache();
        return this;
    }

    public BlockMatrix persist(StorageLevel storageLevel) {
        this.blocks().persist(storageLevel);
        return this;
    }

    public CoordinateMatrix toCoordinateMatrix() {
        RDD entryRDD = this.blocks().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final ArrayBuffer<MatrixEntry> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$4) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$4;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix mat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        long rowStart = (long)blockRowIndex * (long)this.$outer.rowsPerBlock();
                        long colStart = (long)blockColIndex * (long)this.$outer.colsPerBlock();
                        ArrayBuffer entryValues = new ArrayBuffer();
                        mat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, rowStart, colStart, entryValues){
                            public static final long serialVersionUID = 0L;
                            private final long rowStart$1;
                            private final long colStart$1;
                            private final ArrayBuffer entryValues$1;

                            public final void apply(int i, int j, double v) {
                                if (v != 0.0) {
                                    this.entryValues$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatrixEntry[]{new MatrixEntry(this.rowStart$1 + (long)i, this.colStart$1 + (long)j, v)}));
                                }
                            }
                            {
                                this.rowStart$1 = rowStart$1;
                                this.colStart$1 = colStart$1;
                                this.entryValues$1 = entryValues$1;
                            }
                        });
                        ArrayBuffer arrayBuffer = entryValues;
                        return arrayBuffer;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)entryRDD, this.numRows(), this.numCols());
    }

    public IndexedRowMatrix toIndexedRowMatrix() {
        int cols = (int)this.numCols();
        Predef$.MODULE$.require(cols < Integer.MAX_VALUE, (Function0)new Serializable(this, cols){
            public static final long serialVersionUID = 0L;
            private final int cols$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of columns should be less than Int.MaxValue (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cols$2)}));
            }
            {
                this.cols$2 = cols$2;
            }
        });
        RDD rows = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final Iterator<Tuple2<Object, Tuple2<Object, breeze.linalg.Vector<Object>>>> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$5) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$5;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix mat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIdx = tuple22._1$mcI$sp();
                        int blockColIdx = tuple22._2$mcI$sp();
                        Iterator iterator = mat.rowIter().zipWithIndex().map((Function1)new Serializable(this, blockRowIdx, blockColIdx){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final int blockRowIdx$1;
                            private final int blockColIdx$1;

                            public final Tuple2<Object, Tuple2<Object, breeze.linalg.Vector<Object>>> apply(Tuple2<Vector, Object> x0$6) {
                                Tuple2<Vector, Object> tuple2 = x0$6;
                                if (tuple2 != null) {
                                    Vector vector = (Vector)tuple2._1();
                                    int rowIdx = tuple2._2$mcI$sp();
                                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)(this.blockRowIdx$1 * this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$anonfun$$$outer().rowsPerBlock() + rowIdx))), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)this.blockColIdx$1), vector.asBreeze()));
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.blockRowIdx$1 = blockRowIdx$1;
                                this.blockColIdx$1 = blockColIdx$1;
                            }
                        });
                        return iterator;
                    }
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ BlockMatrix org$apache$spark$mllib$linalg$distributed$BlockMatrix$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).groupByKey().map((Function1)new Serializable(this, cols){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            public final int cols$2;

            public final IndexedRow apply(Tuple2<Object, Iterable<Tuple2<Object, breeze.linalg.Vector<Object>>>> x0$7) {
                Tuple2<Object, Iterable<Tuple2<Object, breeze.linalg.Vector<Object>>>> tuple2 = x0$7;
                if (tuple2 != null) {
                    int rowIdx = tuple2._1$mcI$sp();
                    Iterable vectors = (Iterable)tuple2._2();
                    double numberNonZeroPerRow = (double)BoxesRunTime.unboxToInt((Object)((TraversableOnce)vectors.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<Object, breeze.linalg.Vector<Object>> x$2) {
                            return ((TensorLike)x$2._2()).activeSize();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / (double)this.cols$2;
                    SparseVector wholeVector = numberNonZeroPerRow <= 0.1 ? SparseVector$.MODULE$.zeros$mDc$sp(this.cols$2, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$) : DenseVector$.MODULE$.zeros$mDc$sp(this.cols$2, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                    vectors.foreach((Function1)new Serializable(this, (StorageVector)wholeVector){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$7 $outer;
                        private final StorageVector wholeVector$1;

                        public final breeze.linalg.Vector<Object> apply(Tuple2<Object, breeze.linalg.Vector<Object>> x0$8) {
                            Tuple2<Object, breeze.linalg.Vector<Object>> tuple2 = x0$8;
                            if (tuple2 != null) {
                                int blockColIdx = tuple2._1$mcI$sp();
                                breeze.linalg.Vector vec = (breeze.linalg.Vector)tuple2._2();
                                int n = blockColIdx;
                                if (vec != null) {
                                    breeze.linalg.Vector vector = vec;
                                    int offset = this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$anonfun$$$outer().colsPerBlock() * n;
                                    breeze.linalg.Vector vector2 = (breeze.linalg.Vector)((NumericOps)this.wholeVector$1.apply((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), Math.min(this.$outer.cols$2, offset + this.$outer.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$anonfun$$$outer().colsPerBlock())), Tensor$.MODULE$.canSliceTensor(ClassTag$.MODULE$.Double()))).$colon$eq((Object)vector, (UFunc.InPlaceImpl2)Vector$.MODULE$.v_v_UpdateOp_Double_OpSet());
                                    return vector2;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.wholeVector$1 = wholeVector$1;
                        }
                    });
                    IndexedRow indexedRow = new IndexedRow(rowIdx, Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)wholeVector));
                    return indexedRow;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ BlockMatrix org$apache$spark$mllib$linalg$distributed$BlockMatrix$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.cols$2 = cols$2;
            }
        }, ClassTag$.MODULE$.apply(IndexedRow.class));
        return new IndexedRowMatrix((RDD<IndexedRow>)rows);
    }

    public Matrix toLocalMatrix() {
        Predef$.MODULE$.require(this.numRows() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of rows of this matrix should be less than ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Int.MaxValue. Currently numRows: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numRows())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.numCols() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of columns of this matrix should be less than ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Int.MaxValue. Currently numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(this.numRows() * this.numCols() < Integer.MAX_VALUE, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;

            public final String apply() {
                return new StringBuilder().append((Object)"The length of the values array must be ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"less than Int.MaxValue. Currently numRows * numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.$outer.numRows() * this.$outer.numCols()))}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        int mem = m * n / 125000;
        if (mem > 500) {
            this.logWarning((Function0<String>)new Serializable(this, mem){
                public static final long serialVersionUID = 0L;
                private final int mem$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Storing this matrix will require ", " MB of memory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.mem$1)}));
                }
                {
                    this.mem$1 = mem$1;
                }
            });
        }
        Tuple2[] localBlocks = (Tuple2[])this.blocks().collect();
        double[] values = new double[m * n];
        Predef$.MODULE$.refArrayOps((Object[])localBlocks).foreach((Function1)new Serializable(this, m, values){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            public final int m$1;
            public final double[] values$1;

            public final void apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$9) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$9;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix submat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        int rowOffset = blockRowIndex * this.$outer.rowsPerBlock();
                        int colOffset = blockColIndex * this.$outer.colsPerBlock();
                        submat.foreachActive((Function3<Object, Object, Object, BoxedUnit>)new Serializable(this, rowOffset, colOffset){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$toLocalMatrix$5 $outer;
                            private final int rowOffset$1;
                            private final int colOffset$1;

                            public final void apply(int i, int j, double v) {
                                int indexOffset = (j + this.colOffset$1) * this.$outer.m$1 + this.rowOffset$1 + i;
                                this.$outer.values$1[indexOffset] = v;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.rowOffset$1 = rowOffset$1;
                                this.colOffset$1 = colOffset$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.m$1 = m$1;
                this.values$1 = values$1;
            }
        });
        return new DenseMatrix(m, n, values);
    }

    public BlockMatrix transpose() {
        RDD transposedBlocks = this.blocks().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Tuple2<Object, Object>, Matrix> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$10) {
                Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$10;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Matrix mat = (Matrix)tuple2._2();
                    if (tuple22 != null) {
                        int blockRowIndex = tuple22._1$mcI$sp();
                        int blockColIndex = tuple22._2$mcI$sp();
                        Tuple2 tuple23 = new Tuple2((Object)new Tuple2.mcII.sp(blockColIndex, blockRowIndex), (Object)mat.transpose());
                        return tuple23;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)transposedBlocks, this.colsPerBlock(), this.rowsPerBlock(), this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols(), this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows());
    }

    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        Matrix localMat = this.toLocalMatrix();
        return new DenseMatrix.mcD.sp(localMat.numRows(), localMat.numCols(), localMat.toArray());
    }

    public BlockMatrix blockMap(BlockMatrix other, Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>> binMap) {
        Predef$.MODULE$.require(this.numRows() == other.numRows(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final BlockMatrix other$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Both matrices must have the same number of rows. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.numRows: ", ", B.numRows: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numRows()), BoxesRunTime.boxToLong((long)this.other$1.numRows())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        Predef$.MODULE$.require(this.numCols() == other.numCols(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final BlockMatrix other$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Both matrices must have the same number of columns. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.numCols: ", ", B.numCols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols()), BoxesRunTime.boxToLong((long)this.other$1.numCols())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$1 = other$1;
            }
        });
        if (this.rowsPerBlock() == other.rowsPerBlock() && this.colsPerBlock() == other.colsPerBlock()) {
            RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(this.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).cogroup(other.blocks(), (Partitioner)this.createPartitioner()).map((Function1)new Serializable(this, binMap){
                public static final long serialVersionUID = 0L;
                private final Function2 binMap$1;

                public final Tuple2<Tuple2<Object, Object>, Matrix> apply(Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Matrix>, Iterable<Matrix>>> x0$11) {
                    Tuple2<Tuple2<Object, Object>, Tuple2<Iterable<Matrix>, Iterable<Matrix>>> tuple2 = x0$11;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        Tuple2 tuple23 = (Tuple2)tuple2._2();
                        if (tuple22 != null) {
                            int blockRowIndex = tuple22._1$mcI$sp();
                            int blockColIndex = tuple22._2$mcI$sp();
                            if (tuple23 != null) {
                                Tuple2 tuple24;
                                Iterable a = (Iterable)tuple23._1();
                                Iterable b = (Iterable)tuple23._2();
                                if (a.size() > 1 || b.size() > 1) {
                                    throw new SparkException(new StringBuilder().append((Object)"There are multiple MatrixBlocks with indices: ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ", ", "). Please remove them."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)blockRowIndex), BoxesRunTime.boxToInteger((int)blockColIndex)}))).toString());
                                }
                                if (a.isEmpty()) {
                                    breeze.linalg.Matrix zeroBlock = Matrix$.MODULE$.zeros$mDc$sp(((Matrix)b.head()).numRows(), ((Matrix)b.head()).numCols(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                                    breeze.linalg.Matrix result = (breeze.linalg.Matrix)this.binMap$1.apply((Object)zeroBlock, ((Matrix)b.head()).asBreeze());
                                    tuple24 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
                                } else if (b.isEmpty()) {
                                    tuple24 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), a.head());
                                } else {
                                    breeze.linalg.Matrix result = (breeze.linalg.Matrix)this.binMap$1.apply(((Matrix)a.head()).asBreeze(), ((Matrix)b.head()).asBreeze());
                                    tuple24 = new Tuple2((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Object)Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)result));
                                }
                                Tuple2 tuple25 = tuple24;
                                return tuple25;
                            }
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.binMap$1 = binMap$1;
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), this.colsPerBlock(), this.numRows(), this.numCols());
        }
        throw new SparkException("Cannot perform on matrices with different block dimensions");
    }

    public BlockMatrix add(BlockMatrix other) {
        return this.blockMap(other, (Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.Matrix<Object> apply(breeze.linalg.Matrix<Object> x, breeze.linalg.Matrix<Object> y) {
                return (breeze.linalg.Matrix)x.$plus(y, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd());
            }
        });
    }

    public BlockMatrix subtract(BlockMatrix other) {
        return this.blockMap(other, (Function2<breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>, breeze.linalg.Matrix<Object>>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.Matrix<Object> apply(breeze.linalg.Matrix<Object> x, breeze.linalg.Matrix<Object> y) {
                return (breeze.linalg.Matrix)x.$minus(y, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpSub());
            }
        });
    }

    public Tuple2<Map<Tuple2<Object, Object>, Set<Object>>, Map<Tuple2<Object, Object>, Set<Object>>> simulateMultiply(BlockMatrix other, GridPartitioner partitioner) {
        Tuple2[] leftMatrix = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(this.blockInfo(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).keys().collect();
        Tuple2[] rightMatrix = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(other.blocks(), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).keys().collect();
        Map rightCounterpartsHelper = Predef$.MODULE$.refArrayOps((Object[])rightMatrix).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$3) {
                return x$3._1$mcI$sp();
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int[] apply(Tuple2<Object, Object>[] x$4) {
                return (int[])Predef$.MODULE$.refArrayOps((Object[])x$4).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$5) {
                        return x$5._2$mcI$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            }
        });
        Map leftDestinations = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])leftMatrix).map((Function1)new Serializable(this, partitioner, rightCounterpartsHelper){
            public static final long serialVersionUID = 0L;
            public final GridPartitioner partitioner$1;
            private final Map rightCounterpartsHelper$1;

            public final Tuple2<Tuple2<Object, Object>, Set<Object>> apply(Tuple2<Object, Object> x0$12) {
                Tuple2<Object, Object> tuple2 = x0$12;
                if (tuple2 != null) {
                    int rowIndex = tuple2._1$mcI$sp();
                    int colIndex = tuple2._2$mcI$sp();
                    int[] rightCounterparts = (int[])this.rightCounterpartsHelper$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)colIndex), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int[] apply() {
                            return (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
                        }
                    });
                    int[] partitions = (int[])Predef$.MODULE$.intArrayOps(rightCounterparts).map((Function1)new Serializable(this, rowIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$13 $outer;
                        private final int rowIndex$1;

                        public final int apply(int b) {
                            return this.apply$mcII$sp(b);
                        }

                        public int apply$mcII$sp(int b) {
                            return this.$outer.partitioner$1.getPartition(new Tuple2.mcII.sp(this.rowIndex$1, b));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rowIndex$1 = rowIndex$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(rowIndex, colIndex), (Object)Predef$.MODULE$.intArrayOps(partitions).toSet());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.partitioner$1 = partitioner$1;
                this.rightCounterpartsHelper$1 = rightCounterpartsHelper$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        Map leftCounterpartsHelper = Predef$.MODULE$.refArrayOps((Object[])leftMatrix).groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$6) {
                return x$6._2$mcI$sp();
            }
        }).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int[] apply(Tuple2<Object, Object>[] x$7) {
                return (int[])Predef$.MODULE$.refArrayOps((Object[])x$7).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$8) {
                        return x$8._1$mcI$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            }
        });
        Map rightDestinations = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rightMatrix).map((Function1)new Serializable(this, partitioner, leftCounterpartsHelper){
            public static final long serialVersionUID = 0L;
            public final GridPartitioner partitioner$1;
            private final Map leftCounterpartsHelper$1;

            public final Tuple2<Tuple2<Object, Object>, Set<Object>> apply(Tuple2<Object, Object> x0$13) {
                Tuple2<Object, Object> tuple2 = x0$13;
                if (tuple2 != null) {
                    int rowIndex = tuple2._1$mcI$sp();
                    int colIndex = tuple2._2$mcI$sp();
                    int[] leftCounterparts = (int[])this.leftCounterpartsHelper$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)rowIndex), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int[] apply() {
                            return (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int());
                        }
                    });
                    int[] partitions = (int[])Predef$.MODULE$.intArrayOps(leftCounterparts).map((Function1)new Serializable(this, colIndex){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$17 $outer;
                        private final int colIndex$1;

                        public final int apply(int b) {
                            return this.apply$mcII$sp(b);
                        }

                        public int apply$mcII$sp(int b) {
                            return this.$outer.partitioner$1.getPartition(new Tuple2.mcII.sp(b, this.colIndex$1));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.colIndex$1 = colIndex$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(rowIndex, colIndex), (Object)Predef$.MODULE$.intArrayOps(partitions).toSet());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.partitioner$1 = partitioner$1;
                this.leftCounterpartsHelper$1 = leftCounterpartsHelper$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        return new Tuple2((Object)leftDestinations, (Object)rightDestinations);
    }

    public BlockMatrix multiply(BlockMatrix other) {
        Predef$.MODULE$.require(this.numCols() == other.numRows(), (Function0)new Serializable(this, other){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BlockMatrix $outer;
            private final BlockMatrix other$2;

            public final String apply() {
                return new StringBuilder().append((Object)"The number of columns of A and the number of rows ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"of B must be equal. A.numCols: ", ", B.numRows: ", ". If you "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.numCols()), BoxesRunTime.boxToLong((long)this.other$2.numRows())}))).append((Object)"think they should be equal, try setting the dimensions of A and B explicitly while ").append((Object)"initializing them.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.other$2 = other$2;
            }
        });
        if (this.colsPerBlock() == other.rowsPerBlock()) {
            GridPartitioner resultPartitioner = GridPartitioner$.MODULE$.apply(this.numRowBlocks(), other.numColBlocks(), package$.MODULE$.max(this.blocks().partitions().length, other.blocks().partitions().length));
            Tuple2<Map<Tuple2<Object, Object>, Set<Object>>, Map<Tuple2<Object, Object>, Set<Object>>> tuple2 = this.simulateMultiply(other, resultPartitioner);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Map leftDestinations = (Map)tuple2._1();
                Map rightDestinations = (Map)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)leftDestinations, (Object)rightDestinations);
                Map leftDestinations2 = (Map)tuple23._1();
                Map rightDestinations2 = (Map)tuple23._2();
                RDD flatA = this.blocks().flatMap((Function1)new Serializable(this, leftDestinations2){
                    public static final long serialVersionUID = 0L;
                    private final Map leftDestinations$1;

                    public final Set<Tuple2<Object, Tuple3<Object, Object, Matrix>>> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$14) {
                        Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$14;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Matrix block = (Matrix)tuple2._2();
                            if (tuple22 != null) {
                                int blockRowIndex = tuple22._1$mcI$sp();
                                int blockColIndex = tuple22._2$mcI$sp();
                                Set destinations = (Set)this.leftDestinations$1.getOrElse((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Set<Object> apply() {
                                        return Predef$.MODULE$.Set().empty();
                                    }
                                });
                                Set set = (Set)destinations.map((Function1)new Serializable(this, blockRowIndex, blockColIndex, block){
                                    public static final long serialVersionUID = 0L;
                                    private final int blockRowIndex$1;
                                    private final int blockColIndex$1;
                                    private final Matrix block$1;

                                    public final Tuple2<Object, Tuple3<Object, Object, Matrix>> apply(int j) {
                                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.blockRowIndex$1), (Object)BoxesRunTime.boxToInteger((int)this.blockColIndex$1), (Object)this.block$1));
                                    }
                                    {
                                        this.blockRowIndex$1 = blockRowIndex$1;
                                        this.blockColIndex$1 = blockColIndex$1;
                                        this.block$1 = block$1;
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                return set;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.leftDestinations$1 = leftDestinations$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                RDD flatB = other.blocks().flatMap((Function1)new Serializable(this, rightDestinations2){
                    public static final long serialVersionUID = 0L;
                    private final Map rightDestinations$1;

                    public final Set<Tuple2<Object, Tuple3<Object, Object, Matrix>>> apply(Tuple2<Tuple2<Object, Object>, Matrix> x0$15) {
                        Tuple2<Tuple2<Object, Object>, Matrix> tuple2 = x0$15;
                        if (tuple2 != null) {
                            Tuple2 tuple22 = (Tuple2)tuple2._1();
                            Matrix block = (Matrix)tuple2._2();
                            if (tuple22 != null) {
                                int blockRowIndex = tuple22._1$mcI$sp();
                                int blockColIndex = tuple22._2$mcI$sp();
                                Set destinations = (Set)this.rightDestinations$1.getOrElse((Object)new Tuple2.mcII.sp(blockRowIndex, blockColIndex), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Set<Object> apply() {
                                        return Predef$.MODULE$.Set().empty();
                                    }
                                });
                                Set set = (Set)destinations.map((Function1)new Serializable(this, blockRowIndex, blockColIndex, block){
                                    public static final long serialVersionUID = 0L;
                                    private final int blockRowIndex$2;
                                    private final int blockColIndex$2;
                                    private final Matrix block$2;

                                    public final Tuple2<Object, Tuple3<Object, Object, Matrix>> apply(int j) {
                                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)j), (Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.blockRowIndex$2), (Object)BoxesRunTime.boxToInteger((int)this.blockColIndex$2), (Object)this.block$2));
                                    }
                                    {
                                        this.blockRowIndex$2 = blockRowIndex$2;
                                        this.blockColIndex$2 = blockColIndex$2;
                                        this.block$2 = block$2;
                                    }
                                }, Set$.MODULE$.canBuildFrom());
                                return set;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.rightDestinations$1 = rightDestinations$1;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                RDD newBlocks = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(flatA, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Int$.MODULE$).cogroup(flatB, (Partitioner)resultPartitioner).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Tuple2<Tuple2<Object, Object>, breeze.linalg.Matrix<Object>>> apply(Tuple2<Object, Tuple2<Iterable<Tuple3<Object, Object, Matrix>>, Iterable<Tuple3<Object, Object, Matrix>>>> x0$16) {
                        Tuple2 tuple2;
                        Tuple2<Object, Tuple2<Iterable<Tuple3<Object, Object, Matrix>>, Iterable<Tuple3<Object, Object, Matrix>>>> tuple22 = x0$16;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            Iterable a = (Iterable)tuple2._1();
                            Iterable b = (Iterable)tuple2._2();
                            Iterable iterable = (Iterable)a.flatMap((Function1)new Serializable(this, b){
                                public static final long serialVersionUID = 0L;
                                private final Iterable b$1;

                                public final Iterable<Tuple2<Tuple2<Object, Object>, breeze.linalg.Matrix<Object>>> apply(Tuple3<Object, Object, Matrix> x0$17) {
                                    Tuple3<Object, Object, Matrix> tuple3 = x0$17;
                                    if (tuple3 != null) {
                                        int leftRowIndex = BoxesRunTime.unboxToInt((Object)tuple3._1());
                                        int leftColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                        Matrix leftBlock = (Matrix)tuple3._3();
                                        Iterable iterable = (Iterable)((TraversableLike)this.b$1.filter((Function1)new Serializable(this, leftColIndex){
                                            public static final long serialVersionUID = 0L;
                                            private final int leftColIndex$1;

                                            public final boolean apply(Tuple3<Object, Object, Matrix> x$10) {
                                                return BoxesRunTime.unboxToInt((Object)x$10._1()) == this.leftColIndex$1;
                                            }
                                            {
                                                this.leftColIndex$1 = leftColIndex$1;
                                            }
                                        })).map((Function1)new Serializable(this, leftRowIndex, leftBlock){
                                            public static final long serialVersionUID = 0L;
                                            private final int leftRowIndex$1;
                                            private final Matrix leftBlock$1;

                                            public final Tuple2<Tuple2<Object, Object>, breeze.linalg.Matrix<Object>> apply(Tuple3<Object, Object, Matrix> x0$18) {
                                                Tuple3<Object, Object, Matrix> tuple3;
                                                block2: {
                                                    Matrix rightBlock;
                                                    block5: {
                                                        DenseMatrix denseMatrix;
                                                        int rightColIndex;
                                                        block4: {
                                                            Matrix matrix;
                                                            block3: {
                                                                tuple3 = x0$18;
                                                                if (tuple3 == null) break block2;
                                                                rightColIndex = BoxesRunTime.unboxToInt((Object)tuple3._2());
                                                                rightBlock = (Matrix)tuple3._3();
                                                                matrix = rightBlock;
                                                                if (!(matrix instanceof DenseMatrix)) break block3;
                                                                DenseMatrix denseMatrix2 = (DenseMatrix)matrix;
                                                                denseMatrix = this.leftBlock$1.multiply(denseMatrix2);
                                                                break block4;
                                                            }
                                                            if (!(matrix instanceof SparseMatrix)) break block5;
                                                            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                                                            denseMatrix = this.leftBlock$1.multiply(sparseMatrix.toDense());
                                                        }
                                                        DenseMatrix C = denseMatrix;
                                                        Tuple2 tuple2 = new Tuple2((Object)new Tuple2.mcII.sp(this.leftRowIndex$1, rightColIndex), C.asBreeze());
                                                        return tuple2;
                                                    }
                                                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unrecognized matrix type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rightBlock.getClass()})));
                                                }
                                                throw new MatchError(tuple3);
                                            }
                                            {
                                                this.leftRowIndex$1 = leftRowIndex$1;
                                                this.leftBlock$1 = leftBlock$1;
                                            }
                                        }, Iterable$.MODULE$.canBuildFrom());
                                        return iterable;
                                    }
                                    throw new MatchError(tuple3);
                                }
                                {
                                    this.b$1 = b$1;
                                }
                            }, Iterable$.MODULE$.canBuildFrom());
                            return iterable;
                        }
                        throw new MatchError(tuple22);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Partitioner)resultPartitioner, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final breeze.linalg.Matrix<Object> apply(breeze.linalg.Matrix<Object> a, breeze.linalg.Matrix<Object> b) {
                        return (breeze.linalg.Matrix)a.$plus(b, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd());
                    }
                }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(breeze.linalg.Matrix.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matrix apply(breeze.linalg.Matrix<Object> breeze) {
                        return Matrices$.MODULE$.fromBreeze(breeze);
                    }
                });
                return new BlockMatrix((RDD<Tuple2<Tuple2<Object, Object>, Matrix>>)newBlocks, this.rowsPerBlock(), other.colsPerBlock(), this.numRows(), other.numCols());
            }
            throw new MatchError(tuple2);
        }
        throw new SparkException(new StringBuilder().append((Object)"colsPerBlock of A doesn't match rowsPerBlock of B. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A.colsPerBlock: ", ", B.rowsPerBlock: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.colsPerBlock()), BoxesRunTime.boxToInteger((int)other.rowsPerBlock())}))).toString());
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock, long nRows, long nCols) {
        this.blocks = blocks;
        this.rowsPerBlock = rowsPerBlock;
        this.colsPerBlock = colsPerBlock;
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nRows = nRows;
        this.org$apache$spark$mllib$linalg$distributed$BlockMatrix$$nCols = nCols;
        Logging.class.$init$((Logging)this);
        this.numRowBlocks = (int)package$.MODULE$.ceil((double)this.numRows() * 1.0 / (double)rowsPerBlock);
        this.numColBlocks = (int)package$.MODULE$.ceil((double)this.numCols() * 1.0 / (double)colsPerBlock);
    }

    public BlockMatrix(RDD<Tuple2<Tuple2<Object, Object>, Matrix>> blocks, int rowsPerBlock, int colsPerBlock) {
        this(blocks, rowsPerBlock, colsPerBlock, 0L, 0L);
    }
}

