/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.util;

import java.util.List;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.LinearDataGenerator$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.util.Random;

@DeveloperApi
public final class LinearDataGenerator$ {
    public static final LinearDataGenerator$ MODULE$;

    static {
        new LinearDataGenerator$();
    }

    public List<LabeledPoint> generateLinearInputAsList(double intercept, double[] weights, int nPoints, int seed, double eps) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.generateLinearInput(intercept, weights, nPoints, seed, eps)).asJava();
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, int nPoints, int seed, double eps) {
        return this.generateLinearInput(intercept, weights, (double[])Array$.MODULE$.fill(weights.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.fill(weights.length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.3333333333333333;
            }
        }, ClassTag$.MODULE$.Double()), nPoints, seed, eps);
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, double[] xMean, double[] xVariance, int nPoints, int seed, double eps) {
        return this.generateLinearInput(intercept, weights, xMean, xVariance, nPoints, seed, eps, 0.0);
    }

    public Seq<LabeledPoint> generateLinearInput(double intercept, double[] weights, double[] xMean, double[] xVariance, int nPoints, int seed, double eps, double sparsity) {
        Predef$.MODULE$.require(0.0 <= sparsity && sparsity <= 1.0);
        Random rnd = new Random(seed);
        return sparsity == 0.0 ? (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(intercept, weights, xMean, xVariance, eps, rnd){
            public static final long serialVersionUID = 0L;
            private final double intercept$1;
            private final double[] weights$1;
            public final double[] xMean$1;
            public final double[] xVariance$1;
            private final double eps$1;
            public final Random rnd$1;

            public final LabeledPoint apply(int x$1) {
                Vector features = Vectors$.MODULE$.dense((double[])((TraversableOnce)Predef$.MODULE$.doubleArrayOps(this.weights$1).indices().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateLinearInput.3 $outer;

                    public final double apply(int x$2) {
                        return this.apply$mcDI$sp(x$2);
                    }

                    public double apply$mcDI$sp(int x$2) {
                        return LinearDataGenerator$.MODULE$.org$apache$spark$mllib$util$LinearDataGenerator$$rndElement$1(x$2, this.$outer.xMean$1, this.$outer.xVariance$1, this.$outer.rnd$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                double label = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(this.weights$1), features) + this.intercept$1 + this.eps$1 * this.rnd$1.nextGaussian();
                return new LabeledPoint(label, features);
            }
            {
                this.intercept$1 = intercept$1;
                this.weights$1 = weights$1;
                this.xMean$1 = xMean$1;
                this.xVariance$1 = xVariance$1;
                this.eps$1 = eps$1;
                this.rnd$1 = rnd$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()) : (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPoints).map((Function1)new Serializable(intercept, weights, xMean, xVariance, eps, sparsity, rnd){
            public static final long serialVersionUID = 0L;
            private final double intercept$1;
            private final double[] weights$1;
            public final double[] xMean$1;
            public final double[] xVariance$1;
            private final double eps$1;
            public final double sparsity$1;
            public final Random rnd$1;

            public final LabeledPoint apply(int x$3) {
                IndexedSeq indices = (IndexedSeq)Predef$.MODULE$.doubleArrayOps(this.weights$1).indices().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateLinearInput.4 $outer;

                    public final boolean apply(int x$4) {
                        return this.apply$mcZI$sp(x$4);
                    }

                    public boolean apply$mcZI$sp(int x$4) {
                        return this.$outer.rnd$1.nextDouble() <= this.$outer.sparsity$1;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                IndexedSeq values = (IndexedSeq)indices.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.generateLinearInput.4 $outer;

                    public final double apply(int x$5) {
                        return this.apply$mcDI$sp(x$5);
                    }

                    public double apply$mcDI$sp(int x$5) {
                        return LinearDataGenerator$.MODULE$.org$apache$spark$mllib$util$LinearDataGenerator$$rndElement$1(x$5, this.$outer.xMean$1, this.$outer.xVariance$1, this.$outer.rnd$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                Vector features = Vectors$.MODULE$.sparse(this.weights$1.length, (int[])indices.toArray(ClassTag$.MODULE$.Int()), (double[])values.toArray(ClassTag$.MODULE$.Double()));
                double label = BLAS$.MODULE$.dot(Vectors$.MODULE$.dense(this.weights$1), features) + this.intercept$1 + this.eps$1 * this.rnd$1.nextGaussian();
                return new LabeledPoint(label, features);
            }
            {
                this.intercept$1 = intercept$1;
                this.weights$1 = weights$1;
                this.xMean$1 = xMean$1;
                this.xVariance$1 = xVariance$1;
                this.eps$1 = eps$1;
                this.sparsity$1 = sparsity$1;
                this.rnd$1 = rnd$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public double generateLinearInput$default$5() {
        return 0.1;
    }

    public RDD<LabeledPoint> generateLinearRDD(SparkContext sc, int nexamples, int nfeatures, double eps, int nparts, double intercept) {
        Random random = new Random(42);
        double[] w2 = (double[])Array$.MODULE$.fill(nfeatures, (Function0)new Serializable(random){
            public static final long serialVersionUID = 0L;
            private final Random random$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.random$1.nextDouble() - 0.5;
            }
            {
                this.random$1 = random$1;
            }
        }, ClassTag$.MODULE$.Double());
        RDD data = sc.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nparts), nparts, ClassTag$.MODULE$.Int()).flatMap((Function1)new Serializable(nexamples, eps, nparts, intercept, w2){
            public static final long serialVersionUID = 0L;
            private final int nexamples$1;
            private final double eps$2;
            private final int nparts$1;
            private final double intercept$2;
            private final double[] w$1;

            public final Seq<LabeledPoint> apply(int p) {
                int seed = 42 + p;
                int examplesInPartition = this.nexamples$1 / this.nparts$1;
                return LinearDataGenerator$.MODULE$.generateLinearInput(this.intercept$2, (double[])Predef$.MODULE$.doubleArrayOps(this.w$1).toArray(ClassTag$.MODULE$.Double()), examplesInPartition, seed, this.eps$2);
            }
            {
                this.nexamples$1 = nexamples$1;
                this.eps$2 = eps$2;
                this.nparts$1 = nparts$1;
                this.intercept$2 = intercept$2;
                this.w$1 = w$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
        return data;
    }

    public int generateLinearRDD$default$5() {
        return 2;
    }

    public double generateLinearRDD$default$6() {
        return 0.0;
    }

    public void main(String[] args) {
        if (args.length < 2) {
            Predef$.MODULE$.println((Object)"Usage: LinearDataGenerator <master> <output_dir> [num_examples] [num_features] [num_partitions]");
            System.exit(1);
        }
        String sparkMaster = args[0];
        String outputPath = args[1];
        int nexamples = args.length > 2 ? new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt() : 1000;
        int nfeatures = args.length > 3 ? new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt() : 100;
        int parts = args.length > 4 ? new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt() : 2;
        int eps = 10;
        SparkContext sc = new SparkContext(sparkMaster, "LinearDataGenerator");
        RDD<LabeledPoint> data = this.generateLinearRDD(sc, nexamples, nfeatures, eps, parts, this.generateLinearRDD$default$6());
        data.saveAsTextFile(outputPath);
        sc.stop();
    }

    public final double org$apache$spark$mllib$util$LinearDataGenerator$$rndElement$1(int i, double[] xMean$1, double[] xVariance$1, Random rnd$1) {
        return (rnd$1.nextDouble() - 0.5) * package$.MODULE$.sqrt(12.0 * xVariance$1[i]) + xMean$1[i];
    }

    private LinearDataGenerator$() {
        MODULE$ = this;
    }
}

