/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.Classifier$;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.classification.ClassifierParams$class;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasRawPredictionCol$class;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001y4Q!\u0001\u0002\u0002\u00025\u0011!b\u00117bgNLg-[3s\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0005\u001dU\u0011\u0003fE\u0002\u0001\u001f9\u0002R\u0001E\t\u0014C\u001dj\u0011\u0001B\u0005\u0003%\u0011\u0011\u0011\u0002\u0015:fI&\u001cGo\u001c:\u0011\u0005Q)B\u0002\u0001\u0003\u0006-\u0001\u0011\ra\u0006\u0002\r\r\u0016\fG/\u001e:fgRK\b/Z\t\u00031y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011qAT8uQ&tw\r\u0005\u0002\u001a?%\u0011\u0001E\u0007\u0002\u0004\u0003:L\bC\u0001\u000b#\t\u0015\u0019\u0003A1\u0001%\u0005\u0005)\u0015C\u0001\r&!\u00151\u0003aE\u0011(\u001b\u0005\u0011\u0001C\u0001\u000b)\t\u0015I\u0003A1\u0001+\u0005\u0005i\u0015C\u0001\r,!\u00111CfE\u0014\n\u00055\u0012!aE\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007C\u0001\u00140\u0013\t\u0001$A\u0001\tDY\u0006\u001c8/\u001b4jKJ\u0004\u0016M]1ng\")!\u0007\u0001C\u0001g\u00051A(\u001b8jiz\"\u0012!\n\u0005\u0006k\u0001!\tAN\u0001\u0014g\u0016$(+Y<Qe\u0016$\u0017n\u0019;j_:\u001cu\u000e\u001c\u000b\u0003C]BQ\u0001\u000f\u001bA\u0002e\nQA^1mk\u0016\u0004\"AO\u001f\u000f\u0005eY\u0014B\u0001\u001f\u001b\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qR\u0002\"B!\u0001\t#\u0011\u0015\u0001F3yiJ\f7\r\u001e'bE\u0016dW\r\u001a)pS:$8\u000fF\u0002D\u001fn\u00032\u0001R$J\u001b\u0005)%B\u0001$\u0007\u0003\r\u0011H\rZ\u0005\u0003\u0011\u0016\u00131A\u0015#E!\tQU*D\u0001L\u0015\taE!A\u0004gK\u0006$XO]3\n\u00059[%\u0001\u0004'bE\u0016dW\r\u001a)pS:$\b\"\u0002)A\u0001\u0004\t\u0016a\u00023bi\u0006\u001cX\r\u001e\u0019\u0003%f\u00032a\u0015,Y\u001b\u0005!&BA+\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003/R\u0013q\u0001R1uCN,G\u000f\u0005\u0002\u00153\u0012I!lTA\u0001\u0002\u0003\u0015\ta\u0006\u0002\u0004?\u0012\n\u0004\"\u0002/A\u0001\u0004i\u0016A\u00038v[\u000ec\u0017m]:fgB\u0011\u0011DX\u0005\u0003?j\u00111!\u00138u\u0011\u0015\t\u0007\u0001\"\u0005c\u000359W\r\u001e(v[\u000ec\u0017m]:fgR\u0019QlY5\t\u000bA\u0003\u0007\u0019\u000131\u0005\u0015<\u0007cA*WMB\u0011Ac\u001a\u0003\nQ\u000e\f\t\u0011!A\u0003\u0002]\u00111a\u0018\u00133\u0011\u001dQ\u0007\r%AA\u0002u\u000bQ\"\\1y\u001dVl7\t\\1tg\u0016\u001c\bb\u00027\u0001#\u0003%\t\"\\\u0001\u0018O\u0016$h*^7DY\u0006\u001c8/Z:%I\u00164\u0017-\u001e7uII*\u0012A\u001c\u0016\u0003;>\\\u0013\u0001\u001d\t\u0003cZl\u0011A\u001d\u0006\u0003gR\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005UT\u0012AC1o]>$\u0018\r^5p]&\u0011qO\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007F\u0001\u0001z!\tQH0D\u0001|\u0015\t)h!\u0003\u0002~w\naA)\u001a<fY>\u0004XM]!qS\u0002")
public abstract class Classifier<FeaturesType, E extends Classifier<FeaturesType, E, M>, M extends ClassificationModel<FeaturesType, M>>
extends Predictor<FeaturesType, E, M>
implements ClassifierParams {
    private final Param<String> rawPredictionCol;

    @Override
    public StructType org$apache$spark$ml$classification$ClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol$class.getRawPredictionCol(this);
    }

    public E setRawPredictionCol(String value) {
        return (E)((Classifier)this.set(this.rawPredictionCol(), value));
    }

    public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset, int numClasses) {
        Predef$.MODULE$.require(numClasses > 0, (Function0)new Serializable(this, numClasses){
            public static final long serialVersionUID = 0L;
            private final int numClasses$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classifier (in extractLabeledPoints) found numClasses ="})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ", but requires numClasses > 0."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1)}))).toString();
            }
            {
                this.numClasses$1 = numClasses$1;
            }
        });
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1)new Serializable(this, numClasses){
            public static final long serialVersionUID = 0L;
            public final int numClasses$1;

            public final LabeledPoint apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object features = ((SeqLike)some.get()).apply(1);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (features instanceof Vector) {
                            Vector vector = (Vector)features;
                            Predef$.MODULE$.require(d % 1.0 == 0.0 && d >= 0.0 && d < (double)this.numClasses$1, (Function0)new Serializable(this, d){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$extractLabeledPoints$2 $outer;
                                private final double x3$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classifier was given"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" dataset with invalid label ", ".  Labels must be integers in range"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.x3$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" [0, 1, ..., ", "), where numClasses=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses$1), BoxesRunTime.boxToInteger((int)this.$outer.numClasses$1)}))).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }
                            });
                            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
                            return labeledPoint;
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
            {
                this.numClasses$1 = numClasses$1;
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public int getNumClasses(Dataset<?> dataset, int maxNumClasses) {
        Option<Object> option;
        block6: {
            int n;
            block5: {
                block4: {
                    int n2;
                    int n3;
                    option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    n = n3 = (n2 = BoxesRunTime.unboxToInt((Object)some.x()));
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                Row[] maxLabelRow = (Row[])dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.$(this.labelCol()))})).take(1);
                if (Predef$.MODULE$.refArrayOps((Object[])maxLabelRow).isEmpty()) {
                    throw new SparkException("ML algorithm was given empty dataset.");
                }
                double maxDoubleLabel = ((Row)Predef$.MODULE$.refArrayOps((Object[])maxLabelRow).head()).getDouble(0);
                Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0)new Serializable(this, maxDoubleLabel){
                    public static final long serialVersionUID = 0L;
                    private final double maxDoubleLabel$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classifier found max label value ="})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " but requires integers in range [0, ... ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.maxDoubleLabel$1), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)}))).toString();
                    }
                    {
                        this.maxDoubleLabel$1 = maxDoubleLabel$1;
                    }
                });
                int numClasses = (int)maxDoubleLabel + 1;
                Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0)new Serializable(this, maxNumClasses, numClasses){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Classifier $outer;
                    private final int maxNumClasses$1;
                    private final int numClasses$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classifier inferred ", " from label values"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" in column ", ", but this exceeded the max numClasses (", ") allowed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.labelCol(), BoxesRunTime.boxToInteger((int)this.maxNumClasses$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" to be inferred from values.  To avoid this error for labels with > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxNumClasses$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" classes, specify numClasses explicitly in the metadata; this can be done by applying"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" StringIndexer to the label column."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.maxNumClasses$1 = maxNumClasses$1;
                        this.numClasses$2 = numClasses$2;
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this, numClasses){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Classifier $outer;
                    private final int numClasses$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)this.$outer.getClass().getCanonicalName()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" inferred ", " classes for"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" labelCol=", " since numClasses was not specified in the column metadata."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.labelCol()}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.numClasses$2 = numClasses$2;
                    }
                });
                n = numClasses;
            }
            return n;
        }
        throw new MatchError(option);
    }

    public int getNumClasses$default$2() {
        return 100;
    }

    public Classifier() {
        HasRawPredictionCol$class.$init$(this);
        ClassifierParams$class.$init$(this);
    }
}

