/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import breeze.linalg.DenseVector;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.GaussianMixtureModel$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$;
import org.apache.spark.ml.clustering.GaussianMixtureModel$GaussianMixtureModelWriter$Data$;
import org.apache.spark.ml.clustering.GaussianMixtureParams;
import org.apache.spark.ml.clustering.GaussianMixtureParams$class;
import org.apache.spark.ml.clustering.GaussianMixtureSummary;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasProbabilityCol$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\r%d\u0001B\u0001\u0003\u00015\u0011AcR1vgNL\u0017M\\'jqR,(/Z'pI\u0016d'BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002cA\b\u0011%5\tA!\u0003\u0002\u0012\t\t)Qj\u001c3fYB\u00111\u0003A\u0007\u0002\u0005A\u00111#F\u0005\u0003-\t\u0011QcR1vgNL\u0017M\\'jqR,(/\u001a)be\u0006l7\u000f\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\t\u0005!Q\u000f^5m\u0013\ta\u0012D\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016D\u0001B\b\u0001\u0003\u0006\u0004%\teH\u0001\u0004k&$W#\u0001\u0011\u0011\u0005\u0005:cB\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a\u0013A\u0002)sK\u0012,g-\u0003\u0002)S\t11\u000b\u001e:j]\u001eT!AJ\u0012)\u0007uY\u0013\u0007\u0005\u0002-_5\tQF\u0003\u0002/\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Aj#!B*j]\u000e,\u0017%\u0001\u001a\u0002\u000bIr\u0003G\f\u0019\t\u0011Q\u0002!\u0011!Q\u0001\n\u0001\nA!^5eA!\u001a1gK\u0019\t\u0011]\u0002!Q1A\u0005\u0002a\nqa^3jO\"$8/F\u0001:!\r\u0011#\bP\u0005\u0003w\r\u0012Q!\u0011:sCf\u0004\"AI\u001f\n\u0005y\u001a#A\u0002#pk\ndW\rK\u00027WEB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006I!O\u0001\to\u0016Lw\r\u001b;tA!\u001a\u0001iK\u0019\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015\u000b\u0011bZ1vgNL\u0017M\\:\u0016\u0003\u0019\u00032A\t\u001eH!\tAU*D\u0001J\u0015\tQ5*\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002M\t\u0005!1\u000f^1u\u0013\tq\u0015J\u0001\u000bNk2$\u0018N^1sS\u0006$XmR1vgNL\u0017M\u001c\u0015\u0004\u0007.\n\u0004\u0002C)\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u0015\u001d\fWo]:jC:\u001c\b\u0005K\u0002QWEBa\u0001\u0016\u0001\u0005\u0002\u0011)\u0016A\u0002\u001fj]&$h\b\u0006\u0003\u0013-bS\u0006\"\u0002\u0010T\u0001\u0004\u0001\u0003f\u0001,,c!)qg\u0015a\u0001s!\u001a\u0001lK\u0019\t\u000b\u0011\u001b\u0006\u0019\u0001$)\u0007i[\u0013\u0007C\u0003^\u0001\u0011\u0005c,\u0001\u0003d_BLHC\u0001\n`\u0011\u0015\u0001G\f1\u0001b\u0003\u0015)\u0007\u0010\u001e:b!\t\u0011W-D\u0001d\u0015\t!G!A\u0003qCJ\fW.\u0003\u0002gG\nA\u0001+\u0019:b[6\u000b\u0007\u000fK\u0002]WEBQ!\u001b\u0001\u0005B)\f\u0011\u0002\u001e:b]N4wN]7\u0015\u0005-|\bC\u00017}\u001d\ti\u0017P\u0004\u0002oo:\u0011qN\u001e\b\u0003aVt!!\u001d;\u000e\u0003IT!a\u001d\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002y\r\u0005\u00191/\u001d7\n\u0005i\\\u0018a\u00029bG.\fw-\u001a\u0006\u0003q\u001aI!! @\u0003\u0013\u0011\u000bG/\u0019$sC6,'B\u0001>|\u0011\u001d\t\t\u0001\u001ba\u0001\u0003\u0007\tq\u0001Z1uCN,G\u000f\r\u0003\u0002\u0006\u0005E\u0001CBA\u0004\u0003\u0013\ti!D\u0001|\u0013\r\tYa\u001f\u0002\b\t\u0006$\u0018m]3u!\u0011\ty!!\u0005\r\u0001\u0011Y\u00111C@\u0002\u0002\u0003\u0005)\u0011AA\u000b\u0005\ryF%M\t\u0005\u0003/\ti\u0002E\u0002#\u00033I1!a\u0007$\u0005\u001dqu\u000e\u001e5j]\u001e\u00042AIA\u0010\u0013\r\t\tc\t\u0002\u0004\u0003:L\bf\u00015,c!9\u0011q\u0005\u0001\u0005B\u0005%\u0012a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005-\u0012q\u0007\t\u0005\u0003[\t\u0019$\u0004\u0002\u00020)\u0019\u0011\u0011G>\u0002\u000bQL\b/Z:\n\t\u0005U\u0012q\u0006\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\u001d\u0003K\u0001\r!a\u000b\u0002\rM\u001c\u0007.Z7bQ\u0011\t)cK\u0019\t\u0011\u0005}\u0002\u0001\"\u0001\u0003\u0003\u0003\nq\u0001\u001d:fI&\u001cG\u000f\u0006\u0003\u0002D\u0005%\u0003c\u0001\u0012\u0002F%\u0019\u0011qI\u0012\u0003\u0007%sG\u000f\u0003\u0005\u0002L\u0005u\u0002\u0019AA'\u0003!1W-\u0019;ve\u0016\u001c\b\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005MC!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003/\n\tF\u0001\u0004WK\u000e$xN\u001d\u0005\t\u00037\u0002A\u0011\u0001\u0002\u0002^\u0005\u0011\u0002O]3eS\u000e$\bK]8cC\nLG.\u001b;z)\u0011\ti%a\u0018\t\u0011\u0005-\u0013\u0011\fa\u0001\u0003\u001bBq!a\u0019\u0001\t\u0003\t)'A\u0006hCV\u001c8/[1og\u00123U#A6)\t\u0005\u00054&\r\u0005\b\u0003W\u0002A\u0011IA7\u0003\u00159(/\u001b;f+\t\ty\u0007E\u0002\u0019\u0003cJ1!a\u001d\u001a\u0005!iEj\u0016:ji\u0016\u0014\b\u0006BA5WEB\u0011\"!\u001f\u0001\u0001\u0004%I!a\u001f\u0002\u001fQ\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef,\"!! \u0011\u000b\t\ny(a!\n\u0007\u0005\u00055E\u0001\u0004PaRLwN\u001c\t\u0004'\u0005\u0015\u0015bAAD\u0005\t1r)Y;tg&\fg.T5yiV\u0014XmU;n[\u0006\u0014\u0018\u0010C\u0005\u0002\f\u0002\u0001\r\u0011\"\u0003\u0002\u000e\u0006\u0019BO]1j]&twmU;n[\u0006\u0014\u0018p\u0018\u0013fcR!\u0011qRAK!\r\u0011\u0013\u0011S\u0005\u0004\u0003'\u001b#\u0001B+oSRD!\"a&\u0002\n\u0006\u0005\t\u0019AA?\u0003\rAH%\r\u0005\t\u00037\u0003\u0001\u0015)\u0003\u0002~\u0005\u0001BO]1j]&twmU;n[\u0006\u0014\u0018\u0010\t\u0005\t\u0003?\u0003A\u0011\u0001\u0002\u0002\"\u0006Q1/\u001a;Tk6l\u0017M]=\u0015\t\u0005\r\u0016QU\u0007\u0002\u0001!A\u0011qUAO\u0001\u0004\t\u0019)A\u0004tk6l\u0017M]=\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\u0006Q\u0001.Y:Tk6l\u0017M]=\u0016\u0005\u0005=\u0006c\u0001\u0012\u00022&\u0019\u00111W\u0012\u0003\u000f\t{w\u000e\\3b]\"\"\u0011\u0011V\u00162\u0011\u001d\t9\u000b\u0001C\u0001\u0003s+\"!a!)\t\u0005]6&\r\u0015\u0004\u0001\u0005}\u0006c\u0001\u0017\u0002B&\u0019\u00111Y\u0017\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u0001Y\u0013gB\u0004\u0002J\nA\t!a3\u0002)\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016lu\u000eZ3m!\r\u0019\u0012Q\u001a\u0004\u0007\u0003\tA\t!a4\u0014\u0011\u00055\u0017\u0011[Al\u0003;\u00042AIAj\u0013\r\t)n\t\u0002\u0007\u0003:L(+\u001a4\u0011\ta\tINE\u0005\u0004\u00037L\"AC'M%\u0016\fG-\u00192mKB\u0019!%a8\n\u0007\u0005\u00058E\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004U\u0003\u001b$\t!!:\u0015\u0005\u0005-\u0007\u0002CAu\u0003\u001b$\t%a;\u0002\tI,\u0017\rZ\u000b\u0003\u0003[\u0004B\u0001GAx%%\u0019\u0011\u0011_\r\u0003\u00115c%+Z1eKJDC!a:,c!A\u0011q_Ag\t\u0003\nI0\u0001\u0003m_\u0006$Gc\u0001\n\u0002|\"9\u0011Q`A{\u0001\u0004\u0001\u0013\u0001\u00029bi\"DC!!>,c\u0019I!1AAg\u0001\u00055'Q\u0001\u0002\u001b\u000f\u0006,8o]5b]6K\u0007\u0010^;sK6{G-\u001a7Xe&$XM]\n\u0005\u0005\u0003\ty\u0007\u0003\u0006\u0003\n\t\u0005!\u0011!Q\u0001\nI\t\u0001\"\u001b8ti\u0006t7-\u001a\u0005\b)\n\u0005A\u0011\u0001B\u0007)\u0011\u0011yAa\u0005\u0011\t\tE!\u0011A\u0007\u0003\u0003\u001bDqA!\u0003\u0003\f\u0001\u0007!CB\u0004\u0003\u0018\t\u0005AI!\u0007\u0003\t\u0011\u000bG/Y\n\t\u0005+\t\tNa\u0007\u0002^B\u0019!E!\b\n\u0007\t}1EA\u0004Qe>$Wo\u0019;\t\u0013]\u0012)B!f\u0001\n\u0003A\u0004\"C!\u0003\u0016\tE\t\u0015!\u0003:\u0011-\u00119C!\u0006\u0003\u0016\u0004%\tA!\u000b\u0002\u00075,8/\u0006\u0002\u0003,A!!E\u000fB\u0017!\u0011\u0011yCa\u000e\u000e\u0005\tE\"\u0002BA*\u0005gQ1A!\u000e\u0007\u0003\u0015iG\u000e\\5c\u0013\u0011\t9F!\r\t\u0017\tm\"Q\u0003B\tB\u0003%!1F\u0001\u0005[V\u001c\b\u0005C\u0006\u0003@\tU!Q3A\u0005\u0002\t\u0005\u0013AB:jO6\f7/\u0006\u0002\u0003DA!!E\u000fB#!\u0011\u0011yCa\u0012\n\t\t%#\u0011\u0007\u0002\u0007\u001b\u0006$(/\u001b=\t\u0017\t5#Q\u0003B\tB\u0003%!1I\u0001\bg&<W.Y:!\u0011\u001d!&Q\u0003C\u0001\u0005#\"\u0002Ba\u0015\u0003X\te#1\f\t\u0005\u0005+\u0012)\"\u0004\u0002\u0003\u0002!1qGa\u0014A\u0002eB\u0001Ba\n\u0003P\u0001\u0007!1\u0006\u0005\t\u0005\u007f\u0011y\u00051\u0001\u0003D!IQL!\u0006\u0002\u0002\u0013\u0005!q\f\u000b\t\u0005'\u0012\tGa\u0019\u0003f!AqG!\u0018\u0011\u0002\u0003\u0007\u0011\b\u0003\u0006\u0003(\tu\u0003\u0013!a\u0001\u0005WA!Ba\u0010\u0003^A\u0005\t\u0019\u0001B\"\u0011)\u0011IG!\u0006\u0012\u0002\u0013\u0005!1N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011iGK\u0002:\u0005_Z#A!\u001d\u0011\t\tM$1P\u0007\u0003\u0005kRAAa\u001e\u0003z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003]\rJAA! \u0003v\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t\u0005%QCI\u0001\n\u0003\u0011\u0019)\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u0015%\u0006\u0002B\u0016\u0005_B!B!#\u0003\u0016E\u0005I\u0011\u0001BF\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"A!$+\t\t\r#q\u000e\u0005\u000b\u0005#\u0013)\"!A\u0005B\tM\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003\u0016B!!q\u0013BQ\u001b\t\u0011IJ\u0003\u0003\u0003\u001c\nu\u0015\u0001\u00027b]\u001eT!Aa(\u0002\t)\fg/Y\u0005\u0004Q\te\u0005B\u0003BS\u0005+\t\t\u0011\"\u0001\u0003(\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\t\u0005\u000b\u0005W\u0013)\"!A\u0005\u0002\t5\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\u0011y\u000b\u0003\u0006\u0002\u0018\n%\u0016\u0011!a\u0001\u0003\u0007B!Ba-\u0003\u0016\u0005\u0005I\u0011\tB[\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\\!\u0019\u0011ILa0\u0002\u001e5\u0011!1\u0018\u0006\u0004\u0005{\u001b\u0013AC2pY2,7\r^5p]&!!\u0011\u0019B^\u0005!IE/\u001a:bi>\u0014\bB\u0003Bc\u0005+\t\t\u0011\"\u0001\u0003H\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u00020\n%\u0007BCAL\u0005\u0007\f\t\u00111\u0001\u0002\u001e!Q!Q\u001aB\u000b\u0003\u0003%\tEa4\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\u0011\t\u0015\tM'QCA\u0001\n\u0003\u0012).\u0001\u0005u_N#(/\u001b8h)\t\u0011)\n\u0003\u0006\u0003Z\nU\u0011\u0011!C!\u00057\fa!Z9vC2\u001cH\u0003BAX\u0005;D!\"a&\u0003X\u0006\u0005\t\u0019AA\u000f\u000f)\u0011\tO!\u0001\u0002\u0002#%!1]\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0003V\t\u0015hA\u0003B\f\u0005\u0003\t\t\u0011#\u0003\u0003hN1!Q\u001dBu\u0003;\u00042Ba;\u0003rf\u0012YCa\u0011\u0003T5\u0011!Q\u001e\u0006\u0004\u0005_\u001c\u0013a\u0002:v]RLW.Z\u0005\u0005\u0005g\u0014iOA\tBEN$(/Y2u\rVt7\r^5p]NBq\u0001\u0016Bs\t\u0003\u00119\u0010\u0006\u0002\u0003d\"Q!1\u001bBs\u0003\u0003%)E!6\t\u0015\tu(Q]A\u0001\n\u0003\u0013y0A\u0003baBd\u0017\u0010\u0006\u0005\u0003T\r\u000511AB\u0003\u0011\u00199$1 a\u0001s!A!q\u0005B~\u0001\u0004\u0011Y\u0003\u0003\u0005\u0003@\tm\b\u0019\u0001B\"\u0011)\u0019IA!:\u0002\u0002\u0013\u000551B\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019ia!\u0006\u0011\u000b\t\nyha\u0004\u0011\u0011\t\u001a\t\"\u000fB\u0016\u0005\u0007J1aa\u0005$\u0005\u0019!V\u000f\u001d7fg!Q1qCB\u0004\u0003\u0003\u0005\rAa\u0015\u0002\u0007a$\u0003\u0007\u0003\u0006\u0004\u001c\t\u0015\u0018\u0011!C\u0005\u0007;\t1B]3bIJ+7o\u001c7wKR\u00111q\u0004\t\u0005\u0005/\u001b\t#\u0003\u0003\u0004$\te%AB(cU\u0016\u001cG\u000f\u0003\u0005\u0004(\t\u0005A\u0011KB\u0015\u0003!\u0019\u0018M^3J[BdG\u0003BAH\u0007WAq!!@\u0004&\u0001\u0007\u0001EB\u0004\u00040\u00055Ga!\r\u00035\u001d\u000bWo]:jC:l\u0015\u000e\u001f;ve\u0016lu\u000eZ3m%\u0016\fG-\u001a:\u0014\t\r5\u0012Q\u001e\u0005\b)\u000e5B\u0011AB\u001b)\t\u00199\u0004\u0005\u0003\u0003\u0012\r5\u0002BCB\u001e\u0007[\u0011\r\u0011\"\u0003\u0003\u0014\u0006I1\r\\1tg:\u000bW.\u001a\u0005\n\u0007\u007f\u0019i\u0003)A\u0005\u0005+\u000b!b\u00197bgNt\u0015-\\3!\u0011!\t9p!\f\u0005B\r\rCc\u0001\n\u0004F!9\u0011Q`B!\u0001\u0004\u0001\u0003\"CB%\u0003\u001b$\tAAB&\u0003Q\u0019w.\u001c9vi\u0016\u0004&o\u001c2bE&d\u0017\u000e^5fgR9\u0011h!\u0014\u0004^\r\u0005\u0004\u0002CA&\u0007\u000f\u0002\raa\u0014\u0011\u000b\rE3\u0011\f\u001f\u000e\u0005\rM#\u0002BA*\u0007+R!aa\u0016\u0002\r\t\u0014X-\u001a>f\u0013\u0011\u0019Yfa\u0015\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\b\u0007?\u001a9\u00051\u0001G\u0003\u0015!\u0017n\u001d;t\u0011\u001994q\ta\u0001s!Q11DAg\u0003\u0003%Ia!\b)\t\u000557&\r\u0015\u0005\u0003\u000f\\\u0013\u0007")
public class GaussianMixtureModel
extends Model<GaussianMixtureModel>
implements GaussianMixtureParams,
MLWritable {
    private final String uid;
    private final double[] weights;
    private final MultivariateGaussian[] gaussians;
    private Option<GaussianMixtureSummary> trainingSummary;
    private final IntParam k;
    private final DoubleParam tol;
    private final Param<String> probabilityCol;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static GaussianMixtureModel load(String string) {
        return GaussianMixtureModel$.MODULE$.load(string);
    }

    public static MLReader<GaussianMixtureModel> read() {
        return GaussianMixtureModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final void org$apache$spark$ml$clustering$GaussianMixtureParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public int getK() {
        return GaussianMixtureParams$class.getK(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return GaussianMixtureParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol$class.getProbabilityCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public double[] weights() {
        return this.weights;
    }

    public MultivariateGaussian[] gaussians() {
        return this.gaussians;
    }

    @Override
    public GaussianMixtureModel copy(ParamMap extra) {
        GaussianMixtureModel copied = new GaussianMixtureModel(this.uid(), this.weights(), this.gaussians());
        return (GaussianMixtureModel)((Model)this.copyValues(copied, extra)).setParent(this.parent());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        this.transformSchema(dataset.schema(), true);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(GaussianMixtureModel $outer) {
            }
        }
        UserDefinedFunction predUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureModel $outer;

            public final int apply(org.apache.spark.ml.linalg.Vector vector) {
                return this.$outer.predict(vector);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator1$1(this)));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(GaussianMixtureModel $outer) {
            }
        }
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(GaussianMixtureModel $outer) {
            }
        }
        UserDefinedFunction probUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureModel $outer;

            public final org.apache.spark.ml.linalg.Vector apply(org.apache.spark.ml.linalg.Vector vector) {
                return this.$outer.predictProbability(vector);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator2$1(this)), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator3$1(this)));
        return dataset.withColumn(this.$(this.predictionCol()), predUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).withColumn(this.$(this.probabilityCol()), probUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public int predict(org.apache.spark.ml.linalg.Vector features) {
        org.apache.spark.ml.linalg.Vector r = this.predictProbability(features);
        return r.argmax();
    }

    public org.apache.spark.ml.linalg.Vector predictProbability(org.apache.spark.ml.linalg.Vector features) {
        double[] probs = GaussianMixtureModel$.MODULE$.computeProbabilities((DenseVector<Object>)features.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()), this.gaussians(), this.weights());
        return org.apache.spark.ml.linalg.Vectors$.MODULE$.dense(probs);
    }

    public Dataset<Row> gaussiansDF() {
        Tuple2[] modelGaussians = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.gaussians()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Vector, Matrix> apply(MultivariateGaussian gaussian) {
                return new Tuple2((Object)Vectors$.MODULE$.fromML(gaussian.mean()), (Object)Matrices$.MODULE$.fromML(gaussian.cov()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor(), ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Matrix")).asType()).toTypeConstructor()})));
            }

            public Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(GaussianMixtureModel $outer) {
            }
        }
        return SparkSession$.MODULE$.builder().getOrCreate().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])modelGaussians), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$$typecreator4$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "cov"}));
    }

    @Override
    public MLWriter write() {
        return new GaussianMixtureModelWriter(this);
    }

    private Option<GaussianMixtureSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<GaussianMixtureSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public GaussianMixtureModel setSummary(GaussianMixtureSummary summary2) {
        this.trainingSummary_$eq((Option<GaussianMixtureSummary>)new Some((Object)summary2));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().nonEmpty();
    }

    public GaussianMixtureSummary summary() {
        return (GaussianMixtureSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GaussianMixtureModel $outer;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No training summary available for the ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.getClass().getSimpleName()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public GaussianMixtureModel(String uid, double[] weights, MultivariateGaussian[] gaussians) {
        this.uid = uid;
        this.weights = weights;
        this.gaussians = gaussians;
        HasMaxIter$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasSeed$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasProbabilityCol$class.$init$(this);
        HasTol$class.$init$(this);
        GaussianMixtureParams$class.$init$(this);
        MLWritable$class.$init$(this);
        this.trainingSummary = None$.MODULE$;
    }

    public static class GaussianMixtureModelWriter
    extends MLWriter {
        private final GaussianMixtureModel instance;
        private volatile GaussianMixtureModel$GaussianMixtureModelWriter$Data$ Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private GaussianMixtureModel$GaussianMixtureModelWriter$Data$ org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$$Data$lzycompute() {
            GaussianMixtureModelWriter gaussianMixtureModelWriter = this;
            synchronized (gaussianMixtureModelWriter) {
                if (this.Data$module != null) return this.Data$module;
                this.Data$module = new GaussianMixtureModel$GaussianMixtureModelWriter$Data$(this);
                return this.Data$module;
            }
        }

        public GaussianMixtureModel$GaussianMixtureModelWriter$Data$ org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$$Data() {
            return this.Data$module == null ? this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$$Data$lzycompute() : this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            double[] weights = this.instance.weights();
            MultivariateGaussian[] gaussians = this.instance.gaussians();
            Vector[] mus = (Vector[])Predef$.MODULE$.refArrayOps((Object[])gaussians).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(MultivariateGaussian g) {
                    return Vectors$.MODULE$.fromML(g.mean());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class)));
            Matrix[] sigmas = (Matrix[])Predef$.MODULE$.refArrayOps((Object[])gaussians).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Matrix apply(MultivariateGaussian c) {
                    return Matrices$.MODULE$.fromML(c.cov());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Matrix.class)));
            Data data = new Data(this, weights, mus, sigmas);
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GaussianMixtureModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.TypeRef().apply($u.ThisType().apply($m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter")), $u.build().selectType($m.staticClass("org.apache.spark.ml.clustering.GaussianMixtureModel.GaussianMixtureModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator5$1(GaussianMixtureModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_GaussianMixtureModel$GaussianMixtureModelWriter$$typecreator5$1(this))).repartition(1).write().parquet(dataPath);
        }

        public GaussianMixtureModelWriter(GaussianMixtureModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final double[] weights;
            private final Vector[] mus;
            private final Matrix[] sigmas;
            public final /* synthetic */ GaussianMixtureModelWriter $outer;

            public double[] weights() {
                return this.weights;
            }

            public Vector[] mus() {
                return this.mus;
            }

            public Matrix[] sigmas() {
                return this.sigmas;
            }

            public Data copy(double[] weights, Vector[] mus, Matrix[] sigmas) {
                return new Data(this.org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer(), weights, mus, sigmas);
            }

            public double[] copy$default$1() {
                return this.weights();
            }

            public Vector[] copy$default$2() {
                return this.mus();
            }

            public Matrix[] copy$default$3() {
                return this.sigmas();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                Object[] objectArray;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 2: {
                        objectArray = this.sigmas();
                        break;
                    }
                    case 1: {
                        objectArray = this.mus();
                        break;
                    }
                    case 0: {
                        objectArray = this.weights();
                    }
                }
                return objectArray;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.weights() != data.weights()) return false;
                if (this.mus() != data.mus()) return false;
                if (this.sigmas() != data.sigmas()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ GaussianMixtureModelWriter org$apache$spark$ml$clustering$GaussianMixtureModel$GaussianMixtureModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(GaussianMixtureModelWriter $outer, double[] weights, Vector[] mus, Matrix[] sigmas) {
                this.weights = weights;
                this.mus = mus;
                this.sigmas = sigmas;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class GaussianMixtureModelReader
    extends MLReader<GaussianMixtureModel> {
        private final String className = GaussianMixtureModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public GaussianMixtureModel load(String path) {
            Matrix[] sigmas;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            String dataPath = new Path(path, "data").toString();
            Row row = (Row)this.sparkSession().read().parquet(dataPath).select("weights", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mus", "sigmas"})).head();
            double[] weights = (double[])row.getSeq(0).toArray(ClassTag$.MODULE$.Double());
            Vector[] mus = (Vector[])row.getSeq(1).toArray(ClassTag$.MODULE$.apply(Vector.class));
            Predef$.MODULE$.require(mus.length == (sigmas = (Matrix[])row.getSeq(2).toArray(ClassTag$.MODULE$.apply(Matrix.class))).length, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Length of Mu and Sigma array must match";
                }
            });
            Predef$.MODULE$.require(mus.length == weights.length, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Length of weight and Gaussian array must match";
                }
            });
            MultivariateGaussian[] gaussians = (MultivariateGaussian[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])mus).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])sigmas), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final MultivariateGaussian apply(Tuple2<Vector, Matrix> x0$1) {
                    Tuple2<Vector, Matrix> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Vector mu = (Vector)tuple2._1();
                        Matrix sigma = (Matrix)tuple2._2();
                        MultivariateGaussian multivariateGaussian = new MultivariateGaussian(mu.asML(), sigma.asML());
                        return multivariateGaussian;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(MultivariateGaussian.class)));
            GaussianMixtureModel model = new GaussianMixtureModel(metadata.uid(), weights, gaussians);
            DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
            return model;
        }
    }
}

