/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.clustering.LDAParams$class;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055h!B\u0001\u0003\u0003Ci!\u0001\u0003'E\u00036{G-\u001a7\u000b\u0005\r!\u0011AC2mkN$XM]5oO*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002F\f\u001e!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003'UI!A\u0006\u0002\u0003\u00131#\u0015\tU1sC6\u001c\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001e\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!!\u0003A!b\u0001\n\u0003*\u0013aA;jIV\ta\u0005\u0005\u0002([9\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0013\u0006K\u0002$c]\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00027g\t)1+\u001b8dK\u0006\n\u0001(A\u00032]Yr\u0003\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003'\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007e\nt\u0007\u0003\u0005>\u0001\t\u0015\r\u0011\"\u0001?\u0003%1xnY1c'&TX-F\u0001@!\tA\u0003)\u0003\u0002BS\t\u0019\u0011J\u001c;)\u0007q\nt\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003@\u0003)1xnY1c'&TX\r\t\u0015\u0004\u0007F:\u0004\"C$\u0001\u0005\u000b\u0007I\u0011\u0001\u0003I\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u001d.\u0013Ab\u00159be.\u001cVm]:j_:D3AR\u00198\u0011!\t\u0006A!A!\u0002\u0013I\u0015!D:qCJ\\7+Z:tS>t\u0007\u0005\u000b\u0002Q'B\u0011\u0001\u0006V\u0005\u0003+&\u0012\u0011\u0002\u001e:b]NLWM\u001c;)\u0007A\u000bt\u0007\u0003\u0004Y\u0001\u0011\u0005A!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\tIQFL\u0018\u0005\u0006I]\u0003\rA\n\u0015\u00045F:\u0004\"B\u001fX\u0001\u0004y\u0004f\u0001/2o!)qi\u0016a\u0001\u0013\"\u001aa,M\u001c\t\u000b\u0005\u0004a\u0011\u00032\u0002\u001b=dG\rT8dC2lu\u000eZ3m+\u0005\u0019\u0007C\u00013i\u001b\u0005)'BA\u0002g\u0015\t9g!A\u0003nY2L'-\u0003\u0002jK\niAj\\2bY2#\u0015)T8eK2D3\u0001Y\u00198\u0011\u0015a\u0007A\"\u0005n\u0003!9W\r^'pI\u0016dW#\u00018\u0011\u0005\u0011|\u0017BA\u0001fQ\rY\u0017g\u000e\u0005\u0006e\u0002!\ta]\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\t!X/D\u0001\u0001\u0011\u00151\u0018\u000f1\u0001'\u0003\u00151\u0018\r\\;fQ\r\t\u0018g\u000e\u0005\u0006s\u0002!\tA_\u0001\bg\u0016$8+Z3e)\t!8\u0010C\u0003wq\u0002\u0007A\u0010\u0005\u0002){&\u0011a0\u000b\u0002\u0005\u0019>tw\rK\u0002yc]Bq!a\u0001\u0001\t\u0003\n)!A\u0005ue\u0006t7OZ8s[R!\u0011qAA\u0016!\u0011\tI!!\n\u000f\t\u0005-\u0011\u0011\u0005\b\u0005\u0003\u001b\tyB\u0004\u0003\u0002\u0010\u0005ua\u0002BA\t\u00037qA!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/a\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011AJB\u0005\u0004\u0003GY\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003O\tICA\u0005ECR\fgI]1nK*\u0019\u00111E&\t\u0011\u00055\u0012\u0011\u0001a\u0001\u0003_\tq\u0001Z1uCN,G\u000f\r\u0003\u00022\u0005m\u0002#\u0002&\u00024\u0005]\u0012bAA\u001b\u0017\n9A)\u0019;bg\u0016$\b\u0003BA\u001d\u0003wa\u0001\u0001\u0002\u0007\u0002>\u0005-\u0012\u0011!A\u0001\u0006\u0003\tyDA\u0002`IE\nB!!\u0011\u0002HA\u0019\u0001&a\u0011\n\u0007\u0005\u0015\u0013FA\u0004O_RD\u0017N\\4\u0011\u0007!\nI%C\u0002\u0002L%\u00121!\u00118zQ\u0015\t\t!MA(C\t\t\t&A\u00033]Ar\u0003\u0007C\u0004\u0002V\u0001!\t%a\u0016\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!!\u0017\u0002fA!\u00111LA1\u001b\t\tiFC\u0002\u0002`-\u000bQ\u0001^=qKNLA!a\u0019\u0002^\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005\u001d\u00141\u000ba\u0001\u00033\naa]2iK6\f\u0007\u0006BA*c]Bq!!\u001c\u0001\t\u0003\ty'A\rfgRLW.\u0019;fI\u0012{7mQ8oG\u0016tGO]1uS>tWCAA9!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\t\u00051A.\u001b8bY\u001eLA!a\u001f\u0002v\t1a+Z2u_JDS!a\u001b2\u0003\u001fBq!!!\u0001\t\u0003\t\u0019)\u0001\u0007u_BL7m]'biJL\u00070\u0006\u0002\u0002\u0006B!\u00111OAD\u0013\u0011\tI)!\u001e\u0003\r5\u000bGO]5yQ\u0015\ty(MA(\u0011\u001d\ty\t\u0001D\u0001\u0003#\u000bQ\"[:ESN$(/\u001b2vi\u0016$WCAAJ!\rA\u0013QS\u0005\u0004\u0003/K#a\u0002\"p_2,\u0017M\u001c\u0015\u0005\u0003\u001b\u000bt\u0007C\u0004\u0002\u001e\u0002!\t!a(\u0002\u001b1|w\rT5lK2L\u0007n\\8e)\u0011\t\t+a*\u0011\u0007!\n\u0019+C\u0002\u0002&&\u0012a\u0001R8vE2,\u0007\u0002CA\u0017\u00037\u0003\r!!+1\t\u0005-\u0016q\u0016\t\u0006\u0015\u0006M\u0012Q\u0016\t\u0005\u0003s\ty\u000b\u0002\u0007\u00022\u0006\u001d\u0016\u0011!A\u0001\u0006\u0003\tyDA\u0002`IIBS!a'2\u0003\u001fBq!a.\u0001\t\u0003\tI,A\u0007m_\u001e\u0004VM\u001d9mKbLG/\u001f\u000b\u0005\u0003C\u000bY\f\u0003\u0005\u0002.\u0005U\u0006\u0019AA_a\u0011\ty,a1\u0011\u000b)\u000b\u0019$!1\u0011\t\u0005e\u00121\u0019\u0003\r\u0003\u000b\fY,!A\u0001\u0002\u000b\u0005\u0011q\b\u0002\u0004?\u0012\u001a\u0004&BA[c\u0005=\u0003bBAf\u0001\u0011\u0005\u0011QZ\u0001\u000fI\u0016\u001c8M]5cKR{\u0007/[2t)\u0011\t9!a4\t\u000f\u0005E\u0017\u0011\u001aa\u0001\u007f\u0005\u0001R.\u0019=UKJl7\u000fU3s)>\u0004\u0018n\u0019\u0015\u0005\u0003\u0013\ft\u0007C\u0004\u0002L\u0002!\t!a6\u0015\u0005\u0005\u001d\u0001\u0006BAkc]JS\u0001AAo\u0003CL1!a8\u0003\u0005M!\u0015n\u001d;sS\n,H/\u001a3M\t\u0006ku\u000eZ3m\u0013\tI'\u0001K\u0002\u0001\u0003K\u00042AMAt\u0013\r\tIo\r\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0004\u0001E:\u0004")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
Logging,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SparkSession sparkSession;
    private final IntParam k;
    private final DoubleArrayParam docConcentration;
    private final DoubleParam topicConcentration;
    private final String[] supportedOptimizers;
    private final Param<String> optimizer;
    private final Param<String> topicDistributionCol;
    private final DoubleParam learningOffset;
    private final DoubleParam learningDecay;
    private final DoubleParam subsamplingRate;
    private final BooleanParam optimizeDocConcentration;
    private final BooleanParam keepLastCheckpoint;
    private final IntParam checkpointInterval;
    private final LongParam seed;
    private final IntParam maxIter;
    private final Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final BooleanParam keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam x$1) {
        this.keepLastCheckpoint = x$1;
    }

    @Override
    public int getK() {
        return LDAParams$class.getK(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams$class.getDocConcentration(this);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector getOldDocConcentration() {
        return LDAParams$class.getOldDocConcentration(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams$class.getTopicConcentration(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams$class.getOldTopicConcentration(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams$class.getOptimizer(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams$class.getTopicDistributionCol(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams$class.getLearningOffset(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams$class.getLearningDecay(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams$class.getSubsamplingRate(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams$class.getOptimizeDocConcentration(this);
    }

    @Override
    public boolean getKeepLastCheckpoint() {
        return LDAParams$class.getKeepLastCheckpoint(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams$class.getOldOptimizer(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol()))).nonEmpty()) {
            Function1<Vector, Vector> transformer = this.oldLocalModel().getTopicDistributionMethod(this.sparkSession().sparkContext());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.ml.linalg.Vector")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
                }
            }
            UserDefinedFunction t = functions$.MODULE$.udf((Function1)new Serializable(this, transformer){
                public static final long serialVersionUID = 0L;
                private final Function1 transformer$1;

                public final org.apache.spark.ml.linalg.Vector apply(org.apache.spark.ml.linalg.Vector v) {
                    return ((Vector)this.transformer$1.apply((Object)Vectors$.MODULE$.fromML(v))).asML();
                }
                {
                    this.transformer$1 = transformer$1;
                }
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(this)));
            dataset2 = dataset.withColumn(this.$(this.topicDistributionCol()), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).toDF();
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "LDAModel.transform was called without any output columns. Set an output column such as topicDistributionCol to produce results.";
                }
            });
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public org.apache.spark.ml.linalg.Vector estimatedDocConcentration() {
        return VectorImplicits$.MODULE$.mllibVectorToMLVector(this.getModel().docConcentration());
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix().asML();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public Dataset<Row> describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Seq<Object>, Seq<Object>> apply(Tuple2<Tuple2<int[], double[]>, Object> x0$2) {
                Tuple2<Tuple2<int[], double[]>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int topic = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        int[] termIndices = (int[])tuple22._1();
                        double[] termWeights = (double[])tuple22._2();
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)Predef$.MODULE$.intArrayOps(termIndices).toSeq(), (Object)Predef$.MODULE$.doubleArrayOps(termWeights).toSeq());
                        return tuple3;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala")).asModule()).moduleClass()), $m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor(), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala.collection")).asModule()).moduleClass()), $m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Int")).asType()).toTypeConstructor()}))), $u.TypeRef().apply($u.ThisType().apply(((Symbols.ModuleSymbolApi)((Symbols.ModuleSymbolApi)$m.staticPackage("scala.collection")).asModule()).moduleClass()), $m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("scala.Double")).asType()).toTypeConstructor()})))})));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(LDAModel $outer) {
            }
        }
        return this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public Dataset<Row> describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SparkSession sparkSession) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sparkSession = sparkSession;
        HasFeaturesCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasSeed$class.$init$(this);
        HasCheckpointInterval$class.$init$(this);
        LDAParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }
}

