/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.mllib.linalg.CholeskyDecomposition$;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh!B\u0001\u0003\u0001\u0011a!\u0001F,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7O\u0003\u0002\u0004\t\u0005)q\u000e\u001d;j[*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0005\u00015\u0019\u0012\u0004\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003)]i\u0011!\u0006\u0006\u0003-\u0019\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u00031U\u0011q\u0001T8hO&tw\r\u0005\u0002\u000f5%\u00111d\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t;\u0001\u0011)\u0019!C\u0001?\u0005aa-\u001b;J]R,'oY3qi\u000e\u0001Q#\u0001\u0011\u0011\u00059\t\u0013B\u0001\u0012\u0010\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u000eM&$\u0018J\u001c;fe\u000e,\u0007\u000f\u001e\u0011\t\u0011\u0019\u0002!Q1A\u0005\u0002\u001d\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0002QA\u0011a\"K\u0005\u0003U=\u0011a\u0001R8vE2,\u0007\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0013I,w\rU1sC6\u0004\u0003\u0002\u0003\u0018\u0001\u0005\u000b\u0007I\u0011A\u0010\u0002'M$\u0018M\u001c3be\u0012L'0\u001a$fCR,(/Z:\t\u0011A\u0002!\u0011!Q\u0001\n\u0001\nAc\u001d;b]\u0012\f'\u000fZ5{K\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u0010\u0002!M$\u0018M\u001c3be\u0012L'0\u001a'bE\u0016d\u0007\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0011\u0002#M$\u0018M\u001c3be\u0012L'0\u001a'bE\u0016d\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0006qiZD(\u0010\t\u0003s\u0001i\u0011A\u0001\u0005\u0006;U\u0002\r\u0001\t\u0005\u0006MU\u0002\r\u0001\u000b\u0005\u0006]U\u0002\r\u0001\t\u0005\u0006eU\u0002\r\u0001\t\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0004M&$HCA!E!\tI$)\u0003\u0002D\u0005\tIr+Z5hQR,G\rT3bgR\u001c\u0016/^1sKNlu\u000eZ3m\u0011\u0015)e\b1\u0001G\u0003%Ign\u001d;b]\u000e,7\u000fE\u0002H\u00152k\u0011\u0001\u0013\u0006\u0003\u0013\u001a\t1A\u001d3e\u0013\tY\u0005JA\u0002S\t\u0012\u0003\"!\u0014)\u000e\u00039S!a\u0014\u0003\u0002\u000f\u0019,\u0017\r^;sK&\u0011\u0011K\u0014\u0002\t\u0013:\u001cH/\u00198dK\u001e11K\u0001E\u0001\tQ\u000bAcV3jO\"$X\r\u001a'fCN$8+];be\u0016\u001c\bCA\u001dV\r\u0019\t!\u0001#\u0001\u0005-N\u0019Q+D\r\t\u000bY*F\u0011\u0001-\u0015\u0003QCqAW+C\u0002\u0013\u00051,\u0001\tN\u0003b{f*V'`\r\u0016\u000bE+\u0016*F'V\tA\f\u0005\u0002\u000f;&\u0011al\u0004\u0002\u0004\u0013:$\bB\u00021VA\u0003%A,A\tN\u0003b{f*V'`\r\u0016\u000bE+\u0016*F'\u00022AAY+\u0005G\nQ\u0011iZ4sK\u001e\fGo\u001c:\u0014\u0007\u0005l\u0011\u0004C\u00037C\u0012\u0005Q\rF\u0001g!\t9\u0017-D\u0001V\u0011\u001dI\u0017\r1A\u0005\u0002}\t1\"\u001b8ji&\fG.\u001b>fI\"91.\u0019a\u0001\n\u0003a\u0017aD5oSRL\u0017\r\\5{K\u0012|F%Z9\u0015\u00055\u0004\bC\u0001\bo\u0013\tywB\u0001\u0003V]&$\bbB9k\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004BB:bA\u0003&\u0001%\u0001\u0007j]&$\u0018.\u00197ju\u0016$\u0007\u0005C\u0005vC\u0002\u0007\t\u0019!C\u00017\u0006\t1\u000eC\u0005xC\u0002\u0007\t\u0019!C\u0001q\u0006)1n\u0018\u0013fcR\u0011Q.\u001f\u0005\bcZ\f\t\u00111\u0001]\u0011\u0019Y\u0018\r)Q\u00059\u0006\u00111\u000e\t\u0005\n{\u0006\u0004\r\u00111A\u0005\u0002y\fQaY8v]R,\u0012a \t\u0004\u001d\u0005\u0005\u0011bAA\u0002\u001f\t!Aj\u001c8h\u0011-\t9!\u0019a\u0001\u0002\u0004%\t!!\u0003\u0002\u0013\r|WO\u001c;`I\u0015\fHcA7\u0002\f!A\u0011/!\u0002\u0002\u0002\u0003\u0007q\u0010C\u0004\u0002\u0010\u0005\u0004\u000b\u0015B@\u0002\r\r|WO\u001c;!\u0011)\t\u0019\"\u0019a\u0001\u0002\u0004%\taW\u0001\u0005iJL7\nC\u0006\u0002\u0018\u0005\u0004\r\u00111A\u0005\u0002\u0005e\u0011\u0001\u0003;sS.{F%Z9\u0015\u00075\fY\u0002\u0003\u0005r\u0003+\t\t\u00111\u0001]\u0011\u001d\ty\"\u0019Q!\nq\u000bQ\u0001\u001e:j\u0017\u0002B!\"a\tb\u0001\u0004\u0005\r\u0011\"\u0001(\u0003\u001198+^7\t\u0017\u0005\u001d\u0012\r1AA\u0002\u0013\u0005\u0011\u0011F\u0001\toN+Xn\u0018\u0013fcR\u0019Q.a\u000b\t\u0011E\f)#!AA\u0002!Bq!a\fbA\u0003&\u0001&A\u0003x'Vl\u0007\u0005\u0003\u0006\u00024\u0005\u0004\r\u00111A\u0005\n\u001d\nQa^<Tk6D1\"a\u000eb\u0001\u0004\u0005\r\u0011\"\u0003\u0002:\u0005Iqo^*v[~#S-\u001d\u000b\u0004[\u0006m\u0002\u0002C9\u00026\u0005\u0005\t\u0019\u0001\u0015\t\u000f\u0005}\u0012\r)Q\u0005Q\u00051qo^*v[\u0002B!\"a\u0011b\u0001\u0004\u0005\r\u0011\"\u0003(\u0003\u0011\u00117+^7\t\u0017\u0005\u001d\u0013\r1AA\u0002\u0013%\u0011\u0011J\u0001\tEN+Xn\u0018\u0013fcR\u0019Q.a\u0013\t\u0011E\f)%!AA\u0002!Bq!a\u0014bA\u0003&\u0001&A\u0003c'Vl\u0007\u0005\u0003\u0006\u0002T\u0005\u0004\r\u00111A\u0005\n\u001d\nQA\u00192Tk6D1\"a\u0016b\u0001\u0004\u0005\r\u0011\"\u0003\u0002Z\u0005I!MY*v[~#S-\u001d\u000b\u0004[\u0006m\u0003\u0002C9\u0002V\u0005\u0005\t\u0019\u0001\u0015\t\u000f\u0005}\u0013\r)Q\u0005Q\u00051!MY*v[\u0002B1\"a\u0019b\u0001\u0004\u0005\r\u0011\"\u0003\u0002f\u0005!\u0011mU;n+\t\t9\u0007\u0005\u0003\u0002j\u0005=TBAA6\u0015\r\ti\u0007B\u0001\u0007Y&t\u0017\r\\4\n\t\u0005E\u00141\u000e\u0002\f\t\u0016t7/\u001a,fGR|'\u000fC\u0006\u0002v\u0005\u0004\r\u00111A\u0005\n\u0005]\u0014\u0001C1Tk6|F%Z9\u0015\u00075\fI\bC\u0005r\u0003g\n\t\u00111\u0001\u0002h!A\u0011QP1!B\u0013\t9'A\u0003b'Vl\u0007\u0005C\u0006\u0002\u0002\u0006\u0004\r\u00111A\u0005\n\u0005\u0015\u0014!B1c'Vl\u0007bCACC\u0002\u0007\t\u0019!C\u0005\u0003\u000f\u000b\u0011\"\u00192Tk6|F%Z9\u0015\u00075\fI\tC\u0005r\u0003\u0007\u000b\t\u00111\u0001\u0002h!A\u0011QR1!B\u0013\t9'\u0001\u0004bEN+X\u000e\t\u0005\f\u0003#\u000b\u0007\u0019!a\u0001\n\u0013\t)'A\u0003bCN+X\u000eC\u0006\u0002\u0016\u0006\u0004\r\u00111A\u0005\n\u0005]\u0015!C1b'Vlw\fJ3r)\ri\u0017\u0011\u0014\u0005\nc\u0006M\u0015\u0011!a\u0001\u0003OB\u0001\"!(bA\u0003&\u0011qM\u0001\u0007C\u0006\u001cV/\u001c\u0011\t\u000f\u0005\u0005\u0016\r\"\u0003\u0002$\u0006!\u0011N\\5u)\ri\u0017Q\u0015\u0005\u0007k\u0006}\u0005\u0019\u0001/\t\u000f\u0005%\u0016\r\"\u0001\u0002,\u0006\u0019\u0011\r\u001a3\u0015\t\u00055\u0016qV\u0007\u0002C\"9\u0011\u0011WAT\u0001\u0004a\u0015\u0001C5ogR\fgnY3\t\u000f\u0005U\u0016\r\"\u0001\u00028\u0006)Q.\u001a:hKR!\u0011QVA]\u0011\u001d\tY,a-A\u0002\u0019\fQa\u001c;iKJDq!a0b\t\u0003\t\t-\u0001\u0005wC2LG-\u0019;f)\u0005i\u0007bBAcC\u0012\u0005\u0011QM\u0001\u0005C\n\u000b'\u000f\u0003\u0004\u0002J\u0006$\taJ\u0001\u0005E\n\u000b'\u000f\u0003\u0004\u0002N\u0006$\taJ\u0001\u0005EN#H\rC\u0004\u0002R\u0006$\t!!\u001a\u0002\u000b\u0005\u0014')\u0019:\t\u000f\u0005U\u0017\r\"\u0001\u0002f\u0005)\u0011-\u0019\"be\"9\u0011\u0011\\1\u0005\u0002\u0005\u0015\u0014\u0001B1WCJD\u0011\"!8V\u0003\u0003%I!a8\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003C\u0004B!a9\u0002n6\u0011\u0011Q\u001d\u0006\u0005\u0003O\fI/\u0001\u0003mC:<'BAAv\u0003\u0011Q\u0017M^1\n\t\u0005=\u0018Q\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class WeightedLeastSquares
implements Logging,
Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public WeightedLeastSquaresModel fit(RDD<Instance> instances) {
        Tuple2 tuple2;
        Aggregator x$7 = new Aggregator();
        Serializable x$8 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Aggregator apply(Aggregator x$1, Instance x$2) {
                return x$1.add(x$2);
            }
        };
        Serializable x$9 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Aggregator apply(Aggregator x$3, Aggregator x$4) {
                return x$3.merge(x$4);
            }
        };
        int x$10 = instances.treeAggregate$default$4((Object)x$7);
        Aggregator summary2 = (Aggregator)instances.treeAggregate((Object)x$7, (Function2)x$8, (Function2)x$9, x$10, ClassTag$.MODULE$.apply(Aggregator.class));
        summary2.validate();
        this.logInfo((Function0<String>)new Serializable(this, summary2){
            public static final long serialVersionUID = 0L;
            private final Aggregator summary$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of instances: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.summary$1.count())}));
            }
            {
                this.summary$1 = summary$1;
            }
        });
        int k = this.fitIntercept() ? summary2.k() + 1 : summary2.k();
        int triK = summary2.triK();
        double wSum = summary2.wSum();
        double bBar = summary2.bBar();
        double bStd = summary2.bStd();
        DenseVector aBar = summary2.aBar();
        DenseVector aVar = summary2.aVar();
        DenseVector abBar = summary2.abBar();
        DenseVector aaBar = summary2.aaBar();
        double[] aaValues = aaBar.values();
        if (bStd == 0.0) {
            if (this.fitIntercept()) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero, so the coefficients will be "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"zeros and the intercept will be the mean of the label; as a result, "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"training is not needed."})).s((Seq)Nil$.MODULE$)).toString();
                    }
                });
                DenseVector coefficients2 = new DenseVector((double[])Array$.MODULE$.ofDim(k - 1, ClassTag$.MODULE$.Double()));
                double intercept = bBar;
                DenseVector diagInvAtWA = new DenseVector(new double[]{0.0});
                return new WeightedLeastSquaresModel(coefficients2, intercept, diagInvAtWA);
            }
            Predef$.MODULE$.require(!(this.regParam() > 0.0) || !this.standardizeLabel(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The standard deviation of the label is zero. Model cannot be regularized with standardization=true";
                }
            });
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The standard deviation of the label is zero. "})).s((Seq)Nil$.MODULE$)).append((Object)"Consider setting fitIntercept=true.").toString();
                }
            });
        }
        int i = 0;
        int j = 2;
        while (i < triK) {
            double lambda = this.regParam();
            if (this.standardizeFeatures()) {
                lambda *= aVar.apply(j - 2);
            }
            if (this.standardizeLabel() && bStd != 0.0) {
                lambda /= bStd;
            }
            int n = i;
            aaValues[n] = aaValues[n] + lambda;
            i += j;
            ++j;
        }
        double[] aa = this.fitIntercept() ? (double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar.values(), aBar.values(), {1.0}}), ClassTag$.MODULE$.Double()) : aaBar.values();
        double[] ab = this.fitIntercept() ? (double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{abBar.values(), {bBar}}), ClassTag$.MODULE$.Double()) : abBar.values();
        double[] x = CholeskyDecomposition$.MODULE$.solve(aa, ab);
        double[] aaInv = CholeskyDecomposition$.MODULE$.inverse(aa, k);
        DenseVector diagInvAtWA = new DenseVector((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), k).map((Function1)new Serializable(this, wSum, aaInv){
            public static final long serialVersionUID = 0L;
            private final double wSum$1;
            private final double[] aaInv$1;

            public final double apply(int i) {
                return this.apply$mcDI$sp(i);
            }

            public double apply$mcDI$sp(int i) {
                return this.aaInv$1[i + (i - 1) * i / 2 - 1] / this.wSum$1;
            }
            {
                this.wSum$1 = wSum$1;
                this.aaInv$1 = aaInv$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
        Tuple2 tuple22 = tuple2 = this.fitIntercept() ? new Tuple2((Object)new DenseVector((double[])Predef$.MODULE$.doubleArrayOps(x).slice(0, x.length - 1)), Predef$.MODULE$.doubleArrayOps(x).last()) : new Tuple2((Object)new DenseVector(x), (Object)BoxesRunTime.boxToDouble((double)0.0));
        if (tuple2 != null) {
            Tuple2 tuple23;
            DenseVector coefficients3 = (DenseVector)tuple2._1();
            double intercept = tuple2._2$mcD$sp();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)coefficients3, (Object)BoxesRunTime.boxToDouble((double)intercept));
            DenseVector coefficients4 = (DenseVector)tuple24._1();
            double intercept2 = tuple24._2$mcD$sp();
            return new WeightedLeastSquaresModel(coefficients4, intercept2, diagInvAtWA);
        }
        throw new MatchError((Object)tuple2);
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, boolean standardizeFeatures, boolean standardizeLabel) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(regParam >= 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WeightedLeastSquares $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"regParam cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.regParam())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (regParam == 0.0) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "regParam is zero, which might cause numerical instability and overfitting.";
                }
            });
        }
    }

    public static class Aggregator
    implements Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0)new Serializable(this, k){
                public static final long serialVersionUID = 0L;
                private final int k$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"In order to take the normal equation approach efficiently, ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"we set the max number of features to ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()), BoxesRunTime.boxToInteger((int)this.k$1)}))).toString();
                }
                {
                    this.k$1 = k$1;
                }
            });
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 != null) {
                Tuple3 tuple3;
                double l = instance2.label();
                double w2 = instance2.weight();
                Vector f = instance2.features();
                Tuple3 tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w2), (Object)f);
                double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                double w3 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                Vector f2 = (Vector)tuple32._3();
                int ak = f2.size();
                if (!this.initialized()) {
                    this.init(ak);
                }
                Predef$.MODULE$.assert(ak == this.k(), (Function0)new Serializable(this, ak){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final int ak$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch. Expect vectors of size ", " but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.ak$1)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.ak$1 = ak$1;
                    }
                });
                this.count_$eq(this.count() + 1L);
                this.wSum_$eq(this.wSum() + w3);
                this.wwSum_$eq(this.wwSum() + w3 * w3);
                this.bSum_$eq(this.bSum() + w3 * l2);
                this.bbSum_$eq(this.bbSum() + w3 * l2 * l2);
                BLAS$.MODULE$.axpy(w3, f2, (Vector)this.aSum());
                BLAS$.MODULE$.axpy(w3 * l2, f2, (Vector)this.abSum());
                BLAS$.MODULE$.spr(w3, f2, this.aaSum());
                return this;
            }
            throw new MatchError((Object)instance2);
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (other.initialized()) {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0)new Serializable(this, other){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Aggregator $outer;
                    private final Aggregator other$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dimension mismatch: this.k = ", " but other.k = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)this.other$1.k())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.other$1 = other$1;
                    }
                });
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            } else {
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Training dataset is empty.";
                }
            });
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sum of weights cannot be zero.";
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bStd() {
            return package$.MODULE$.sqrt(this.bbSum() / this.wSum() - this.bBar() * this.bBar());
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public DenseVector aVar() {
            double[] variance2 = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance2[l] = aaValues[i] / this.wSum() - aw * aw;
                i += j;
                ++j;
            }
            return new DenseVector(variance2);
        }
    }
}

