/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.GeneralizedLinearRegressionWrapper;
import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReadable$class;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenTraversableOnce;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class GeneralizedLinearRegressionWrapper$
implements MLReadable<GeneralizedLinearRegressionWrapper> {
    public static final GeneralizedLinearRegressionWrapper$ MODULE$;

    static {
        new GeneralizedLinearRegressionWrapper$();
    }

    public GeneralizedLinearRegressionWrapper fit(String formula, Dataset<Row> data, String family, String link, double tol, int maxIter) {
        RFormula rFormula = new RFormula().setFormula(formula);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(rFormula.getFeaturesCol())).attributes().get();
        String[] features = (String[])Predef$.MODULE$.refArrayOps((Object[])featureAttrs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Attribute x$1) {
                return (String)x$1.name().get();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        GeneralizedLinearRegression glr = new GeneralizedLinearRegression().setFamily(family).setLink(link).setFitIntercept(rFormula.hasIntercept()).setTol(tol).setMaxIter(maxIter);
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, glr})).fit((Dataset)data);
        GeneralizedLinearRegressionModel glm = (GeneralizedLinearRegressionModel)((PipelineModel)pipeline).stages()[1];
        GeneralizedLinearRegressionTrainingSummary summary2 = glm.summary();
        String[] rFeatures = glm.getFitIntercept() ? (String[])Predef$.MODULE$.refArrayOps((Object[])new String[]{"(Intercept)"}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])features), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : features;
        double[] rCoefficientStandardErrors = glm.getFitIntercept() ? (double[])Predef$.MODULE$.doubleArrayOps(new double[]{BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(summary2.coefficientStandardErrors()).last())}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(summary2.coefficientStandardErrors()).dropRight(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : summary2.coefficientStandardErrors();
        double[] rTValues = glm.getFitIntercept() ? (double[])Predef$.MODULE$.doubleArrayOps(new double[]{BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(summary2.tValues()).last())}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(summary2.tValues()).dropRight(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : summary2.tValues();
        double[] rPValues = glm.getFitIntercept() ? (double[])Predef$.MODULE$.doubleArrayOps(new double[]{BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(summary2.pValues()).last())}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(summary2.pValues()).dropRight(1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : summary2.pValues();
        double[] rCoefficients = glm.getFitIntercept() ? (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(new double[]{glm.intercept()}).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(glm.coefficients().toArray()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rCoefficientStandardErrors), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rTValues), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rPValues), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.doubleArrayOps(glm.coefficients().toArray()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rCoefficientStandardErrors), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rTValues), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.doubleArrayOps(rPValues), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double rDispersion = summary2.dispersion();
        double rNullDeviance = summary2.nullDeviance();
        double rDeviance = summary2.deviance();
        long rResidualDegreeOfFreedomNull = summary2.residualDegreeOfFreedomNull();
        long rResidualDegreeOfFreedom = summary2.residualDegreeOfFreedom();
        double rAic = summary2.aic();
        int rNumIterations = summary2.numIterations();
        return new GeneralizedLinearRegressionWrapper((PipelineModel)pipeline, rFeatures, rCoefficients, rDispersion, rNullDeviance, rDeviance, rResidualDegreeOfFreedomNull, rResidualDegreeOfFreedom, rAic, rNumIterations, this.$lessinit$greater$default$11());
    }

    @Override
    public MLReader<GeneralizedLinearRegressionWrapper> read() {
        return new GeneralizedLinearRegressionWrapper.GeneralizedLinearRegressionWrapperReader();
    }

    @Override
    public GeneralizedLinearRegressionWrapper load(String path) {
        return (GeneralizedLinearRegressionWrapper)MLReadable$class.load(this, path);
    }

    private boolean $lessinit$greater$default$11() {
        return false;
    }

    private GeneralizedLinearRegressionWrapper$() {
        MODULE$ = this;
        MLReadable$class.$init$(this);
    }
}

