/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.DecisionTreeRegressor;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$$anonfun$evaluateEachIteration$1$;
import org.apache.spark.ml.tree.impl.TimeTracker;
import org.apache.spark.mllib.impl.PeriodicRDDCheckpointer;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Variance$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class GradientBoostedTrees$
implements Logging {
    public static final GradientBoostedTrees$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new GradientBoostedTrees$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<DecisionTreeRegressionModel[], double[]> run(RDD<LabeledPoint> input, BoostingStrategy boostingStrategy, long seed) {
        void var5_4;
        block4: {
            Tuple2<DecisionTreeRegressionModel[], double[]> tuple2;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = boostingStrategy.treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    tuple2 = this.boost(input, input, boostingStrategy, false, seed);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                tuple2 = this.boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedInput, boostingStrategy, false, seed);
            }
            return tuple2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var5_4})));
    }

    /*
     * WARNING - void declaration
     */
    public Tuple2<DecisionTreeRegressionModel[], double[]> runWithValidation(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput, BoostingStrategy boostingStrategy, long seed) {
        void var6_5;
        block4: {
            Tuple2<DecisionTreeRegressionModel[], double[]> tuple2;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = boostingStrategy.treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    tuple2 = this.boost(input, validationInput, boostingStrategy, true, seed);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD remappedValidationInput = validationInput.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                tuple2 = this.boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedValidationInput, boostingStrategy, true, seed);
            }
            return tuple2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var6_5})));
    }

    public RDD<Tuple2<Object, Object>> computeInitialPredictionAndError(RDD<LabeledPoint> data, double initTreeWeight, DecisionTreeRegressionModel initTree, Loss loss2) {
        return data.map((Function1)new Serializable(initTreeWeight, initTree, loss2){
            public static final long serialVersionUID = 0L;
            private final double initTreeWeight$1;
            private final DecisionTreeRegressionModel initTree$1;
            private final Loss loss$1;

            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                double pred = GradientBoostedTrees$.MODULE$.updatePrediction(lp.features(), 0.0, this.initTree$1, this.initTreeWeight$1);
                double error = this.loss$1.computeError(pred, lp.label());
                return new Tuple2.mcDD.sp(pred, error);
            }
            {
                this.initTreeWeight$1 = initTreeWeight$1;
                this.initTree$1 = initTree$1;
                this.loss$1 = loss$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Object>> updatePredictionError(RDD<LabeledPoint> data, RDD<Tuple2<Object, Object>> predictionAndError, double treeWeight, DecisionTreeRegressionModel tree, Loss loss2) {
        RDD qual$1 = data.zip(predictionAndError, ClassTag$.MODULE$.apply(Tuple2.class));
        Serializable x$1 = new Serializable(treeWeight, tree, loss2){
            public static final long serialVersionUID = 0L;
            public final double treeWeight$1;
            public final DecisionTreeRegressionModel tree$1;
            public final Loss loss$2;

            public final Iterator<Tuple2<Object, Object>> apply(Iterator<Tuple2<LabeledPoint, Tuple2<Object, Object>>> iter) {
                return iter.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;

                    public final Tuple2<Object, Object> apply(Tuple2<LabeledPoint, Tuple2<Object, Object>> x0$1) {
                        Tuple2<LabeledPoint, Tuple2<Object, Object>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            LabeledPoint lp = (LabeledPoint)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double pred = tuple22._1$mcD$sp();
                                double newPred = GradientBoostedTrees$.MODULE$.updatePrediction(lp.features(), pred, this.$outer.tree$1, this.$outer.treeWeight$1);
                                double newError = this.$outer.loss$2.computeError(newPred, lp.label());
                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(newPred, newError);
                                return sp2;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.treeWeight$1 = treeWeight$1;
                this.tree$1 = tree$1;
                this.loss$2 = loss$2;
            }
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD newPredError = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
        return newPredError;
    }

    public double updatePrediction(Vector features, double prediction, DecisionTreeRegressionModel tree, double weight) {
        return prediction + tree.rootNode().predictImpl(features).prediction() * weight;
    }

    public double computeError(RDD<LabeledPoint> data, DecisionTreeRegressionModel[] trees, double[] treeWeights, Loss loss2) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(data.map((Function1)new Serializable(trees, treeWeights, loss2){
            public static final long serialVersionUID = 0L;
            private final DecisionTreeRegressionModel[] trees$1;
            private final double[] treeWeights$1;
            private final Loss loss$3;

            public final double apply(LabeledPoint lp) {
                double predicted = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.trees$1).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(this.treeWeights$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this, lp){
                    public static final long serialVersionUID = 0L;
                    private final LabeledPoint lp$1;

                    public final double apply(double x0$2, Tuple2<DecisionTreeRegressionModel, Object> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)x0$2), x1$1);
                        if (tuple2 != null) {
                            double acc = tuple2._1$mcD$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                DecisionTreeRegressionModel model = (DecisionTreeRegressionModel)tuple22._1();
                                double weight = tuple22._2$mcD$sp();
                                double d = GradientBoostedTrees$.MODULE$.updatePrediction(this.lp$1.features(), acc, model, weight);
                                return d;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.lp$1 = lp$1;
                    }
                }));
                return this.loss$3.computeError(predicted, lp.label());
            }
            {
                this.trees$1 = trees$1;
                this.treeWeights$1 = treeWeights$1;
                this.loss$3 = loss$3;
            }
        }, ClassTag$.MODULE$.Double())).mean();
    }

    public double[] evaluateEachIteration(RDD<LabeledPoint> data, DecisionTreeRegressionModel[] trees, double[] treeWeights, Loss loss2, Enumeration.Value algo) {
        SparkContext sc = data.sparkContext();
        Enumeration.Value value = algo;
        Enumeration.Value value2 = Algo$.MODULE$.Classification();
        Enumeration.Value value3 = value;
        RDD rDD = !(value2 != null ? !value2.equals(value3) : value3 != null) ? data.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final LabeledPoint apply(LabeledPoint x) {
                return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
            }
        }, ClassTag$.MODULE$.apply(LabeledPoint.class)) : data;
        RDD remappedData = rDD;
        int numIterations = trees.length;
        double[] evaluationArray = (double[])Array$.MODULE$.fill(numIterations, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        double[] localTreeWeights = treeWeights;
        ObjectRef predictionAndError = new ObjectRef(this.computeInitialPredictionAndError((RDD<LabeledPoint>)remappedData, localTreeWeights[0], trees[0], loss2));
        evaluationArray[0] = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)predictionAndError.elem, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values()).mean();
        Broadcast broadcastTrees = sc.broadcast((Object)trees, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(DecisionTreeRegressionModel.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), numIterations).foreach$mVc$sp((Function1)new Serializable(loss2, remappedData, evaluationArray, localTreeWeights, predictionAndError, broadcastTrees){
            public static final long serialVersionUID = 0L;
            public final Loss loss$4;
            private final RDD remappedData$1;
            private final double[] evaluationArray$1;
            public final double[] localTreeWeights$1;
            private final ObjectRef predictionAndError$1;
            public final Broadcast broadcastTrees$1;

            public final void apply(int nTree) {
                this.apply$mcVI$sp(nTree);
            }

            public void apply$mcVI$sp(int nTree) {
                RDD qual$2 = this.remappedData$1.zip((RDD)this.predictionAndError$1.elem, ClassTag$.MODULE$.apply(Tuple2.class));
                Serializable x$3 = new Serializable(this, nTree){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.evaluateEachIteration.1 $outer;
                    private final int nTree$1;

                    public final Iterator<Tuple2<Object, Object>> apply(Iterator<Tuple2<LabeledPoint, Tuple2<Object, Object>>> iter) {
                        DecisionTreeRegressionModel currentTree = ((DecisionTreeRegressionModel[])this.$outer.broadcastTrees$1.value())[this.nTree$1];
                        double currentTreeWeight = this.$outer.localTreeWeights$1[this.nTree$1];
                        return iter.map((Function1)new Serializable(this, currentTree, currentTreeWeight){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$evaluateEachIteration$1$$anonfun$8 $outer;
                            private final DecisionTreeRegressionModel currentTree$1;
                            private final double currentTreeWeight$1;

                            public final Tuple2<Object, Object> apply(Tuple2<LabeledPoint, Tuple2<Object, Object>> x0$3) {
                                Tuple2<LabeledPoint, Tuple2<Object, Object>> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    LabeledPoint point = (LabeledPoint)tuple2._1();
                                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                                    if (tuple22 != null) {
                                        double pred = tuple22._1$mcD$sp();
                                        double newPred = GradientBoostedTrees$.MODULE$.updatePrediction(point.features(), pred, this.currentTree$1, this.currentTreeWeight$1);
                                        double newError = this.$outer.org$apache$spark$ml$tree$impl$GradientBoostedTrees$$anonfun$$anonfun$$$outer().loss$4.computeError(newPred, point.label());
                                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(newPred, newError);
                                        return sp2;
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.currentTree$1 = currentTree$1;
                                this.currentTreeWeight$1 = currentTreeWeight$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.evaluateEachIteration.1 org$apache$spark$ml$tree$impl$GradientBoostedTrees$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.nTree$1 = nTree$1;
                    }
                };
                boolean x$4 = qual$2.mapPartitions$default$2();
                this.predictionAndError$1.elem = qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class));
                this.evaluationArray$1[nTree] = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.predictionAndError$1.elem, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values()).mean();
            }
            {
                this.loss$4 = loss$4;
                this.remappedData$1 = remappedData$1;
                this.evaluationArray$1 = evaluationArray$1;
                this.localTreeWeights$1 = localTreeWeights$1;
                this.predictionAndError$1 = predictionAndError$1;
                this.broadcastTrees$1 = broadcastTrees$1;
            }
        });
        broadcastTrees.unpersist();
        return evaluationArray;
    }

    public Tuple2<DecisionTreeRegressionModel[], double[]> boost(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput, BoostingStrategy boostingStrategy, boolean validate2, long seed) {
        boolean bl;
        TimeTracker timer = new TimeTracker();
        timer.start("total");
        timer.start("init");
        boostingStrategy.assertValid();
        int numIterations = boostingStrategy.numIterations();
        DecisionTreeRegressionModel[] baseLearners = new DecisionTreeRegressionModel[numIterations];
        double[] baseLearnerWeights = new double[numIterations];
        Loss loss2 = boostingStrategy.loss();
        double learningRate = boostingStrategy.learningRate();
        Strategy treeStrategy = boostingStrategy.treeStrategy().copy();
        double validationTol = boostingStrategy.validationTol();
        treeStrategy.algo_$eq(Algo$.MODULE$.Regression());
        treeStrategy.impurity_$eq(Variance$.MODULE$);
        treeStrategy.assertValid();
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            input.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            bl = true;
        } else {
            bl = false;
        }
        boolean persistedInput = bl;
        PeriodicRDDCheckpointer<RDD> predErrorCheckpointer = new PeriodicRDDCheckpointer<RDD>(treeStrategy.getCheckpointInterval(), input.sparkContext());
        PeriodicRDDCheckpointer<RDD<Tuple2<Object, Object>>> validatePredErrorCheckpointer = new PeriodicRDDCheckpointer<RDD<Tuple2<Object, Object>>>(treeStrategy.getCheckpointInterval(), input.sparkContext());
        timer.stop("init");
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "##########";
            }
        });
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Building tree 0";
            }
        });
        this.logDebug((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "##########";
            }
        });
        timer.start("building tree 0");
        DecisionTreeRegressor firstTree = new DecisionTreeRegressor().setSeed(seed);
        DecisionTreeRegressionModel firstTreeModel = firstTree.train(input, treeStrategy);
        double firstTreeWeight = 1.0;
        baseLearners[0] = firstTreeModel;
        baseLearnerWeights[0] = firstTreeWeight;
        ObjectRef predError = new ObjectRef(this.computeInitialPredictionAndError(input, firstTreeWeight, firstTreeModel, loss2));
        predErrorCheckpointer.update((RDD)predError.elem);
        this.logDebug((Function0<String>)new Serializable(predError){
            public static final long serialVersionUID = 0L;
            private final ObjectRef predError$1;

            public final String apply() {
                return new StringBuilder().append((Object)"error of gbt = ").append((Object)BoxesRunTime.boxToDouble((double)RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.predError$1.elem, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values()).mean())).toString();
            }
            {
                this.predError$1 = predError$1;
            }
        });
        timer.stop("building tree 0");
        RDD<Tuple2<Object, Object>> validatePredError = this.computeInitialPredictionAndError(validationInput, firstTreeWeight, firstTreeModel, loss2);
        if (validate2) {
            validatePredErrorCheckpointer.update(validatePredError);
        }
        double bestValidateError = validate2 ? RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(validatePredError, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values()).mean() : 0.0;
        int bestM = 1;
        IntRef m = new IntRef(1);
        boolean doneLearning = false;
        while (m.elem < numIterations && !doneLearning) {
            RDD data = ((RDD)predError.elem).zip(input, ClassTag$.MODULE$.apply(LabeledPoint.class)).map((Function1)new Serializable(loss2){
                public static final long serialVersionUID = 0L;
                private final Loss loss$5;

                public final LabeledPoint apply(Tuple2<Tuple2<Object, Object>, LabeledPoint> x0$4) {
                    Tuple2<Tuple2<Object, Object>, LabeledPoint> tuple2 = x0$4;
                    if (tuple2 != null) {
                        Tuple2 tuple22 = (Tuple2)tuple2._1();
                        LabeledPoint point = (LabeledPoint)tuple2._2();
                        if (tuple22 != null) {
                            double pred = tuple22._1$mcD$sp();
                            LabeledPoint labeledPoint = new LabeledPoint(-this.loss$5.gradient(pred, point.label()), point.features());
                            return labeledPoint;
                        }
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.loss$5 = loss$5;
                }
            }, ClassTag$.MODULE$.apply(LabeledPoint.class));
            timer.start(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"building tree ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m.elem)})));
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "###################################################";
                }
            });
            this.logDebug((Function0<String>)new Serializable(m){
                public static final long serialVersionUID = 0L;
                private final IntRef m$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Gradient boosting tree iteration ").append((Object)BoxesRunTime.boxToInteger((int)this.m$1.elem)).toString();
                }
                {
                    this.m$1 = m$1;
                }
            });
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "###################################################";
                }
            });
            DecisionTreeRegressor dt = new DecisionTreeRegressor().setSeed(seed + (long)m.elem);
            DecisionTreeRegressionModel model = dt.train((RDD<LabeledPoint>)data, treeStrategy);
            timer.stop(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"building tree ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m.elem)})));
            baseLearners[m.elem] = model;
            baseLearnerWeights[m.elem] = learningRate;
            predError.elem = this.updatePredictionError(input, (RDD<Tuple2<Object, Object>>)((RDD)predError.elem), baseLearnerWeights[m.elem], baseLearners[m.elem], loss2);
            predErrorCheckpointer.update((RDD)predError.elem);
            this.logDebug((Function0<String>)new Serializable(predError){
                public static final long serialVersionUID = 0L;
                private final ObjectRef predError$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"error of gbt = ").append((Object)BoxesRunTime.boxToDouble((double)RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions((RDD)this.predError$1.elem, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values()).mean())).toString();
                }
                {
                    this.predError$1 = predError$1;
                }
            });
            if (validate2) {
                validatePredError = this.updatePredictionError(validationInput, validatePredError, baseLearnerWeights[m.elem], baseLearners[m.elem], loss2);
                validatePredErrorCheckpointer.update(validatePredError);
                double currentValidateError = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(validatePredError, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Double$.MODULE$).values()).mean();
                if (bestValidateError - currentValidateError < validationTol * Math.max(currentValidateError, 0.01)) {
                    doneLearning = true;
                } else if (currentValidateError < bestValidateError) {
                    bestValidateError = currentValidateError;
                    bestM = m.elem + 1;
                }
            }
            ++m.elem;
        }
        timer.stop("total");
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Internal timing for DecisionTree:";
            }
        });
        this.logInfo((Function0<String>)new Serializable(timer){
            public static final long serialVersionUID = 0L;
            private final TimeTracker timer$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
            }
            {
                this.timer$1 = timer$1;
            }
        });
        predErrorCheckpointer.deleteAllCheckpoints();
        validatePredErrorCheckpointer.deleteAllCheckpoints();
        Object object = persistedInput ? input.unpersist(input.unpersist$default$1()) : BoxedUnit.UNIT;
        return validate2 ? new Tuple2(Predef$.MODULE$.refArrayOps((Object[])baseLearners).slice(0, bestM), Predef$.MODULE$.doubleArrayOps(baseLearnerWeights).slice(0, bestM)) : new Tuple2((Object)baseLearners, (Object)baseLearnerWeights);
    }

    private GradientBoostedTrees$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

