/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.StreamingKMeans$;
import org.apache.spark.mllib.clustering.StreamingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaDStream$;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u00015\u0011qb\u0015;sK\u0006l\u0017N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00155A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!!\u0007\f\u0003\u000f1{wmZ5oOB\u0011qbG\u0005\u00039A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\b\u0001\u0003\u0002\u0004%\taH\u0001\u0002WV\t\u0001\u0005\u0005\u0002\u0010C%\u0011!\u0005\u0005\u0002\u0004\u0013:$\bfA\u000f%UA\u0011Q\u0005K\u0007\u0002M)\u0011qEB\u0001\u000bC:tw\u000e^1uS>t\u0017BA\u0015'\u0005\u0015\u0019\u0016N\\2fC\u0005Y\u0013!B\u0019/e9\u0002\u0004\u0002C\u0017\u0001\u0005\u0003\u0007I\u0011\u0001\u0018\u0002\u000b-|F%Z9\u0015\u0005=\u0012\u0004CA\b1\u0013\t\t\u0004C\u0001\u0003V]&$\bbB\u001a-\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004f\u0001\u0017%U!Aa\u0007\u0001B\u0001B\u0003&\u0001%\u0001\u0002lA!\u001aQ\u0007\n\u0016\t\u0011e\u0002!\u00111A\u0005\u0002i\n1\u0002Z3dCf4\u0015m\u0019;peV\t1\b\u0005\u0002\u0010y%\u0011Q\b\u0005\u0002\u0007\t>,(\r\\3)\u0007a\"#\u0006\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0001B\u0003=!WmY1z\r\u0006\u001cGo\u001c:`I\u0015\fHCA\u0018C\u0011\u001d\u0019t(!AA\u0002mB3a\u0010\u0013+\u0011!)\u0005A!A!B\u0013Y\u0014\u0001\u00043fG\u0006Lh)Y2u_J\u0004\u0003f\u0001#%U!A\u0001\n\u0001BA\u0002\u0013\u0005\u0011*\u0001\u0005uS6,WK\\5u+\u0005Q\u0005CA&O\u001d\tyA*\u0003\u0002N!\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\rM#(/\u001b8h\u0015\ti\u0005\u0003K\u0002HI)B\u0001b\u0015\u0001\u0003\u0002\u0004%\t\u0001V\u0001\ri&lW-\u00168ji~#S-\u001d\u000b\u0003_UCqa\r*\u0002\u0002\u0003\u0007!\nK\u0002SI)B\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006KAS\u0001\ni&lW-\u00168ji\u0002B3a\u0016\u0013+\u0011\u0015Y\u0006\u0001\"\u0001]\u0003\u0019a\u0014N\\5u}Q!QlX1d!\tq\u0006!D\u0001\u0003\u0011\u0015q\"\f1\u0001!Q\ryFE\u000b\u0005\u0006si\u0003\ra\u000f\u0015\u0004C\u0012R\u0003\"\u0002%[\u0001\u0004Q\u0005fA2%U!\u001a!\f\n\u0016\t\u000bm\u0003A\u0011A4\u0015\u0003uC3A\u001a\u0013+\u0011\u001dQ\u0007\u00011A\u0005\u0012-\fQ!\\8eK2,\u0012\u0001\u001c\t\u0003=6L!A\u001c\u0002\u0003)M#(/Z1nS:<7*T3b]Nlu\u000eZ3m\u0011\u001d\u0001\b\u00011A\u0005\u0012E\f\u0011\"\\8eK2|F%Z9\u0015\u0005=\u0012\bbB\u001ap\u0003\u0003\u0005\r\u0001\u001c\u0005\u0007i\u0002\u0001\u000b\u0015\u00027\u0002\r5|G-\u001a7!\u0011\u00151\b\u0001\"\u0001x\u0003\u0011\u0019X\r^&\u0015\u0005aLX\"\u0001\u0001\t\u000by)\b\u0019\u0001\u0011)\u0007U$#\u0006C\u0003}\u0001\u0011\u0005Q0\u0001\btKR$UmY1z\r\u0006\u001cGo\u001c:\u0015\u0005at\b\"B@|\u0001\u0004Y\u0014!A1)\u0007m$#\u0006C\u0004\u0002\u0006\u0001!\t!a\u0002\u0002\u0017M,G\u000fS1mM2Kg-\u001a\u000b\u0006q\u0006%\u0011Q\u0002\u0005\b\u0003\u0017\t\u0019\u00011\u0001<\u0003!A\u0017\r\u001c4MS\u001a,\u0007B\u0002%\u0002\u0004\u0001\u0007!\n\u000b\u0003\u0002\u0004\u0011R\u0003bBA\n\u0001\u0011\u0005\u0011QC\u0001\u0012g\u0016$\u0018J\\5uS\u0006d7)\u001a8uKJ\u001cH#\u0002=\u0002\u0018\u00055\u0002\u0002CA\r\u0003#\u0001\r!a\u0007\u0002\u000f\r,g\u000e^3sgB)q\"!\b\u0002\"%\u0019\u0011q\u0004\t\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n\u0005\u0003\u0019a\u0017N\\1mO&!\u00111FA\u0013\u0005\u00191Vm\u0019;pe\"A\u0011qFA\t\u0001\u0004\t\t$A\u0004xK&<\u0007\u000e^:\u0011\t=\tib\u000f\u0015\u0005\u0003#!#\u0006C\u0004\u00028\u0001!\t!!\u000f\u0002!M,GOU1oI>l7)\u001a8uKJ\u001cHc\u0002=\u0002<\u0005}\u00121\t\u0005\b\u0003{\t)\u00041\u0001!\u0003\r!\u0017.\u001c\u0005\b\u0003\u0003\n)\u00041\u0001<\u0003\u00199X-[4ii\"Q\u0011QIA\u001b!\u0003\u0005\r!a\u0012\u0002\tM,W\r\u001a\t\u0004\u001f\u0005%\u0013bAA&!\t!Aj\u001c8hQ\u0011\t)\u0004\n\u0016\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T\u0005YA.\u0019;fgRlu\u000eZ3m)\u0005a\u0007\u0006BA(I)Bq!!\u0017\u0001\t\u0003\tY&A\u0004ue\u0006Lgn\u00148\u0015\u0007=\ni\u0006\u0003\u0005\u0002`\u0005]\u0003\u0019AA1\u0003\u0011!\u0017\r^1\u0011\r\u0005\r\u0014QNA\u0011\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014a\u00023tiJ,\u0017-\u001c\u0006\u0004\u0003W2\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\ty'!\u001a\u0003\u000f\u0011\u001bFO]3b[\"\"\u0011q\u000b\u0013+\u0011\u001d\tI\u0006\u0001C\u0001\u0003k\"2aLA<\u0011!\ty&a\u001dA\u0002\u0005e\u0004CBA>\u0003\u000b\u000b\t#\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0011Q\u0017M^1\u000b\t\u0005\r\u0015\u0011N\u0001\u0004CBL\u0017\u0002BAD\u0003{\u00121BS1wC\u0012\u001bFO]3b[\"*\u00111\u000f\u0013\u0002\f\u0006\u0012\u0011QR\u0001\u0006c9\"d\u0006\r\u0005\b\u0003#\u0003A\u0011AAJ\u0003%\u0001(/\u001a3jGR|e\u000e\u0006\u0003\u0002\u0016\u0006]\u0005#BA2\u0003[\u0002\u0003\u0002CA0\u0003\u001f\u0003\r!!\u0019)\t\u0005=EE\u000b\u0005\b\u0003#\u0003A\u0011AAO)\u0011\ty*a,\u0011\r\u0005m\u0014QQAQ!\u0011\t\u0019+a+\u000e\u0005\u0005\u0015&\u0002BAT\u0003S\u000bA\u0001\\1oO*\u0011\u0011qP\u0005\u0005\u0003[\u000b)KA\u0004J]R,w-\u001a:\t\u0011\u0005}\u00131\u0014a\u0001\u0003sBS!a'%\u0003\u0017Cq!!.\u0001\t\u0003\t9,A\bqe\u0016$\u0017n\u0019;P]Z\u000bG.^3t+\u0011\tI,!3\u0015\t\u0005m\u00161\u001e\u000b\u0005\u0003{\u000bY\u000e\u0005\u0004\u0002d\u00055\u0014q\u0018\t\u0007\u001f\u0005\u0005\u0017Q\u0019\u0011\n\u0007\u0005\r\u0007C\u0001\u0004UkBdWM\r\t\u0005\u0003\u000f\fI\r\u0004\u0001\u0005\u0011\u0005-\u00171\u0017b\u0001\u0003\u001b\u0014\u0011aS\t\u0005\u0003\u001f\f)\u000eE\u0002\u0010\u0003#L1!a5\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aDAl\u0013\r\tI\u000e\u0005\u0002\u0004\u0003:L\bBCAo\u0003g\u000b\t\u0011q\u0001\u0002`\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005\u0005\u0018q]Ac\u001b\t\t\u0019OC\u0002\u0002fB\tqA]3gY\u0016\u001cG/\u0003\u0003\u0002j\u0006\r(\u0001C\"mCN\u001cH+Y4\t\u0011\u0005}\u00131\u0017a\u0001\u0003[\u0004b!a\u0019\u0002n\u0005=\bcB\b\u0002B\u0006\u0015\u0017\u0011\u0005\u0015\u0005\u0003g##\u0006C\u0004\u00026\u0002!\t!!>\u0016\t\u0005](\u0011\u0001\u000b\u0005\u0003s\u0014\u0019\u0001\u0005\u0005\u0002|\u0005m\u0018q`AQ\u0013\u0011\ti0! \u0003\u001f)\u000bg/\u0019)bSJ$5\u000b\u001e:fC6\u0004B!a2\u0003\u0002\u0011A\u00111ZAz\u0005\u0004\ti\r\u0003\u0005\u0002`\u0005M\b\u0019\u0001B\u0003!!\tY(a?\u0002\u0000\u0006\u0005\u0002&BAzI\u0005-\u0005\u0002\u0003B\u0006\u0001\u0001&IA!\u0004\u0002#\u0005\u001c8/\u001a:u\u0013:LG/[1mSj,G\rF\u00010\u0011%\u0011\t\u0002AI\u0001\n\u0003\u0011\u0019\"\u0001\u000etKR\u0014\u0016M\u001c3p[\u000e+g\u000e^3sg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u0016)\"\u0011q\tB\fW\t\u0011I\u0002\u0005\u0003\u0003\u001c\t\rRB\u0001B\u000f\u0015\u0011\u0011yB!\t\u0002\u0013Ut7\r[3dW\u0016$'BA\u0014\u0011\u0013\u0011\u0011)C!\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rK\u0002\u0001I):\u0001Ba\u000b\u0003\u0011\u0003\u0011!QF\u0001\u0010'R\u0014X-Y7j]\u001e\\U*Z1ogB\u0019aLa\f\u0007\u000f\u0005\u0011\u0001\u0012\u0001\u0002\u00032M!!q\u0006\b\u001b\u0011\u001dY&q\u0006C\u0001\u0005k!\"A!\f\t\u0015\te\"q\u0006b\u0001\n\u000b\u0011Y$A\u0004C\u0003R\u001b\u0005*R*\u0016\u0005\turB\u0001B C\t\u0011\t%A\u0004cCR\u001c\u0007.Z:\t\u0013\t\u0015#q\u0006Q\u0001\u000e\tu\u0012\u0001\u0003\"B)\u000eCUi\u0015\u0011\t\u0015\t%#q\u0006b\u0001\n\u000b\u0011Y%\u0001\u0004Q\u001f&sEkU\u000b\u0003\u0005\u001bz!Aa\u0014\"\u0005\tE\u0013A\u00029pS:$8\u000fC\u0005\u0003V\t=\u0002\u0015!\u0004\u0003N\u00059\u0001kT%O)N\u0003\u0003B\u0003B-\u0005_\t\t\u0011\"\u0003\u0003\\\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011i\u0006\u0005\u0003\u0002$\n}\u0013\u0002\u0002B1\u0003K\u0013aa\u00142kK\u000e$\b")
public class StreamingKMeans
implements Logging,
Serializable {
    private int k;
    private double decayFactor;
    private String timeUnit;
    private StreamingKMeansModel model;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String POINTS() {
        return StreamingKMeans$.MODULE$.POINTS();
    }

    public static String BATCHES() {
        return StreamingKMeans$.MODULE$.BATCHES();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int k() {
        return this.k;
    }

    public void k_$eq(int x$1) {
        this.k = x$1;
    }

    public double decayFactor() {
        return this.decayFactor;
    }

    public void decayFactor_$eq(double x$1) {
        this.decayFactor = x$1;
    }

    public String timeUnit() {
        return this.timeUnit;
    }

    public void timeUnit_$eq(String x$1) {
        this.timeUnit = x$1;
    }

    public StreamingKMeansModel model() {
        return this.model;
    }

    public void model_$eq(StreamingKMeansModel x$1) {
        this.model = x$1;
    }

    public StreamingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of clusters must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public StreamingKMeans setDecayFactor(double a) {
        Predef$.MODULE$.require(a >= 0.0, (Function0)new Serializable(this, a){
            public static final long serialVersionUID = 0L;
            private final double a$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Decay factor must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.a$1)}));
            }
            {
                this.a$1 = a$1;
            }
        });
        this.decayFactor_$eq(a);
        return this;
    }

    public StreamingKMeans setHalfLife(double halfLife, String timeUnit) {
        block3: {
            block2: {
                Predef$.MODULE$.require(halfLife > 0.0, (Function0)new Serializable(this, halfLife){
                    public static final long serialVersionUID = 0L;
                    private final double halfLife$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Half life must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.halfLife$1)}));
                    }
                    {
                        this.halfLife$1 = halfLife$1;
                    }
                });
                String string = timeUnit;
                String string2 = "batches";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block2;
                String string3 = timeUnit;
                String string4 = "points";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
            }
            this.decayFactor_$eq(package$.MODULE$.exp(package$.MODULE$.log(0.5) / halfLife));
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamingKMeans $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Setting decay factor to: %g ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.$outer.decayFactor())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.timeUnit_$eq(timeUnit);
            return this;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid time unit for decay: ").append((Object)timeUnit).toString());
    }

    public StreamingKMeans setInitialCenters(Vector[] centers, double[] weights) {
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])centers).size() == Predef$.MODULE$.doubleArrayOps(weights).size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of initial centers must be equal to number of weights";
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])centers).size() == this.k(), (Function0)new Serializable(this, centers){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeans $outer;
            private final Vector[] centers$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of initial centers must be ", " but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.k()), BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])this.centers$1).size())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.centers$1 = centers$1;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps(weights).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$5) {
                return this.apply$mcZD$sp(x$5);
            }

            public boolean apply$mcZD$sp(double x$5) {
                return x$5 >= 0.0;
            }
        }), (Function0)new Serializable(this, weights){
            public static final long serialVersionUID = 0L;
            private final double[] weights$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weight for each inital center must be nonnegative but got [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(this.weights$1).mkString(" ")}));
            }
            {
                this.weights$1 = weights$1;
            }
        });
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public StreamingKMeans setRandomCenters(int dim, double weight, long seed) {
        Predef$.MODULE$.require(dim > 0, (Function0)new Serializable(this, dim){
            public static final long serialVersionUID = 0L;
            private final int dim$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of dimensions must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.dim$1)}));
            }
            {
                this.dim$1 = dim$1;
            }
        });
        Predef$.MODULE$.require(weight >= 0.0, (Function0)new Serializable(this, weight){
            public static final long serialVersionUID = 0L;
            private final double weight$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Weight for each center must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.weight$1)}));
            }
            {
                this.weight$1 = weight$1;
            }
        });
        XORShiftRandom random = new XORShiftRandom(seed);
        Vector[] centers = (Vector[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this, dim, random){
            public static final long serialVersionUID = 0L;
            private final int dim$1;
            public final XORShiftRandom random$1;

            public final Vector apply() {
                return Vectors$.MODULE$.dense((double[])Array$.MODULE$.fill(this.dim$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return this.$outer.random$1.nextGaussian();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Double()));
            }
            {
                this.dim$1 = dim$1;
                this.random$1 = random$1;
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
        double[] weights = (double[])Array$.MODULE$.fill(this.k(), (Function0)new Serializable(this, weight){
            public static final long serialVersionUID = 0L;
            private final double weight$1;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return this.weight$1;
            }
            {
                this.weight$1 = weight$1;
            }
        }, ClassTag$.MODULE$.Double());
        this.model_$eq(new StreamingKMeansModel(centers, weights));
        return this;
    }

    public long setRandomCenters$default$3() {
        return Utils$.MODULE$.random().nextLong();
    }

    public StreamingKMeansModel latestModel() {
        return this.model();
    }

    public void trainOn(DStream<Vector> data) {
        this.assertInitialized();
        data.foreachRDD((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingKMeans $outer;

            public final void apply(RDD<Vector> rdd, Time time) {
                this.$outer.model_$eq(this.$outer.model().update(rdd, this.$outer.decayFactor(), this.$outer.timeUnit()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void trainOn(JavaDStream<Vector> data) {
        this.trainOn((DStream<Vector>)data.dstream());
    }

    public DStream<Object> predictOn(DStream<Vector> data) {
        this.assertInitialized();
        StreamingKMeansModel streamingKMeansModel = this.model();
        return data.map((Function1)new Serializable(this, streamingKMeansModel){
            public static final long serialVersionUID = 0L;
            private final StreamingKMeansModel eta$0$1$1;

            public final int apply(Vector point) {
                return this.eta$0$1$1.predict(point);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public JavaDStream<Integer> predictOn(JavaDStream<Vector> data) {
        return JavaDStream$.MODULE$.fromDStream(this.predictOn((DStream<Vector>)data.dstream()), ClassTag$.MODULE$.apply(Integer.class));
    }

    public <K> DStream<Tuple2<K, Object>> predictOnValues(DStream<Tuple2<K, Vector>> data, ClassTag<K> evidence$1) {
        this.assertInitialized();
        DStream<Tuple2<K, Vector>> x$6 = data;
        ClassTag<K> x$7 = evidence$1;
        ClassTag x$8 = ClassTag$.MODULE$.apply(Vector.class);
        Null$ x$9 = DStream$.MODULE$.toPairDStreamFunctions$default$4(x$6);
        StreamingKMeansModel streamingKMeansModel = this.model();
        return DStream$.MODULE$.toPairDStreamFunctions(x$6, x$7, x$8, null).mapValues((Function1)new Serializable(this, streamingKMeansModel){
            public static final long serialVersionUID = 0L;
            private final StreamingKMeansModel eta$0$2$1;

            public final int apply(Vector point) {
                return this.eta$0$2$1.predict(point);
            }
            {
                this.eta$0$2$1 = eta$0$2$1;
            }
        }, ClassTag$.MODULE$.Int());
    }

    public <K> JavaPairDStream<K, Integer> predictOnValues(JavaPairDStream<K, Vector> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return JavaPairDStream$.MODULE$.fromPairDStream(this.predictOnValues(data.dstream(), tag), tag, ClassTag$.MODULE$.apply(Integer.class));
    }

    private void assertInitialized() {
        if (this.model().clusterCenters() == null) {
            throw new IllegalStateException("Initial cluster centers must be set before starting predictions");
        }
    }

    public StreamingKMeans(int k, double decayFactor, String timeUnit) {
        this.k = k;
        this.decayFactor = decayFactor;
        this.timeUnit = timeUnit;
        Logging.class.$init$((Logging)this);
        this.model = new StreamingKMeansModel(null, null);
    }

    public StreamingKMeans() {
        this(2, 1.0, "batches");
    }
}

