/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.feature.VocabWord;
import org.apache.spark.mllib.feature.Word2Vec$;
import org.apache.spark.mllib.feature.Word2Vec$$anonfun$fit$1$;
import org.apache.spark.mllib.feature.Word2Vec$$anonfun$fit$1$$anonfun$8$;
import org.apache.spark.mllib.feature.Word2VecModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tud\u0001B\u0001\u0003\u00015\u0011\u0001bV8sIJ2Vm\u0019\u0006\u0003\u0007\u0011\tqAZ3biV\u0014XM\u0003\u0002\u0006\r\u0005)Q\u000e\u001c7jE*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qAc\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f!\tA2$D\u0001\u001a\u0015\tQb!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\t\u000by\u0001A\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005\u0011\u0001bB\u0012\u0001\u0001\u0004%I\u0001J\u0001\u000bm\u0016\u001cGo\u001c:TSj,W#A\u0013\u0011\u0005=1\u0013BA\u0014\u0011\u0005\rIe\u000e\u001e\u0005\bS\u0001\u0001\r\u0011\"\u0003+\u000391Xm\u0019;peNK'0Z0%KF$\"a\u000b\u0018\u0011\u0005=a\u0013BA\u0017\u0011\u0005\u0011)f.\u001b;\t\u000f=B\u0013\u0011!a\u0001K\u0005\u0019\u0001\u0010J\u0019\t\rE\u0002\u0001\u0015)\u0003&\u0003-1Xm\u0019;peNK'0\u001a\u0011\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005aA.Z1s]&twMU1uKV\tQ\u0007\u0005\u0002\u0010m%\u0011q\u0007\u0005\u0002\u0007\t>,(\r\\3\t\u000fe\u0002\u0001\u0019!C\u0005u\u0005\u0001B.Z1s]&twMU1uK~#S-\u001d\u000b\u0003WmBqa\f\u001d\u0002\u0002\u0003\u0007Q\u0007\u0003\u0004>\u0001\u0001\u0006K!N\u0001\u000eY\u0016\f'O\\5oOJ\u000bG/\u001a\u0011\t\u000f}\u0002\u0001\u0019!C\u0005I\u0005ia.^7QCJ$\u0018\u000e^5p]NDq!\u0011\u0001A\u0002\u0013%!)A\tok6\u0004\u0016M\u001d;ji&|gn]0%KF$\"aK\"\t\u000f=\u0002\u0015\u0011!a\u0001K!1Q\t\u0001Q!\n\u0015\naB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004H\u0001\u0001\u0007I\u0011\u0002\u0013\u0002\u001b9,X.\u0013;fe\u0006$\u0018n\u001c8t\u0011\u001dI\u0005\u00011A\u0005\n)\u000b\u0011C\\;n\u0013R,'/\u0019;j_:\u001cx\fJ3r)\tY3\nC\u00040\u0011\u0006\u0005\t\u0019A\u0013\t\r5\u0003\u0001\u0015)\u0003&\u00039qW/\\%uKJ\fG/[8og\u0002Bqa\u0014\u0001A\u0002\u0013%\u0001+\u0001\u0003tK\u0016$W#A)\u0011\u0005=\u0011\u0016BA*\u0011\u0005\u0011auN\\4\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006A1/Z3e?\u0012*\u0017\u000f\u0006\u0002,/\"9q\u0006VA\u0001\u0002\u0004\t\u0006BB-\u0001A\u0003&\u0011+A\u0003tK\u0016$\u0007\u0005C\u0004\\\u0001\u0001\u0007I\u0011\u0002\u0013\u0002\u00115LgnQ8v]RDq!\u0018\u0001A\u0002\u0013%a,\u0001\u0007nS:\u001cu.\u001e8u?\u0012*\u0017\u000f\u0006\u0002,?\"9q\u0006XA\u0001\u0002\u0004)\u0003BB1\u0001A\u0003&Q%A\u0005nS:\u001cu.\u001e8uA!91\r\u0001a\u0001\n\u0013!\u0013!E7bqN+g\u000e^3oG\u0016dUM\\4uQ\"9Q\r\u0001a\u0001\n\u00131\u0017!F7bqN+g\u000e^3oG\u0016dUM\\4uQ~#S-\u001d\u000b\u0003W\u001dDqa\f3\u0002\u0002\u0003\u0007Q\u0005\u0003\u0004j\u0001\u0001\u0006K!J\u0001\u0013[\u0006D8+\u001a8uK:\u001cW\rT3oORD\u0007\u0005C\u0003l\u0001\u0011\u0005A.\u0001\u000btKRl\u0015\r_*f]R,gnY3MK:<G\u000f\u001b\u000b\u0003[:l\u0011\u0001\u0001\u0005\u0006G*\u0004\r!\n\u0015\u0004UB4\bCA9u\u001b\u0005\u0011(BA:\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003kJ\u0014QaU5oG\u0016\f\u0013a^\u0001\u0006e9\u0002d\u0006\r\u0005\u0006s\u0002!\tA_\u0001\u000eg\u0016$h+Z2u_J\u001c\u0016N_3\u0015\u00055\\\b\"B\u0012y\u0001\u0004)\u0003f\u0001=q{\u0006\na0A\u00032]Er\u0003\u0007C\u0004\u0002\u0002\u0001!\t!a\u0001\u0002\u001fM,G\u000fT3be:Lgn\u001a*bi\u0016$2!\\A\u0003\u0011\u0015\u0019t\u00101\u00016Q\ry\b/ \u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003A\u0019X\r\u001e(v[B\u000b'\u000f^5uS>t7\u000fF\u0002n\u0003\u001fAaaPA\u0005\u0001\u0004)\u0003\u0006BA\u0005avDq!!\u0006\u0001\t\u0003\t9\"\u0001\ttKRtU/\\%uKJ\fG/[8ogR\u0019Q.!\u0007\t\r\u001d\u000b\u0019\u00021\u0001&Q\u0011\t\u0019\u0002]?\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u000591/\u001a;TK\u0016$GcA7\u0002$!1q*!\bA\u0002ECC!!\bq{\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012!D:fi^Kg\u000eZ8x'&TX\rF\u0002n\u0003[Aq!a\f\u0002(\u0001\u0007Q%\u0001\u0004xS:$wn\u001e\u0015\u0006\u0003O\u0001\u00181G\u0011\u0003\u0003k\tQ!\r\u00187]ABq!!\u000f\u0001\t\u0003\tY$A\u0006tKRl\u0015N\\\"pk:$HcA7\u0002>!11,a\u000eA\u0002\u0015BS!a\u000eq\u0003\u0003\n#!a\u0011\u0002\u000bEr3G\f\u0019\t\u0011\u0005\u001d\u0003A1A\u0005\n\u0011\na\"\u0012-Q?R\u000b%\tT#`'&SV\tC\u0004\u0002L\u0001\u0001\u000b\u0011B\u0013\u0002\u001f\u0015C\u0006k\u0018+B\u00052+ulU%[\u000b\u0002B\u0001\"a\u0014\u0001\u0005\u0004%I\u0001J\u0001\b\u001b\u0006Cv,\u0012-Q\u0011\u001d\t\u0019\u0006\u0001Q\u0001\n\u0015\n\u0001\"T!Y?\u0016C\u0006\u000b\t\u0005\t\u0003/\u0002!\u0019!C\u0005I\u0005yQ*\u0011-`\u0007>#Ui\u0018'F\u001d\u001e#\u0006\nC\u0004\u0002\\\u0001\u0001\u000b\u0011B\u0013\u0002!5\u000b\u0005lX\"P\t\u0016{F*\u0012(H)\"\u0003\u0003\u0002CA\u0018\u0001\u0001\u0007I\u0011\u0002\u0013\t\u0013\u0005\u0005\u0004\u00011A\u0005\n\u0005\r\u0014AC<j]\u0012|wo\u0018\u0013fcR\u00191&!\u001a\t\u0011=\ny&!AA\u0002\u0015Bq!!\u001b\u0001A\u0003&Q%A\u0004xS:$wn\u001e\u0011\t\u0011\u00055\u0004\u00011A\u0005\nA\u000bq\u0002\u001e:bS:<vN\u001d3t\u0007>,h\u000e\u001e\u0005\n\u0003c\u0002\u0001\u0019!C\u0005\u0003g\n1\u0003\u001e:bS:<vN\u001d3t\u0007>,h\u000e^0%KF$2aKA;\u0011!y\u0013qNA\u0001\u0002\u0004\t\u0006bBA=\u0001\u0001\u0006K!U\u0001\u0011iJ\f\u0017N\\,pe\u0012\u001c8i\\;oi\u0002B\u0001\"! \u0001\u0001\u0004%I\u0001J\u0001\nm>\u001c\u0017MY*ju\u0016D\u0011\"!!\u0001\u0001\u0004%I!a!\u0002\u001bY|7-\u00192TSj,w\fJ3r)\rY\u0013Q\u0011\u0005\t_\u0005}\u0014\u0011!a\u0001K!9\u0011\u0011\u0012\u0001!B\u0013)\u0013A\u0003<pG\u0006\u00147+\u001b>fA!I\u0011Q\u0012\u0001A\u0002\u0013%\u0011qR\u0001\u0006m>\u001c\u0017MY\u000b\u0003\u0003#\u0003RaDAJ\u0003/K1!!&\u0011\u0005\u0015\t%O]1z!\r\t\u0013\u0011T\u0005\u0004\u00037\u0013!!\u0003,pG\u0006\u0014wk\u001c:e\u0011%\ty\n\u0001a\u0001\n\u0013\t\t+A\u0005w_\u000e\f'm\u0018\u0013fcR\u00191&a)\t\u0013=\ni*!AA\u0002\u0005E\u0005\u0002CAT\u0001\u0001\u0006K!!%\u0002\rY|7-\u00192!Q\u0011\t)+a+\u0011\u0007=\ti+C\u0002\u00020B\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0013\u0005M\u0006\u00011A\u0005\n\u0005U\u0016!\u0003<pG\u0006\u0014\u0007*Y:i+\t\t9\fE\u0004\u0002:\u0006\r\u0017qY\u0013\u000e\u0005\u0005m&\u0002BA_\u0003\u007f\u000bq!\\;uC\ndWMC\u0002\u0002BB\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)-a/\u0003\u000f!\u000b7\u000f['baB!\u0011\u0011ZAh\u001d\ry\u00111Z\u0005\u0004\u0003\u001b\u0004\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002R\u0006M'AB*ue&twMC\u0002\u0002NBA\u0011\"a6\u0001\u0001\u0004%I!!7\u0002\u001bY|7-\u00192ICNDw\fJ3r)\rY\u00131\u001c\u0005\n_\u0005U\u0017\u0011!a\u0001\u0003oC\u0001\"a8\u0001A\u0003&\u0011qW\u0001\u000bm>\u001c\u0017M\u0019%bg\"\u0004\u0003\u0006BAo\u0003WCq!!:\u0001\t\u0013\t9/\u0001\u0006mK\u0006\u0014hNV8dC\n,B!!;\u0002\u0000R\u00191&a;\t\u0011\u00055\u00181\u001da\u0001\u0003_\fq\u0001Z1uCN,G\u000f\u0005\u0004\u0002r\u0006]\u00181`\u0007\u0003\u0003gT1!!>\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003s\f\u0019PA\u0002S\t\u0012\u0003B!!@\u0002\u00002\u0001A\u0001\u0003B\u0001\u0003G\u0014\rAa\u0001\u0003\u0003M\u000bBA!\u0002\u0003\fA\u0019qBa\u0002\n\u0007\t%\u0001CA\u0004O_RD\u0017N\\4\u0011\r\t5!QDAd\u001d\u0011\u0011yA!\u0007\u000f\t\tE!qC\u0007\u0003\u0005'Q1A!\u0006\r\u0003\u0019a$o\\8u}%\t\u0011#C\u0002\u0003\u001cA\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003 \t\u0005\"\u0001C%uKJ\f'\r\\3\u000b\u0007\tm\u0001\u0003C\u0004\u0003&\u0001!IAa\n\u0002\u001d\r\u0014X-\u0019;f\u000bb\u0004H+\u00192mKR\u0011!\u0011\u0006\t\u0006\u001f\u0005M%1\u0006\t\u0004\u001f\t5\u0012b\u0001B\u0018!\t)a\t\\8bi\"9!1\u0007\u0001\u0005\n\tU\u0012\u0001E2sK\u0006$XMQ5oCJLHK]3f)\u0005Y\u0003b\u0002B\u001d\u0001\u0011\u0005!1H\u0001\u0004M&$X\u0003\u0002B\u001f\u0005\u0017\"BAa\u0010\u0003FA\u0019\u0011E!\u0011\n\u0007\t\r#AA\u0007X_J$'GV3d\u001b>$W\r\u001c\u0005\t\u0003[\u00149\u00041\u0001\u0003HA1\u0011\u0011_A|\u0005\u0013\u0002B!!@\u0003L\u0011A!\u0011\u0001B\u001c\u0005\u0004\u0011\u0019\u0001\u000b\u0003\u00038Al\bb\u0002B\u001d\u0001\u0011\u0005!\u0011K\u000b\u0005\u0005'\u0012I\u0007\u0006\u0003\u0003@\tU\u0003\u0002CAw\u0005\u001f\u0002\rAa\u0016\u0011\r\te#1\rB4\u001b\t\u0011YF\u0003\u0003\u0003^\t}\u0013\u0001\u00026bm\u0006T1A!\u0019\u0007\u0003\r\t\u0007/[\u0005\u0005\u0005K\u0012YFA\u0004KCZ\f'\u000b\u0012#\u0011\t\u0005u(\u0011\u000e\u0003\t\u0005\u0003\u0011yE1\u0001\u0003lE!!Q\u0001B7!\u0019\u0011yGa\u001e\u0002H6\u0011!\u0011\u000f\u0006\u0005\u0005g\u0012)(\u0001\u0003mC:<'B\u0001B/\u0013\u0011\u0011yB!\u001d)\t\t=\u0003/ \u0015\u0004\u0001Al\b")
public class Word2Vec
implements Serializable,
Logging {
    private int org$apache$spark$mllib$feature$Word2Vec$$vectorSize;
    private double org$apache$spark$mllib$feature$Word2Vec$$learningRate;
    private int org$apache$spark$mllib$feature$Word2Vec$$numPartitions;
    private int numIterations;
    private long org$apache$spark$mllib$feature$Word2Vec$$seed;
    private int org$apache$spark$mllib$feature$Word2Vec$$minCount;
    private int org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength;
    private final int org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE;
    private final int org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP;
    private final int org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH;
    private int org$apache$spark$mllib$feature$Word2Vec$$window;
    private long org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount;
    private int org$apache$spark$mllib$feature$Word2Vec$$vocabSize;
    private transient VocabWord[] vocab;
    private transient HashMap<String, Object> vocabHash;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$vectorSize() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$vectorSize_$eq(int x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize = x$1;
    }

    public double org$apache$spark$mllib$feature$Word2Vec$$learningRate() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$learningRate;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$learningRate_$eq(double x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$learningRate = x$1;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$numPartitions() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$numPartitions;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$numPartitions_$eq(int x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$numPartitions = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    public long org$apache$spark$mllib$feature$Word2Vec$$seed() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$seed;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$seed_$eq(long x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$seed = x$1;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$minCount() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$minCount;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$minCount_$eq(int x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$minCount = x$1;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength_$eq(int x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength = x$1;
    }

    public Word2Vec setMaxSentenceLength(int maxSentenceLength) {
        Predef$.MODULE$.require(maxSentenceLength > 0, (Function0)new Serializable(this, maxSentenceLength){
            public static final long serialVersionUID = 0L;
            private final int maxSentenceLength$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Maximum length of sentences must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxSentenceLength$1)}));
            }
            {
                this.maxSentenceLength$1 = maxSentenceLength$1;
            }
        });
        this.org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength_$eq(maxSentenceLength);
        return this;
    }

    public Word2Vec setVectorSize(int vectorSize) {
        Predef$.MODULE$.require(vectorSize > 0, (Function0)new Serializable(this, vectorSize){
            public static final long serialVersionUID = 0L;
            private final int vectorSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vector size must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.vectorSize$1)}));
            }
            {
                this.vectorSize$1 = vectorSize$1;
            }
        });
        this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize_$eq(vectorSize);
        return this;
    }

    public Word2Vec setLearningRate(double learningRate) {
        Predef$.MODULE$.require(learningRate > 0.0, (Function0)new Serializable(this, learningRate){
            public static final long serialVersionUID = 0L;
            private final double learningRate$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initial learning rate must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.learningRate$1)}));
            }
            {
                this.learningRate$1 = learningRate$1;
            }
        });
        this.org$apache$spark$mllib$feature$Word2Vec$$learningRate_$eq(learningRate);
        return this;
    }

    public Word2Vec setNumPartitions(int numPartitions) {
        Predef$.MODULE$.require(numPartitions > 0, (Function0)new Serializable(this, numPartitions){
            public static final long serialVersionUID = 0L;
            private final int numPartitions$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of partitions must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numPartitions$1)}));
            }
            {
                this.numPartitions$1 = numPartitions$1;
            }
        });
        this.org$apache$spark$mllib$feature$Word2Vec$$numPartitions_$eq(numPartitions);
        return this;
    }

    public Word2Vec setNumIterations(int numIterations) {
        Predef$.MODULE$.require(numIterations >= 0, (Function0)new Serializable(this, numIterations){
            public static final long serialVersionUID = 0L;
            private final int numIterations$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of iterations must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numIterations$1)}));
            }
            {
                this.numIterations$1 = numIterations$1;
            }
        });
        this.numIterations_$eq(numIterations);
        return this;
    }

    public Word2Vec setSeed(long seed) {
        this.org$apache$spark$mllib$feature$Word2Vec$$seed_$eq(seed);
        return this;
    }

    public Word2Vec setWindowSize(int window) {
        Predef$.MODULE$.require(window > 0, (Function0)new Serializable(this, window){
            public static final long serialVersionUID = 0L;
            private final int window$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Window of words must be positive but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.window$1)}));
            }
            {
                this.window$1 = window$1;
            }
        });
        this.org$apache$spark$mllib$feature$Word2Vec$$window_$eq(window);
        return this;
    }

    public Word2Vec setMinCount(int minCount) {
        Predef$.MODULE$.require(minCount >= 0, (Function0)new Serializable(this, minCount){
            public static final long serialVersionUID = 0L;
            private final int minCount$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Minimum number of times must be nonnegative but got ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.minCount$1)}));
            }
            {
                this.minCount$1 = minCount$1;
            }
        });
        this.org$apache$spark$mllib$feature$Word2Vec$$minCount_$eq(minCount);
        return this;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$window() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$window;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$window_$eq(int x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$window = x$1;
    }

    public long org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount_$eq(long x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount = x$1;
    }

    public int org$apache$spark$mllib$feature$Word2Vec$$vocabSize() {
        return this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize;
    }

    private void org$apache$spark$mllib$feature$Word2Vec$$vocabSize_$eq(int x$1) {
        this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize = x$1;
    }

    private VocabWord[] vocab() {
        return this.vocab;
    }

    private void vocab_$eq(VocabWord[] x$1) {
        this.vocab = x$1;
    }

    private HashMap<String, Object> vocabHash() {
        return this.vocabHash;
    }

    private void vocabHash_$eq(HashMap<String, Object> x$1) {
        this.vocabHash = x$1;
    }

    private <S extends Iterable<String>> void learnVocab(RDD<S> dataset) {
        RDD words = dataset.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final S apply(S x) {
                return x;
            }
        }, ClassTag$.MODULE$.apply(String.class));
        this.vocab_$eq((VocabWord[])Predef$.MODULE$.refArrayOps((Object[])RDD$.MODULE$.rddToPairRDDFunctions(words.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(String w2) {
                return new Tuple2((Object)w2, (Object)BoxesRunTime.boxToInteger((int)1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$1, int x$2) {
                return this.apply$mcIII$sp(x$1, x$2);
            }

            public int apply$mcIII$sp(int x$1, int x$2) {
                return x$1 + x$2;
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2Vec $outer;

            public final boolean apply(Tuple2<String, Object> x$3) {
                return x$3._2$mcI$sp() >= this.$outer.org$apache$spark$mllib$feature$Word2Vec$$minCount();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2Vec $outer;

            public final VocabWord apply(Tuple2<String, Object> x) {
                return new VocabWord((String)x._1(), x._2$mcI$sp(), new int[this.$outer.org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH()], new int[this.$outer.org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH()], 0);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(VocabWord.class)).collect()).sortWith((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(VocabWord a, VocabWord b) {
                return a.cn() > b.cn();
            }
        }));
        this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize_$eq(this.vocab().length);
        Predef$.MODULE$.require(this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The vocabulary size should be > 0. You may need to check the setting of minCount, which could be large enough to remove all your words in sentences.";
            }
        });
        for (int a = 0; a < this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize(); ++a) {
            this.vocabHash().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.vocab()[a].word()), (Object)BoxesRunTime.boxToInteger((int)a)));
            this.org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount_$eq(this.org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount() + (long)this.vocab()[a].cn());
        }
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2Vec $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"vocabSize = ", ", trainWordsCount = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vocabSize()), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private float[] createExpTable() {
        void var1_1;
        float[] expTable = new float[this.org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE()];
        for (int i = 0; i < this.org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE(); ++i) {
            double tmp = scala.math.package$.MODULE$.exp((2.0 * (double)i / (double)this.org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE() - 1.0) * (double)this.org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP());
            expTable[i] = (float)(tmp / (tmp + 1.0));
        }
        return var1_1;
    }

    private void createBinaryTree() {
        int a;
        long[] count = new long[this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * 2 + 1];
        int[] binary = new int[this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * 2 + 1];
        int[] parentNode = new int[this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * 2 + 1];
        int[] code = new int[this.org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH()];
        int[] point = new int[this.org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH()];
        for (a = 0; a < this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize(); ++a) {
            count[a] = this.vocab()[a].cn();
        }
        while (a < 2 * this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize()) {
            count[a] = (int)1.0E9;
            ++a;
        }
        int pos1 = this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() - 1;
        int pos2 = this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize();
        int min1i = 0;
        int min2i = 0;
        for (a = 0; a < this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() - 1; ++a) {
            min1i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            min2i = pos1 >= 0 ? (count[pos1] < count[pos2] ? pos1-- : pos2++) : pos2++;
            count[this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() + a] = count[min1i] + count[min2i];
            parentNode[min1i] = this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() + a;
            parentNode[min2i] = this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() + a;
            binary[min2i] = 1;
        }
        int i = 0;
        for (a = 0; a < this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize(); ++a) {
            int b = a;
            i = 0;
            while (b != this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * 2 - 2) {
                code[i] = binary[b];
                point[i] = b;
                ++i;
                b = parentNode[b];
            }
            this.vocab()[a].codeLen_$eq(i);
            this.vocab()[a].point()[0] = this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() - 2;
            for (b = 0; b < i; ++b) {
                this.vocab()[a].code()[i - b - 1] = code[b];
                this.vocab()[a].point()[i - b] = point[b] - this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize();
            }
        }
    }

    public <S extends Iterable<String>> Word2VecModel fit(RDD<S> dataset) {
        this.learnVocab(dataset);
        this.createBinaryTree();
        SparkContext sc = dataset.context();
        Broadcast expTable = sc.broadcast((Object)this.createExpTable(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
        Broadcast bcVocab = sc.broadcast((Object)this.vocab(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VocabWord.class)));
        Broadcast bcVocabHash = sc.broadcast(this.vocabHash(), ClassTag$.MODULE$.apply(HashMap.class));
        RDD sentences = dataset.mapPartitions((Function1)new Serializable(this, bcVocabHash){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2Vec $outer;
            public final Broadcast bcVocabHash$1;

            public final Iterator<int[]> apply(Iterator<S> sentenceIter) {
                return sentenceIter.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Iterator<int[]> apply(S sentence) {
                        HashMap hashMap = (HashMap)this.$outer.bcVocabHash$1.value();
                        Iterable wordIndexes = (Iterable)sentence.flatMap((Function1)new Serializable(this, hashMap){
                            public static final long serialVersionUID = 0L;
                            private final HashMap eta$0$1$1;

                            public final Iterable<Object> apply(String key) {
                                return Option$.MODULE$.option2Iterable(this.eta$0$1$1.get((Object)key));
                            }
                            {
                                this.eta$0$1$1 = eta$0$1$1;
                            }
                        }, Iterable$.MODULE$.canBuildFrom());
                        return wordIndexes.grouped(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int[] apply(Iterable<Object> x$4) {
                                return (int[])x$4.toArray(ClassTag$.MODULE$.Int());
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ Word2Vec org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcVocabHash$1 = bcVocabHash$1;
            }
        }, dataset.mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
        int x$14 = this.org$apache$spark$mllib$feature$Word2Vec$$numPartitions();
        Ordering x$15 = sentences.repartition$default$2(x$14);
        RDD newSentences = sentences.repartition(x$14, x$15).cache();
        XORShiftRandom initRandom2 = new XORShiftRandom(this.org$apache$spark$mllib$feature$Word2Vec$$seed());
        if ((long)this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * (long)this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize() >= Integer.MAX_VALUE) {
            throw new RuntimeException(new StringBuilder().append((Object)"Please increase minCount or decrease vectorSize in Word2Vec to avoid an OOM. You are highly recommended to make your vocabSize*vectorSize, which is ").append((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize())).append((Object)"*").append((Object)BoxesRunTime.boxToInteger((int)this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize())).append((Object)" for now, less than `Int.MaxValue`.").toString());
        }
        float[] syn0Global = (float[])Array$.MODULE$.fill(this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), (Function0)new Serializable(this, initRandom2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2Vec $outer;
            private final XORShiftRandom initRandom$1;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return (this.initRandom$1.nextFloat() - 0.5f) / (float)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vectorSize();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.initRandom$1 = initRandom$1;
            }
        }, ClassTag$.MODULE$.Float());
        float[] syn1Global = new float[this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize() * this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize()];
        DoubleRef alpha = new DoubleRef(this.org$apache$spark$mllib$feature$Word2Vec$$learningRate());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.numIterations()).foreach$mVc$sp((Function1)new Serializable(this, sc, expTable, bcVocab, newSentences, syn0Global, syn1Global, alpha){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2Vec $outer;
            private final SparkContext sc$1;
            public final Broadcast expTable$1;
            public final Broadcast bcVocab$1;
            private final RDD newSentences$1;
            private final float[] syn0Global$1;
            private final float[] syn1Global$1;
            public final DoubleRef alpha$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                Broadcast bcSyn0Global = this.sc$1.broadcast((Object)this.syn0Global$1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
                Broadcast bcSyn1Global = this.sc$1.broadcast((Object)this.syn1Global$1, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)));
                RDD partial = this.newSentences$1.mapPartitionsWithIndex((Function2)new Serializable(this, bcSyn0Global, bcSyn1Global, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$fit$1 $outer;
                    private final Broadcast bcSyn0Global$1;
                    private final Broadcast bcSyn1Global$1;
                    private final int k$1;

                    public final Iterator<Tuple2<Object, float[]>> apply(int x0$1, Iterator<int[]> x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), x1$1);
                        if (tuple2 != null) {
                            int idx = tuple2._1$mcI$sp();
                            Iterator iter = (Iterator)tuple2._2();
                            XORShiftRandom random = new XORShiftRandom(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$seed() ^ (long)(idx + 1 << 16) ^ (long)(-this.k$1 - 1 << 8));
                            int[] syn0Modify = new int[this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vocabSize()];
                            int[] syn1Modify = new int[this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vocabSize()];
                            Tuple4 model = (Tuple4)iter.foldLeft((Object)new Tuple4(this.bcSyn0Global$1.value(), this.bcSyn1Global$1.value(), (Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2)new Serializable(this, random, syn0Modify, syn1Modify){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$fit$1$$anonfun$8 $outer;
                                private final XORShiftRandom random$1;
                                private final int[] syn0Modify$1;
                                private final int[] syn1Modify$1;

                                public final Tuple4<float[], float[], Object, Object> apply(Tuple4<float[], float[], Object, Object> x0$2, int[] x1$2) {
                                    Tuple2 tuple2 = new Tuple2(x0$2, (Object)x1$2);
                                    if (tuple2 != null) {
                                        Tuple4 tuple4 = (Tuple4)tuple2._1();
                                        int[] sentence = (int[])tuple2._2();
                                        if (tuple4 != null) {
                                            float[] syn0 = (float[])tuple4._1();
                                            float[] syn1 = (float[])tuple4._2();
                                            long lastWordCount = BoxesRunTime.unboxToLong((Object)tuple4._3());
                                            long wordCount = BoxesRunTime.unboxToLong((Object)tuple4._4());
                                            long lwc = lastWordCount;
                                            long wc = wordCount;
                                            if (wordCount - lastWordCount > 10000L) {
                                                lwc = wordCount;
                                                this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().alpha$1.elem = this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$learningRate() * (1.0 - (double)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$numPartitions() * (double)wordCount / (double)(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount() + 1L));
                                                if (this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().alpha$1.elem < this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$learningRate() * 1.0E-4) {
                                                    this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().alpha$1.elem = this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$learningRate() * 1.0E-4;
                                                }
                                                this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this, wordCount){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$fit$1$$anonfun$8$$anonfun$9 $outer;
                                                    private final long wordCount$1;

                                                    public final String apply() {
                                                        return new StringBuilder().append((Object)"wordCount = ").append((Object)BoxesRunTime.boxToLong((long)this.wordCount$1)).append((Object)", alpha = ").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().alpha$1.elem)).toString();
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.wordCount$1 = wordCount$1;
                                                    }
                                                });
                                            }
                                            wc += (long)sentence.length;
                                            for (int pos = 0; pos < sentence.length; ++pos) {
                                                int b;
                                                int word = sentence[pos];
                                                for (int a = b = this.random$1.nextInt(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$window()); a < this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$window() * 2 + 1 - b; ++a) {
                                                    int c;
                                                    if (a == this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$window() || (c = pos - this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$window() + a) < 0 || c >= sentence.length) continue;
                                                    int lastWord = sentence[c];
                                                    int l1 = lastWord * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize();
                                                    float[] neu1e = new float[this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize()];
                                                    for (int d = 0; d < ((VocabWord[])this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().bcVocab$1.value())[word].codeLen(); ++d) {
                                                        int inner = ((VocabWord[])this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().bcVocab$1.value())[word].point()[d];
                                                        int l2 = inner * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize();
                                                        float f = BLAS.getInstance().sdot(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), syn0, l1, 1, syn1, l2, 1);
                                                        if (!(f > (float)(-this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP())) || !(f < (float)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP())) continue;
                                                        int ind = (int)((double)(f + (float)this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP()) * ((double)(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE() / this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP()) / 2.0));
                                                        f = ((float[])this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().expTable$1.value())[ind];
                                                        float g = (float)((double)((float)(1 - ((VocabWord[])this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().bcVocab$1.value())[word].code()[d]) - f) * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().alpha$1.elem);
                                                        BLAS.getInstance().saxpy(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), g, syn1, l2, 1, neu1e, 0, 1);
                                                        BLAS.getInstance().saxpy(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), g, syn0, l1, 1, syn1, l2, 1);
                                                        this.syn1Modify$1[inner] = this.syn1Modify$1[inner] + 1;
                                                    }
                                                    BLAS.getInstance().saxpy(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), 1.0f, neu1e, 0, 1, syn0, l1, 1);
                                                    this.syn0Modify$1[lastWord] = this.syn0Modify$1[lastWord] + 1;
                                                }
                                            }
                                            Tuple4 tuple42 = new Tuple4((Object)syn0, (Object)syn1, (Object)BoxesRunTime.boxToLong((long)lwc), (Object)BoxesRunTime.boxToLong((long)wc));
                                            return tuple42;
                                        }
                                    }
                                    throw new MatchError((Object)tuple2);
                                }

                                public /* synthetic */ $anonfun$fit$1$$anonfun$8 org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.random$1 = random$1;
                                    this.syn0Modify$1 = syn0Modify$1;
                                    this.syn1Modify$1 = syn1Modify$1;
                                }
                            });
                            float[] syn0Local = (float[])model._1();
                            float[] syn1Local = (float[])model._2();
                            Iterator iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vocabSize(), (Function1)new Serializable(this, syn0Modify, syn0Local){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$fit$1$$anonfun$8 $outer;
                                private final int[] syn0Modify$1;
                                private final float[] syn0Local$1;

                                public final Option<Tuple2<Object, float[]>> apply(int index2) {
                                    return this.syn0Modify$1[index2] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)index2), Predef$.MODULE$.floatArrayOps(this.syn0Local$1).slice(index2 * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), (index2 + 1) * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize()))) : None$.MODULE$;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.syn0Modify$1 = syn0Modify$1;
                                    this.syn0Local$1 = syn0Local$1;
                                }
                            }), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Iterable<Tuple2<Object, float[]>> apply(Option<Tuple2<Object, float[]>> xo) {
                                    return Option$.MODULE$.option2Iterable(xo);
                                }
                            }).flatten().$plus$plus((Function0)new Serializable(this, syn1Modify, syn1Local){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$fit$1$$anonfun$8 $outer;
                                public final int[] syn1Modify$1;
                                public final float[] syn1Local$1;

                                public final Iterator<Tuple2<Object, float[]>> apply() {
                                    return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)package$.MODULE$.Iterator().tabulate(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vocabSize(), (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$fit$1$$anonfun$8$$anonfun$apply$6 $outer;

                                        public final Option<Tuple2<Object, float[]>> apply(int index2) {
                                            return this.$outer.syn1Modify$1[index2] > 0 ? new Some((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)(index2 + this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vocabSize())), Predef$.MODULE$.floatArrayOps(this.$outer.syn1Local$1).slice(index2 * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), (index2 + 1) * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize()))) : None$.MODULE$;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }), (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Iterable<Tuple2<Object, float[]>> apply(Option<Tuple2<Object, float[]>> xo) {
                                            return Option$.MODULE$.option2Iterable(xo);
                                        }
                                    }).flatten();
                                }

                                public /* synthetic */ $anonfun$fit$1$$anonfun$8 org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.syn1Modify$1 = syn1Modify$1;
                                    this.syn1Local$1 = syn1Local$1;
                                }
                            });
                            return iterator;
                        }
                        throw new MatchError((Object)tuple2);
                    }

                    public /* synthetic */ $anonfun$fit$1 org$apache$spark$mllib$feature$Word2Vec$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.bcSyn0Global$1 = bcSyn0Global$1;
                        this.bcSyn1Global$1 = bcSyn1Global$1;
                        this.k$1 = k$1;
                    }
                }, this.newSentences$1.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                Tuple2[] synAgg = (Tuple2[])RDD$.MODULE$.rddToPairRDDFunctions(partial, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Float.TYPE)), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$fit$1 $outer;

                    public final float[] apply(float[] x0$3, float[] x1$3) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
                        if (tuple2 != null) {
                            float[] v1 = (float[])tuple2._1();
                            float[] v2 = (float[])tuple2._2();
                            BLAS.getInstance().saxpy(this.$outer.org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer().org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), 1.0f, v2, 1, v1, 1);
                            float[] fArray = v1;
                            return fArray;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).collect();
                for (int i = 0; i < synAgg.length; ++i) {
                    int index2 = synAgg[i]._1$mcI$sp();
                    if (index2 < this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vocabSize()) {
                        Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)this.syn0Global$1, index2 * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vectorSize());
                        continue;
                    }
                    Array$.MODULE$.copy(synAgg[i]._2(), 0, (Object)this.syn1Global$1, (index2 - this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vocabSize()) * this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vectorSize(), this.$outer.org$apache$spark$mllib$feature$Word2Vec$$vectorSize());
                }
                bcSyn0Global.unpersist(false);
                bcSyn1Global.unpersist(false);
            }

            public /* synthetic */ Word2Vec org$apache$spark$mllib$feature$Word2Vec$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sc$1 = sc$1;
                this.expTable$1 = expTable$1;
                this.bcVocab$1 = bcVocab$1;
                this.newSentences$1 = newSentences$1;
                this.syn0Global$1 = syn0Global$1;
                this.syn1Global$1 = syn1Global$1;
                this.alpha$1 = alpha$1;
            }
        });
        newSentences.unpersist(newSentences.unpersist$default$1());
        expTable.destroy();
        bcVocab.destroy();
        bcVocabHash.destroy();
        String[] wordArray = (String[])Predef$.MODULE$.refArrayOps((Object[])this.vocab()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(VocabWord x$5) {
                return x$5.word();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new Word2VecModel((Map<String, Object>)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])wordArray).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms()), syn0Global);
    }

    public <S extends java.lang.Iterable<String>> Word2VecModel fit(JavaRDD<S> dataset) {
        return this.fit(dataset.rdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<String> apply(S x$6) {
                return (Iterable)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$6).asScala();
            }
        }, ClassTag$.MODULE$.apply(Iterable.class)));
    }

    public Word2Vec() {
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$mllib$feature$Word2Vec$$vectorSize = 100;
        this.org$apache$spark$mllib$feature$Word2Vec$$learningRate = 0.025;
        this.org$apache$spark$mllib$feature$Word2Vec$$numPartitions = 1;
        this.numIterations = 1;
        this.org$apache$spark$mllib$feature$Word2Vec$$seed = Utils$.MODULE$.random().nextLong();
        this.org$apache$spark$mllib$feature$Word2Vec$$minCount = 5;
        this.org$apache$spark$mllib$feature$Word2Vec$$maxSentenceLength = 1000;
        this.org$apache$spark$mllib$feature$Word2Vec$$EXP_TABLE_SIZE = 1000;
        this.org$apache$spark$mllib$feature$Word2Vec$$MAX_EXP = 6;
        this.org$apache$spark$mllib$feature$Word2Vec$$MAX_CODE_LENGTH = 40;
        this.org$apache$spark$mllib$feature$Word2Vec$$window = 5;
        this.org$apache$spark$mllib$feature$Word2Vec$$trainWordsCount = 0L;
        this.org$apache$spark$mllib$feature$Word2Vec$$vocabSize = 0;
        this.vocab = null;
        this.vocabHash = HashMap$.MODULE$.empty();
    }
}

