/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.inv$;
import breeze.linalg.qr;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$$anonfun$24$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$2$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001B\u0001\u0003\u0001=\u0011\u0011BU8x\u001b\u0006$(/\u001b=\u000b\u0005\r!\u0011a\u00033jgR\u0014\u0018NY;uK\u0012T!!\u0002\u0004\u0002\r1Lg.\u00197h\u0015\t9\u0001\"A\u0003nY2L'M\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\t\u00175A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003\tI!!\u0007\u0002\u0003#\u0011K7\u000f\u001e:jEV$X\rZ'biJL\u0007\u0010\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\u0011\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002 9\t9Aj\\4hS:<\u0007\u0002C\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\tI|wo]\u000b\u0002GA\u0019AeJ\u0015\u000e\u0003\u0015R!A\n\u0005\u0002\u0007I$G-\u0003\u0002)K\t\u0019!\u000b\u0012#\u0011\u0005)ZS\"\u0001\u0003\n\u00051\"!A\u0002,fGR|'\u000fK\u0002!]Q\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0005\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00024a\t)1+\u001b8dK\u0006\nQ'A\u00032]Ar\u0003\u0007\u0003\u00058\u0001\t\u0005\t\u0015!\u0003$\u0003\u0015\u0011xn^:!Q\r1d\u0006\u000e\u0005\tu\u0001\u0011\t\u0019!C\u0005w\u0005)aNU8xgV\tA\b\u0005\u0002\u0012{%\u0011aH\u0005\u0002\u0005\u0019>tw\r\u0003\u0005A\u0001\t\u0005\r\u0011\"\u0003B\u0003%q'k\\<t?\u0012*\u0017\u000f\u0006\u0002C\u000bB\u0011\u0011cQ\u0005\u0003\tJ\u0011A!\u00168ji\"9aiPA\u0001\u0002\u0004a\u0014a\u0001=%c!A\u0001\n\u0001B\u0001B\u0003&A(\u0001\u0004o%><8\u000f\t\u0005\t\u0015\u0002\u0011\t\u0019!C\u0005\u0017\u0006)anQ8mgV\tA\n\u0005\u0002\u0012\u001b&\u0011aJ\u0005\u0002\u0004\u0013:$\b\u0002\u0003)\u0001\u0005\u0003\u0007I\u0011B)\u0002\u00139\u001cu\u000e\\:`I\u0015\fHC\u0001\"S\u0011\u001d1u*!AA\u00021C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006K\u0001T\u0001\u0007]\u000e{Gn\u001d\u0011\t\u000bY\u0003A\u0011A,\u0002\rqJg.\u001b;?)\u0011A\u0016l\u0017/\u0011\u0005]\u0001\u0001\"B\u0011V\u0001\u0004\u0019\u0003fA-/i!)!(\u0016a\u0001y!)!*\u0016a\u0001\u0019\"\u001aQK\f\u001b\t\u000bY\u0003A\u0011A0\u0015\u0005a\u0003\u0007\"B\u0011_\u0001\u0004\u0019\u0003f\u00010/i!)1\r\u0001C!I\u00069a.^7D_2\u001cH#\u0001\u001f)\u0007\ttC\u0007C\u0003h\u0001\u0011\u0005C-A\u0004ok6\u0014vn^:)\u0007\u0019tC\u0007\u0003\u0004k\u0001\u0011\u0005aa[\u0001\u0018[VdG/\u001b9ms\u001e\u0013\u0018-\\5b]6\u000bGO]5y\u0005f$\"\u0001\u001c<\u0011\u00075\f8/D\u0001o\u0015\t)qNC\u0001q\u0003\u0019\u0011'/Z3{K&\u0011!O\u001c\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0005\u0002\u0012i&\u0011QO\u0005\u0002\u0007\t>,(\r\\3\t\u000b]L\u0007\u0019\u00017\u0002\u0003YDQ!\u001f\u0001\u0005\u0002i\fAcY8naV$Xm\u0012:b[&\fg.T1ue&DH#A>\u0011\u0005)b\u0018BA?\u0005\u0005\u0019i\u0015\r\u001e:jq\"\u001a\u0001P\f\u001b\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004\u0005y1\r[3dW:+XnQ8mk6t7\u000fF\u0002C\u0003\u000bAa!a\u0002\u0000\u0001\u0004a\u0015\u0001B2pYNDq!a\u0003\u0001\t\u0003\ti!\u0001\u0006d_6\u0004X\u000f^3T-\u0012#\u0002\"a\u0004\u0002\u0016\u0005e\u00111\u0005\t\u0006U\u0005E\u0001l_\u0005\u0004\u0003'!!AG*j]\u001e,H.\u0019:WC2,X\rR3d_6\u0004xn]5uS>t\u0007bBA\f\u0003\u0013\u0001\r\u0001T\u0001\u0002W\"Q\u00111DA\u0005!\u0003\u0005\r!!\b\u0002\u0011\r|W\u000e];uKV\u00032!EA\u0010\u0013\r\t\tC\u0005\u0002\b\u0005>|G.Z1o\u0011%\t)#!\u0003\u0011\u0002\u0003\u00071/A\u0003s\u0007>tG\r\u000b\u0003\u0002\n9\"\u0004\u0002CA\u0006\u0001\u0011\u0005a!a\u000b\u0015\u001d\u0005=\u0011QFA\u0018\u0003c\t\u0019$a\u000e\u0002<!9\u0011qCA\u0015\u0001\u0004a\u0005\u0002CA\u000e\u0003S\u0001\r!!\b\t\u000f\u0005\u0015\u0012\u0011\u0006a\u0001g\"9\u0011QGA\u0015\u0001\u0004a\u0015aB7bq&#XM\u001d\u0005\b\u0003s\tI\u00031\u0001t\u0003\r!x\u000e\u001c\u0005\t\u0003{\tI\u00031\u0001\u0002@\u0005!Qn\u001c3f!\u0011\t\t%a\u0012\u000f\u0007E\t\u0019%C\u0002\u0002FI\ta\u0001\u0015:fI\u00164\u0017\u0002BA%\u0003\u0017\u0012aa\u0015;sS:<'bAA#%!1\u0011q\n\u0001\u0005\u0002i\f\u0011cY8naV$XmQ8wCJL\u0017M\\2fQ\u0011\tiE\f\u001b\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005q3m\\7qkR,\u0007K]5oG&\u0004\u0018\r\\\"p[B|g.\u001a8ug\u0006sG-\u0012=qY\u0006Lg.\u001a3WCJL\u0017M\\2f)\u0011\tI&a\u0018\u0011\u000bE\tYf_\u0015\n\u0007\u0005u#C\u0001\u0004UkBdWM\r\u0005\b\u0003/\t\u0019\u00061\u0001MQ\u0015\t\u0019FLA2C\t\t)'A\u00032]Yr\u0003\u0007C\u0004\u0002j\u0001!\t!a\u001b\u00025\r|W\u000e];uKB\u0013\u0018N\\2ja\u0006d7i\\7q_:,g\u000e^:\u0015\u0007m\fi\u0007C\u0004\u0002\u0018\u0005\u001d\u0004\u0019\u0001')\t\u0005\u001dd\u0006\u000e\u0005\b\u0003g\u0002A\u0011AA;\u0003y\u0019w.\u001c9vi\u0016\u001cu\u000e\\;n]N+X.\\1ssN#\u0018\r^5ti&\u001c7\u000f\u0006\u0002\u0002xA!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~\u0019\tAa\u001d;bi&!\u0011\u0011QA>\u0005yiU\u000f\u001c;jm\u0006\u0014\u0018.\u0019;f'R\fG/[:uS\u000e\fGnU;n[\u0006\u0014\u0018\u0010\u000b\u0003\u0002r9\"\u0004bBAD\u0001\u0011\u0005\u0011\u0011R\u0001\t[VdG/\u001b9msR\u0019\u0001,a#\t\u000f\u00055\u0015Q\u0011a\u0001w\u0006\t!\t\u000b\u0003\u0002\u0006:\"\u0004bBAJ\u0001\u0011\u0005\u0011QS\u0001\u0013G>dW/\u001c8TS6LG.\u0019:ji&,7\u000f\u0006\u0002\u0002\u0018B\u0019q#!'\n\u0007\u0005m%A\u0001\tD_>\u0014H-\u001b8bi\u0016l\u0015\r\u001e:jq\"*\u0011\u0011\u0013\u0018\u0002 \u0006\u0012\u0011\u0011U\u0001\u0006c9\u0012d\u0006\r\u0005\b\u0003'\u0003A\u0011AAS)\u0011\t9*a*\t\u000f\u0005%\u00161\u0015a\u0001g\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\u0015\u0006\u0003Gs\u0013q\u0014\u0005\b\u0003_\u0003A\u0011AAY\u00031!\u0018\r\u001c7TW&tg._)S)\u0011\t\u0019,!/\u0011\u000b)\n)\fW>\n\u0007\u0005]FAA\bR%\u0012+7m\\7q_NLG/[8o\u0011)\tY,!,\u0011\u0002\u0003\u0007\u0011QD\u0001\tG>l\u0007/\u001e;f#\"*\u0011Q\u0016\u0018\u0002@\u0006\u0012\u0011\u0011Y\u0001\u0006c9*d\u0006\r\u0005\t\u0003\u000b\u0004A\u0011\u0001\u0004\u0002H\u0006A2m\u001c7v[:\u001c\u0016.\\5mCJLG/[3t\t&k5+V'\u0015\r\u0005]\u0015\u0011ZAj\u0011!\tY-a1A\u0002\u00055\u0017aB2pY6\u000bwm\u001d\t\u0005#\u0005=7/C\u0002\u0002RJ\u0011Q!\u0011:sCfDq!!6\u0002D\u0002\u00071/A\u0003hC6l\u0017\r\u0003\u0005\u0002Z\u0002!\tEBAn\u0003!!xN\u0011:fKj,GCAAo!\u0011i\u0017q\\:\n\u0007\u0005\u0005hNA\u0006EK:\u001cX-T1ue&D\bbBAs\u0001\u0011%\u0011q]\u0001\u000ekB$\u0017\r^3Ok6\u0014vn^:\u0015\u0007\t\u000bI\u000fC\u0004\u0002l\u0006\r\b\u0019\u0001\u001f\u0002\u00035D\u0011\"a<\u0001#\u0003%\t!!=\u0002)\r|W\u000e];uKN3F\t\n3fM\u0006,H\u000e\u001e\u00133+\t\t\u0019P\u000b\u0003\u0002\u001e\u0005U8FAA|!\u0011\tIP!\u0001\u000e\u0005\u0005m(\u0002BA\u007f\u0003\u007f\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005E\u0012\u0012\u0002\u0002B\u0002\u0003w\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u00119\u0001AI\u0001\n\u0003\u0011I!\u0001\u000bd_6\u0004X\u000f^3T-\u0012#C-\u001a4bk2$HeM\u000b\u0003\u0005\u0017Q3a]A{\u0011%\u0011y\u0001AI\u0001\n\u0003\t\t0\u0001\fuC2d7k[5o]f\f&\u000b\n3fM\u0006,H\u000e\u001e\u00132Q\r\u0001a\u0006N\u0004\b\u0005+\u0011\u0001\u0012\u0001B\f\u0003%\u0011vn^'biJL\u0007\u0010E\u0002\u0018\u000531a!\u0001\u0002\t\u0002\tm1#\u0002B\r!\tu\u0001cA\t\u0003 %\u0019!\u0011\u0005\n\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fY\u0013I\u0002\"\u0001\u0003&Q\u0011!q\u0003\u0005\t\u0005S\u0011I\u0002\"\u0003\u0003,\u0005QAO]5v)>4U\u000f\u001c7\u0015\u000bm\u0014iC!\r\t\u000f\t=\"q\u0005a\u0001\u0019\u0006\ta\u000e\u0003\u0005\u00034\t\u001d\u0002\u0019AAg\u0003\u0005)\u0006B\u0003B\u001c\u00053\t\t\u0011\"\u0003\u0003:\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0004\u0005\u0003\u0003>\t\u001dSB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\t1\fgn\u001a\u0006\u0003\u0005\u000b\nAA[1wC&!!\u0011\nB \u0005\u0019y%M[3di\"\"!\u0011\u0004\u00185Q\u0011\u0011\u0019B\f\u001b")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    private int nCols;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowMatrix$SVDMode$2$ SVDMode$1$lzycompute(VolatileObjectRef x$1) {
        RowMatrix rowMatrix = this;
        synchronized (rowMatrix) {
            if (x$1.elem != null) return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
            x$1.elem = new RowMatrix$SVDMode$2$(this);
            return (RowMatrix$SVDMode$2$)((Object)x$1.elem);
        }
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    public long org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() {
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows;
    }

    private void org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(long x$1) {
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long numCols() {
        if (this.nCols() > 0) return this.nCols();
        try {
            this.nCols_$eq(((Vector)this.rows().first()).size());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(this.rows().count());
            if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        breeze.linalg.DenseVector x$8 = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Serializable x$9 = new Serializable(this, vbr){
            public static final long serialVersionUID = 0L;
            private final Broadcast vbr$1;

            /*
             * WARNING - void declaration
             */
            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U, Vector r) {
                void var3_3;
                block4: {
                    block3: {
                        breeze.linalg.Vector<Object> vector;
                        double a;
                        breeze.linalg.Vector<Object> rBrz;
                        block2: {
                            rBrz = r.asBreeze();
                            a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(this.vbr$1.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
                            vector = rBrz;
                            if (!(vector instanceof breeze.linalg.DenseVector)) break block2;
                            breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(vector instanceof breeze.linalg.SparseVector)) break block4;
                        breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), U, breeze.linalg.SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return U;
                }
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support vector operation from type ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3.getClass().getName()})));
            }
            {
                this.vbr$1 = vbr$1;
            }
        };
        Serializable x$10 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U1, breeze.linalg.DenseVector<Object> U2) {
                return (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$11 = this.rows().treeAggregate$default$4((Object)x$8);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$8, (Function2)x$9, (Function2)x$10, x$11, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        DenseVector.mcD.sp x$12 = new DenseVector.mcD.sp(nt, ClassTag$.MODULE$.Double());
        Serializable x$13 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U, Vector v) {
                BLAS$.MODULE$.spr(1.0, v, U.data$mcD$sp());
                return U;
            }
        };
        Serializable x$14 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseVector<Object> apply(breeze.linalg.DenseVector<Object> U1, breeze.linalg.DenseVector<Object> U2) {
                return (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
            }
        };
        int x$15 = this.rows().treeAggregate$default$4((Object)x$12);
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$12, (Function2)x$13, (Function2)x$14, x$15, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private void checkNumColumns(int cols) {
        if (cols > 65535) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Argument with more than 65535 cols: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)cols)})));
        }
        if (cols > 10000) {
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning((Function0<String>)new Serializable(this, cols, memMB){
                public static final long serialVersionUID = 0L;
                private final int cols$1;
                private final long memMB$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " columns will require at least ", " megabytes of memory!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.cols$1), BoxesRunTime.boxToLong((long)this.memMB$1)}));
                }
                {
                    this.cols$1 = cols$1;
                    this.memMB$1 = memMB$1;
                }
            });
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        block21: {
            Enumeration.Value value;
            block26: {
                Tuple2 tuple2;
                Enumeration.Value computeMode;
                int n;
                VolatileObjectRef SVDMode$module;
                block23: {
                    block24: {
                        svd.SVD sVD;
                        block25: {
                            Tuple2 tuple22;
                            block22: {
                                Enumeration.Value value2;
                                block18: {
                                    String string;
                                    block20: {
                                        block19: {
                                            block17: {
                                                SVDMode$module = new VolatileObjectRef(null);
                                                n = (int)this.numCols();
                                                Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
                                                    public static final long serialVersionUID = 0L;
                                                    private final int k$2;
                                                    private final int n$1;

                                                    public final String apply() {
                                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested k singular values but got k=", " and numCols=", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                    }
                                                    {
                                                        this.k$2 = k$2;
                                                        this.n$1 = n$1;
                                                    }
                                                });
                                                String string2 = string = mode;
                                                if ("auto" != null ? !"auto".equals(string2) : string2 != null) break block17;
                                                if (k > 5000) {
                                                    this.logWarning((Function0<String>)new Serializable(this, k, n){
                                                        public static final long serialVersionUID = 0L;
                                                        private final int k$2;
                                                        private final int n$1;

                                                        public final String apply() {
                                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"computing svd with k=", " and n=", ", please check necessity"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.n$1)}));
                                                        }
                                                        {
                                                            this.k$2 = k$2;
                                                            this.n$1 = n$1;
                                                        }
                                                    });
                                                }
                                                value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$1(SVDMode$module).LocalARPACK() : this.SVDMode$1(SVDMode$module).LocalLAPACK()) : this.SVDMode$1(SVDMode$module).DistARPACK();
                                                break block18;
                                            }
                                            String string3 = string;
                                            if ("local-svd" != null ? !"local-svd".equals(string3) : string3 != null) break block19;
                                            value2 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                                            break block18;
                                        }
                                        String string4 = string;
                                        if ("local-eigs" != null ? !"local-eigs".equals(string4) : string4 != null) break block20;
                                        value2 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                        break block18;
                                    }
                                    String string5 = string;
                                    if ("dist-eigs" != null ? !"dist-eigs".equals(string5) : string5 != null) break block21;
                                    value2 = this.SVDMode$1(SVDMode$module).DistARPACK();
                                }
                                value = computeMode = value2;
                                Enumeration.Value value3 = this.SVDMode$1(SVDMode$module).LocalARPACK();
                                Enumeration.Value value4 = value;
                                if (value3 != null ? !value3.equals(value4) : value4 != null) break block22;
                                Predef$.MODULE$.require(k < n, (Function0)new $anonfun$11(this, k, n));
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)new $anonfun$12(this, G), n, k, tol, maxIter);
                                break block23;
                            }
                            Enumeration.Value value5 = this.SVDMode$1(SVDMode$module).LocalLAPACK();
                            Enumeration.Value value6 = value;
                            if (value5 != null ? !value5.equals(value6) : value6 != null) break block24;
                            Predef$.MODULE$.require(n < 17515, (Function0)new $anonfun$13(this, n));
                            breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                            sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                            if (sVD == null) break block25;
                            breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                            breeze.linalg.DenseVector sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                            if (uFull == null) break block25;
                            breeze.linalg.DenseMatrix denseMatrix = uFull;
                            if (sigmaSquaresFull == null) break block25;
                            breeze.linalg.DenseVector denseVector = sigmaSquaresFull;
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)denseMatrix, (Object)denseVector);
                            breeze.linalg.DenseMatrix uFull2 = (breeze.linalg.DenseMatrix)tuple23._1();
                            breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple23._2();
                            tuple2 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull2);
                            break block23;
                        }
                        throw new MatchError((Object)sVD);
                    }
                    Enumeration.Value value7 = this.SVDMode$1(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (value7 != null ? !value7.equals(value8) : value8 != null) break block26;
                    StorageLevel storageLevel = this.rows().getStorageLevel();
                    StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                    if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                        this.logWarning((Function0<String>)new $anonfun$14(this));
                    }
                    Predef$.MODULE$.require(k < n, (Function0)new $anonfun$15(this, k, n));
                    tuple2 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)new $anonfun$16(this), n, k, tol, maxIter);
                }
                Tuple2 tuple24 = tuple2;
                if (tuple24 != null) {
                    breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple24._1();
                    breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple24._2();
                    if (sigmaSquares != null) {
                        breeze.linalg.DenseVector denseVector = sigmaSquares;
                        if (u != null) {
                            SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
                            Tuple2 tuple25;
                            breeze.linalg.DenseMatrix denseMatrix = u;
                            Tuple2 tuple26 = tuple25 = new Tuple2((Object)denseVector, (Object)denseMatrix);
                            breeze.linalg.DenseVector sigmaSquares2 = (breeze.linalg.DenseVector)tuple26._1();
                            breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple26._2();
                            breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares2, package.sqrt$.MODULE$.fromLowOrderCanMapValues(breeze.linalg.DenseVector$.MODULE$.handholdCMV(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, breeze.linalg.DenseVector$.MODULE$.canMapValues(ClassTag$.MODULE$.Double())));
                            double sigma0 = sigmas.apply$mcD$sp(0);
                            double threshold = rCond * sigma0;
                            int i = 0;
                            if (sigmas.length() < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sigmas){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$2;
                                    private final breeze.linalg.DenseVector sigmas$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " converged."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.sigmas$1.length())}));
                                    }
                                    {
                                        this.k$2 = k$2;
                                        this.sigmas$1 = sigmas$1;
                                    }
                                });
                            }
                            while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
                                ++i;
                            }
                            int sk = i;
                            if (sk < k) {
                                this.logWarning((Function0<String>)new Serializable(this, k, sk){
                                    public static final long serialVersionUID = 0L;
                                    private final int k$2;
                                    private final int sk$1;

                                    public final String apply() {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested ", " singular values but only found ", " nonzeros."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$2), BoxesRunTime.boxToInteger((int)this.sk$1)}));
                                    }
                                    {
                                        this.k$2 = k$2;
                                        this.sk$1 = sk$1;
                                    }
                                });
                            }
                            Enumeration.Value value9 = computeMode;
                            Enumeration.Value value10 = this.SVDMode$1(SVDMode$module).DistARPACK();
                            if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
                                StorageLevel storageLevel = this.rows().getStorageLevel();
                                StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
                                if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                                    this.logWarning((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                                        }
                                    });
                                }
                            }
                            Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
                            Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                            if (computeU) {
                                DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
                                int i2 = 0;
                                for (int j = 0; j < sk; ++j) {
                                    i2 = 0;
                                    double sigma = sigmas.apply$mcD$sp(j);
                                    while (i2 < n) {
                                        int n2 = i2++;
                                        int n3 = j;
                                        N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                                    }
                                }
                                RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
                            } else {
                                singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
                            }
                            return singularValueDecomposition;
                        }
                    }
                }
                throw new MatchError(tuple24);
            }
            throw new MatchError((Object)value);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Do not support mode ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mode})));
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        MultivariateStatisticalSummary summary2 = this.computeColumnSummaryStatistics();
        long m = summary2.count();
        Predef$.MODULE$.require(m > 1L, (Function0)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final long m$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RowMatrix.computeCovariance called on matrix with only ", " rows."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.m$1)}))).append((Object)"  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString();
            }
            {
                this.m$1 = m$1;
            }
        });
        Vector mean2 = summary2.mean();
        breeze.linalg.Matrix<Object> G = this.computeGramianMatrix().asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        double alpha = 0.0;
        for (int i = 0; i < n; ++i) {
            alpha = (double)m / m1 * mean2.apply(i);
            for (j = i; j < n; ++j) {
                double Gij = G.apply$mcD$sp(i, j) / m1 - alpha * mean2.apply(j);
                G.update$mcD$sp(i, j, Gij);
                G.update$mcD$sp(j, i, Gij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(G);
    }

    public Tuple2<Matrix, Vector> computePrincipalComponentsAndExplainedVariance(int k) {
        int n = (int)this.numCols();
        Predef$.MODULE$.require(k > 0 && k <= n, (Function0)new Serializable(this, k, n){
            public static final long serialVersionUID = 0L;
            private final int k$1;
            private final int n$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"k = ", " out of range (0, n = ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1), BoxesRunTime.boxToInteger((int)this.n$2)}));
            }
            {
                this.k$1 = k$1;
                this.n$2 = n$2;
            }
        });
        breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().asBreeze();
        svd.SVD sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
        if (sVD != null) {
            breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)sVD.leftVectors();
            breeze.linalg.DenseVector s = (breeze.linalg.DenseVector)sVD.singularValues();
            if (u != null) {
                breeze.linalg.DenseMatrix denseMatrix = u;
                if (s != null) {
                    Tuple2 tuple2;
                    breeze.linalg.DenseVector denseVector = s;
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)denseMatrix, (Object)denseVector);
                    breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple22._1();
                    breeze.linalg.DenseVector s2 = (breeze.linalg.DenseVector)tuple22._2();
                    double eigenSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(s2.data$mcD$sp()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                    double[] explainedVariance = (double[])Predef$.MODULE$.doubleArrayOps(s2.data$mcD$sp()).map((Function1)new Serializable(this, eigenSum){
                        public static final long serialVersionUID = 0L;
                        private final double eigenSum$1;

                        public final double apply(double x$4) {
                            return this.apply$mcDD$sp(x$4);
                        }

                        public double apply$mcDD$sp(double x$4) {
                            return x$4 / this.eigenSum$1;
                        }
                        {
                            this.eigenSum$1 = eigenSum$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    return k == n ? new Tuple2((Object)Matrices$.MODULE$.dense(n, k, u2.data$mcD$sp()), (Object)Vectors$.MODULE$.dense(explainedVariance)) : new Tuple2((Object)Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * k)), (Object)Vectors$.MODULE$.dense(Arrays.copyOfRange(explainedVariance, 0, k)));
                }
            }
        }
        throw new MatchError((Object)sVD);
    }

    public Matrix computePrincipalComponents(int k) {
        return (Matrix)this.computePrincipalComponentsAndExplainedVariance(k)._1();
    }

    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        MultivariateOnlineSummarizer x$16 = new MultivariateOnlineSummarizer();
        Serializable x$17 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator, Vector data) {
                return aggregator.add(data);
            }
        };
        Serializable x$18 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MultivariateOnlineSummarizer apply(MultivariateOnlineSummarizer aggregator1, MultivariateOnlineSummarizer aggregator2) {
                return aggregator1.merge(aggregator2);
            }
        };
        int x$19 = this.rows().treeAggregate$default$4((Object)x$16);
        MultivariateOnlineSummarizer summary2 = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$16, (Function2)x$17, (Function2)x$18, x$19, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary2.count());
        return summary2;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0)new Serializable(this, B, n){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;
            private final int n$3;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch: ", " vs ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.n$3), BoxesRunTime.boxToInteger((int)this.B$1.numRows())}));
            }
            {
                this.B$1 = B$1;
                this.n$3 = n$3;
            }
        });
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0)new Serializable(this, B){
            public static final long serialVersionUID = 0L;
            private final Matrix B$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only support dense matrix at this time but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.B$1.getClass().getName()}));
            }
            {
                this.B$1 = B$1;
            }
        });
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.asBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1)new Serializable(this, n, k, Bb){
            public static final long serialVersionUID = 0L;
            public final int n$3;
            public final int k$3;
            private final Broadcast Bb$1;

            public final Iterator<Vector> apply(Iterator<Vector> iter) {
                double[] Bi = (double[])this.Bb$1.value();
                return iter.map((Function1)new Serializable(this, Bi){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$19 $outer;
                    private final double[] Bi$1;

                    public final Vector apply(Vector row) {
                        breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(this.$outer.k$3, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                        for (int i = 0; i < this.$outer.k$3; ++i) {
                            v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.asBreeze().dot((Object)new DenseVector.mcD.sp(this.Bi$1, i * this.$outer.n$3, 1, this.$outer.n$3), Vector$.MODULE$.castOps(Predef$.MODULE$.conforms(), Predef$.MODULE$.conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                        }
                        return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.Bi$1 = Bi$1;
                    }
                });
            }
            {
                this.n$3 = n$3;
                this.k$3 = k$3;
                this.Bb$1 = Bb$1;
            }
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0)new Serializable(this, threshold){
            public static final long serialVersionUID = 0L;
            private final double threshold$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold cannot be negative: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.threshold$1)}));
            }
            {
                this.threshold$1 = threshold$1;
            }
        });
        if (threshold > 1.0) {
            this.logWarning((Function0<String>)new Serializable(this, threshold){
                public static final long serialVersionUID = 0L;
                private final double threshold$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Threshold is greater than 1: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.threshold$1)}))).append((Object)"Computation will be more efficient with promoted sparsity, ").append((Object)" however there is no correctness guarantee.").toString();
                }
                {
                    this.threshold$1 = threshold$1;
                }
            });
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        return this.columnSimilaritiesDIMSUM(this.computeColumnSummaryStatistics().normL2().toArray(), gamma);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QRDecomposition<RowMatrix, Matrix> tallSkinnyQR(boolean computeQ) {
        RowMatrix rowMatrix;
        int col = (int)this.numCols();
        RDD blockQRs = this.rows().retag(Vector.class).glom().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Vector[] x$5) {
                return x$5.length != 0;
            }
        }).map((Function1)new Serializable(this, col){
            public static final long serialVersionUID = 0L;
            private final int col$1;

            public final breeze.linalg.DenseMatrix<Object> apply(Vector[] partRows) {
                breeze.linalg.DenseMatrix bdm = DenseMatrix$.MODULE$.zeros$mDc$sp(partRows.length, this.col$1, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                IntRef i = new IntRef(0);
                Predef$.MODULE$.refArrayOps((Object[])partRows).foreach((Function1)new Serializable(this, bdm, i){
                    public static final long serialVersionUID = 0L;
                    private final breeze.linalg.DenseMatrix bdm$1;
                    private final IntRef i$1;

                    public final void apply(Vector row) {
                        ((NumericOps)this.bdm$1.apply((Object)BoxesRunTime.boxToInteger((int)this.i$1.elem), (Object)scala.package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).$colon$eq(row.asBreeze().t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.conforms())), Transpose$.MODULE$.liftInPlaceOps((UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_InPlaceOp_Double_OpSet()));
                        ++this.i$1.elem;
                    }
                    {
                        this.bdm$1 = bdm$1;
                        this.i$1 = i$1;
                    }
                });
                return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)bdm, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
            }
            {
                this.col$1 = col$1;
            }
        }, ClassTag$.MODULE$.apply(breeze.linalg.DenseMatrix.class));
        breeze.linalg.DenseMatrix combinedR = (breeze.linalg.DenseMatrix)blockQRs.treeReduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final breeze.linalg.DenseMatrix<Object> apply(breeze.linalg.DenseMatrix<Object> r1, breeze.linalg.DenseMatrix<Object> r2) {
                breeze.linalg.DenseMatrix stackedR = DenseMatrix$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new breeze.linalg.DenseMatrix[]{r1, r2}), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)stackedR, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
            }
        }, blockQRs.treeReduce$default$2());
        Matrix finalR = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)combinedR.toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        if (computeQ) {
            try {
                breeze.linalg.DenseMatrix invR = (breeze.linalg.DenseMatrix)inv$.MODULE$.apply((Object)combinedR, inv$.MODULE$.canInvUsingLU((UFunc.UImpl)LU.LU_DM_Impl$.MODULE$));
                rowMatrix = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)invR));
            }
            catch (MatrixSingularException matrixSingularException) {
                this.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "R is not invertible and return Q as null";
                    }
                });
                rowMatrix = null;
            }
        } else {
            rowMatrix = null;
        }
        RowMatrix finalQ = rowMatrix;
        return new QRDecomposition<Object, Matrix>(finalQ, finalR);
    }

    public boolean tallSkinnyQR$default$1() {
        return false;
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0)new Serializable(this, gamma){
            public static final long serialVersionUID = 0L;
            private final double gamma$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Oversampling should be greater than 1: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.gamma$1)}));
            }
            {
                this.gamma$1 = gamma$1;
            }
        });
        Predef$.MODULE$.require((long)Predef$.MODULE$.doubleArrayOps(colMags).size() == this.numCols(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of magnitudes didn't match column dimension";
            }
        });
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])Predef$.MODULE$.doubleArrayOps(colMags).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x == 0.0 ? 1.0 : x;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(Predef$.MODULE$.doubleArrayOps(colMagsCorrected).map((Function1)new Serializable(this, sg){
            public static final long serialVersionUID = 0L;
            private final double sg$1;

            public final double apply(double c) {
                return this.apply$mcDD$sp(c);
            }

            public double apply$mcDD$sp(double c) {
                return this.sg$1 / c;
            }
            {
                this.sg$1 = sg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(Predef$.MODULE$.doubleArrayOps(colMagsCorrected).map((Function1)new Serializable(this, sg){
            public static final long serialVersionUID = 0L;
            private final double sg$1;

            public final double apply(double c) {
                return this.apply$mcDD$sp(c);
            }

            public double apply$mcDD$sp(double c) {
                return package$.MODULE$.min(this.sg$1, c);
            }
            {
                this.sg$1 = sg$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2)new Serializable(this, pBV, qBV){
            public static final long serialVersionUID = 0L;
            private final Broadcast pBV$1;
            private final Broadcast qBV$1;

            public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(int indx, Iterator<Vector> iter) {
                double[] p = (double[])this.pBV$1.value();
                double[] q = (double[])this.qBV$1.value();
                XORShiftRandom rand2 = new XORShiftRandom((long)indx);
                double[] scaled = new double[Predef$.MODULE$.doubleArrayOps(p).size()];
                return iter.flatMap((Function1)new Serializable(this, p, q, rand2, scaled){
                    public static final long serialVersionUID = 0L;
                    public final double[] p$1;
                    private final double[] q$1;
                    public final XORShiftRandom rand$1;
                    public final double[] scaled$1;

                    public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(Vector row) {
                        Vector vector;
                        block6: {
                            Iterator iterator;
                            block5: {
                                DenseVector denseVector;
                                Option<double[]> option;
                                block4: {
                                    SparseVector sparseVector;
                                    Option<Tuple3<Object, int[], double[]>> option2;
                                    vector = row;
                                    if (!(vector instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block4;
                                    int[] indices = (int[])((Tuple3)option2.get())._2();
                                    double[] values = (double[])((Tuple3)option2.get())._3();
                                    int nnz = Predef$.MODULE$.intArrayOps(indices).size();
                                    for (int k = 0; k < nnz; ++k) {
                                        this.scaled$1[k] = values[k] / this.q$1[indices[k]];
                                    }
                                    iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1)new Serializable(this, indices, nnz){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$24$$anonfun$apply$4 $outer;
                                        private final int[] indices$1;
                                        private final int nnz$1;

                                        /*
                                         * WARNING - void declaration
                                         */
                                        public final ListBuffer<Tuple2<Tuple2<Object, Object>, Object>> apply(int k) {
                                            void var2_2;
                                            ListBuffer buf = new ListBuffer();
                                            int i = this.indices$1[k];
                                            double iVal = this.$outer.scaled$1[k];
                                            if (iVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[i]) {
                                                for (int l = k + 1; l < this.nnz$1; ++l) {
                                                    int j = this.indices$1[l];
                                                    double jVal = this.$outer.scaled$1[l];
                                                    Object object = jVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
                                                }
                                            }
                                            return var2_2;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.indices$1 = indices$1;
                                            this.nnz$1 = nnz$1;
                                        }
                                    }), (Function1)Predef$.MODULE$.conforms()).flatten();
                                    break block5;
                                }
                                if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block6;
                                double[] values = (double[])option.get();
                                int n = Predef$.MODULE$.doubleArrayOps(values).size();
                                for (int i = 0; i < n; ++i) {
                                    this.scaled$1[i] = values[i] / this.q$1[i];
                                }
                                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(n, (Function1)new Serializable(this, n){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$24$$anonfun$apply$4 $outer;
                                    private final int n$4;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final ListBuffer<Tuple2<Tuple2<Object, Object>, Object>> apply(int i) {
                                        void var2_2;
                                        ListBuffer buf = new ListBuffer();
                                        double iVal = this.$outer.scaled$1[i];
                                        if (iVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[i]) {
                                            for (int j = i + 1; j < this.n$4; ++j) {
                                                double jVal = this.$outer.scaled$1[j];
                                                Object object = jVal != 0.0 && this.$outer.rand$1.nextDouble() < this.$outer.p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
                                            }
                                        }
                                        return var2_2;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.n$4 = n$4;
                                    }
                                }), (Function1)Predef$.MODULE$.conforms()).flatten();
                            }
                            return iterator;
                        }
                        throw new MatchError((Object)vector);
                    }
                    {
                        this.p$1 = p$1;
                        this.q$1 = q$1;
                        this.rand$1 = rand$1;
                        this.scaled$1 = scaled$1;
                    }
                });
            }
            {
                this.pBV$1 = pBV$1;
                this.qBV$1 = qBV$1;
            }
        }, this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$6, double x$7) {
                return this.apply$mcDDD$sp(x$6, x$7);
            }

            public double apply$mcDDD$sp(double x$6, double x$7) {
                return x$6 + x$7;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final MatrixEntry apply(Tuple2<Tuple2<Object, Object>, Object> x0$1) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    double sim = tuple2._2$mcD$sp();
                    if (tuple22 != null) {
                        int i = tuple22._1$mcI$sp();
                        int j = tuple22._2$mcI$sp();
                        MatrixEntry matrixEntry = new MatrixEntry(i, j, sim);
                        return matrixEntry;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = new IntRef(0);
        Predef$.MODULE$.refArrayOps((Object[])this.rows().collect()).foreach((Function1)new Serializable(this, mat, i){
            public static final long serialVersionUID = 0L;
            public final breeze.linalg.DenseMatrix mat$1;
            public final IntRef i$2;

            public final void apply(Vector vector) {
                vector.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$toBreeze$1 $outer;

                    public final void apply(int x0$2, double x1$1) {
                        this.apply$mcVID$sp(x0$2, x1$1);
                    }

                    public void apply$mcVID$sp(int x0$2, double x1$1) {
                        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                        if (sp2 != null) {
                            int j = sp2._1$mcI$sp();
                            double v = sp2._2$mcD$sp();
                            this.$outer.mat$1.update$mcD$sp(this.$outer.i$2.elem, j, v);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError((Object)sp2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                ++this.i$2.elem;
            }
            {
                this.mat$1 = mat$1;
                this.i$2 = i$2;
            }
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() <= 0L) {
            this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows() == m, (Function0)new Serializable(this, m){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RowMatrix $outer;
                private final long m$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of rows ", " is different from what specified or previously computed: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.m$2), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$2 = m$2;
                }
            });
        }
    }

    private final RowMatrix$SVDMode$2$ SVDMode$1(VolatileObjectRef SVDMode$module$1) {
        return SVDMode$module$1.elem == null ? this.SVDMode$1$lzycompute(SVDMode$module$1) : (RowMatrix$SVDMode$2$)((Object)SVDMode$module$1.elem);
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.org$apache$spark$mllib$linalg$distributed$RowMatrix$$nRows = nRows;
        this.nCols = nCols;
        Logging.class.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

