/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.optimization.GradientDescent;
import org.apache.spark.mllib.optimization.LeastSquaresGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.regression.GeneralizedLinearAlgorithm;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.regression.RidgeRegressionModel;
import org.apache.spark.mllib.regression.RidgeRegressionWithSGD$;
import org.apache.spark.rdd.RDD;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u00015\u0011aCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0016!\ry\u0001CE\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u001b\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014\u0018\t\\4pe&$\b.\u001c\t\u0003\u001fMI!\u0001\u0006\u0002\u0003)IKGmZ3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!a\u0002A!a\u0001\n\u0013i\u0012\u0001C:uKB\u001c\u0016N_3\u0016\u0003y\u0001\"AF\u0010\n\u0005\u0001:\"A\u0002#pk\ndW\r\u0003\u0005#\u0001\t\u0005\r\u0011\"\u0003$\u00031\u0019H/\u001a9TSj,w\fJ3r)\t!s\u0005\u0005\u0002\u0017K%\u0011ae\u0006\u0002\u0005+:LG\u000fC\u0004)C\u0005\u0005\t\u0019\u0001\u0010\u0002\u0007a$\u0013\u0007\u0003\u0005+\u0001\t\u0005\t\u0015)\u0003\u001f\u0003%\u0019H/\u001a9TSj,\u0007\u0005\u0003\u0005-\u0001\t\u0005\r\u0011\"\u0003.\u00035qW/\\%uKJ\fG/[8ogV\ta\u0006\u0005\u0002\u0017_%\u0011\u0001g\u0006\u0002\u0004\u0013:$\b\u0002\u0003\u001a\u0001\u0005\u0003\u0007I\u0011B\u001a\u0002#9,X.\u0013;fe\u0006$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0002%i!9\u0001&MA\u0001\u0002\u0004q\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0018\u0002\u001d9,X.\u0013;fe\u0006$\u0018n\u001c8tA!A\u0001\b\u0001BA\u0002\u0013%Q$\u0001\u0005sK\u001e\u0004\u0016M]1n\u0011!Q\u0004A!a\u0001\n\u0013Y\u0014\u0001\u0004:fOB\u000b'/Y7`I\u0015\fHC\u0001\u0013=\u0011\u001dA\u0013(!AA\u0002yA\u0001B\u0010\u0001\u0003\u0002\u0003\u0006KAH\u0001\ne\u0016<\u0007+\u0019:b[\u0002B\u0001\u0002\u0011\u0001\u0003\u0002\u0004%I!H\u0001\u0012[&t\u0017NQ1uG\"4%/Y2uS>t\u0007\u0002\u0003\"\u0001\u0005\u0003\u0007I\u0011B\"\u0002+5Lg.\u001b\"bi\u000eDgI]1di&|gn\u0018\u0013fcR\u0011A\u0005\u0012\u0005\bQ\u0005\u000b\t\u00111\u0001\u001f\u0011!1\u0005A!A!B\u0013q\u0012AE7j]&\u0014\u0015\r^2i\rJ\f7\r^5p]\u0002Ba\u0001\u0013\u0001\u0005\u0002\u0011I\u0015A\u0002\u001fj]&$h\bF\u0003K\u00172ke\n\u0005\u0002\u0010\u0001!)Ad\u0012a\u0001=!)Af\u0012a\u0001]!)\u0001h\u0012a\u0001=!)\u0001i\u0012a\u0001=!9\u0001\u000b\u0001b\u0001\n\u0013\t\u0016\u0001C4sC\u0012LWM\u001c;\u0016\u0003I\u0003\"a\u0015,\u000e\u0003QS!!\u0016\u0003\u0002\u0019=\u0004H/[7ju\u0006$\u0018n\u001c8\n\u0005]#&\u0001\u0006'fCN$8+];be\u0016\u001cxI]1eS\u0016tG\u000f\u0003\u0004Z\u0001\u0001\u0006IAU\u0001\nOJ\fG-[3oi\u0002Bqa\u0017\u0001C\u0002\u0013%A,A\u0004va\u0012\fG/\u001a:\u0016\u0003u\u0003\"a\u00150\n\u0005}#&\u0001E*rk\u0006\u0014X\r\u001a'3+B$\u0017\r^3s\u0011\u0019\t\u0007\u0001)A\u0005;\u0006AQ\u000f\u001d3bi\u0016\u0014\b\u0005C\u0004d\u0001\t\u0007I\u0011\t3\u0002\u0013=\u0004H/[7ju\u0016\u0014X#A3\u0011\u0005M3\u0017BA4U\u0005=9%/\u00193jK:$H)Z:dK:$\bf\u00012j_B\u0011!.\\\u0007\u0002W*\u0011ANB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00018l\u0005\u0015\u0019\u0016N\\2fC\u0005\u0001\u0018!\u0002\u0019/q9\u0002\u0004B\u0002:\u0001A\u0003%Q-\u0001\u0006paRLW.\u001b>fe\u0002B3!]5p\u0011\u0015A\u0005\u0001\"\u0001v)\u0005Q\u0005\u0006\u0002;xur\u0004\"A\u0006=\n\u0005e<\"A\u00033faJ,7-\u0019;fI\u0006\n10AA\u001e+N,\u0007%\u001c7/e\u0016<'/Z:tS>tg\u0006T5oK\u0006\u0014(+Z4sKN\u001c\u0018n\u001c8!o&$\b\u000eI3mCN$\u0018n\u0019(fiB\u000b'/Y7!{\u0001\u0002d\u0006\r\u0018!\u001d>$X\r\t;iK\u0002\"WMZ1vYR\u0004#/Z4QCJ\fW\u000eI5tAAr\u0003'\r\u0011g_J\u0004#+\u001b3hKJ+wM]3tg&|gnV5uQN;E\t\f\u0011ckR\u0004\u0013n\u001d\u00111]A\u0002cm\u001c:!\u0019&tW-\u0019:SK\u001e\u0014Xm]:j_:t\u0013%A?\u0002\u000bIr\u0003G\f\u0019)\u0007QLw\u000eC\u0004\u0002\u0002\u0001!\t&a\u0001\u0002\u0017\r\u0014X-\u0019;f\u001b>$W\r\u001c\u000b\u0006%\u0005\u0015\u0011Q\u0003\u0005\b\u0003\u000fy\b\u0019AA\u0005\u0003\u001d9X-[4iiN\u0004B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0004\u0003\u001f!\u0011A\u00027j]\u0006dw-\u0003\u0003\u0002\u0014\u00055!A\u0002,fGR|'\u000f\u0003\u0004\u0002\u0018}\u0004\rAH\u0001\nS:$XM]2faRD3\u0001A5p\u000f\u001d\tiB\u0001E\u0001\u0003?\taCU5eO\u0016\u0014Vm\u001a:fgNLwN\\,ji\"\u001cv\t\u0012\t\u0004\u001f\u0005\u0005bAB\u0001\u0003\u0011\u0003\t\u0019cE\u0003\u0002\"\u0005\u0015R\u0003E\u0002\u0017\u0003OI1!!\u000b\u0018\u0005\u0019\te.\u001f*fM\"9\u0001*!\t\u0005\u0002\u00055BCAA\u0010\u0011!\t\t$!\t\u0005\u0002\u0005M\u0012!\u0002;sC&tG#\u0004\n\u00026\u0005-\u0013QJA(\u0003#\n\u0019\u0006\u0003\u0005\u00028\u0005=\u0002\u0019AA\u001d\u0003\u0015Ig\u000e];u!\u0019\tY$!\u0011\u0002F5\u0011\u0011Q\b\u0006\u0004\u0003\u007f1\u0011a\u0001:eI&!\u00111IA\u001f\u0005\r\u0011F\t\u0012\t\u0004\u001f\u0005\u001d\u0013bAA%\u0005\taA*\u00192fY\u0016$\u0007k\\5oi\"1A&a\fA\u00029Ba\u0001HA\u0018\u0001\u0004q\u0002B\u0002\u001d\u00020\u0001\u0007a\u0004\u0003\u0004A\u0003_\u0001\rA\b\u0005\t\u0003+\ny\u00031\u0001\u0002\n\u0005q\u0011N\\5uS\u0006dw+Z5hQR\u001c\b&BA\u0018S\u0006e\u0013EAA.\u0003\u0015\td\u0006\r\u00181\u0011!\t\t$!\t\u0005\u0002\u0005}Cc\u0003\n\u0002b\u0005\r\u0014QMA4\u0003SB\u0001\"a\u000e\u0002^\u0001\u0007\u0011\u0011\b\u0005\u0007Y\u0005u\u0003\u0019\u0001\u0018\t\rq\ti\u00061\u0001\u001f\u0011\u0019A\u0014Q\fa\u0001=!1\u0001)!\u0018A\u0002yAC!!\u0018j_\"A\u0011\u0011GA\u0011\t\u0003\ty\u0007F\u0005\u0013\u0003c\n\u0019(!\u001e\u0002x!A\u0011qGA7\u0001\u0004\tI\u0004\u0003\u0004-\u0003[\u0002\rA\f\u0005\u00079\u00055\u0004\u0019\u0001\u0010\t\ra\ni\u00071\u0001\u001fQ\u0011\ti'[8\t\u0011\u0005E\u0012\u0011\u0005C\u0001\u0003{\"RAEA@\u0003\u0003C\u0001\"a\u000e\u0002|\u0001\u0007\u0011\u0011\b\u0005\u0007Y\u0005m\u0004\u0019\u0001\u0018)\t\u0005m\u0014n\u001c\u0005\u000b\u0003\u000f\u000b\t#!A\u0005\n\u0005%\u0015a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006!A.\u00198h\u0015\t\t)*\u0001\u0003kCZ\f\u0017\u0002BAM\u0003\u001f\u0013aa\u00142kK\u000e$\b&BA\u0011ojd\b\u0006BA\u0011S>DS!a\u0007xurDC!a\u0007j_\u0002")
public class RidgeRegressionWithSGD
extends GeneralizedLinearAlgorithm<RidgeRegressionModel>
implements Serializable {
    private double stepSize;
    private int numIterations;
    private double regParam;
    private double miniBatchFraction;
    private final LeastSquaresGradient gradient;
    private final SquaredL2Updater updater;
    private final GradientDescent optimizer;

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3);
    }

    public static RidgeRegressionModel train(RDD<LabeledPoint> rDD, int n, double d, double d2, double d3, Vector vector) {
        return RidgeRegressionWithSGD$.MODULE$.train(rDD, n, d, d2, d3, vector);
    }

    private double stepSize() {
        return this.stepSize;
    }

    private void stepSize_$eq(double x$1) {
        this.stepSize = x$1;
    }

    private int numIterations() {
        return this.numIterations;
    }

    private void numIterations_$eq(int x$1) {
        this.numIterations = x$1;
    }

    private double regParam() {
        return this.regParam;
    }

    private void regParam_$eq(double x$1) {
        this.regParam = x$1;
    }

    private double miniBatchFraction() {
        return this.miniBatchFraction;
    }

    private void miniBatchFraction_$eq(double x$1) {
        this.miniBatchFraction = x$1;
    }

    private LeastSquaresGradient gradient() {
        return this.gradient;
    }

    private SquaredL2Updater updater() {
        return this.updater;
    }

    @Override
    public GradientDescent optimizer() {
        return this.optimizer;
    }

    @Override
    public RidgeRegressionModel createModel(Vector weights, double intercept) {
        return new RidgeRegressionModel(weights, intercept);
    }

    public RidgeRegressionWithSGD(double stepSize, int numIterations, double regParam, double miniBatchFraction) {
        this.stepSize = stepSize;
        this.numIterations = numIterations;
        this.regParam = regParam;
        this.miniBatchFraction = miniBatchFraction;
        this.gradient = new LeastSquaresGradient();
        this.updater = new SquaredL2Updater();
        this.optimizer = new GradientDescent(this.gradient(), this.updater()).setStepSize(this.stepSize()).setNumIterations(this.numIterations()).setRegParam(this.regParam()).setMiniBatchFraction(this.miniBatchFraction());
    }

    public RidgeRegressionWithSGD() {
        this(1.0, 100, 0.01, 1.0);
    }
}

