/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionModel$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$;
import org.apache.spark.ml.classification.LogisticRegressionModel$LogisticRegressionModelWriter$Data$;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamMap$;
import org.apache.spark.ml.param.shared.HasAggregationDepth$class;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.param.shared.HasWeightCol$class;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.VersionUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rUg\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dea\u0002\u0003B\b\u0011%ai\u0011AA\u0005\u0003#\t\u0011\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0007Y&t\u0017\r\\4\n\u0005]!\"A\u0002,fGR|'\u000f\u0005\u0002\u0010\u0001A\u0011qBG\u0005\u00037\t\u0011\u0001\u0004T8hSN$\u0018n\u0019*fOJ,7o]5p]B\u000b'/Y7t!\ti\u0002%D\u0001\u001f\u0015\tyB!\u0001\u0003vi&d\u0017BA\u0011\u001f\u0005)iEj\u0016:ji\u0006\u0014G.\u001a\u0005\tG\u0001\u0011)\u0019!C!I\u0005\u0019Q/\u001b3\u0016\u0003\u0015\u0002\"A\n\u0017\u000f\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0002\rA\u0013X\rZ3g\u0013\ticF\u0001\u0004TiJLgn\u001a\u0006\u0003W!B3A\t\u00197!\t\tD'D\u00013\u0015\t\u0019d!\u0001\u0006b]:|G/\u0019;j_:L!!\u000e\u001a\u0003\u000bMKgnY3\"\u0003]\nQ!\r\u00185]AB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0005k&$\u0007\u0005K\u00029aYB\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!P\u0001\u0012G>,gMZ5dS\u0016tG/T1ue&DX#\u0001 \u0011\u0005My\u0014B\u0001!\u0015\u0005\u0019i\u0015\r\u001e:jq\"\u001a1\b\r\"\"\u0003\r\u000bQA\r\u00182]AB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IAP\u0001\u0013G>,gMZ5dS\u0016tG/T1ue&D\b\u0005K\u0002Ea\tC\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!S\u0001\u0010S:$XM]2faR4Vm\u0019;peV\t!\u0003K\u0002Ha\tC\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006IAE\u0001\u0011S:$XM]2faR4Vm\u0019;pe\u0002B3a\u0013\u0019C\u0011!y\u0005A!b\u0001\n\u0003\u0002\u0016A\u00038v[\u000ec\u0017m]:fgV\t\u0011\u000b\u0005\u0002(%&\u00111\u000b\u000b\u0002\u0004\u0013:$\bf\u0001(1+\u0006\na+A\u00032]Mr\u0003\u0007\u0003\u0005Y\u0001\t\u0005\t\u0015!\u0003R\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\u0007]\u0003T\u000b\u0003\u0005\\\u0001\t\u0015\r\u0011\"\u0003]\u00035I7/T;mi&tw.\\5bYV\tQ\f\u0005\u0002(=&\u0011q\f\u000b\u0002\b\u0005>|G.Z1o\u0011!\t\u0007A!A!\u0002\u0013i\u0016AD5t\u001bVdG/\u001b8p[&\fG\u000e\t\u0005\u0007G\u0002!\tA\u00023\u0002\rqJg.\u001b;?)\u0019ARmZ5l[\")1E\u0019a\u0001K!\u001aQ\r\r\u001c\t\u000bq\u0012\u0007\u0019\u0001 )\u0007\u001d\u0004$\tC\u0003IE\u0002\u0007!\u0003K\u0002ja\tCQa\u00142A\u0002EC3a\u001b\u0019V\u0011\u0015Y&\r1\u0001^\u0011\u0019\u0019\u0007\u0001\"\u0001\u0007_R!\u0001\u0004]9t\u0011\u0015\u0019c\u000e1\u0001&\u0011\u0015\u0011h\u000e1\u0001\u0013\u00031\u0019w.\u001a4gS\u000eLWM\u001c;t\u0011\u0015!h\u000e1\u0001v\u0003%Ig\u000e^3sG\u0016\u0004H\u000f\u0005\u0002(m&\u0011q\u000f\u000b\u0002\u0007\t>,(\r\\3\t\u000bI\u0004A\u0011A%)\u0007a\u0004$0I\u0001|\u0003\u0015\u0011d\u0006\r\u00181\u0011!i\b\u0001#b\u0001\n\u0013I\u0015!D0d_\u00164g-[2jK:$8\u000f\u0003\u0005\u0000\u0001!\u0005\t\u0015)\u0003\u0013\u00039y6m\\3gM&\u001c\u0017.\u001a8ug\u0002Ba\u0001\u001e\u0001\u0005\u0002\u0005\rQ#A;)\t\u0005\u0005\u0001'\u0016\u0005\u000b\u0003\u0013\u0001\u0001R1A\u0005\n\u0005\r\u0011AC0j]R,'oY3qi\"I\u0011Q\u0002\u0001\t\u0002\u0003\u0006K!^\u0001\f?&tG/\u001a:dKB$\b\u0005C\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u0019M,G\u000f\u00165sKNDw\u000e\u001c3\u0015\t\u0005U\u0011qC\u0007\u0002\u0001!9\u0011\u0011DA\b\u0001\u0004)\u0018!\u0002<bYV,\u0007&BA\ba\u0005u\u0011EAA\u0010\u0003\u0015\td&\u000e\u00181\u0011\u001d\t\u0019\u0003\u0001C!\u0003\u0007\tAbZ3u)\"\u0014Xm\u001d5pY\u0012DS!!\t1\u0003;Aq!!\u000b\u0001\t\u0003\nY#A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0005\u0003+\ti\u0003\u0003\u0005\u0002\u001a\u0005\u001d\u0002\u0019AA\u0018!\u00119\u0013\u0011G;\n\u0007\u0005M\u0002FA\u0003BeJ\f\u0017\u0010K\u0003\u0002(A\ni\u0002C\u0004\u0002:\u0001!\t%a\u000f\u0002\u001b\u001d,G\u000f\u00165sKNDw\u000e\u001c3t+\t\ty\u0003K\u0003\u00028A\ni\u0002C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D\u00051Q.\u0019:hS:,\"!!\u0012\u0011\u000b\u001d\n9EE;\n\u0007\u0005%\u0003FA\u0005Gk:\u001cG/[8oc!A\u0011Q\n\u0001!\u0002\u0013\t)%A\u0004nCJ<\u0017N\u001c\u0011\t\u0013\u0005E\u0003A1A\u0005\n\u0005M\u0013aB7be\u001eLgn]\u000b\u0003\u0003+\u0002RaJA$%IA\u0001\"!\u0017\u0001A\u0003%\u0011QK\u0001\t[\u0006\u0014x-\u001b8tA!I\u0011Q\f\u0001C\u0002\u0013%\u00111I\u0001\u0006g\u000e|'/\u001a\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002F\u000511oY8sK\u0002B\u0001\"!\u001a\u0001\u0005\u0004%\t\u0005U\u0001\f]Vlg)Z1ukJ,7\u000fK\u0003\u0002dA\nI'\t\u0002\u0002l\u0005)\u0011G\f\u001c/a!9\u0011q\u000e\u0001!\u0002\u0013\t\u0016\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003&BA7a\u0005%\u0004\"CA;\u0001\u0001\u0007I\u0011BA<\u0003=!(/Y5oS:<7+^7nCJLXCAA=!\u00159\u00131PA@\u0013\r\ti\b\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\t\t)C\u0002\u0002\u0004\n\u0011\u0011\u0005T8hSN$\u0018n\u0019*fOJ,7o]5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7befD\u0011\"a\"\u0001\u0001\u0004%I!!#\u0002'Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef|F%Z9\u0015\t\u0005-\u0015\u0011\u0013\t\u0004O\u00055\u0015bAAHQ\t!QK\\5u\u0011)\t\u0019*!\"\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u0004q\u0012\n\u0004\u0002CAL\u0001\u0001\u0006K!!\u001f\u0002!Q\u0014\u0018-\u001b8j]\u001e\u001cV/\\7bef\u0004\u0003bBAN\u0001\u0011\u0005\u0011QT\u0001\bgVlW.\u0019:z+\t\ty\bK\u0003\u0002\u001aB\ni\u0002\u0003\u0005\u0002$\u0002!\tAAAS\u0003\u00052\u0017N\u001c3Tk6l\u0017M]=N_\u0012,G.\u00118e!J|'-\u00192jY&$\u0018pQ8m)\t\t9\u000bE\u0003(\u0003SCR%C\u0002\u0002,\"\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CAX\u0001\u0011\u0005!!!-\u0002\u0015M,GoU;n[\u0006\u0014\u0018\u0010\u0006\u0003\u0002\u0016\u0005M\u0006\u0002CAN\u0003[\u0003\r!!\u001f\t\r\u0005]\u0006\u0001\"\u0001]\u0003)A\u0017m]*v[6\f'/\u001f\u0015\u0006\u0003k\u0003\u0014Q\u0004\u0005\b\u0003{\u0003A\u0011AA`\u0003!)g/\u00197vCR,G\u0003BAa\u0003\u000f\u00042aDAb\u0013\r\t)M\u0001\u0002\u001a\u0019><\u0017n\u001d;jGJ+wM]3tg&|gnU;n[\u0006\u0014\u0018\u0010\u0003\u0005\u0002J\u0006m\u0006\u0019AAf\u0003\u001d!\u0017\r^1tKR\u0004D!!4\u0002^B1\u0011qZAk\u00033l!!!5\u000b\u0007\u0005Mg!A\u0002tc2LA!a6\u0002R\n9A)\u0019;bg\u0016$\b\u0003BAn\u0003;d\u0001\u0001\u0002\u0007\u0002`\u0006\u001d\u0017\u0011!A\u0001\u0006\u0003\t\tOA\u0002`IM\nB!a9\u0002jB\u0019q%!:\n\u0007\u0005\u001d\bFA\u0004O_RD\u0017N\\4\u0011\u0007\u001d\nY/C\u0002\u0002n\"\u00121!\u00118zQ\u0011\tY\f\r>\t\u000f\u0005M\b\u0001\"\u0015\u0002v\u00069\u0001O]3eS\u000e$HcA;\u0002x\"9\u0011\u0011`Ay\u0001\u0004\u0011\u0012\u0001\u00034fCR,(/Z:\t\u000f\u0005u\b\u0001\"\u0015\u0002\u0000\u00061\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002\u0013\u0005\u0003AqAa\u0001\u0002|\u0002\u0007!#A\u0007sC^\u0004&/\u001a3jGRLwN\u001c\u0005\b\u0005\u000f\u0001A\u0011\u000bB\u0005\u0003)\u0001(/\u001a3jGR\u0014\u0016m\u001e\u000b\u0004%\t-\u0001bBA}\u0005\u000b\u0001\rA\u0005\u0005\b\u0005\u001f\u0001A\u0011\tB\t\u0003\u0011\u0019w\u000e]=\u0015\u0007a\u0011\u0019\u0002\u0003\u0005\u0003\u0016\t5\u0001\u0019\u0001B\f\u0003\u0015)\u0007\u0010\u001e:b!\u0011\u0011IBa\b\u000e\u0005\tm!b\u0001B\u000f\t\u0005)\u0001/\u0019:b[&!!\u0011\u0005B\u000e\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b\u0006\u0002B\u0007aYBqAa\n\u0001\t#\u0012I#\u0001\bsC^\u0014\u0004O]3eS\u000e$\u0018n\u001c8\u0015\u0007U\u0014Y\u0003C\u0004\u0003\u0004\t\u0015\u0002\u0019\u0001\n\t\u000f\t=\u0002\u0001\"\u0015\u00032\u00051\u0002O]8cC\nLG.\u001b;zeA\u0014X\rZ5di&|g\u000eF\u0002v\u0005gAqA!\u000e\u0003.\u0001\u0007!#A\u0006qe>\u0014\u0017MY5mSRL\bb\u0002B\u001d\u0001\u0011\u0005#1H\u0001\u0006oJLG/Z\u000b\u0003\u0005{\u00012!\bB \u0013\r\u0011\tE\b\u0002\t\u001b2;&/\u001b;fe\"*!q\u0007\u0019\u0002j!\u001a\u0001\u0001\r\u001c\b\u000f\t%#\u0001#\u0001\u0003L\u00059Bj\\4jgRL7MU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0004\u001f\t5cAB\u0001\u0003\u0011\u0003\u0011ye\u0005\u0005\u0003N\tE#q\u000bB/!\r9#1K\u0005\u0004\u0005+B#AB!osJ+g\r\u0005\u0003\u001e\u00053B\u0012b\u0001B.=\tQQ\n\u0014*fC\u0012\f'\r\\3\u0011\u0007\u001d\u0012y&C\u0002\u0003b!\u0012AbU3sS\u0006d\u0017N_1cY\u0016Dqa\u0019B'\t\u0003\u0011)\u0007\u0006\u0002\u0003L!A!\u0011\u000eB'\t\u0003\u0012Y'\u0001\u0003sK\u0006$WC\u0001B7!\u0011i\"q\u000e\r\n\u0007\tEdD\u0001\u0005N\u0019J+\u0017\rZ3sQ\u0015\u00119\u0007MA5\u0011!\u00119H!\u0014\u0005B\te\u0014\u0001\u00027pC\u0012$2\u0001\u0007B>\u0011\u001d\u0011iH!\u001eA\u0002\u0015\nA\u0001]1uQ\"*!Q\u000f\u0019\u0002j\u0019I!1\u0011B'\u0001\t5#Q\u0011\u0002\u001e\u0019><\u0017n\u001d;jGJ+wM]3tg&|g.T8eK2<&/\u001b;feN1!\u0011\u0011B\u001f\u0005\u000f\u0003BA!#\u0003\u00106\u0011!1\u0012\u0006\u0004\u0005\u001b3\u0011\u0001C5oi\u0016\u0014h.\u00197\n\t\tE%1\u0012\u0002\b\u0019><w-\u001b8h\u0011)\u0011)J!!\u0003\u0002\u0003\u0006I\u0001G\u0001\tS:\u001cH/\u00198dK\"91M!!\u0005\u0002\teE\u0003\u0002BN\u0005?\u0003BA!(\u0003\u00026\u0011!Q\n\u0005\b\u0005+\u00139\n1\u0001\u0019\r\u001d\u0011\u0019K!!E\u0005K\u0013A\u0001R1uCNA!\u0011\u0015B)\u0005O\u0013i\u0006E\u0002(\u0005SK1Aa+)\u0005\u001d\u0001&o\u001c3vGRD\u0011b\u0014BQ\u0005+\u0007I\u0011\u0001)\t\u0013a\u0013\tK!E!\u0002\u0013\t\u0006BCA3\u0005C\u0013)\u001a!C\u0001!\"Q\u0011q\u000eBQ\u0005#\u0005\u000b\u0011B)\t\u0013!\u0013\tK!f\u0001\n\u0003I\u0005\"\u0003'\u0003\"\nE\t\u0015!\u0003\u0013\u0011%a$\u0011\u0015BK\u0002\u0013\u0005Q\bC\u0005F\u0005C\u0013\t\u0012)A\u0005}!I1L!)\u0003\u0016\u0004%\t\u0001\u0018\u0005\nC\n\u0005&\u0011#Q\u0001\nuCqa\u0019BQ\t\u0003\u0011\u0019\r\u0006\u0007\u0003F\n%'1\u001aBg\u0005\u001f\u0014\t\u000e\u0005\u0003\u0003H\n\u0005VB\u0001BA\u0011\u0019y%\u0011\u0019a\u0001#\"9\u0011Q\rBa\u0001\u0004\t\u0006B\u0002%\u0003B\u0002\u0007!\u0003\u0003\u0004=\u0005\u0003\u0004\rA\u0010\u0005\u00077\n\u0005\u0007\u0019A/\t\u0015\t=!\u0011UA\u0001\n\u0003\u0011)\u000e\u0006\u0007\u0003F\n]'\u0011\u001cBn\u0005;\u0014y\u000e\u0003\u0005P\u0005'\u0004\n\u00111\u0001R\u0011%\t)Ga5\u0011\u0002\u0003\u0007\u0011\u000b\u0003\u0005I\u0005'\u0004\n\u00111\u0001\u0013\u0011!a$1\u001bI\u0001\u0002\u0004q\u0004\u0002C.\u0003TB\u0005\t\u0019A/\t\u0015\t\r(\u0011UI\u0001\n\u0003\u0011)/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d(fA)\u0003j.\u0012!1\u001e\t\u0005\u0005[\u0014)0\u0004\u0002\u0003p*!!\u0011\u001fBz\u0003%)hn\u00195fG.,GM\u0003\u00024Q%!!q\u001fBx\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0005w\u0014\t+%A\u0005\u0002\t\u0015\u0018AD2paf$C-\u001a4bk2$HE\r\u0005\u000b\u0005\u007f\u0014\t+%A\u0005\u0002\r\u0005\u0011AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0007\u0007Q3A\u0005Bu\u0011)\u00199A!)\u0012\u0002\u0013\u00051\u0011B\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019YAK\u0002?\u0005SD!ba\u0004\u0003\"F\u0005I\u0011AB\t\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"aa\u0005+\u0007u\u0013I\u000f\u0003\u0006\u0004\u0018\t\u0005\u0016\u0011!C!\u00073\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAB\u000e!\u0011\u0019iba\n\u000e\u0005\r}!\u0002BB\u0011\u0007G\tA\u0001\\1oO*\u00111QE\u0001\u0005U\u00064\u0018-C\u0002.\u0007?A\u0011ba\u000b\u0003\"\u0006\u0005I\u0011\u0001)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0015\r=\"\u0011UA\u0001\n\u0003\u0019\t$\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%81\u0007\u0005\n\u0003'\u001bi#!AA\u0002EC!ba\u000e\u0003\"\u0006\u0005I\u0011IB\u001d\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB\u001e!\u0019\u0019ida\u0011\u0002j6\u00111q\b\u0006\u0004\u0007\u0003B\u0013AC2pY2,7\r^5p]&!1QIB \u0005!IE/\u001a:bi>\u0014\bBCB%\u0005C\u000b\t\u0011\"\u0001\u0004L\u0005A1-\u00198FcV\fG\u000eF\u0002^\u0007\u001bB!\"a%\u0004H\u0005\u0005\t\u0019AAu\u0011)\u0019\tF!)\u0002\u0002\u0013\u000531K\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011\u000b\u0003\u0006\u0004X\t\u0005\u0016\u0011!C!\u00073\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00077A!b!\u0018\u0003\"\u0006\u0005I\u0011IB0\u0003\u0019)\u0017/^1mgR\u0019Ql!\u0019\t\u0015\u0005M51LA\u0001\u0002\u0004\tIo\u0002\u0006\u0004f\t\u0005\u0015\u0011!E\u0005\u0007O\nA\u0001R1uCB!!qYB5\r)\u0011\u0019K!!\u0002\u0002#%11N\n\u0007\u0007S\u001aiG!\u0018\u0011\u0017\r=4QO)R%yj&QY\u0007\u0003\u0007cR1aa\u001d)\u0003\u001d\u0011XO\u001c;j[\u0016LAaa\u001e\u0004r\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000f\r\u001cI\u0007\"\u0001\u0004|Q\u00111q\r\u0005\u000b\u0007/\u001aI'!A\u0005F\re\u0003BCBA\u0007S\n\t\u0011\"!\u0004\u0004\u0006)\u0011\r\u001d9msRa!QYBC\u0007\u000f\u001bIia#\u0004\u000e\"1qja A\u0002ECq!!\u001a\u0004\u0000\u0001\u0007\u0011\u000b\u0003\u0004I\u0007\u007f\u0002\rA\u0005\u0005\u0007y\r}\u0004\u0019\u0001 \t\rm\u001by\b1\u0001^\u0011)\u0019\tj!\u001b\u0002\u0002\u0013\u000551S\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019)j!(\u0011\u000b\u001d\nYha&\u0011\u0011\u001d\u001aI*U)\u0013}uK1aa')\u0005\u0019!V\u000f\u001d7fk!Q1qTBH\u0003\u0003\u0005\rA!2\u0002\u0007a$\u0003\u0007\u0003\u0006\u0004$\u000e%\u0014\u0011!C\u0005\u0007K\u000b1B]3bIJ+7o\u001c7wKR\u00111q\u0015\t\u0005\u0007;\u0019I+\u0003\u0003\u0004,\u000e}!AB(cU\u0016\u001cG\u000f\u0003\u0005\u00040\n\u0005E\u0011KBY\u0003!\u0019\u0018M^3J[BdG\u0003BAF\u0007gCqA! \u0004.\u0002\u0007QEB\u0004\u00048\n5Ca!/\u0003;1{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\'pI\u0016d'+Z1eKJ\u001cBa!.\u0003n!91m!.\u0005\u0002\ruFCAB`!\u0011\u0011ij!.\t\u0015\r\r7Q\u0017b\u0001\n\u0013\u0019I\"A\u0005dY\u0006\u001c8OT1nK\"I1qYB[A\u0003%11D\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0003\u0002\u0003B<\u0007k#\tea3\u0015\u0007a\u0019i\rC\u0004\u0003~\r%\u0007\u0019A\u0013\t\u0015\r\r&QJA\u0001\n\u0013\u0019)\u000bK\u0003\u0003NA\nI\u0007K\u0003\u0003HA\nI\u0007")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams,
MLWritable {
    private final String uid;
    private final Matrix coefficientMatrix;
    private final Vector interceptVector;
    private final int numClasses;
    private final boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    private Vector org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients;
    private double org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Vector> margins;
    private final Function1<Vector, Object> score;
    private final int numFeatures;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final Param<String> family;
    private final IntParam aggregationDepth;
    private final DoubleParam threshold;
    private final Param<String> weightCol;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;
    private volatile byte bitmap$0;

    public static LogisticRegressionModel load(String string) {
        return LogisticRegressionModel$.MODULE$.load(string);
    }

    public static MLReader<LogisticRegressionModel> read() {
        return LogisticRegressionModel$.MODULE$.read();
    }

    private Vector org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Vector vector;
                Predef$.MODULE$.require(this.coefficientMatrix().isTransposed(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "LogisticRegressionModel coefficients should be row major.";
                    }
                });
                Matrix matrix = this.coefficientMatrix();
                if (matrix instanceof DenseMatrix) {
                    DenseMatrix denseMatrix = (DenseMatrix)matrix;
                    vector = Vectors$.MODULE$.dense(denseMatrix.values());
                } else {
                    if (!(matrix instanceof SparseMatrix)) {
                        throw new MatchError((Object)matrix);
                    }
                    SparseMatrix sparseMatrix = (SparseMatrix)matrix;
                    vector = Vectors$.MODULE$.sparse(this.coefficientMatrix().numCols(), sparseMatrix.rowIndices(), sparseMatrix.values());
                }
                this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients = vector;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients;
        }
    }

    private double org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept$lzycompute() {
        LogisticRegressionModel logisticRegressionModel = this;
        synchronized (logisticRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(this.interceptVector().toArray()).head());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept;
        }
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> family() {
        return this.family;
    }

    @Override
    public StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param x$1) {
        this.family = x$1;
    }

    @Override
    public String getFamily() {
        return LogisticRegressionParams$class.getFamily(this);
    }

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return LogisticRegressionParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth$class.getAggregationDepth(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol$class.getWeightCol(this);
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Matrix coefficientMatrix() {
        return this.coefficientMatrix;
    }

    public Vector interceptVector() {
        return this.interceptVector;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    public boolean org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial;
    }

    public Vector coefficients() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a matrix of coefficients, use coefficientMatrix instead.");
        }
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients();
    }

    public Vector org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients$lzycompute() : this.org$apache$spark$ml$classification$LogisticRegressionModel$$_coefficients;
    }

    public double intercept() {
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            throw new SparkException("Multinomial models contain a vector of intercepts, use interceptVector instead.");
        }
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept();
    }

    public double org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept$lzycompute() : this.org$apache$spark$ml$classification$LogisticRegressionModel$$_intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Vector> margins() {
        return this.margins;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        return (LogisticRegressionTrainingSummary)this.trainingSummary().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply() {
                throw new SparkException("No training summary available for this LogisticRegressionModel");
            }
        });
    }

    public Tuple2<LogisticRegressionModel, String> findSummaryModelAndProbabilityCol() {
        Tuple2 tuple2;
        String string;
        String string2 = string = this.$(this.probabilityCol());
        if (!("" != null ? !"".equals(string2) : string2 != null)) {
            String probabilityColName = new StringBuilder().append((Object)"probability_").append((Object)UUID.randomUUID().toString()).toString();
            tuple2 = new Tuple2(this.copy(ParamMap$.MODULE$.empty()).setProbabilityCol(probabilityColName), (Object)probabilityColName);
        } else {
            tuple2 = new Tuple2((Object)this, (Object)string);
        }
        return tuple2;
    }

    public LogisticRegressionModel setSummary(Option<LogisticRegressionTrainingSummary> summary2) {
        this.trainingSummary_$eq(summary2);
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(Dataset<?> dataset) {
        Tuple2<LogisticRegressionModel, String> tuple2 = this.findSummaryModelAndProbabilityCol();
        if (tuple2 != null) {
            Tuple2 tuple22;
            LogisticRegressionModel summaryModel = (LogisticRegressionModel)tuple2._1();
            String probabilityColName = (String)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summaryModel, (Object)probabilityColName);
            LogisticRegressionModel summaryModel2 = (LogisticRegressionModel)tuple23._1();
            String probabilityColName2 = (String)tuple23._2();
            return new BinaryLogisticRegressionSummary(summaryModel2.transform(dataset), probabilityColName2, this.$(this.labelCol()), this.$(this.featuresCol()));
        }
        throw new MatchError(tuple2);
    }

    @Override
    public double predict(Vector features) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.predict(features) : (BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector;
            DenseVector denseVector2 = (DenseVector)vector;
            if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
                int size = denseVector2.size();
                double[] values = denseVector2.values();
                int maxMarginIndex = rawPrediction.argmax();
                double maxMargin = rawPrediction.apply(maxMarginIndex);
                if (maxMargin == Double.POSITIVE_INFINITY) {
                    for (int k = 0; k < size; ++k) {
                        values[k] = k == maxMarginIndex ? 1.0 : 0.0;
                    }
                } else {
                    double temp = 0.0;
                    for (int k = 0; k < this.numClasses(); ++k) {
                        values[k] = maxMargin > 0.0 ? scala.math.package$.MODULE$.exp(values[k] - maxMargin) : scala.math.package$.MODULE$.exp(values[k]);
                        temp += values[k];
                    }
                    double sum = temp;
                    BLAS$.MODULE$.scal(1.0 / sum, (Vector)denseVector2);
                }
                denseVector = denseVector2;
            } else {
                int size = denseVector2.size();
                for (int i = 0; i < size; ++i) {
                    denseVector2.values()[i] = 1.0 / (1.0 + scala.math.package$.MODULE$.exp(-denseVector2.values()[i]));
                }
                denseVector = denseVector2;
            }
            DenseVector denseVector3 = denseVector;
            return denseVector3;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        Vector vector;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            vector = (Vector)this.margins().apply((Object)features);
        } else {
            double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
            vector = Vectors$.MODULE$.dense(-m, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
        }
        return vector;
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        LogisticRegressionModel newModel = this.copyValues(new LogisticRegressionModel(this.uid(), this.coefficientMatrix(), this.interceptVector(), this.numClasses(), this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()), extra);
        return (LogisticRegressionModel)newModel.setSummary(this.trainingSummary()).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double d;
        if (this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial()) {
            d = super.raw2prediction(rawPrediction);
        } else {
            double t = this.getThreshold();
            double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : scala.math.package$.MODULE$.log(t / (1.0 - t)));
            d = rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
        }
        return d;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial() ? super.probability2prediction(probability) : (probability.apply(1) > this.getThreshold() ? 1.0 : 0.0);
    }

    @Override
    public MLWriter write() {
        return new LogisticRegressionModelWriter(this);
    }

    public LogisticRegressionModel(String uid, Matrix coefficientMatrix, Vector interceptVector, int numClasses, boolean isMultinomial) {
        this.uid = uid;
        this.coefficientMatrix = coefficientMatrix;
        this.interceptVector = interceptVector;
        this.numClasses = numClasses;
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial = isMultinomial;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasWeightCol$class.$init$(this);
        HasThreshold$class.$init$(this);
        HasAggregationDepth$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        MLWritable$class.$init$(this);
        Predef$.MODULE$.require(coefficientMatrix.numRows() == interceptVector.size(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dimension mismatch! Expected "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficientMatrix.numRows == interceptVector.size, but ", " != "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.coefficientMatrix().numRows())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.interceptVector().size())}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new $anonfun$27(this);
        this.margins = new $anonfun$28(this);
        this.score = new $anonfun$29(this);
        this.numFeatures = coefficientMatrix.numCols();
        this.trainingSummary = None$.MODULE$;
    }

    public LogisticRegressionModel(String uid, Vector coefficients2, double intercept) {
        this(uid, (Matrix)new DenseMatrix(1, coefficients2.size(), coefficients2.toArray(), true), Vectors$.MODULE$.dense(intercept, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0])), 2, false);
    }

    public static class LogisticRegressionModelWriter
    extends MLWriter {
        private final LogisticRegressionModel instance;
        private volatile LogisticRegressionModel$LogisticRegressionModelWriter$Data$ Data$module;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() {
            LogisticRegressionModelWriter logisticRegressionModelWriter = this;
            synchronized (logisticRegressionModelWriter) {
                if (this.Data$module != null) return this.Data$module;
                this.Data$module = new LogisticRegressionModel$LogisticRegressionModelWriter$Data$(this);
                return this.Data$module;
            }
        }

        public LogisticRegressionModel$LogisticRegressionModelWriter$Data$ org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data() {
            return this.Data$module == null ? this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$$Data$lzycompute() : this.Data$module;
        }

        @Override
        public void saveImpl(String path) {
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), DefaultParamsWriter$.MODULE$.saveMetadata$default$4(), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Data data = new Data(this, this.instance.numClasses(), this.instance.numFeatures(), this.instance.interceptVector(), this.instance.coefficientMatrix(), this.instance.org$apache$spark$ml$classification$LogisticRegressionModel$$isMultinomial());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LogisticRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.TypeRef().apply($u.ThisType().apply($m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter")), $u.build().selectType($m.staticClass("org.apache.spark.ml.classification.LogisticRegressionModel.LogisticRegressionModelWriter"), "Data"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(LogisticRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Data[]{data})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_LogisticRegressionModel$LogisticRegressionModelWriter$$typecreator1$1(this))).repartition(1).write().parquet(dataPath);
        }

        public LogisticRegressionModelWriter(LogisticRegressionModel instance) {
            this.instance = instance;
        }

        public class Data
        implements Product,
        Serializable {
            private final int numClasses;
            private final int numFeatures;
            private final Vector interceptVector;
            private final Matrix coefficientMatrix;
            private final boolean isMultinomial;
            public final /* synthetic */ LogisticRegressionModelWriter $outer;

            public int numClasses() {
                return this.numClasses;
            }

            public int numFeatures() {
                return this.numFeatures;
            }

            public Vector interceptVector() {
                return this.interceptVector;
            }

            public Matrix coefficientMatrix() {
                return this.coefficientMatrix;
            }

            public boolean isMultinomial() {
                return this.isMultinomial;
            }

            public Data copy(int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                return new Data(this.org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer(), numClasses, numFeatures, interceptVector, coefficientMatrix, isMultinomial);
            }

            public int copy$default$1() {
                return this.numClasses();
            }

            public int copy$default$2() {
                return this.numFeatures();
            }

            public Vector copy$default$3() {
                return this.interceptVector();
            }

            public Matrix copy$default$4() {
                return this.coefficientMatrix();
            }

            public boolean copy$default$5() {
                return this.isMultinomial();
            }

            public String productPrefix() {
                return "Data";
            }

            public int productArity() {
                return 5;
            }

            public Object productElement(int x$1) {
                Object object;
                int n = x$1;
                switch (n) {
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                    case 4: {
                        object = BoxesRunTime.boxToBoolean((boolean)this.isMultinomial());
                        break;
                    }
                    case 3: {
                        object = this.coefficientMatrix();
                        break;
                    }
                    case 2: {
                        object = this.interceptVector();
                        break;
                    }
                    case 1: {
                        object = BoxesRunTime.boxToInteger((int)this.numFeatures());
                        break;
                    }
                    case 0: {
                        object = BoxesRunTime.boxToInteger((int)this.numClasses());
                    }
                }
                return object;
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Data;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.numClasses());
                n = Statics.mix((int)n, (int)this.numFeatures());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interceptVector()));
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficientMatrix()));
                n = Statics.mix((int)n, (int)(this.isMultinomial() ? 1231 : 1237));
                return Statics.finalizeHash((int)n, (int)5);
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Data)) return false;
                boolean bl = true;
                if (!bl) return false;
                Data data = (Data)x$1;
                if (this.numClasses() != data.numClasses()) return false;
                if (this.numFeatures() != data.numFeatures()) return false;
                Vector vector = this.interceptVector();
                Vector vector2 = data.interceptVector();
                if (vector == null) {
                    if (vector2 != null) {
                        return false;
                    }
                } else if (!vector.equals(vector2)) return false;
                Matrix matrix = this.coefficientMatrix();
                Matrix matrix2 = data.coefficientMatrix();
                if (matrix == null) {
                    if (matrix2 != null) {
                        return false;
                    }
                } else if (!matrix.equals(matrix2)) return false;
                if (this.isMultinomial() != data.isMultinomial()) return false;
                if (!data.canEqual(this)) return false;
                return true;
            }

            public /* synthetic */ LogisticRegressionModelWriter org$apache$spark$ml$classification$LogisticRegressionModel$LogisticRegressionModelWriter$Data$$$outer() {
                return this.$outer;
            }

            public Data(LogisticRegressionModelWriter $outer, int numClasses, int numFeatures, Vector interceptVector, Matrix coefficientMatrix, boolean isMultinomial) {
                this.numClasses = numClasses;
                this.numFeatures = numFeatures;
                this.interceptVector = interceptVector;
                this.coefficientMatrix = coefficientMatrix;
                this.isMultinomial = isMultinomial;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                Product.class.$init$((Product)this);
            }
        }
    }

    public static class LogisticRegressionModelReader
    extends MLReader<LogisticRegressionModel> {
        private final String className = LogisticRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public LogisticRegressionModel load(String path) {
            Tuple2 tuple2;
            block2: {
                Row row;
                block6: {
                    LogisticRegressionModel logisticRegressionModel;
                    DefaultParamsReader.Metadata metadata;
                    block5: {
                        Tuple5 tuple5;
                        Dataset data;
                        block3: {
                            Row row2;
                            block4: {
                                Tuple4 tuple4;
                                Tuple2.mcII.sp sp2;
                                metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
                                tuple2 = VersionUtils$.MODULE$.majorMinorVersion(metadata.sparkVersion());
                                if (tuple2 == null) break block2;
                                int major = tuple2._1$mcI$sp();
                                int minor = tuple2._2$mcI$sp();
                                Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(major, minor);
                                int major2 = sp3._1$mcI$sp();
                                int minor2 = sp3._2$mcI$sp();
                                String dataPath = new Path(path, "data").toString();
                                data = this.sparkSession().read().format("parquet").load(dataPath);
                                if (major2 >= 2 && (major2 != 2 || minor2 != 0)) break block3;
                                row2 = (Row)MLUtils$.MODULE$.convertVectorColumnsToML(data, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"coefficients"})).select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "intercept", "coefficients"})).head();
                                Some some = Row$.MODULE$.unapplySeq(row2);
                                if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block4;
                                Object numClasses = ((SeqLike)some.get()).apply(0);
                                Object numFeatures = ((SeqLike)some.get()).apply(1);
                                Object intercept = ((SeqLike)some.get()).apply(2);
                                Object coefficients2 = ((SeqLike)some.get()).apply(3);
                                if (!(numClasses instanceof Integer)) break block4;
                                int n = BoxesRunTime.unboxToInt((Object)numClasses);
                                if (!(numFeatures instanceof Integer)) break block4;
                                int n2 = BoxesRunTime.unboxToInt((Object)numFeatures);
                                if (!(intercept instanceof Double)) break block4;
                                double d = BoxesRunTime.unboxToDouble((Object)intercept);
                                if (!(coefficients2 instanceof Vector)) break block4;
                                Vector vector = (Vector)coefficients2;
                                Tuple4 tuple42 = tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                                int numClasses2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
                                int numFeatures2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
                                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple42._3());
                                Vector coefficients3 = (Vector)tuple42._4();
                                DenseMatrix coefficientMatrix = new DenseMatrix(1, coefficients3.size(), coefficients3.toArray(), true);
                                Vector interceptVector = Vectors$.MODULE$.dense(intercept2, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
                                logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), (Matrix)coefficientMatrix, interceptVector, numClasses2, false);
                                break block5;
                            }
                            throw new MatchError((Object)row2);
                        }
                        row = (Row)data.select("numClasses", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"numFeatures", "interceptVector", "coefficientMatrix", "isMultinomial"})).head();
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(5) != 0) break block6;
                        Object numClasses = ((SeqLike)some.get()).apply(0);
                        Object numFeatures = ((SeqLike)some.get()).apply(1);
                        Object interceptVector = ((SeqLike)some.get()).apply(2);
                        Object coefficientMatrix = ((SeqLike)some.get()).apply(3);
                        Object isMultinomial = ((SeqLike)some.get()).apply(4);
                        if (!(numClasses instanceof Integer)) break block6;
                        int n = BoxesRunTime.unboxToInt((Object)numClasses);
                        if (!(numFeatures instanceof Integer)) break block6;
                        int n3 = BoxesRunTime.unboxToInt((Object)numFeatures);
                        if (!(interceptVector instanceof Vector)) break block6;
                        Vector vector = (Vector)interceptVector;
                        if (!(coefficientMatrix instanceof Matrix)) break block6;
                        Matrix matrix = (Matrix)coefficientMatrix;
                        if (!(isMultinomial instanceof Boolean)) break block6;
                        boolean bl = BoxesRunTime.unboxToBoolean((Object)isMultinomial);
                        Tuple5 tuple52 = tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)n), (Object)BoxesRunTime.boxToInteger((int)n3), (Object)vector, (Object)matrix, (Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        int numClasses3 = BoxesRunTime.unboxToInt((Object)tuple52._1());
                        int numFeatures3 = BoxesRunTime.unboxToInt((Object)tuple52._2());
                        Vector interceptVector2 = (Vector)tuple52._3();
                        Matrix coefficientMatrix2 = (Matrix)tuple52._4();
                        boolean isMultinomial2 = BoxesRunTime.unboxToBoolean((Object)tuple52._5());
                        logisticRegressionModel = new LogisticRegressionModel(metadata.uid(), coefficientMatrix2, interceptVector2, numClasses3, isMultinomial2);
                    }
                    LogisticRegressionModel model = logisticRegressionModel;
                    DefaultParamsReader$.MODULE$.getAndSetParams(model, metadata);
                    return model;
                }
                throw new MatchError((Object)row);
            }
            throw new MatchError((Object)tuple2);
        }
    }
}

